/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fontwork.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:43:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _SFXMODULE_HXX
// auto strip #include <bf_sfx2/module.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SHL_HXX //autogen
// auto strip #include <tools/shl.hxx>
// auto strip #endif

#pragma hdrstop

#define _SVX_FONTWORK_CXX

// auto strip #ifndef _SVDOBJ_HXX
// auto strip #include "svdobj.hxx"
// auto strip #endif
// auto strip #ifndef _SVDOPATH_HXX
// auto strip #include "svdopath.hxx"
// auto strip #endif
// auto strip #ifndef _SVDVIEW_HXX
// auto strip #include "svdview.hxx"
// auto strip #endif
// auto strip #ifndef _SVDOCIRC_HXX
// auto strip #include "svdocirc.hxx"
// auto strip #endif
// auto strip #ifndef _SVX_XTEXTITEM_HXX //autogen
// auto strip #include "xtextit.hxx"
// auto strip #endif

// auto strip #include "dialmgr.hxx"
// auto strip #include "dlgutil.hxx"

#include "dialogs.hrc"
#include "fontwork.hrc"
#include "fontwork.hxx"
// auto strip #include "outlobj.hxx"
namespace binfilter {


/*N*/ SFX_IMPL_DOCKINGWINDOW( SvxFontWorkChildWindow, SID_FONTWORK );

/*************************************************************************
|*
|* ControllerItem fuer Fontwork
|*
\************************************************************************/

//STRIP001 SvxFontWorkControllerItem::SvxFontWorkControllerItem
//STRIP001 (
//STRIP001 	USHORT nId,
//STRIP001 	SvxFontWorkDialog& rDlg,
//STRIP001 	SfxBindings& rBindings
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxControllerItem( nId, rBindings ),
//STRIP001 
//STRIP001 	rFontWorkDlg( rDlg )
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* StateChanged-Methode fuer FontWork-Items
|*
\************************************************************************/

//STRIP001 void SvxFontWorkControllerItem::StateChanged( USHORT nSID, SfxItemState eState,
//STRIP001 											  const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	switch ( GetId() )
//STRIP001 	{
//STRIP001 		case SID_FORMTEXT_STYLE:
//STRIP001 		{
//STRIP001 			const XFormTextStyleItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextStyleItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextStyleItem erwartet");
//STRIP001 			rFontWorkDlg.SetStyle_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_ADJUST:
//STRIP001 		{
//STRIP001 			const XFormTextAdjustItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextAdjustItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextAdjustItem erwartet");
//STRIP001 			rFontWorkDlg.SetAdjust_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_DISTANCE:
//STRIP001 		{
//STRIP001 			const XFormTextDistanceItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextDistanceItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextDistanceItem erwartet");
//STRIP001 			rFontWorkDlg.SetDistance_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_START:
//STRIP001 		{
//STRIP001 			const XFormTextStartItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextStartItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextStartItem erwartet");
//STRIP001 			rFontWorkDlg.SetStart_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_MIRROR:
//STRIP001 		{
//STRIP001 			const XFormTextMirrorItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextMirrorItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextMirrorItem erwartet");
//STRIP001 			rFontWorkDlg.SetMirror_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_STDFORM:
//STRIP001 		{
//STRIP001 			const XFormTextStdFormItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextStdFormItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextStdFormItem erwartet");
//STRIP001 			rFontWorkDlg.SetStdForm_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_HIDEFORM:
//STRIP001 		{
//STRIP001 			const XFormTextHideFormItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextHideFormItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextHideFormItem erwartet");
//STRIP001 			rFontWorkDlg.SetShowForm_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_OUTLINE:
//STRIP001 		{
//STRIP001 			const XFormTextOutlineItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextOutlineItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextOutlineItem erwartet");
//STRIP001 			rFontWorkDlg.SetOutline_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_SHADOW:
//STRIP001 		{
//STRIP001 			const XFormTextShadowItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextShadowItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextShadowItem erwartet");
//STRIP001 			rFontWorkDlg.SetShadow_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_SHDWCOLOR:
//STRIP001 		{
//STRIP001 			const XFormTextShadowColorItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextShadowColorItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextShadowColorItem erwartet");
//STRIP001 			rFontWorkDlg.SetShadowColor_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_SHDWXVAL:
//STRIP001 		{
//STRIP001 			const XFormTextShadowXValItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextShadowXValItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextShadowXValItem erwartet");
//STRIP001 			rFontWorkDlg.SetShadowXVal_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_FORMTEXT_SHDWYVAL:
//STRIP001 		{
//STRIP001 			const XFormTextShadowYValItem* pStateItem =
//STRIP001 								PTR_CAST(XFormTextShadowYValItem, pItem);
//STRIP001 			DBG_ASSERT(pStateItem || pItem == 0, "XFormTextShadowYValItem erwartet");
//STRIP001 			rFontWorkDlg.SetShadowYVal_Impl(pStateItem);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Fontwork-Dialog
|*
\************************************************************************/

/*N*/ SvxFontWorkChildWindow::SvxFontWorkChildWindow
/*N*/ (
/*N*/ 	Window* pParent,
/*N*/ 	USHORT nId,
/*N*/ 	SfxBindings* pBindings,
/*N*/ 	SfxChildWinInfo* pInfo
/*N*/ ) :
/*N*/ 
/*N*/ 	SfxChildWindow( pParent, nId )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pWindow = new SvxFontWorkDialog( pBindings, this, pParent,
//STRIP001 									 SVX_RES( RID_SVXDLG_FONTWORK ) );
//STRIP001 	SvxFontWorkDialog* pDlg = (SvxFontWorkDialog*) pWindow;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001 	pDlg->Initialize( pInfo );
/*N*/ }

/*************************************************************************
|*
|* Floating Window zur Attributierung von Texteffekten
|*
\************************************************************************/

//STRIP001 SvxFontWorkDialog::SvxFontWorkDialog( SfxBindings *pBindinx,
//STRIP001 									  SfxChildWindow *pCW,
//STRIP001 									  Window* pParent,
//STRIP001 									  const ResId& rResId ) :
//STRIP001 	SfxDockingWindow( pBindinx, pCW, pParent, rResId ),
//STRIP001 
//STRIP001 	aFormSet		(this, ResId(VS_FORMS)),
//STRIP001 
//STRIP001 	aTbxStyle		(this, ResId(TBX_STYLE)),
//STRIP001 	aTbxAdjust		(this, ResId(TBX_ADJUST)),
//STRIP001 
//STRIP001 	aFbDistance 	(this, ResId(FB_DISTANCE)),
//STRIP001 	aMtrFldDistance (this, ResId(MTR_FLD_DISTANCE)),
//STRIP001 	aFbTextStart	(this, ResId(FB_TEXTSTART)),
//STRIP001 	aMtrFldTextStart(this, ResId(MTR_FLD_TEXTSTART)),
//STRIP001 
//STRIP001 	aTbxShadow		(this, ResId(TBX_SHADOW)),
//STRIP001 
//STRIP001 	aFbShadowX		(this, ResId(FB_SHADOW_X)),
//STRIP001 	aMtrFldShadowX	(this, ResId(MTR_FLD_SHADOW_X)),
//STRIP001 	aFbShadowY		(this, ResId(FB_SHADOW_Y)),
//STRIP001 	aMtrFldShadowY	(this, ResId(MTR_FLD_SHADOW_Y)),
//STRIP001 
//STRIP001 	aShadowColorLB	(this, ResId(CLB_SHADOW_COLOR)),
//STRIP001 
//STRIP001 	maImageList		(ResId(IL_FONTWORK)),
//STRIP001     maImageListH    (ResId(ILH_FONTWORK)),
//STRIP001 
//STRIP001 	rBindings		(*pBindinx),
//STRIP001 
//STRIP001 	nLastStyleTbxId(0),
//STRIP001 	nLastAdjustTbxId(0),
//STRIP001 	nLastShadowTbxId(0),
//STRIP001 	nSaveShadowX	(0),
//STRIP001 	nSaveShadowY	(0),
//STRIP001 	nSaveShadowAngle(450),
//STRIP001 	nSaveShadowSize (100),
//STRIP001 
//STRIP001 	pColorTable 	(NULL)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	ApplyImageList();
//STRIP001 
//STRIP001 	pCtrlItems[0] = new SvxFontWorkControllerItem(SID_FORMTEXT_STYLE, *this, rBindings);
//STRIP001 	pCtrlItems[1] = new SvxFontWorkControllerItem(SID_FORMTEXT_ADJUST, *this, rBindings);
//STRIP001 	pCtrlItems[2] = new SvxFontWorkControllerItem(SID_FORMTEXT_DISTANCE, *this, rBindings);
//STRIP001 	pCtrlItems[3] = new SvxFontWorkControllerItem(SID_FORMTEXT_START, *this, rBindings);
//STRIP001 	pCtrlItems[4] = new SvxFontWorkControllerItem(SID_FORMTEXT_MIRROR, *this, rBindings);
//STRIP001 	pCtrlItems[5] = new SvxFontWorkControllerItem(SID_FORMTEXT_STDFORM, *this, rBindings);
//STRIP001 	pCtrlItems[6] = new SvxFontWorkControllerItem(SID_FORMTEXT_HIDEFORM, *this, rBindings);
//STRIP001 	pCtrlItems[7] = new SvxFontWorkControllerItem(SID_FORMTEXT_OUTLINE, *this, rBindings);
//STRIP001 	pCtrlItems[8] = new SvxFontWorkControllerItem(SID_FORMTEXT_SHADOW, *this, rBindings);
//STRIP001 	pCtrlItems[9] = new SvxFontWorkControllerItem(SID_FORMTEXT_SHDWCOLOR, *this, rBindings);
//STRIP001 	pCtrlItems[10] = new SvxFontWorkControllerItem(SID_FORMTEXT_SHDWXVAL, *this, rBindings);
//STRIP001 	pCtrlItems[11] = new SvxFontWorkControllerItem(SID_FORMTEXT_SHDWYVAL, *this, rBindings);
//STRIP001 
//STRIP001 	WinBits aNewStyle = ( aFormSet.GetStyle() | WB_VSCROLL | WB_ITEMBORDER | WB_DOUBLEBORDER );
//STRIP001 	aFormSet.SetStyle( aNewStyle );
//STRIP001 
//STRIP001 	Size aSize = aTbxStyle.CalcWindowSizePixel();
//STRIP001 	aTbxStyle.SetSizePixel(aSize);
//STRIP001 	aTbxStyle.SetSelectHdl( LINK(this, SvxFontWorkDialog, SelectStyleHdl_Impl) );
//STRIP001 
//STRIP001 	aTbxAdjust.SetSizePixel(aSize);
//STRIP001 	aTbxAdjust.SetSelectHdl( LINK(this, SvxFontWorkDialog, SelectAdjustHdl_Impl) );
//STRIP001 
//STRIP001 	aTbxShadow.SetSizePixel(aSize);
//STRIP001 	aTbxShadow.SetSelectHdl( LINK(this, SvxFontWorkDialog, SelectShadowHdl_Impl) );
//STRIP001 
//STRIP001 //	aFbShadowX.SetBitmap(Bitmap(FW_RESID(RID_SVXBMP_SHADOW_XDIST)));
//STRIP001 //	aFbShadowY.SetBitmap(Bitmap(FW_RESID(RID_SVXBMP_SHADOW_YDIST)));
//STRIP001 
//STRIP001 	Link aLink = LINK(this, SvxFontWorkDialog, ModifyInputHdl_Impl);
//STRIP001 	aMtrFldDistance.SetModifyHdl( aLink );
//STRIP001 	aMtrFldTextStart.SetModifyHdl( aLink );
//STRIP001 	aMtrFldShadowX.SetModifyHdl( aLink );
//STRIP001 	aMtrFldShadowY.SetModifyHdl( aLink );
//STRIP001 
//STRIP001 	// System-Metrik setzen
//STRIP001 	const FieldUnit eDlgUnit = GetModuleFieldUnit();
//STRIP001 	SetFieldUnit( aMtrFldDistance, eDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( aMtrFldTextStart, eDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( aMtrFldShadowX, eDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( aMtrFldShadowY, eDlgUnit, TRUE );
//STRIP001 	if( eDlgUnit == FUNIT_MM )
//STRIP001 	{
//STRIP001 		aMtrFldDistance.SetSpinSize( 50 );
//STRIP001 		aMtrFldTextStart.SetSpinSize( 50 );
//STRIP001 		aMtrFldShadowX.SetSpinSize( 50 );
//STRIP001 		aMtrFldShadowY.SetSpinSize( 50 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMtrFldDistance.SetSpinSize( 10 );
//STRIP001 		aMtrFldTextStart.SetSpinSize( 10 );
//STRIP001 		aMtrFldShadowX.SetSpinSize( 10 );
//STRIP001 		aMtrFldShadowY.SetSpinSize( 10 );
//STRIP001 	}
//STRIP001 
//STRIP001 	aShadowColorLB.SetSelectHdl( LINK(this, SvxFontWorkDialog, ColorSelectHdl_Impl) );
//STRIP001 
//STRIP001 	aInputTimer.SetTimeout(500);
//STRIP001 	aInputTimer.SetTimeoutHdl(LINK(this, SvxFontWorkDialog, InputTimoutHdl_Impl));
//STRIP001 
//STRIP001 	aFormSet.SetSelectHdl( LINK(this, SvxFontWorkDialog, FormSelectHdl_Impl) );
//STRIP001 	aFormSet.SetColCount(4);
//STRIP001 	aFormSet.SetLineCount(2);
//STRIP001 
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 	Bitmap aBmp(ResId(RID_SVXBMP_FONTWORK_FORM1,pMgr));
//STRIP001 	aSize.Height() = aFormSet.CalcWindowSizePixel(aBmp.GetSizePixel()).Height() + 2;
//STRIP001 	aFormSet.SetSizePixel(aSize);
//STRIP001 }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

//STRIP001 SvxFontWorkDialog::~SvxFontWorkDialog()
//STRIP001 {
//STRIP001 	for (USHORT i = 0; i < CONTROLLER_COUNT; i++)
//STRIP001 		DELETEZ(pCtrlItems[i]);
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::Zoom()
//STRIP001 {
//STRIP001 	SfxDockingWindow::Roll();
//STRIP001 }


/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SfxChildAlignment SvxFontWorkDialog::CheckAlignment( SfxChildAlignment eActAlign,
//STRIP001 													 SfxChildAlignment eAlign )
//STRIP001 {
//STRIP001 	SfxChildAlignment eAlignment;
//STRIP001 
//STRIP001 	switch ( eAlign )
//STRIP001 	{
//STRIP001 		case SFX_ALIGN_TOP:
//STRIP001 		case SFX_ALIGN_HIGHESTTOP:
//STRIP001 		case SFX_ALIGN_LOWESTTOP:
//STRIP001 		case SFX_ALIGN_BOTTOM:
//STRIP001 		case SFX_ALIGN_LOWESTBOTTOM:
//STRIP001 		case SFX_ALIGN_HIGHESTBOTTOM:
//STRIP001 		{
//STRIP001 			eAlignment = eActAlign;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SFX_ALIGN_LEFT:
//STRIP001 		case SFX_ALIGN_RIGHT:
//STRIP001 		case SFX_ALIGN_FIRSTLEFT:
//STRIP001 		case SFX_ALIGN_LASTLEFT:
//STRIP001 		case SFX_ALIGN_FIRSTRIGHT:
//STRIP001 		case SFX_ALIGN_LASTRIGHT:
//STRIP001 		{
//STRIP001 			eAlignment = eAlign;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			eAlignment = eAlign;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return eAlignment;
//STRIP001 }


/*************************************************************************
|*
|* Style-Buttons setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetStyle_Impl(const XFormTextStyleItem* pItem)
//STRIP001 {
//STRIP001     if ( pItem )
//STRIP001 	{
//STRIP001 		USHORT nId = TBI_STYLE_OFF;
//STRIP001 
//STRIP001 		switch ( pItem->GetValue() )
//STRIP001 		{
//STRIP001 			case XFT_ROTATE : nId = TBI_STYLE_ROTATE;	break;
//STRIP001 			case XFT_UPRIGHT: nId = TBI_STYLE_UPRIGHT;	break;
//STRIP001 			case XFT_SLANTX : nId = TBI_STYLE_SLANTX;	break;
//STRIP001 			case XFT_SLANTY : nId = TBI_STYLE_SLANTY;	break;
//STRIP001 		}
//STRIP001 		aTbxStyle.Enable();
//STRIP001 
//STRIP001         // Make sure that there is allways exactly one checked toolbox item.
//STRIP001 		if ( pItem->GetValue() == XFT_NONE )
//STRIP001 		{
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_ROTATE, FALSE);
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_UPRIGHT, FALSE);
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_SLANTX, FALSE);
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_SLANTY, FALSE);
//STRIP001 
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_OFF, TRUE);
//STRIP001 		}
//STRIP001 		else
//STRIP001         {
//STRIP001 			aTbxStyle.CheckItem(TBI_STYLE_OFF, FALSE);
//STRIP001             aTbxStyle.CheckItem(nId);
//STRIP001         }
//STRIP001 
//STRIP001 		nLastStyleTbxId = nId;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aTbxStyle.Disable();
//STRIP001 }

/*************************************************************************
|*
|* Adjust-Buttons setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetAdjust_Impl(const XFormTextAdjustItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		USHORT nId;
//STRIP001 
//STRIP001 		aTbxAdjust.Enable();
//STRIP001 		aMtrFldDistance.Enable();
//STRIP001 
//STRIP001 		if ( pItem->GetValue() == XFT_LEFT || pItem->GetValue() == XFT_RIGHT )
//STRIP001 		{
//STRIP001 			if ( pItem->GetValue() == XFT_LEFT )	nId = TBI_ADJUST_LEFT;
//STRIP001 			else									nId = TBI_ADJUST_RIGHT;
//STRIP001 			aMtrFldTextStart.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( pItem->GetValue() == XFT_CENTER )	nId = TBI_ADJUST_CENTER;
//STRIP001 			else									nId = TBI_ADJUST_AUTOSIZE;
//STRIP001 			aMtrFldTextStart.Disable();
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !aTbxAdjust.IsItemChecked(nId) )
//STRIP001 		{
//STRIP001 			aTbxAdjust.CheckItem(nId);
//STRIP001 		}
//STRIP001 		nLastAdjustTbxId = nId;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTbxAdjust.Disable();
//STRIP001 		aMtrFldTextStart.Disable();
//STRIP001 		aMtrFldDistance.Disable();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Abstand-Wert in Editfeld eintragen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetDistance_Impl(const XFormTextDistanceItem* pItem)
//STRIP001 {
//STRIP001 	// #104596# Use HasChildPathFocus() instead of HasFocus() at SpinFields
//STRIP001 	if ( pItem && !aMtrFldDistance.HasChildPathFocus() )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrFldDistance, pItem->GetValue(), SFX_MAPUNIT_100TH_MM );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Einzug-Wert in Editfeld eintragen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetStart_Impl(const XFormTextStartItem* pItem)
//STRIP001 {
//STRIP001 	// #104596# Use HasChildPathFocus() instead of HasFocus() at SpinFields
//STRIP001 	if ( pItem && !aMtrFldTextStart.HasChildPathFocus() )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrFldTextStart, pItem->GetValue(), SFX_MAPUNIT_100TH_MM );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Button fuer Umkehrung der Textrichtung setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetMirror_Impl(const XFormTextMirrorItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 		aTbxAdjust.CheckItem(TBI_ADJUST_MIRROR, pItem->GetValue());
//STRIP001 }

/*************************************************************************
|*
|* Standardform im ValueSet anzeigen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetStdForm_Impl(const XFormTextStdFormItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		aFormSet.Enable();
//STRIP001 		aFormSet.SetNoSelection();
//STRIP001 
//STRIP001 		if ( pItem->GetValue() != XFTFORM_NONE )
//STRIP001 			aFormSet.SelectItem(pItem->GetValue());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aFormSet.Disable();
//STRIP001 }

/*************************************************************************
|*
|* Button fuer Konturanzeige setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetShowForm_Impl(const XFormTextHideFormItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 		aTbxShadow.CheckItem(TBI_SHOWFORM, !pItem->GetValue());
//STRIP001 }

/*************************************************************************
|*
|* Button fuer Zeichenumrandung setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetOutline_Impl(const XFormTextOutlineItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 		aTbxShadow.CheckItem(TBI_OUTLINE, pItem->GetValue());
//STRIP001 }

/*************************************************************************
|*
|* Shadow-Buttons setzen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetShadow_Impl(const XFormTextShadowItem* pItem,
//STRIP001 										BOOL bRestoreValues)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		USHORT nId;
//STRIP001 
//STRIP001 		aTbxShadow.Enable();
//STRIP001 
//STRIP001 		if ( pItem->GetValue() == XFTSHADOW_NONE )
//STRIP001 		{
//STRIP001 			nId = TBI_SHADOW_OFF;
//STRIP001 			aFbShadowX.Hide();
//STRIP001 			aFbShadowY.Hide();
//STRIP001 			aMtrFldShadowX.Disable();
//STRIP001 			aMtrFldShadowY.Disable();
//STRIP001 			aShadowColorLB.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			ResMgr* pMgr = DIALOG_MGR();
//STRIP001 			aFbShadowX.Show();
//STRIP001 			aFbShadowY.Show();
//STRIP001 			aMtrFldShadowX.Enable();
//STRIP001 			aMtrFldShadowY.Enable();
//STRIP001 			aShadowColorLB.Enable();
//STRIP001 
//STRIP001 			if ( pItem->GetValue() == XFTSHADOW_NORMAL )
//STRIP001 			{
//STRIP001 				nId = TBI_SHADOW_NORMAL;
//STRIP001 		 		const FieldUnit eDlgUnit = GetModuleFieldUnit();
//STRIP001 
//STRIP001 //				aFbShadowX.SetBitmap( Bitmap( ResId(RID_SVXBMP_SHADOW_XDIST, pMgr ) ) );
//STRIP001 				//aMtrFldShadowX.SetUnit(FUNIT_MM);
//STRIP001 				aMtrFldShadowX.SetUnit( eDlgUnit );
//STRIP001 				aMtrFldShadowX.SetDecimalDigits(2);
//STRIP001 				aMtrFldShadowX.SetMin(LONG_MIN);
//STRIP001 				aMtrFldShadowX.SetMax(LONG_MAX);
//STRIP001 				if( eDlgUnit == FUNIT_MM )
//STRIP001 					aMtrFldShadowX.SetSpinSize( 50 );
//STRIP001 				else
//STRIP001 					aMtrFldShadowX.SetSpinSize( 10 );
//STRIP001 
//STRIP001 //				aFbShadowY.SetBitmap( Bitmap( ResId( RID_SVXBMP_SHADOW_YDIST, pMgr ) ) );
//STRIP001 				//aMtrFldShadowY.SetUnit(FUNIT_MM);
//STRIP001 				aMtrFldShadowY.SetUnit( eDlgUnit );
//STRIP001 				aMtrFldShadowY.SetDecimalDigits(2);
//STRIP001 				aMtrFldShadowY.SetMin(LONG_MIN);
//STRIP001 				aMtrFldShadowY.SetMax(LONG_MAX);
//STRIP001 				if( eDlgUnit == FUNIT_MM )
//STRIP001 					aMtrFldShadowY.SetSpinSize( 50 );
//STRIP001 				else
//STRIP001 					aMtrFldShadowY.SetSpinSize( 10 );
//STRIP001 
//STRIP001 				if ( bRestoreValues )
//STRIP001 				{
//STRIP001 					SetMetricValue( aMtrFldShadowX, nSaveShadowX, SFX_MAPUNIT_100TH_MM );
//STRIP001 					SetMetricValue( aMtrFldShadowY, nSaveShadowY, SFX_MAPUNIT_100TH_MM );
//STRIP001 
//STRIP001 					XFormTextShadowXValItem aXItem( nSaveShadowX );
//STRIP001 					XFormTextShadowYValItem aYItem( nSaveShadowY );
//STRIP001 
//STRIP001 					GetBindings().GetDispatcher()->Execute(
//STRIP001 						SID_FORMTEXT_SHDWXVAL, SFX_CALLMODE_RECORD, &aXItem, &aYItem, 0L );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nId = TBI_SHADOW_SLANT;
//STRIP001 
//STRIP001 //				aFbShadowX.SetBitmap( Bitmap( ResId( RID_SVXBMP_SHADOW_ANGLE, pMgr ) ) );
//STRIP001 				aMtrFldShadowX.SetUnit(FUNIT_CUSTOM);
//STRIP001 				aMtrFldShadowX.SetDecimalDigits(1);
//STRIP001 				aMtrFldShadowX.SetMin(-1800);
//STRIP001 				aMtrFldShadowX.SetMax( 1800);
//STRIP001 				aMtrFldShadowX.SetSpinSize(10);
//STRIP001 
//STRIP001 //				aFbShadowY.SetBitmap( Bitmap( ResId( RID_SVXBMP_SHADOW_SIZE, pMgr ) ) );
//STRIP001 				aMtrFldShadowY.SetUnit(FUNIT_CUSTOM);
//STRIP001 				aMtrFldShadowY.SetDecimalDigits(0);
//STRIP001 				aMtrFldShadowY.SetMin(-999);
//STRIP001 				aMtrFldShadowY.SetMax( 999);
//STRIP001 				aMtrFldShadowY.SetSpinSize(10);
//STRIP001 
//STRIP001 				if ( bRestoreValues )
//STRIP001 				{
//STRIP001 					aMtrFldShadowX.SetValue(nSaveShadowAngle);
//STRIP001 					aMtrFldShadowY.SetValue(nSaveShadowSize);
//STRIP001 					XFormTextShadowXValItem aXItem(nSaveShadowAngle);
//STRIP001 					XFormTextShadowYValItem aYItem(nSaveShadowSize);
//STRIP001 					GetBindings().GetDispatcher()->Execute(
//STRIP001 						SID_FORMTEXT_SHDWXVAL, SFX_CALLMODE_RECORD, &aXItem, &aYItem, 0L );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !aTbxShadow.IsItemChecked(nId) )
//STRIP001 		{
//STRIP001 			aTbxShadow.CheckItem(nId);
//STRIP001 		}
//STRIP001 		nLastShadowTbxId = nId;
//STRIP001 
//STRIP001 		ApplyImageList();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTbxShadow.Disable();
//STRIP001 		aMtrFldShadowX.Disable();
//STRIP001 		aMtrFldShadowY.Disable();
//STRIP001 		aShadowColorLB.Disable();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Schattenfarbe in Listbox eintragen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetShadowColor_Impl(const XFormTextShadowColorItem* pItem)
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 		aShadowColorLB.SelectEntry(pItem->GetValue());
//STRIP001 }

/*************************************************************************
|*
|* X-Wert fuer Schatten in Editfeld eintragen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetShadowXVal_Impl(const XFormTextShadowXValItem* pItem)
//STRIP001 {
//STRIP001 	// #104596# Use HasChildPathFocus() instead of HasFocus() at SpinFields
//STRIP001 	if ( pItem && !aMtrFldShadowX.HasChildPathFocus() )
//STRIP001 	{
//STRIP001 		INT32 nValue = pItem->GetValue();
//STRIP001 		
//STRIP001 		// #104596# Only fo value correction for angle if TBI_SHADOW_SLANT is
//STRIP001 		// active.
//STRIP001 		if(aTbxShadow.IsItemChecked(TBI_SHADOW_SLANT))
//STRIP001 			nValue = nValue - ( int( float( nValue ) / 360.0 ) * 360 );
//STRIP001 		
//STRIP001 		SetMetricValue( aMtrFldShadowX, nValue/*pItem->GetValue()*/, SFX_MAPUNIT_100TH_MM );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Y-Wert fuer Schatten in Editfeld eintragen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetShadowYVal_Impl(const XFormTextShadowYValItem* pItem)
//STRIP001 {
//STRIP001 	// #104596# Use HasChildPathFocus() instead of HasFocus() at SpinFields
//STRIP001 	if ( pItem && !aMtrFldShadowY.HasChildPathFocus() )
//STRIP001 	{
//STRIP001 		SetMetricValue( aMtrFldShadowY, pItem->GetValue(), SFX_MAPUNIT_100TH_MM );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, SelectStyleHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nId = aTbxStyle.GetCurItemId();
//STRIP001 
//STRIP001     // Execute this block when a different toolbox item has been clicked or
//STRIP001     // when the off item has been clicked.  The later is necessary to
//STRIP001     // override the toolbox behaviour of unchecking the item after second
//STRIP001     // click on it: One of the items has to be checked at all times (when
//STRIP001     // enabled that is.)
//STRIP001 	if (nId == TBI_STYLE_OFF || nId != nLastStyleTbxId )
//STRIP001 	{
//STRIP001 		XFormTextStyle eStyle = XFT_NONE;
//STRIP001 
//STRIP001 		switch ( nId )
//STRIP001 		{
//STRIP001 			case TBI_STYLE_ROTATE	: eStyle = XFT_ROTATE;	break;
//STRIP001 			case TBI_STYLE_UPRIGHT	: eStyle = XFT_UPRIGHT; break;
//STRIP001 			case TBI_STYLE_SLANTX	: eStyle = XFT_SLANTX;	break;
//STRIP001 			case TBI_STYLE_SLANTY	: eStyle = XFT_SLANTY;	break;
//STRIP001 		}
//STRIP001 		XFormTextStyleItem aItem( eStyle );
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_STYLE, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 		SetStyle_Impl( &aItem );
//STRIP001 		nLastStyleTbxId = nId;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, SelectAdjustHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nId = aTbxAdjust.GetCurItemId();
//STRIP001 
//STRIP001 	if ( nId == TBI_ADJUST_MIRROR )
//STRIP001 	{
//STRIP001 		XFormTextMirrorItem aItem(aTbxAdjust.IsItemChecked(nId));
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_MIRROR, SFX_CALLMODE_SLOT, &aItem, 0L );
//STRIP001 	}
//STRIP001 	else if ( nId != nLastAdjustTbxId )
//STRIP001 	{
//STRIP001 		XFormTextAdjust eAdjust = XFT_AUTOSIZE;
//STRIP001 
//STRIP001 		switch ( nId )
//STRIP001 		{
//STRIP001 			case TBI_ADJUST_LEFT	: eAdjust = XFT_LEFT;	break;
//STRIP001 			case TBI_ADJUST_CENTER	: eAdjust = XFT_CENTER; break;
//STRIP001 			case TBI_ADJUST_RIGHT	: eAdjust = XFT_RIGHT;	break;
//STRIP001 		}
//STRIP001 		XFormTextAdjustItem aItem(eAdjust);
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_ADJUST, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 		SetAdjust_Impl(&aItem);
//STRIP001 		nLastAdjustTbxId = nId;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, SelectShadowHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nId = aTbxShadow.GetCurItemId();
//STRIP001 
//STRIP001 	if ( nId == TBI_SHOWFORM )
//STRIP001 	{
//STRIP001 		XFormTextHideFormItem aItem(!aTbxShadow.IsItemChecked(nId));
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_HIDEFORM, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	}
//STRIP001 	else if ( nId == TBI_OUTLINE )
//STRIP001 	{
//STRIP001 		XFormTextOutlineItem aItem(aTbxShadow.IsItemChecked(nId));
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_OUTLINE, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	}
//STRIP001 	else if ( nId != nLastShadowTbxId )
//STRIP001 	{
//STRIP001 		XFormTextShadow eShadow = XFTSHADOW_NONE;
//STRIP001 
//STRIP001 		if ( nLastShadowTbxId == TBI_SHADOW_NORMAL )
//STRIP001 		{
//STRIP001 			nSaveShadowX = GetCoreValue( aMtrFldShadowX, SFX_MAPUNIT_100TH_MM );
//STRIP001 			nSaveShadowY = GetCoreValue( aMtrFldShadowY, SFX_MAPUNIT_100TH_MM );
//STRIP001 		}
//STRIP001 		else if ( nLastShadowTbxId == TBI_SHADOW_SLANT )
//STRIP001 		{
//STRIP001 			nSaveShadowAngle = aMtrFldShadowX.GetValue();
//STRIP001 			nSaveShadowSize  = aMtrFldShadowY.GetValue();
//STRIP001 		}
//STRIP001 		nLastShadowTbxId = nId;
//STRIP001 
//STRIP001 		if ( nId == TBI_SHADOW_NORMAL ) 	eShadow = XFTSHADOW_NORMAL;
//STRIP001 		else if ( nId == TBI_SHADOW_SLANT ) eShadow = XFTSHADOW_SLANT;
//STRIP001 
//STRIP001 		XFormTextShadowItem aItem(eShadow);
//STRIP001 		GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_SHADOW, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 		SetShadow_Impl(&aItem, TRUE);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK_INLINE_START( SvxFontWorkDialog, ModifyInputHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aInputTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxFontWorkDialog, ModifyInputHdl_Impl, void *, EMPTYARG )

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, InputTimoutHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// System-Metrik evtl. neu setzen
//STRIP001 	// Dieses sollte mal als Listener passieren, ist aber aus
//STRIP001 	// inkompatibilitaetsgruenden z.Z. nicht moeglich
//STRIP001 	const FieldUnit eDlgUnit = GetModuleFieldUnit();
//STRIP001 	if( eDlgUnit != aMtrFldDistance.GetUnit() )
//STRIP001 	{
//STRIP001 		SetFieldUnit( aMtrFldDistance, eDlgUnit, TRUE );
//STRIP001 		SetFieldUnit( aMtrFldTextStart, eDlgUnit, TRUE );
//STRIP001 		aMtrFldDistance.SetSpinSize( eDlgUnit == FUNIT_MM ? 50 : 10 );
//STRIP001 		aMtrFldTextStart.SetSpinSize( eDlgUnit == FUNIT_MM ? 50 : 10 );
//STRIP001 	}
//STRIP001 	if( eDlgUnit != aMtrFldShadowX.GetUnit() &&
//STRIP001 		aTbxShadow.IsItemChecked( TBI_SHADOW_NORMAL ) )
//STRIP001 	{
//STRIP001 		SetFieldUnit( aMtrFldShadowX, eDlgUnit, TRUE );
//STRIP001 		SetFieldUnit( aMtrFldShadowY, eDlgUnit, TRUE );
//STRIP001 		aMtrFldShadowX.SetSpinSize( eDlgUnit == FUNIT_MM ? 50 : 10 );
//STRIP001 		aMtrFldShadowY.SetSpinSize( eDlgUnit == FUNIT_MM ? 50 : 10 );
//STRIP001 	}
//STRIP001 
//STRIP001 	long nValue = GetCoreValue( aMtrFldDistance, SFX_MAPUNIT_100TH_MM );
//STRIP001 	XFormTextDistanceItem aDistItem( nValue );
//STRIP001 	nValue = GetCoreValue( aMtrFldTextStart, SFX_MAPUNIT_100TH_MM );
//STRIP001 	XFormTextStartItem aStartItem( nValue );
//STRIP001 
//STRIP001 	nValue = GetCoreValue( aMtrFldShadowX, SFX_MAPUNIT_100TH_MM );
//STRIP001 	XFormTextShadowXValItem aShadowXItem( nValue );
//STRIP001 	nValue = GetCoreValue( aMtrFldShadowY, SFX_MAPUNIT_100TH_MM );
//STRIP001 	XFormTextShadowYValItem aShadowYItem( nValue );
//STRIP001 
//STRIP001 	// Slot-ID ist egal, die Exec-Methode wertet das gesamte ItemSet aus
//STRIP001 	GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_DISTANCE, SFX_CALLMODE_RECORD, &aDistItem,
//STRIP001 											&aStartItem, &aShadowXItem, &aShadowYItem, 0L );
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, FormSelectHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	XFormTextStdFormItem aItem;
//STRIP001 
//STRIP001 	if ( aFormSet.IsNoSelection() )
//STRIP001 		aItem.SetValue(XFTFORM_NONE);
//STRIP001 	else
//STRIP001 		aItem.SetValue(((XFormTextStdForm)(aFormSet.GetSelectItemId())));
//STRIP001 	GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_STDFORM, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	aFormSet.SetNoSelection();
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 IMPL_LINK( SvxFontWorkDialog, ColorSelectHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 // Changed by obo. Linux-Compiler can't parse commented lines
//STRIP001 	XFormTextShadowColorItem aItem( (const String &) String(),
//STRIP001 								    (const Color &) aShadowColorLB.GetSelectEntryColor() );
//STRIP001 //	XFormTextShadowColorItem aItem( String(),
//STRIP001 //								    aShadowColorLB.GetSelectEntryColor() );
//STRIP001 	GetBindings().GetDispatcher()->Execute( SID_FORMTEXT_SHDWCOLOR, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetColorTable(const XColorTable* pTable)
//STRIP001 {
//STRIP001 	if ( pTable && pTable != pColorTable )
//STRIP001 	{
//STRIP001 		pColorTable = pTable;
//STRIP001 		aShadowColorLB.Clear();
//STRIP001 		aShadowColorLB.Fill(pColorTable);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::SetActive(BOOL bActivate)
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Standard-FontWork-Objekt erzeugen
|*
\************************************************************************/

//STRIP001 void SvxFontWorkDialog::CreateStdFormObj(SdrView& rView, SdrPageView& rPV,
//STRIP001 										 const SfxItemSet& rAttr,
//STRIP001 										 SdrObject& rOldObj,
//STRIP001 										 XFormTextStdForm eForm)
//STRIP001 {
//STRIP001 	SfxItemSet	aAttr(*rAttr.GetPool(), XATTR_FORMTXTSTYLE,
//STRIP001 										XATTR_FORMTXTHIDEFORM);
//STRIP001 	SdrObject*	pNewObj = NULL;
//STRIP001 	Rectangle	aRect;
//STRIP001 	XFormTextAdjust eAdjust = XFT_AUTOSIZE;
//STRIP001 
//STRIP001 //-/	rOldObj.TakeAttributes(aAttr, TRUE, FALSE);
//STRIP001 	aAttr.Put(rOldObj.GetItemSet());
//STRIP001 	
//STRIP001 	const XFormTextStdFormItem& rOldForm = (const XFormTextStdFormItem&)
//STRIP001 											aAttr.Get(XATTR_FORMTXTSTDFORM);
//STRIP001 
//STRIP001 	aRect = rOldObj.GetSnapRect();
//STRIP001 
//STRIP001 	if ( !rOldObj.ISA(SdrPathObj) )
//STRIP001 	{
//STRIP001 		Point aPos = aRect.TopLeft();
//STRIP001 		aRect = rOldObj.GetLogicRect();
//STRIP001 		aRect.SetPos(aPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	aAttr.Put(rAttr);
//STRIP001 
//STRIP001 	if ( rOldForm.GetValue() == XFTFORM_NONE )
//STRIP001 	{
//STRIP001 		long nW = aRect.GetWidth();
//STRIP001 		aRect.SetSize(Size(nW, nW));
//STRIP001 		aAttr.Put(XFormTextStyleItem(XFT_ROTATE));
//STRIP001 	}
//STRIP001 
//STRIP001 	Point aCenter = aRect.Center();
//STRIP001 
//STRIP001 	switch ( eForm )
//STRIP001 	{
//STRIP001 		case XFTFORM_TOPCIRC:
//STRIP001 		case XFTFORM_BOTCIRC:
//STRIP001 		case XFTFORM_LFTCIRC:
//STRIP001 		case XFTFORM_RGTCIRC:
//STRIP001 		case XFTFORM_TOPARC:
//STRIP001 		case XFTFORM_BOTARC:
//STRIP001 		case XFTFORM_LFTARC:
//STRIP001 		case XFTFORM_RGTARC:
//STRIP001 		{
//STRIP001 			long nBeg, nEnd;
//STRIP001 
//STRIP001 			switch ( eForm )
//STRIP001 			{
//STRIP001 				case XFTFORM_TOPCIRC:
//STRIP001 					nBeg = 0;
//STRIP001 					nEnd = 18000;
//STRIP001 					break;
//STRIP001 				case XFTFORM_BOTCIRC:
//STRIP001 					nBeg = 18000;
//STRIP001 					nEnd = 36000;
//STRIP001 					break;
//STRIP001 				case XFTFORM_LFTCIRC:
//STRIP001 					nBeg =	9000;
//STRIP001 					nEnd = 27000;
//STRIP001 					break;
//STRIP001 				case XFTFORM_RGTCIRC:
//STRIP001 					nBeg = 27000;
//STRIP001 					nEnd =	9000;
//STRIP001 					break;
//STRIP001 				case XFTFORM_TOPARC:
//STRIP001 					nBeg =	4500;
//STRIP001 					nEnd = 13500;
//STRIP001 					break;
//STRIP001 				case XFTFORM_BOTARC:
//STRIP001 					nBeg = 22500;
//STRIP001 					nEnd = 31500;
//STRIP001 					break;
//STRIP001 				case XFTFORM_LFTARC:
//STRIP001 					nBeg = 13500;
//STRIP001 					nEnd = 22500;
//STRIP001 					break;
//STRIP001 				case XFTFORM_RGTARC:
//STRIP001 					nBeg = 31500;
//STRIP001 					nEnd =	4500;
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			pNewObj = new SdrCircObj(OBJ_CARC, aRect, nBeg, nEnd);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XFTFORM_BUTTON1:
//STRIP001 		{
//STRIP001 			XPolyPolygon aXPP;
//STRIP001 			XPolygon aLine(3);
//STRIP001 			long nR = aRect.GetWidth() / 2;
//STRIP001 
//STRIP001 			XPolygon aTopArc(aCenter, -nR, nR, 50, 1750, FALSE);
//STRIP001 			XPolygon aBottomArc(aCenter, -nR, nR, 1850, 3550, FALSE);
//STRIP001 
//STRIP001 			// Polygone schliessen
//STRIP001 			aTopArc[aTopArc.GetPointCount()] = aTopArc[0];
//STRIP001 			aBottomArc[aBottomArc.GetPointCount()] = aBottomArc[0];
//STRIP001 			aXPP.Insert(aTopArc);
//STRIP001 			aLine[0] = aBottomArc[aBottomArc.GetPointCount()-2];
//STRIP001 			aLine[2] = aLine[0];
//STRIP001 			aLine[1] = aBottomArc[0];
//STRIP001 			aXPP.Insert(aLine);
//STRIP001 			aXPP.Insert(aBottomArc);
//STRIP001 
//STRIP001 			pNewObj = new SdrPathObj(OBJ_PATHFILL, aXPP);
//STRIP001 			eAdjust = XFT_CENTER;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case XFTFORM_BUTTON2:
//STRIP001 		case XFTFORM_BUTTON3:
//STRIP001 		case XFTFORM_BUTTON4:
//STRIP001 		{
//STRIP001 			XPolyPolygon aXPP;
//STRIP001 			XPolygon aLine(3);
//STRIP001 			long nR = aRect.GetWidth() / 2;
//STRIP001 			long nWDiff = nR / 5;
//STRIP001 			long nHDiff;
//STRIP001 
//STRIP001 			if ( eForm == XFTFORM_BUTTON4 )
//STRIP001 			{
//STRIP001 				aXPP.Insert(XPolygon(aCenter, -nR, nR, 950, 2650, FALSE));
//STRIP001 				// Polygon schliessen
//STRIP001 				aXPP[0][aXPP[0].GetPointCount()] = aXPP[0][0];
//STRIP001 				eAdjust = XFT_CENTER;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aXPP.Insert(XPolygon(aCenter, -nR, nR, 2700, 2700));
//STRIP001 
//STRIP001 			if ( eForm == XFTFORM_BUTTON3 )
//STRIP001 				nHDiff = -aRect.GetHeight() / 10;
//STRIP001 			else
//STRIP001 				nHDiff = aRect.GetHeight() / 20;
//STRIP001 
//STRIP001 			aLine[0] = aRect.LeftCenter();
//STRIP001 			aLine[0].X() += nWDiff;
//STRIP001 			aLine[0].Y() += nHDiff;
//STRIP001 			aLine[2] = aLine[0];
//STRIP001 			aLine[1] = aRect.RightCenter();
//STRIP001 			aLine[1].X() -= nWDiff;
//STRIP001 			aLine[1].Y() += nHDiff;
//STRIP001 			aXPP.Insert(aLine);
//STRIP001 
//STRIP001 			if ( eForm == XFTFORM_BUTTON4 )
//STRIP001 			{
//STRIP001 				aXPP.Insert(XPolygon(aCenter, -nR, nR, 2750, 850, FALSE));
//STRIP001 				aXPP[2][aXPP[2].GetPointCount()] = aXPP[2][0];
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( eForm == XFTFORM_BUTTON3 )
//STRIP001 			{
//STRIP001 				nHDiff += nHDiff;
//STRIP001 				aLine[0].Y() -= nHDiff;
//STRIP001 				aLine[1].Y() -= nHDiff;
//STRIP001 				aLine[2].Y() -= nHDiff;
//STRIP001 				aXPP.Insert(aLine);
//STRIP001 			}
//STRIP001 
//STRIP001 			pNewObj = new SdrPathObj(OBJ_PATHFILL, aXPP);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if ( pNewObj )
//STRIP001 	{
//STRIP001 		// #78478# due to DLs changes in Outliner the object needs
//STRIP001 		// a model to get an outliner for later calls to
//STRIP001 		// pNewObj->SetOutlinerParaObject(pPara) (see below).
//STRIP001 		pNewObj->SetModel(rOldObj.GetModel());
//STRIP001 
//STRIP001 		Size aSize;
//STRIP001 		Rectangle aSnap = pNewObj->GetSnapRect();
//STRIP001 
//STRIP001 		aSize.Width() = aRect.Left() - aSnap.Left();
//STRIP001 		aSize.Height() = aRect.Top() - aSnap.Top();
//STRIP001 		pNewObj->NbcMove(aSize);
//STRIP001 
//STRIP001 		rView.BegUndo( SVX_RESSTR( RID_SVXSTR_FONTWORK_UNDOCREATE ) );
//STRIP001 		OutlinerParaObject* pPara = rOldObj.GetOutlinerParaObject();
//STRIP001 		BOOL bHide = TRUE;
//STRIP001 
//STRIP001 		if ( pPara != NULL )
//STRIP001 		{
//STRIP001 			pPara = new OutlinerParaObject(*pPara);
//STRIP001 			pNewObj->SetOutlinerParaObject(pPara);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			bHide = FALSE;
//STRIP001 
//STRIP001 		rView.ReplaceObject(&rOldObj, rPV, pNewObj, TRUE);
//STRIP001 		pNewObj->SetLayer(rOldObj.GetLayer());
//STRIP001 		aAttr.Put(XFormTextHideFormItem(bHide));
//STRIP001 		aAttr.Put(XFormTextAdjustItem(eAdjust));
//STRIP001 
//STRIP001 		XFormTextShadow eShadow = XFTSHADOW_NONE;
//STRIP001 
//STRIP001 		if ( nLastShadowTbxId == TBI_SHADOW_NORMAL )
//STRIP001 		{
//STRIP001 			eShadow = XFTSHADOW_NORMAL;
//STRIP001 			aAttr.Put(XFormTextShadowXValItem(nSaveShadowX));
//STRIP001 			aAttr.Put(XFormTextShadowYValItem(nSaveShadowY));
//STRIP001 		}
//STRIP001 		else if ( nLastShadowTbxId == TBI_SHADOW_SLANT )
//STRIP001 		{
//STRIP001 			eShadow = XFTSHADOW_SLANT;
//STRIP001 			aAttr.Put(XFormTextShadowXValItem(nSaveShadowAngle));
//STRIP001 			aAttr.Put(XFormTextShadowYValItem(nSaveShadowSize));
//STRIP001 		}
//STRIP001 
//STRIP001 		aAttr.Put(XFormTextShadowItem(eShadow));
//STRIP001 
//STRIP001 		rView.SetAttributes(aAttr);
//STRIP001 		rView.EndUndo();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxFontWorkDialog::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 
//STRIP001     SfxDockingWindow::DataChanged( rDCEvt );
//STRIP001 }
/* -----------------------------08.05.2002 14:28------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxFontWorkDialog::ApplyImageList()
//STRIP001 {
//STRIP001 	bool bHighContrast =
//STRIP001 		(GetSettings().GetStyleSettings().GetHighContrastMode() != 0) &&
//STRIP001 		(bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0);
//STRIP001 
//STRIP001 	ResMgr* pMgr = DIALOG_MGR();
//STRIP001 
//STRIP001 	USHORT nBitmapResId = bHighContrast ? RID_SVXBMP_FONTWORK_FORM1_H : RID_SVXBMP_FONTWORK_FORM1;
//STRIP001 	USHORT nTextResId = RID_SVXSTR_FONTWORK_FORM1;
//STRIP001 
//STRIP001 	bool bInit = aFormSet.GetItemCount() == 0;
//STRIP001 
//STRIP001 	if( bInit )
//STRIP001 	{
//STRIP001 /*
//STRIP001 		Size aSize( aTbxStyle.CalcWindowSizePixel() );
//STRIP001 		Bitmap aBmp(ResId(RID_SVXBMP_FONTWORK_FORM1,pMgr));
//STRIP001 		aSize.Height() = aFormSet.CalcWindowSizePixel(aBmp.GetSizePixel()).Height() + 2;
//STRIP001 		aFormSet.SetSizePixel(aSize);
//STRIP001 */
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for( i = 1; i < 13; i++, nTextResId++, nBitmapResId++ )
//STRIP001 	{
//STRIP001 		if( bInit )
//STRIP001 		{
//STRIP001 			aFormSet.InsertItem( i, Bitmap(ResId(nBitmapResId,pMgr)),
//STRIP001 									String(ResId(nTextResId,pMgr)));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aFormSet.SetItemImage( i, Bitmap(ResId(nBitmapResId,pMgr)) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     ImageList& rImgLst = bHighContrast ? maImageListH : maImageList;
//STRIP001 
//STRIP001 	aTbxStyle.SetImageList( rImgLst );
//STRIP001 	aTbxAdjust.SetImageList( rImgLst );
//STRIP001 	aTbxShadow.SetImageList( rImgLst );
//STRIP001 
//STRIP001 	switch( nLastShadowTbxId )
//STRIP001 	{
//STRIP001 	case TBI_SHADOW_SLANT:
//STRIP001 		aFbShadowX.SetImage( rImgLst.GetImage( TBI_SHADOW_ANGLE ) );
//STRIP001 		aFbShadowY.SetImage( rImgLst.GetImage( TBI_SHADOW_SIZE ) );
//STRIP001 		break;
//STRIP001 //	case TBI_SHADOW_NORMAL:
//STRIP001 	default:
//STRIP001 		aFbShadowX.SetImage( rImgLst.GetImage( TBI_SHADOW_XDIST ) );
//STRIP001 		aFbShadowY.SetImage( rImgLst.GetImage( TBI_SHADOW_YDIST ) );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	aFbDistance.SetImage( rImgLst.GetImage( TBI_DISTANCE ) );
//STRIP001 	aFbTextStart.SetImage( rImgLst.GetImage( TBI_TEXTSTART ) );
//STRIP001 
//STRIP001 }
}
