/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_pagectrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:58:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#define ITEMID_BOX      	0
#define ITEMID_FRAMEDIR     0
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#ifndef _SVX_FRMDIRITEM_HXX
#include <frmdiritem.hxx>
#endif
#include "pageitem.hxx"
#include "pagectrl.hxx"
#include "boxitem.hxx"

#include <algorithm>
namespace binfilter {

// struct PageWindow_Impl ------------------------------------------------

//STRIP001 struct PageWindow_Impl
//STRIP001 {
//STRIP001 	SvxBoxItem*		pBorder;
//STRIP001 	Bitmap			aBitmap;
//STRIP001 	FASTBOOL		bBitmap;
//STRIP001     sal_Bool        bFrameDirection;
//STRIP001     sal_Int32       nFrameDirection;
//STRIP001 
//STRIP001 
//STRIP001     PageWindow_Impl() :
//STRIP001         pBorder(0),
//STRIP001         bBitmap(FALSE),
//STRIP001         bFrameDirection(sal_False),
//STRIP001         nFrameDirection(0) {}
//STRIP001 
//STRIP001     void        EnableFrameDirection(sal_Bool bEnable){bFrameDirection = bEnable;}
//STRIP001     void        SetFrameDirection(sal_Int32 nDirection){nFrameDirection = nDirection;}
//STRIP001 
//STRIP001 };
//STRIP001 
//STRIP001 // STATIC DATA -----------------------------------------------------------
//STRIP001 
//STRIP001 #define CELL_WIDTH		1600L
//STRIP001 #define CELL_HEIGHT		 800L
//STRIP001 
//STRIP001 // class SvxPageWindow ---------------------------------------------------
//STRIP001 
//STRIP001 SvxPageWindow::SvxPageWindow( Window* pParent, const ResId& rId ) :
//STRIP001 
//STRIP001 	Window( pParent, rId ),
//STRIP001 
//STRIP001 	nTop		( 0 ),
//STRIP001 	nBottom		( 0 ),
//STRIP001 	nLeft		( 0 ),
//STRIP001 	nRight		( 0 ),
//STRIP001     aColor      ( COL_TRANSPARENT ),
//STRIP001 	nHdLeft		( 0 ),
//STRIP001 	nHdRight	( 0 ),
//STRIP001 	nHdDist		( 0 ),
//STRIP001 	nHdHeight	( 0 ),
//STRIP001     aHdColor    ( COL_TRANSPARENT ),
//STRIP001 	pHdBorder	( 0 ),
//STRIP001 	nFtLeft		( 0 ),
//STRIP001 	nFtRight	( 0 ),
//STRIP001 	nFtDist		( 0 ),
//STRIP001 	nFtHeight	( 0 ),
//STRIP001     aFtColor    ( COL_TRANSPARENT ),
//STRIP001 	pFtBorder 	( 0 ),
//STRIP001 	bFooter		( FALSE ),
//STRIP001 	bHeader		( FALSE ),
//STRIP001 	bTable		( FALSE ),
//STRIP001 	bHorz		( FALSE ),
//STRIP001 	bVert		( FALSE ),
//STRIP001 	eUsage		( SVX_PAGE_ALL )
//STRIP001 
//STRIP001 {
//STRIP001 	pImpl = new PageWindow_Impl;
//STRIP001 
//STRIP001 	// defaultmaessing in Twips rechnen
//STRIP001 	SetMapMode( MapMode( MAP_TWIP ) );
//STRIP001 	aWinSize = GetOutputSizePixel();
//STRIP001 	aWinSize.Height() -= 4;
//STRIP001 	aWinSize.Width() -= 4;
//STRIP001 
//STRIP001 	aWinSize = PixelToLogic( aWinSize );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxPageWindow::~SvxPageWindow()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 	delete pHdBorder;
//STRIP001 	delete pFtBorder;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void __EXPORT SvxPageWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Fraction aXScale( aWinSize.Width(), std::max( (long) (aSize.Width() * 2 + aSize.Width() / 8), 1L ) );
//STRIP001 	Fraction aYScale( aWinSize.Height(), std::max( aSize.Height(), 1L ) );
//STRIP001 	MapMode aMapMode( GetMapMode() );
//STRIP001 
//STRIP001 	if ( aYScale < aXScale )
//STRIP001 	{
//STRIP001 		aMapMode.SetScaleX( aYScale );
//STRIP001 		aMapMode.SetScaleY( aYScale );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aMapMode.SetScaleX( aXScale );
//STRIP001 		aMapMode.SetScaleY( aXScale );
//STRIP001 	}
//STRIP001 	SetMapMode( aMapMode );
//STRIP001 	Size aSz( PixelToLogic( GetSizePixel() ) );
//STRIP001 	long nYPos = ( aSz.Height() - aSize.Height() ) / 2;
//STRIP001 
//STRIP001 	if ( eUsage == SVX_PAGE_ALL )
//STRIP001 	{
//STRIP001 		// alle Seiten gleich -> eine Seite malen
//STRIP001 		if ( aSize.Width() > aSize.Height() )
//STRIP001 		{
//STRIP001 			// Querformat in gleicher Gr"osse zeichnen
//STRIP001 			Fraction aX = aMapMode.GetScaleX();
//STRIP001 			Fraction aY = aMapMode.GetScaleY();
//STRIP001 			Fraction a2( 1.5 );
//STRIP001 			aX *= a2;
//STRIP001 			aY *= a2;
//STRIP001 			aMapMode.SetScaleX( aX );
//STRIP001 			aMapMode.SetScaleY( aY );
//STRIP001 			SetMapMode( aMapMode );
//STRIP001 			aSz = PixelToLogic( GetSizePixel() );
//STRIP001 			nYPos = ( aSz.Height() - aSize.Height() ) / 2;
//STRIP001 			long nXPos = ( aSz.Width() - aSize.Width() ) / 2;
//STRIP001 			DrawPage( Point( nXPos, nYPos ), TRUE, TRUE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			// Hochformat
//STRIP001 			DrawPage( Point( ( aSz.Width() - aSize.Width() ) / 2, nYPos ), TRUE, TRUE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Linke und rechte Seite unterschiedlich -> ggf. zwei Seiten malen
//STRIP001 		DrawPage( Point( 0, nYPos ), FALSE, (BOOL)( eUsage & SVX_PAGE_LEFT ) );
//STRIP001 		DrawPage( Point( aSize.Width() + aSize.Width() / 8, nYPos ), TRUE,
//STRIP001 				  (BOOL)( eUsage & SVX_PAGE_RIGHT ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 void SvxPageWindow::DrawPage( const Point& rOrg, const BOOL bSecond, const BOOL bEnabled )
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     const Color& rFieldColor = rStyleSettings.GetFieldColor();
//STRIP001     const Color& rFieldTextColor = rStyleSettings.GetFieldTextColor();
//STRIP001     const Color& rDisableColor = rStyleSettings.GetDisableColor();
//STRIP001     const Color& rDlgColor = rStyleSettings.GetDialogColor();
//STRIP001 
//STRIP001     // background
//STRIP001     if(!bSecond)
//STRIP001     {
//STRIP001         SetLineColor( Color(COL_TRANSPARENT) );
//STRIP001         SetFillColor( rDlgColor );
//STRIP001         Size aWinSize(GetOutputSize());
//STRIP001         DrawRect( Rectangle( Point(0,0), aWinSize ) );
//STRIP001     }
//STRIP001     SetLineColor( rFieldTextColor );
//STRIP001     // Schatten
//STRIP001     Size aTempSize = aSize;
//STRIP001     // Seite
//STRIP001 	if ( !bEnabled )
//STRIP001 	{
//STRIP001         SetFillColor( rDisableColor );
//STRIP001 		DrawRect( Rectangle( rOrg, aTempSize ) );
//STRIP001 		return;
//STRIP001 	}
//STRIP001     SetFillColor( rFieldColor );
//STRIP001 	DrawRect( Rectangle( rOrg, aTempSize ) );
//STRIP001 
//STRIP001 	// Border Top Bottom Left Right
//STRIP001 	Point aBegin( rOrg );
//STRIP001 	Point aEnd( rOrg );
//STRIP001 
//STRIP001 	long nL = nLeft;
//STRIP001 	long nR = nRight;
//STRIP001 
//STRIP001 	if ( eUsage == SVX_PAGE_MIRROR && !bSecond )
//STRIP001 	{
//STRIP001 		// f"ur gespiegelt drehen
//STRIP001 		nL = nRight;
//STRIP001 		nR = nLeft;
//STRIP001 	}
//STRIP001 
//STRIP001 	Rectangle aRect;
//STRIP001 
//STRIP001 	aRect.Left()  = rOrg.X() + nL;
//STRIP001 	aRect.Right() = rOrg.X() + aTempSize.Width() - nR;
//STRIP001 	aRect.Top()	  = rOrg.Y() + nTop;
//STRIP001 	aRect.Bottom()= rOrg.Y() + aTempSize.Height() - nBottom;
//STRIP001 
//STRIP001 	Rectangle aHdRect( aRect );
//STRIP001 	Rectangle aFtRect( aRect );
//STRIP001 
//STRIP001 	if ( bHeader )
//STRIP001 	{
//STRIP001 		// ggf. Header anzeigen
//STRIP001 		aHdRect.Left() += nHdLeft;
//STRIP001 		aHdRect.Right() -= nHdRight;
//STRIP001 		aHdRect.Bottom() = aRect.Top() + nHdHeight;
//STRIP001 		aRect.Top() += nHdHeight + nHdDist;
//STRIP001 		SetFillColor( aHdColor );
//STRIP001 		DrawRect( aHdRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bFooter )
//STRIP001 	{
//STRIP001 		// ggf. Footer anzeigen
//STRIP001 		aFtRect.Left() += nFtLeft;
//STRIP001 		aFtRect.Right() -= nFtRight;
//STRIP001 		aFtRect.Top() = aRect.Bottom() - nFtHeight;
//STRIP001 		aRect.Bottom() -= nFtHeight + nFtDist;
//STRIP001 		SetFillColor( aFtColor );
//STRIP001 		DrawRect( aFtRect );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Body malen
//STRIP001 	SetFillColor( aColor );
//STRIP001 	if ( pImpl->bBitmap )
//STRIP001 	{
//STRIP001 		DrawRect( aRect );
//STRIP001 		Point aBmpPnt = aRect.TopLeft();
//STRIP001 		Size aBmpSiz = aRect.GetSize();
//STRIP001 		long nDeltaX = aBmpSiz.Width() / 15;
//STRIP001 		long nDeltaY = aBmpSiz.Height() / 15;
//STRIP001 		aBmpPnt.X() += nDeltaX;
//STRIP001 		aBmpPnt.Y() += nDeltaY;
//STRIP001 		aBmpSiz.Width() -= nDeltaX * 2;
//STRIP001 		aBmpSiz.Height() -= nDeltaY * 2;
//STRIP001 		DrawBitmap( aBmpPnt, aBmpSiz, pImpl->aBitmap );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		DrawRect( aRect );
//STRIP001 
//STRIP001     if(pImpl->bFrameDirection && !bTable)
//STRIP001     {
//STRIP001        //pImpl->nFrameDirection
//STRIP001         Point aPos;
//STRIP001         Font aFont(GetFont());
//STRIP001         const Size aSaveSize = aFont.GetSize();
//STRIP001         Size aDrawSize( 0, aRect.GetHeight() / 6);
//STRIP001         aFont.SetSize(aDrawSize);
//STRIP001         SetFont(aFont);
//STRIP001         String sText(String::CreateFromAscii("ABC"));
//STRIP001         Point aMove(1, GetTextHeight());
//STRIP001         sal_Unicode cArrow = 0x2193;
//STRIP001         long nAWidth = GetTextWidth(String(sText.GetChar(0)));
//STRIP001         switch(pImpl->nFrameDirection)
//STRIP001         {
//STRIP001             case FRMDIR_HORI_LEFT_TOP:
//STRIP001                 aPos = aRect.TopLeft();
//STRIP001                 aPos.X() += PixelToLogic(Point(1,1)).X();
//STRIP001                 aMove.Y() = 0;
//STRIP001                 cArrow = 0x2192;
//STRIP001             break;
//STRIP001             case FRMDIR_HORI_RIGHT_TOP:
//STRIP001                 aPos = aRect.TopRight();
//STRIP001                 aPos.X() -= nAWidth;
//STRIP001                 aMove.Y() = 0;
//STRIP001                 aMove.X() *= -1;
//STRIP001                 cArrow = 0x2190;
//STRIP001             break;
//STRIP001             case FRMDIR_VERT_TOP_LEFT:
//STRIP001                 aPos = aRect.TopLeft();
//STRIP001                 aPos.X() += PixelToLogic(Point(1,1)).X();
//STRIP001                 aMove.X() = 0;
//STRIP001             break;
//STRIP001             case FRMDIR_VERT_TOP_RIGHT:
//STRIP001                 aPos = aRect.TopRight();
//STRIP001                 aPos.X() -= nAWidth;
//STRIP001                 aMove.X() = 0;
//STRIP001             break;
//STRIP001         }
//STRIP001         sText.Append(cArrow);
//STRIP001         for(USHORT i = 0; i < sText.Len(); i++)
//STRIP001         {
//STRIP001             String sDraw(sText.GetChar(i));
//STRIP001             long nHDiff = 0;
//STRIP001             long nCharWidth = GetTextWidth(sDraw);
//STRIP001             BOOL bHorizontal = 0 == aMove.Y();
//STRIP001             if(!bHorizontal)
//STRIP001             {
//STRIP001                 nHDiff = (nAWidth - nCharWidth)/2;
//STRIP001                 aPos.X() += nHDiff;
//STRIP001             }
//STRIP001             DrawText(aPos, sDraw);
//STRIP001             if(bHorizontal)
//STRIP001             {
//STRIP001                 aPos.X() += aMove.X() < 0 ? - nCharWidth : nCharWidth;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 aPos.X() -= nHDiff;
//STRIP001                 aPos.Y() += aMove.Y();
//STRIP001             }
//STRIP001         }
//STRIP001         aFont.SetSize(aSaveSize);
//STRIP001         SetFont(aFont);
//STRIP001 
//STRIP001     }
//STRIP001 	if ( bTable )
//STRIP001 	{
//STRIP001 		// Tabelle malen, ggf. zentrieren
//STRIP001 		SetLineColor( Color(COL_LIGHTGRAY) );
//STRIP001 
//STRIP001 		long nW = aRect.GetWidth(), nH = aRect.GetHeight();
//STRIP001 		long nTW = CELL_WIDTH * 3, nTH = CELL_HEIGHT * 3;
//STRIP001 		long nLeft = bHorz ? aRect.Left() + ((nW - nTW) / 2) : aRect.Left();
//STRIP001 		long nTop = bVert ? aRect.Top() + ((nH - nTH) / 2) : aRect.Top();
//STRIP001 		Rectangle aCellRect( Point( nLeft, nTop ), Size( CELL_WIDTH, CELL_HEIGHT ) );
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < 3; ++i )
//STRIP001 		{
//STRIP001 			aCellRect.Left() = nLeft;
//STRIP001 			aCellRect.Right() = nLeft + CELL_WIDTH;
//STRIP001 			if ( i > 0 )
//STRIP001 				aCellRect.Move( 0, CELL_HEIGHT );
//STRIP001 
//STRIP001 			for ( USHORT j = 0; j < 3; ++j )
//STRIP001 			{
//STRIP001 				if ( j > 0 )
//STRIP001 					aCellRect.Move( CELL_WIDTH, 0 );
//STRIP001 				DrawRect( aCellRect );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageWindow::SetBorder( const SvxBoxItem& rNew )
//STRIP001 {
//STRIP001 	delete pImpl->pBorder;
//STRIP001 	pImpl->pBorder = new SvxBoxItem( rNew );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageWindow::SetBitmap( Bitmap* pBmp )
//STRIP001 {
//STRIP001 	if ( pBmp )
//STRIP001 	{
//STRIP001 		pImpl->aBitmap = *pBmp;
//STRIP001 		pImpl->bBitmap = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pImpl->bBitmap = FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageWindow::SetHdBorder( const SvxBoxItem& rNew )
//STRIP001 {
//STRIP001 	delete pHdBorder;
//STRIP001 	pHdBorder = new SvxBoxItem( rNew );
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPageWindow::SetFtBorder( const SvxBoxItem& rNew )
//STRIP001 {
//STRIP001 	delete pFtBorder;
//STRIP001 	pFtBorder = new SvxBoxItem( rNew );
//STRIP001 }
//STRIP001 /* -----------------------------13.06.2002 16:16------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void  SvxPageWindow::EnableFrameDirection(sal_Bool bEnable)
//STRIP001 {
//STRIP001     pImpl->EnableFrameDirection(bEnable);
//STRIP001 }
//STRIP001 /* -----------------------------13.06.2002 16:16------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void  SvxPageWindow::SetFrameDirection(sal_Int32 nFrameDirection)
//STRIP001 {
//STRIP001     pImpl->SetFrameDirection(nFrameDirection);
//STRIP001 }

}
