/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_tabstpge.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:07:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#define ITEMID_TABSTOP	0
#define ITEMID_LRSPACE 	0
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _RULER_HXX //autogen
#include <svtools/ruler.hxx>
#endif

#define _SVX_TABSTPGE_CXX

#include "dialogs.hrc"
#include "tabstpge.hrc"

#include "lrspitem.hxx"
#include "tabstpge.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"

#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#ifndef _SVTOOLS_CJKOPTIONS_HXX
#include <svtools/cjkoptions.hxx>
#endif

#ifndef _UNOTOOLS_LOCALEDATAWRAPPER_HXX
#include <unotools/localedatawrapper.hxx>
#endif
#ifndef _UNOTOOLS_PROCESSFACTORY_HXX
#include <comphelper/processfactory.hxx>
#endif

#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

// class TabWin_Impl -----------------------------------------------------

//STRIP001 class TabWin_Impl : public Window
//STRIP001 {
//STRIP001 private:
//STRIP001 	USHORT  nTabStyle;
//STRIP001 
//STRIP001 public:
//STRIP001 	TabWin_Impl( Window* pParent, const ResId& rId, USHORT nStyle ) :
//STRIP001 		Window( pParent, rId ),
//STRIP001 		nTabStyle( nStyle ) {}
//STRIP001 
//STRIP001 	virtual void    Paint( const Rectangle& rRect );
//STRIP001 };
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_TABSTOP,
//STRIP001 	SID_ATTR_TABSTOP_OFFSET,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 // C-Funktion ------------------------------------------------------------
//STRIP001 
//STRIP001 void FillUpWithDefTabs_Impl( long nDefDist, SvxTabStopItem& rTabs )
//STRIP001 {
//STRIP001 	if( rTabs.Count() )
//STRIP001 		return;
//STRIP001 	{
//STRIP001 		SvxTabStop aSwTabStop( nDefDist, SVX_TAB_ADJUST_DEFAULT );
//STRIP001 		rTabs.Insert( aSwTabStop );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // class TabWin_Impl -----------------------------------------------------
//STRIP001 
//STRIP001 void TabWin_Impl::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	// Tabulatoren malen
//STRIP001 	Point aPnt;
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	aPnt.X() = aSize.Width() / 2;
//STRIP001 	aPnt.Y() = aSize.Height() / 2;
//STRIP001 	Ruler::DrawTab( this, aPnt, nTabStyle );
//STRIP001 }
//STRIP001 
//STRIP001 // class SvxTabulatorTabPage ---------------------------------------------
//STRIP001 
//STRIP001 SvxTabulatorTabPage::SvxTabulatorTabPage( Window* pParent,
//STRIP001 										  const SfxItemSet& rAttr ):
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( RID_SVXPAGE_TABULATOR, DIALOG_MGR() ), rAttr ),
//STRIP001 
//STRIP001 	aTabBox         ( this, ResId( ED_TABPOS ) ),
//STRIP001     aTabLabel       ( this, ResId( FL_TABPOS ) ),
//STRIP001     aTabLabelVert   ( this, ResId( FL_TABPOS_VERT ) ),
//STRIP001 	aLeftTab        ( this, ResId( BTN_TABTYPE_LEFT ) ),
//STRIP001 	aRightTab       ( this, ResId( BTN_TABTYPE_RIGHT ) ),
//STRIP001 	aCenterTab      ( this, ResId( BTN_TABTYPE_CENTER ) ),
//STRIP001 	aDezTab         ( this, ResId( BTN_TABTYPE_DECIMAL ) ),
//STRIP001     pLeftWin        ( new TabWin_Impl( this, ResId( WIN_TABLEFT ), RULER_TAB_LEFT|WB_HORZ ) ),
//STRIP001     pRightWin       ( new TabWin_Impl( this, ResId( WIN_TABRIGHT ), RULER_TAB_RIGHT|WB_HORZ ) ),
//STRIP001     pCenterWin      ( new TabWin_Impl( this, ResId( WIN_TABCENTER ), RULER_TAB_CENTER|WB_HORZ ) ),
//STRIP001     pDezWin         ( new TabWin_Impl( this, ResId( WIN_TABDECIMAL ), RULER_TAB_DECIMAL|WB_HORZ ) ),
//STRIP001 	aDezChar        ( this, ResId( ED_TABTYPE_DECCHAR ) ),
//STRIP001 	aDezCharLabel   ( this, ResId( FT_TABTYPE_DECCHAR ) ),
//STRIP001     aTabTypeLabel   ( this, ResId( FL_TABTYPE ) ),
//STRIP001     aTabTypeLabelVert ( this, ResId( FL_TABTYPE_VERT ) ),
//STRIP001 	aNoFillChar     ( this, ResId( BTN_FILLCHAR_NO ) ),
//STRIP001 	aFillPoints     ( this, ResId( BTN_FILLCHAR_POINTS ) ),
//STRIP001 	aFillDashLine   ( this, ResId( BTN_FILLCHAR_DASHLINE ) ),
//STRIP001 	aFillSolidLine  ( this, ResId( BTN_FILLCHAR_UNDERSCORE ) ),
//STRIP001 	aFillSpecial    ( this, ResId( BTN_FILLCHAR_OTHER ) ),
//STRIP001 	aFillChar       ( this, ResId( ED_FILLCHAR_OTHER ) ),
//STRIP001     aFillLabel      ( this, ResId( FL_FILLCHAR ) ),
//STRIP001 	aNewBtn         ( this, ResId( BTN_NEW ) ),
//STRIP001 	aDelAllBtn      ( this, ResId( BTN_DELALL ) ),
//STRIP001 	aDelBtn         ( this, ResId( BTN_DEL ) ),
//STRIP001 
//STRIP001 	aNewTabs    ( 0, 0, SVX_TAB_ADJUST_LEFT, GetWhich( SID_ATTR_TABSTOP ) ),
//STRIP001 	aAktTab     ( 0 ),
//STRIP001 	nDefDist    ( 0 ),
//STRIP001 	bCheck      ( FALSE )
//STRIP001 
//STRIP001 {
//STRIP001     SvtCJKOptions aCJKOptions;
//STRIP001     if(aCJKOptions.IsAsianTypographyEnabled())
//STRIP001     {
//STRIP001         aLeftTab  .SetText(String(ResId(   ST_LEFTTAB_ASIAN )));
//STRIP001         aRightTab .SetText(String(ResId(   ST_RIGHTTAB_ASIAN )));
//STRIP001     }
//STRIP001 
//STRIP001     // diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001     eDefUnit = FUNIT_100TH_MM;
//STRIP001 
//STRIP001 	// Metrik einstellen
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rAttr );
//STRIP001 	SetFieldUnit( aTabBox, eFUnit );
//STRIP001 
//STRIP001 	// Buttons initialisieren
//STRIP001 	aNewBtn.SetClickHdl( LINK( this,SvxTabulatorTabPage, NewHdl_Impl ) );
//STRIP001 	aDelBtn.SetClickHdl( LINK( this,SvxTabulatorTabPage, DelHdl_Impl ) );
//STRIP001 	aDelAllBtn.SetClickHdl( LINK( this,SvxTabulatorTabPage, DelAllHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxTabulatorTabPage, TabTypeCheckHdl_Impl );
//STRIP001 	aLeftTab.SetClickHdl( aLink );
//STRIP001 	aRightTab.SetClickHdl( aLink );
//STRIP001 	aDezTab.SetClickHdl( aLink );
//STRIP001 	aCenterTab.SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aDezChar.SetLoseFocusHdl( LINK( this,  SvxTabulatorTabPage, GetDezCharHdl_Impl ) );
//STRIP001 	aDezChar.SetMaxTextLen(1);
//STRIP001 	aDezChar.Disable();
//STRIP001 	aDezCharLabel.Disable();
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxTabulatorTabPage, FillTypeCheckHdl_Impl );
//STRIP001 	aNoFillChar.SetClickHdl( aLink );
//STRIP001 	aFillPoints.SetClickHdl( aLink );
//STRIP001 	aFillDashLine.SetClickHdl( aLink );
//STRIP001 	aFillSolidLine.SetClickHdl( aLink );
//STRIP001 	aFillSpecial.SetClickHdl( aLink );
//STRIP001 	aFillChar.SetLoseFocusHdl( LINK( this,  SvxTabulatorTabPage, GetFillCharHdl_Impl ) );
//STRIP001 	aFillChar.SetMaxTextLen(1);
//STRIP001 	aFillChar.Disable();
//STRIP001 
//STRIP001 	aTabBox.SetDoubleClickHdl( LINK( this, SvxTabulatorTabPage, SelectHdl_Impl ) );
//STRIP001 	aTabBox.SetModifyHdl( LINK( this, SvxTabulatorTabPage, ModifyHdl_Impl ) );
//STRIP001 
//STRIP001     // das Default-Dezimalzeichen vom System holen
//STRIP001 	LocaleDataWrapper aLocaleWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	aAktTab.GetDecimal() = aLocaleWrapper.getNumDecimalSep().GetChar(0);
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxTabulatorTabPage::~SvxTabulatorTabPage()
//STRIP001 {
//STRIP001 	delete pLeftWin;
//STRIP001 	delete pRightWin;
//STRIP001 	delete pCenterWin;
//STRIP001 	delete pDezWin;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxTabulatorTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxTabulatorTabPage::FillItemSet( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	// Hier die Werte aus den Controls eintueten
//STRIP001 	if ( aNewBtn.IsEnabled() )
//STRIP001 		NewHdl_Impl( 0 );
//STRIP001 
//STRIP001 	// call at first the LoseFocus-Handler
//STRIP001 	GetDezCharHdl_Impl( &aDezChar );
//STRIP001 	GetFillCharHdl_Impl( &aFillChar );
//STRIP001 
//STRIP001 	FillUpWithDefTabs_Impl( nDefDist, aNewTabs );
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	MapUnit eUnit = (MapUnit)pPool->GetMetric( GetWhich( SID_ATTR_TABSTOP ) );
//STRIP001 	const SfxPoolItem* pOld = GetOldItem( rSet, SID_ATTR_TABSTOP );
//STRIP001 
//STRIP001     if ( MAP_100TH_MM != eUnit )
//STRIP001 	{
//STRIP001 		// Wenn sich im ItemSet ein LRSpaceItem mit negativen Erstzeileneinzug
//STRIP001 		// befindet, muss im TabStopItem auf der Position 0 ein DefTab sein.
//STRIP001 		const SfxPoolItem* pLRSpace;
//STRIP001 		// wenn nicht im neuen Set, dann vielleicht im alten
//STRIP001 		if ( SFX_ITEM_SET !=
//STRIP001 			 rSet.GetItemState( GetWhich( SID_ATTR_LRSPACE ), TRUE, &pLRSpace ) )
//STRIP001 			pLRSpace = GetOldItem( rSet, SID_ATTR_LRSPACE );
//STRIP001 
//STRIP001 		if ( pLRSpace && ( (SvxLRSpaceItem*)pLRSpace )->GetTxtFirstLineOfst() < 0 )
//STRIP001 		{
//STRIP001 			SvxTabStop aNull( 0, SVX_TAB_ADJUST_DEFAULT );
//STRIP001 			aNewTabs.Insert( aNull );
//STRIP001 		}
//STRIP001 
//STRIP001 		SvxTabStopItem aTmp( aNewTabs );
//STRIP001 		aTmp.Remove( 0, aTmp.Count() );
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < aNewTabs.Count(); ++i )
//STRIP001 		{
//STRIP001 			SvxTabStop aTmpStop = aNewTabs[i];
//STRIP001 			aTmpStop.GetTabPos() =
//STRIP001                 LogicToLogic( aTmpStop.GetTabPos(), MAP_100TH_MM, eUnit );
//STRIP001 			aTmp.Insert( aTmpStop );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !pOld || !( *( (SvxTabStopItem*)pOld ) == aTmp ) )
//STRIP001 		{
//STRIP001 			rSet.Put( aTmp );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( !pOld || !( *( (SvxTabStopItem*)pOld ) == aNewTabs ) )
//STRIP001 	{
//STRIP001 		rSet.Put( aNewTabs );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxTabulatorTabPage::Create( Window* pParent,
//STRIP001 										 const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	return ( new SvxTabulatorTabPage( pParent, rSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxTabulatorTabPage::Reset( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	MapUnit eUnit = (MapUnit)pPool->GetMetric( GetWhich( SID_ATTR_TABSTOP ) );
//STRIP001 
//STRIP001 	// Aktuelle Tabs
//STRIP001 	const SfxPoolItem* pItem = GetItem( rSet, SID_ATTR_TABSTOP );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001         if ( MAP_100TH_MM != eUnit )
//STRIP001 		{
//STRIP001 			SvxTabStopItem aTmp( *( (const SvxTabStopItem*)pItem ) );
//STRIP001 			aNewTabs.Remove( 0, aNewTabs.Count() );
//STRIP001 
//STRIP001 			for ( USHORT i = 0; i < aTmp.Count(); ++i )
//STRIP001 			{
//STRIP001 				SvxTabStop aTmpStop = aTmp[i];
//STRIP001 				aTmpStop.GetTabPos() =
//STRIP001                     LogicToLogic( aTmpStop.GetTabPos(), eUnit, MAP_100TH_MM );
//STRIP001 				aNewTabs.Insert( aTmpStop );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aNewTabs = *( (const SvxTabStopItem*)pItem );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aNewTabs.Remove( 0, aNewTabs.Count() );
//STRIP001 
//STRIP001 	// Default-Tab - Abstand
//STRIP001 	nDefDist = SVX_TAB_DEFDIST;
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_TABSTOP_DEFAULTS );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		nDefDist = LogicToLogic(
//STRIP001             (long)((const SfxUInt16Item*)pItem)->GetValue(), eUnit, MAP_100TH_MM );
//STRIP001 
//STRIP001 	// Aktuell selektierte Tab-Pos
//STRIP001 	USHORT nTabPos = 0;
//STRIP001 	pItem = GetItem( rSet, SID_ATTR_TABSTOP_POS );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		nTabPos = ( (const SfxUInt16Item*)pItem )->GetValue();
//STRIP001 
//STRIP001 	InitTabPos_Impl( nTabPos );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxTabulatorTabPage::DisableControls( const USHORT nFlag )
//STRIP001 {
//STRIP001 	if ( ( TABTYPE_LEFT & nFlag ) == TABTYPE_LEFT )
//STRIP001 	{
//STRIP001 		aLeftTab.Disable();
//STRIP001 		pLeftWin->Disable();
//STRIP001 	}
//STRIP001 	if ( ( TABTYPE_RIGHT & nFlag ) == TABTYPE_RIGHT )
//STRIP001 	{
//STRIP001 		aRightTab.Disable();
//STRIP001 		pRightWin->Disable();
//STRIP001 	}
//STRIP001 	if ( ( TABTYPE_CENTER & nFlag ) == TABTYPE_CENTER )
//STRIP001 	{
//STRIP001 		aCenterTab.Disable();
//STRIP001 		pCenterWin->Disable();
//STRIP001 	}
//STRIP001 	if ( ( TABTYPE_DEZIMAL & nFlag ) == TABTYPE_DEZIMAL )
//STRIP001 	{
//STRIP001 		aDezTab.Disable();
//STRIP001 		pDezWin->Disable();
//STRIP001 		aDezCharLabel.Disable();
//STRIP001 		aDezChar.Disable();
//STRIP001 	}
//STRIP001 	if ( ( TABTYPE_ALL & nFlag ) == TABTYPE_ALL )
//STRIP001 		aTabTypeLabel.Disable();
//STRIP001 	if ( ( TABFILL_NONE & nFlag ) == TABFILL_NONE )
//STRIP001 		aNoFillChar.Disable();
//STRIP001 	if ( ( TABFILL_POINT & nFlag ) == TABFILL_POINT )
//STRIP001 		aFillPoints.Disable();
//STRIP001 	if ( ( TABFILL_DASHLINE & nFlag ) == TABFILL_DASHLINE )
//STRIP001 		aFillDashLine.Disable();
//STRIP001 	if ( ( TABFILL_SOLIDLINE & nFlag ) == TABFILL_SOLIDLINE )
//STRIP001 		aFillSolidLine.Disable();
//STRIP001 	if ( ( TABFILL_SPECIAL & nFlag ) == TABFILL_SPECIAL )
//STRIP001 	{
//STRIP001 		aFillSpecial.Disable();
//STRIP001 		aFillChar.Disable();
//STRIP001 	}
//STRIP001 	if ( ( TABFILL_ALL & nFlag ) == TABFILL_ALL )
//STRIP001 		aFillLabel.Disable();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxTabulatorTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	return LEAVE_PAGE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxTabulatorTabPage::InitTabPos_Impl( USHORT nTabPos )
//STRIP001 {
//STRIP001 	aTabBox.Clear();
//STRIP001 
//STRIP001     long nOffset = 0;
//STRIP001     const SfxPoolItem* pItem = 0;
//STRIP001     if ( GetItemSet().GetItemState( SID_ATTR_TABSTOP_OFFSET, TRUE, &pItem )
//STRIP001             == SFX_ITEM_SET )
//STRIP001     {
//STRIP001         nOffset = ( (const SfxInt32Item*)pItem )->GetValue();
//STRIP001         MapUnit eUnit = (MapUnit)GetItemSet().GetPool()->GetMetric( GetWhich( SID_ATTR_TABSTOP ) );
//STRIP001         nOffset = OutputDevice::LogicToLogic( nOffset, eUnit, MAP_100TH_MM  );
//STRIP001     }
//STRIP001 
//STRIP001     // Aktuelle TabPos korrigieren und Defaults-Tabs
//STRIP001 	for ( USHORT i = 0; i < aNewTabs.Count(); i++ )
//STRIP001 	{
//STRIP001 		if ( aNewTabs[i].GetAdjustment() != SVX_TAB_ADJUST_DEFAULT )
//STRIP001 		{
//STRIP001             aTabBox.InsertValue( aTabBox.Normalize(
//STRIP001 				aNewTabs[i].GetTabPos() + nOffset ), eDefUnit );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aNewTabs.Remove( i-- );
//STRIP001 	}
//STRIP001 
//STRIP001 	// aktuellen Tabulator auswaehlen
//STRIP001 	const USHORT nSize = aNewTabs.Count();
//STRIP001 
//STRIP001 	if ( nTabPos >= nSize )
//STRIP001 		nTabPos = 0;
//STRIP001 
//STRIP001 	// alle RadioButtons erstmal ausschalten
//STRIP001 	aLeftTab.Check( TRUE );
//STRIP001 	aNoFillChar.Check( TRUE );
//STRIP001 
//STRIP001 	if( aTabBox.GetEntryCount() > 0 )
//STRIP001 	{
//STRIP001 		aTabBox.SetText( aTabBox.GetEntry( nTabPos ) );
//STRIP001 		aAktTab = aNewTabs[nTabPos];
//STRIP001 
//STRIP001 		SetFillAndTabType_Impl();
//STRIP001 		aNewBtn.Disable();
//STRIP001 		aDelBtn.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{   // kein Eintrag dann ist 0 der Default-Wert
//STRIP001 		aTabBox.SetValue( 0, eDefUnit );
//STRIP001 
//STRIP001 		aNewBtn.Enable();
//STRIP001 		aDelBtn.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxTabulatorTabPage::SetFillAndTabType_Impl()
//STRIP001 {
//STRIP001 	RadioButton* pTypeBtn = 0;
//STRIP001 	RadioButton* pFillBtn = 0;
//STRIP001 
//STRIP001 	aDezChar.Disable();
//STRIP001 	aDezCharLabel.Disable();
//STRIP001 
//STRIP001 	if ( aAktTab.GetAdjustment() == SVX_TAB_ADJUST_LEFT )
//STRIP001 		pTypeBtn = &aLeftTab;
//STRIP001 	else if ( aAktTab.GetAdjustment() == SVX_TAB_ADJUST_RIGHT )
//STRIP001 		pTypeBtn = &aRightTab;
//STRIP001 	else if ( aAktTab.GetAdjustment() == SVX_TAB_ADJUST_DECIMAL )
//STRIP001 	{
//STRIP001 		pTypeBtn = &aDezTab;
//STRIP001 		aDezChar.Enable();
//STRIP001 		aDezCharLabel.Enable();
//STRIP001 		aDezChar.SetText( String( (sal_Unicode)aAktTab.GetDecimal() ) );
//STRIP001 	}
//STRIP001 	else if ( aAktTab.GetAdjustment() == SVX_TAB_ADJUST_CENTER )
//STRIP001 		pTypeBtn = &aCenterTab;
//STRIP001 
//STRIP001 	if ( pTypeBtn )
//STRIP001 		pTypeBtn->Check();
//STRIP001 
//STRIP001 	aFillChar.Disable();
//STRIP001 	aFillChar.SetText( String() );
//STRIP001 
//STRIP001 	if ( aAktTab.GetFill() == ' ' )
//STRIP001 		pFillBtn = &aNoFillChar;
//STRIP001 	else if ( aAktTab.GetFill() == '-' )
//STRIP001 		pFillBtn = &aFillDashLine;
//STRIP001 	else if ( aAktTab.GetFill() == '_' )
//STRIP001 		pFillBtn = &aFillSolidLine;
//STRIP001 	else if ( aAktTab.GetFill() == '.' )
//STRIP001 		pFillBtn = &aFillPoints;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFillBtn = &aFillSpecial;
//STRIP001 		aFillChar.Enable();
//STRIP001 		aFillChar.SetText( String( (sal_Unicode)aAktTab.GetFill() ) );
//STRIP001 	}
//STRIP001 	pFillBtn->Check();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, NewHdl_Impl, Button *, pBtn )
//STRIP001 {
//STRIP001 	// Einen neuen Hinzufuegen und Selectieren
//STRIP001 	// Wert aus der Anzeige holen
//STRIP001 	long nVal = aTabBox.Denormalize( aTabBox.GetValue( eDefUnit ) );
//STRIP001 
//STRIP001 	// Wenn der pBtn == 0 && der Value == 0 dann keinen Tab Erzeugen
//STRIP001 	// weil ueber OK erzeugt
//STRIP001 	if ( nVal == 0 && pBtn == 0 )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	long nOffset = 0;
//STRIP001 	const SfxPoolItem* pItem = 0;
//STRIP001 
//STRIP001 	if ( GetItemSet().GetItemState( SID_ATTR_TABSTOP_OFFSET, TRUE, &pItem ) ==
//STRIP001 		 SFX_ITEM_SET )
//STRIP001 	{
//STRIP001 		nOffset = ( (const SfxInt32Item*)pItem )->GetValue();
//STRIP001         MapUnit eUnit = (MapUnit)GetItemSet().GetPool()->GetMetric( GetWhich( SID_ATTR_TABSTOP ) );
//STRIP001         nOffset = OutputDevice::LogicToLogic( nOffset, eUnit, MAP_100TH_MM  );
//STRIP001 	}
//STRIP001 	const long nReal = nVal - nOffset;
//STRIP001 	USHORT nSize = aTabBox.GetEntryCount();
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for( i = 0; i < nSize; i++ )
//STRIP001 	{
//STRIP001 		if ( nReal < aNewTabs[i].GetTabPos() )
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// ListBox-Eintrag vornehmen
//STRIP001 	aTabBox.InsertValue( aTabBox.Normalize( nVal ), eDefUnit, i );
//STRIP001 	aAktTab.GetTabPos() = nReal;
//STRIP001 	SvxTabAdjust eAdj = SVX_TAB_ADJUST_LEFT;
//STRIP001 
//STRIP001 	if ( aRightTab.IsChecked() )
//STRIP001 		eAdj = SVX_TAB_ADJUST_RIGHT;
//STRIP001 	else if ( aCenterTab.IsChecked() )
//STRIP001 		eAdj = SVX_TAB_ADJUST_CENTER;
//STRIP001 	else if ( aDezTab.IsChecked() )
//STRIP001 		eAdj = SVX_TAB_ADJUST_DECIMAL;
//STRIP001 
//STRIP001 	aAktTab.GetAdjustment() = eAdj;
//STRIP001 	aNewTabs.Insert( aAktTab );
//STRIP001 
//STRIP001 	aNewBtn.Disable();
//STRIP001 	aDelBtn.Enable();
//STRIP001 	aTabBox.GrabFocus();
//STRIP001 
//STRIP001 	// falls kein RadioButton geclickt wurde,
//STRIP001 	// muss trotzdem geputtet werden
//STRIP001 	bCheck |= TRUE;
//STRIP001     // set the selection into the position Edit
//STRIP001     aTabBox.SetSelection(Selection(0, aTabBox.GetText().Len()));
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, DelHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue() );
//STRIP001 
//STRIP001 	if ( nPos == COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	if ( aTabBox.GetEntryCount() == 1 )
//STRIP001 	{
//STRIP001 		DelAllHdl_Impl( 0 );
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Tab loeschen
//STRIP001 	aTabBox.RemoveEntry( nPos );
//STRIP001 	aNewTabs.Remove( nPos );
//STRIP001 
//STRIP001 	// aAktTab neu setzen
//STRIP001 	const USHORT nSize = aNewTabs.Count();
//STRIP001 
//STRIP001 	if ( nSize > 0 )
//STRIP001 	{
//STRIP001 		// Pos korrigieren
//STRIP001 		nPos = ( ( nSize - 1 ) >= nPos) ? nPos : nPos - 1;
//STRIP001 		aTabBox.SetValue( aTabBox.GetValue( nPos ) );
//STRIP001 		aAktTab = aNewTabs[nPos];
//STRIP001 	}
//STRIP001 
//STRIP001 	// Falls keine Tabs Enable Disable Controls
//STRIP001 	if ( aTabBox.GetEntryCount() == 0 )
//STRIP001 	{
//STRIP001 		aDelBtn.Disable();
//STRIP001 		aNewBtn.Enable();
//STRIP001 		aTabBox.GrabFocus();
//STRIP001 	}
//STRIP001 
//STRIP001 	// falls kein RadioButton geclickt wurde,
//STRIP001 	// muss trotzdem geputtet werden
//STRIP001 	bCheck |= TRUE;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, DelAllHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( aNewTabs.Count() )
//STRIP001 	{
//STRIP001 		aNewTabs = SvxTabStopItem( 0 );
//STRIP001 		InitTabPos_Impl();
//STRIP001 
//STRIP001 		// damit in FillItemSet() geputtet wird
//STRIP001 		bCheck |= TRUE;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, TabTypeCheckHdl_Impl, RadioButton *, pBox )
//STRIP001 {
//STRIP001 	bCheck |= TRUE;
//STRIP001 	SvxTabAdjust eAdj;
//STRIP001 	aDezChar.Disable();
//STRIP001 	aDezCharLabel.Disable();
//STRIP001 	aDezChar.SetText( String() );
//STRIP001 
//STRIP001 	if ( pBox == &aLeftTab )
//STRIP001 		eAdj = SVX_TAB_ADJUST_LEFT;
//STRIP001 	else if ( pBox == &aRightTab )
//STRIP001 		eAdj = SVX_TAB_ADJUST_RIGHT;
//STRIP001 	else if ( pBox == &aCenterTab )
//STRIP001 		eAdj = SVX_TAB_ADJUST_CENTER;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		eAdj = SVX_TAB_ADJUST_DECIMAL;
//STRIP001 		aDezChar.Enable();
//STRIP001 		aDezCharLabel.Enable();
//STRIP001 		aDezChar.SetText( String( (sal_Unicode)aAktTab.GetDecimal() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	aAktTab.GetAdjustment() = eAdj;
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit );
//STRIP001 
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aNewTabs.Remove( nPos );
//STRIP001 		aNewTabs.Insert( aAktTab );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, FillTypeCheckHdl_Impl, RadioButton *, pBox )
//STRIP001 {
//STRIP001 	bCheck |= TRUE;
//STRIP001 	BYTE cFill = ' ';
//STRIP001 	aFillChar.SetText( String() );
//STRIP001 	aFillChar.Disable();
//STRIP001 
//STRIP001 	if( pBox == &aFillSpecial )
//STRIP001 		aFillChar.Enable();
//STRIP001 	else if ( pBox == &aNoFillChar )
//STRIP001 		cFill = ' ';
//STRIP001 	else if ( pBox == &aFillSolidLine )
//STRIP001 		cFill = '_';
//STRIP001 	else if ( pBox == &aFillPoints )
//STRIP001 		cFill = '.';
//STRIP001 	else if ( pBox == &aFillDashLine )
//STRIP001 		cFill = '-';
//STRIP001 
//STRIP001 	aAktTab.GetFill() = cFill;
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit );
//STRIP001 
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aNewTabs.Remove( nPos );
//STRIP001 		aNewTabs.Insert( aAktTab );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, GetFillCharHdl_Impl, Edit *, pEdit )
//STRIP001 {
//STRIP001 	String aChar( pEdit->GetText() );
//STRIP001 
//STRIP001 	if ( aChar.Len() > 0 )
//STRIP001 		aAktTab.GetFill() = aChar.GetChar( 0 );
//STRIP001 
//STRIP001 	const USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit);
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aNewTabs.Remove( nPos );
//STRIP001 		aNewTabs.Insert( aAktTab );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, GetDezCharHdl_Impl, Edit *, pEdit )
//STRIP001 {
//STRIP001 	String aChar( pEdit->GetText() );
//STRIP001 	if ( aChar.Len() > 0 && ( aChar.GetChar( 0 ) >= ' ' || aChar.GetChar( 0 ) < -1 ) )
//STRIP001 		aAktTab.GetDecimal() = aChar.GetChar( 0 );
//STRIP001 
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit );
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aNewTabs.Remove( nPos );
//STRIP001 		aNewTabs.Insert( aAktTab );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, SelectHdl_Impl, MetricBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit );
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aAktTab = aNewTabs[nPos];
//STRIP001 		aNewBtn.Disable();
//STRIP001 		SetFillAndTabType_Impl();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxTabulatorTabPage, ModifyHdl_Impl, MetricBox *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nPos = aTabBox.GetValuePos( aTabBox.GetValue( eDefUnit ), eDefUnit );
//STRIP001 	if ( nPos != COMBOBOX_ENTRY_NOTFOUND )
//STRIP001 	{
//STRIP001 		aAktTab = aNewTabs[nPos];
//STRIP001 		SetFillAndTabType_Impl();
//STRIP001 
//STRIP001 		aAktTab.GetTabPos() =
//STRIP001 			aTabBox.Denormalize( aTabBox.GetValue( eDefUnit ) );
//STRIP001 
//STRIP001 		aNewBtn.Disable();
//STRIP001 		aDelBtn.Enable();
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 	aNewBtn.Enable();
//STRIP001 	aDelBtn.Disable();
//STRIP001 	return 0;
//STRIP001 }


}
