/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_colrctrl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:13:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "dialogs.hrc"

#define ITEMID_COLOR			0
#define ITEMID_COLOR_TABLE		SID_COLOR_TABLE

// auto strip #include <tools/list.hxx>

// auto strip #ifndef _SFXVIEWSH_HXX //autogen
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #include <vcl/image.hxx>

#include "colrctrl.hxx"

#include "svdview.hxx"
// auto strip #include "drawitem.hxx"
// auto strip #include "colritem.hxx"
// auto strip #include "xattr.hxx"
// auto strip #include "xtable.hxx"
// auto strip #include "dialmgr.hxx"
// auto strip #include "xexch.hxx"
namespace binfilter {

/*N*/ SFX_IMPL_DOCKINGWINDOW( SvxColorChildWindow, SID_COLOR_CONTROL )

// ------------------------
// - SvxColorValueSetData -
// ------------------------

//STRIP001 class SvxColorValueSetData : public TransferableHelper
//STRIP001 {
//STRIP001 private:
//STRIP001 
//STRIP001 	XFillExchangeData		maData;
//STRIP001 
//STRIP001 protected:
//STRIP001 
//STRIP001 	virtual void			AddSupportedFormats();
//STRIP001 	virtual sal_Bool		GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
//STRIP001 	virtual sal_Bool		WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId, const ::com::sun::star::datatransfer::DataFlavor& rFlavor );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 							SvxColorValueSetData( const XFillAttrSetItem& rSetItem ) :
//STRIP001 								maData( rSetItem ) {}
//STRIP001 };
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxColorValueSetData::AddSupportedFormats()
//STRIP001 {
//STRIP001 	AddFormat( SOT_FORMATSTR_ID_XFA );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxColorValueSetData::GetData( const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 
//STRIP001 	if( SotExchange::GetFormat( rFlavor ) == SOT_FORMATSTR_ID_XFA )
//STRIP001 	{
//STRIP001 		SetObject( &maData, 0, rFlavor );
//STRIP001 		bRet = sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxColorValueSetData::WriteObject( SotStorageStreamRef& rxOStm, void* pUserObject, sal_uInt32 nUserObjectId, const ::com::sun::star::datatransfer::DataFlavor& rFlavor )
//STRIP001 {
//STRIP001 	*rxOStm << maData;
//STRIP001 	return( rxOStm->GetError() == ERRCODE_NONE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxColorValueSet: Ctor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxColorValueSet::SvxColorValueSet( Window* pParent, WinBits nWinStyle ) :
//STRIP001 	ValueSet( pParent, nWinStyle ),
//STRIP001 	DragSourceHelper( this ),
//STRIP001     bLeft (TRUE)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxColorValueSet: Ctor
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxColorValueSet::SvxColorValueSet( Window* pParent, const ResId& rResId ) :
//STRIP001 	ValueSet( pParent, rResId ),
//STRIP001 	DragSourceHelper( this ),
//STRIP001     bLeft (TRUE)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxColorValueSet: MouseButtonDown
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorValueSet::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	// Fuer Mac noch anders handlen !
//STRIP001 	if( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		bLeft = TRUE;
//STRIP001 		ValueSet::MouseButtonDown( rMEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bLeft = FALSE;
//STRIP001 		MouseEvent aMEvt( rMEvt.GetPosPixel(),
//STRIP001 						  rMEvt.GetClicks(),
//STRIP001 						  rMEvt.GetMode(),
//STRIP001 						  MOUSE_LEFT,
//STRIP001 						  rMEvt.GetModifier() );
//STRIP001 		ValueSet::MouseButtonDown( aMEvt );
//STRIP001 	}
//STRIP001 
//STRIP001 	aDragPosPixel = GetPointerPosPixel();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxColorValueSet: MouseButtonUp
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorValueSet::MouseButtonUp( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	// Fuer Mac noch anders handlen !
//STRIP001 	if( rMEvt.IsLeft() )
//STRIP001 	{
//STRIP001 		bLeft = TRUE;
//STRIP001 		ValueSet::MouseButtonUp( rMEvt );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bLeft = FALSE;
//STRIP001 		MouseEvent aMEvt( rMEvt.GetPosPixel(),
//STRIP001 						  rMEvt.GetClicks(),
//STRIP001 						  rMEvt.GetMode(),
//STRIP001 						  MOUSE_LEFT,
//STRIP001 						  rMEvt.GetModifier() );
//STRIP001 		ValueSet::MouseButtonUp( aMEvt );
//STRIP001 	}
//STRIP001 	SetNoSelection();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Command-Event
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorValueSet::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	// Basisklasse
//STRIP001 	ValueSet::Command(rCEvt);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* StartDrag
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorValueSet::StartDrag( sal_Int8 nAction, const Point& rPtPixel )
//STRIP001 {
//STRIP001 	Application::PostUserEvent(STATIC_LINK(this, SvxColorValueSet, ExecDragHdl));
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Drag&Drop asynchron ausfuehren
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorValueSet::DoDrag()
//STRIP001 {
//STRIP001 	SfxObjectShell* pDocSh = SfxObjectShell::Current();
//STRIP001 	USHORT			nItemId = GetItemId( aDragPosPixel );
//STRIP001 
//STRIP001 	if( pDocSh && nItemId )
//STRIP001 	{
//STRIP001 		XFillAttrSetItem	aXFillSetItem( &pDocSh->GetPool() );
//STRIP001 		SfxItemSet&			rSet = aXFillSetItem.GetItemSet();
//STRIP001 
//STRIP001 		rSet.Put( XFillColorItem( GetItemText( nItemId ), GetItemColor( nItemId ) ) );
//STRIP001 		rSet.Put(XFillStyleItem( ( 1 == nItemId ) ? XFILL_NONE : XFILL_SOLID ) );
//STRIP001 
//STRIP001 		EndSelection();
//STRIP001 		( new SvxColorValueSetData( aXFillSetItem ) )->StartDrag( this, DND_ACTION_COPY );
//STRIP001 		ReleaseMouse();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_STATIC_LINK(SvxColorValueSet, ExecDragHdl, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	// Als Link, damit asynchron ohne ImpMouseMoveMsg auf dem Stack auch die
//STRIP001 	// Farbleiste geloescht werden darf
//STRIP001 	pThis->DoDrag();
//STRIP001 	return(0);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ableitung vom SfxChildWindow als "Behaelter" fuer Animator
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
/*?*/ SvxColorChildWindow::SvxColorChildWindow( Window* pParent,
/*?*/     									  USHORT nId,
/*?*/ 										  SfxBindings* pBindings,
/*?*/ 										  SfxChildWinInfo* pInfo ) :
/*?*/ 	SfxChildWindow( pParent, nId )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	SvxColorDockingWindow* pWin = new SvxColorDockingWindow( pBindings, this,
//STRIP001 										pParent, SVX_RES( RID_SVXCTRL_COLOR ) );
//STRIP001 	pWindow = pWin;
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_BOTTOM;
//STRIP001 
//STRIP001 	pWin->Initialize( pInfo );
/*?*/ }



//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ctor: SvxColorDockingWindow
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxColorDockingWindow::SvxColorDockingWindow
//STRIP001 (
//STRIP001 	SfxBindings* pBindings,
//STRIP001 	SfxChildWindow* pCW,
//STRIP001 	Window* pParent,
//STRIP001 	const ResId& rResId
//STRIP001 ) :
//STRIP001 
//STRIP001 	SfxDockingWindow( pBindings, pCW, pParent, rResId ),
//STRIP001 
//STRIP001 	aColorSet		( this, ResId( 1 ) ),
//STRIP001 	pColorTable 	( NULL ),
//STRIP001 	nLeftSlot		( SID_ATTR_FILL_COLOR ),
//STRIP001 	nRightSlot		( SID_ATTR_LINE_COLOR ),
//STRIP001 	nCols			( 20 ),
//STRIP001 	nLines			( 1 ),
//STRIP001 	aColorSize		( 14, 14 )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aColorSet.SetStyle( aColorSet.GetStyle() | WB_ITEMBORDER );
//STRIP001 	aColorSet.SetSelectHdl( LINK( this, SvxColorDockingWindow, SelectHdl ) );
//STRIP001 
//STRIP001 	SfxObjectShell*	pDocSh = SfxObjectShell::Current();
//STRIP001 	if ( pDocSh )
//STRIP001 	{
//STRIP001 		const SfxPoolItem*	pItem = pDocSh->GetItem( SID_COLOR_TABLE );
//STRIP001 		if( pItem )
//STRIP001 		{
//STRIP001 			pColorTable = ( (SvxColorTableItem*) pItem )->GetColorTable();
//STRIP001 			FillValueSet();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aItemSize = aColorSet.CalcItemSizePixel( aColorSize );
//STRIP001 	aItemSize.Width() = aItemSize.Width() + aColorSize.Width();
//STRIP001 	aItemSize.Width() /= 2;
//STRIP001 	aItemSize.Height() = aItemSize.Height() + aColorSize.Height();
//STRIP001 	aItemSize.Height() /= 2;
//STRIP001 
//STRIP001 	SetSize();
//STRIP001 	aColorSet.Show();
//STRIP001 	StartListening( *pBindings, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Dtor: SvxColorDockingWindow
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxColorDockingWindow::~SvxColorDockingWindow()
//STRIP001 {
//STRIP001 	EndListening( GetBindings() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Notify
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorDockingWindow::SFX_NOTIFY( SfxBroadcaster& rBC,
//STRIP001 										 const TypeId& rBCType,
//STRIP001 										 const SfxHint& rHint,
//STRIP001 										 const TypeId& rHintType )
//STRIP001 {
//STRIP001 	const SfxPoolItemHint *pPoolItemHint = PTR_CAST(SfxPoolItemHint, &rHint);
//STRIP001 	if ( pPoolItemHint
//STRIP001 		 && ( pPoolItemHint->GetObject()->ISA( SvxColorTableItem ) ) )
//STRIP001 	{
//STRIP001 		// Die Liste der Farben hat sich geaendert
//STRIP001 		pColorTable = ( (SvxColorTableItem*) pPoolItemHint->GetObject() )->GetColorTable();
//STRIP001 		FillValueSet();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* FillValueSet
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorDockingWindow::FillValueSet()
//STRIP001 {
//STRIP001 	if( pColorTable )
//STRIP001 	{
//STRIP001 		aColorSet.Clear();
//STRIP001 
//STRIP001 		// Erster Eintrag: unsichtbar
//STRIP001 		long nPtX = aColorSize.Width() - 1;
//STRIP001 		long nPtY = aColorSize.Height() - 1;
//STRIP001 		VirtualDevice aVD;
//STRIP001 		aVD.SetOutputSizePixel( aColorSize );
//STRIP001 		aVD.SetLineColor( Color( COL_BLACK ) );
//STRIP001 		aVD.SetBackground( Wallpaper( Color( COL_WHITE ) ) );
//STRIP001 		aVD.DrawLine( Point(), Point( nPtX, nPtY ) );
//STRIP001 		aVD.DrawLine( Point( 0, nPtY ), Point( nPtX, 0 ) );
//STRIP001 
//STRIP001 		Bitmap aBmp( aVD.GetBitmap( Point(), aColorSize ) );
//STRIP001 
//STRIP001 		aColorSet.InsertItem( (USHORT)1, Image(aBmp), SVX_RESSTR( RID_SVXSTR_INVISIBLE ) );
//STRIP001 
//STRIP001 		XColorEntry* pEntry;
//STRIP001 		nCount = pColorTable->Count();
//STRIP001 
//STRIP001 		for( long i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			pEntry = pColorTable->Get( i );
//STRIP001 			aColorSet.InsertItem( (USHORT)i+2,
//STRIP001 							pEntry->GetColor(), pEntry->GetName() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SetSize
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorDockingWindow::SetSize()
//STRIP001 {
//STRIP001 	// Groesse fuer ValueSet berechnen
//STRIP001 	Size aSize = GetOutputSizePixel();
//STRIP001 	aSize.Width()  -= 4;
//STRIP001 	aSize.Height() -= 4;
//STRIP001 
//STRIP001 	// Zeilen und Spalten berechnen
//STRIP001 	nCols = (USHORT) ( aSize.Width() / aItemSize.Width() );
//STRIP001 	nLines = (USHORT) ( (float) aSize.Height() / (float) aItemSize.Height() /*+ 0.35*/ );
//STRIP001 	if( nLines == 0 )
//STRIP001 		nLines++;
//STRIP001 
//STRIP001 	// Scrollbar setzen/entfernen
//STRIP001 	WinBits nBits = aColorSet.GetStyle();
//STRIP001 	if ( nLines * nCols >= nCount )
//STRIP001 		nBits &= ~WB_VSCROLL;
//STRIP001 	else
//STRIP001 		nBits |= WB_VSCROLL;
//STRIP001 	aColorSet.SetStyle( nBits );
//STRIP001 
//STRIP001 	// ScrollBar ?
//STRIP001 	long nScrollWidth = aColorSet.GetScrollWidth();
//STRIP001 	if( nScrollWidth > 0 )
//STRIP001 	{
//STRIP001 		// Spalten mit ScrollBar berechnen
//STRIP001 		nCols = (USHORT) ( ( aSize.Width() - nScrollWidth ) / aItemSize.Width() );
//STRIP001 	}
//STRIP001 	aColorSet.SetColCount( nCols );
//STRIP001 
//STRIP001 	if( IsFloatingMode() )
//STRIP001 		aColorSet.SetLineCount( nLines );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aColorSet.SetLineCount( 0 ); // sonst wird LineHeight ignoriert
//STRIP001 		aColorSet.SetItemHeight( aItemSize.Height() );
//STRIP001 	}
//STRIP001 
//STRIP001 	aColorSet.SetPosSizePixel( Point( 2, 2 ), aSize );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SvxColorDockingWindow: Close
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 BOOL SvxColorDockingWindow::Close()
//STRIP001 {
//STRIP001 	SfxBoolItem aItem( SID_COLOR_CONTROL, FALSE );
//STRIP001 	GetBindings().GetDispatcher()->Execute(
//STRIP001 		SID_COLOR_CONTROL, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 	SfxDockingWindow::Close();
//STRIP001 	return( TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* SelectHdl
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SvxColorDockingWindow, SelectHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SfxDispatcher* pDispatcher = GetBindings().GetDispatcher();
//STRIP001 	USHORT nPos = aColorSet.GetSelectItemId();
//STRIP001 	Color  aColor( aColorSet.GetItemColor( nPos ) );
//STRIP001 	String aStr( aColorSet.GetItemText( nPos ) );
//STRIP001 
//STRIP001     if (aColorSet.IsLeftButton())
//STRIP001     {
//STRIP001 		if ( nLeftSlot == SID_ATTR_FILL_COLOR )
//STRIP001 		{
//STRIP001 			if ( nPos == 1 )		// unsichtbar
//STRIP001 			{
//STRIP001 				XFillStyleItem aXFillStyleItem( XFILL_NONE );
//STRIP001 				pDispatcher->Execute( nLeftSlot, SFX_CALLMODE_RECORD, &aXFillStyleItem, 0L );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				BOOL bDone = FALSE;
//STRIP001 
//STRIP001 				// Wenn wir eine DrawView haben und uns im TextEdit-Modus befinden,
//STRIP001 				// wird nicht die Flaechen-, sondern die Textfarbe zugewiesen
//STRIP001 				SfxViewShell* pViewSh = SfxViewShell::Current();
//STRIP001 				if ( pViewSh )
//STRIP001 				{
//STRIP001 					SdrView* pView = pViewSh->GetDrawView();
//STRIP001 					if ( pView && pView->IsTextEdit() )
//STRIP001 					{
//STRIP001 						SvxColorItem aTextColorItem( aColor, SID_ATTR_CHAR_COLOR );
//STRIP001 						pDispatcher->Execute(
//STRIP001 							SID_ATTR_CHAR_COLOR, SFX_CALLMODE_RECORD, &aTextColorItem, 0L );
//STRIP001 						bDone = TRUE;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				if ( !bDone )
//STRIP001 				{
//STRIP001 					XFillStyleItem aXFillStyleItem( XFILL_SOLID );
//STRIP001 					XFillColorItem aXFillColorItem( aStr, aColor );
//STRIP001 					pDispatcher->Execute(
//STRIP001 						nLeftSlot, SFX_CALLMODE_RECORD, &aXFillColorItem, &aXFillStyleItem, 0L );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nPos != 1 )		// unsichtbar
//STRIP001 		{
//STRIP001 			SvxColorItem aLeftColorItem( aColor, nLeftSlot );
//STRIP001 			pDispatcher->Execute( nLeftSlot, SFX_CALLMODE_RECORD, &aLeftColorItem, 0L );
//STRIP001 		}
//STRIP001     }
//STRIP001     else
//STRIP001 	{
//STRIP001 		if ( nRightSlot == SID_ATTR_LINE_COLOR )
//STRIP001 		{
//STRIP001 			if( nPos == 1 )		// unsichtbar
//STRIP001 			{
//STRIP001 				XLineStyleItem aXLineStyleItem( XLINE_NONE );
//STRIP001 				pDispatcher->Execute( nRightSlot, SFX_CALLMODE_RECORD, &aXLineStyleItem, 0L );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				// Sollte der LineStyle unsichtbar sein, so wird er auf SOLID gesetzt
//STRIP001 				SfxViewShell* pViewSh = SfxViewShell::Current();
//STRIP001 				if ( pViewSh )
//STRIP001 				{
//STRIP001 					SdrView* pView = pViewSh->GetDrawView();
//STRIP001 					if ( pView )
//STRIP001 					{
//STRIP001 						SfxItemSet aAttrSet( pView->GetModel()->GetItemPool() );
//STRIP001 						pView->GetAttributes( aAttrSet );
//STRIP001 						if ( aAttrSet.GetItemState( XATTR_LINESTYLE ) != SFX_ITEM_DONTCARE )
//STRIP001 						{
//STRIP001 							XLineStyle eXLS = (XLineStyle)
//STRIP001 								( (const XLineStyleItem&)aAttrSet.Get( XATTR_LINESTYLE ) ).GetValue();
//STRIP001 							if ( eXLS == XLINE_NONE )
//STRIP001 							{
//STRIP001 								XLineStyleItem aXLineStyleItem( XLINE_SOLID );
//STRIP001 								pDispatcher->Execute( nRightSlot, SFX_CALLMODE_RECORD, &aXLineStyleItem, 0L );
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				XLineColorItem aXLineColorItem( aStr, aColor );
//STRIP001 				pDispatcher->Execute( nRightSlot, SFX_CALLMODE_RECORD, &aXLineColorItem, 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if ( nPos != 1 )		// unsichtbar
//STRIP001 		{
//STRIP001 			SvxColorItem aRightColorItem( aColor, nRightSlot );
//STRIP001 			pDispatcher->Execute( nRightSlot, SFX_CALLMODE_RECORD, &aRightColorItem, 0L );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Resizing
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 
//STRIP001 void SvxColorDockingWindow::Resizing( Size& rNewSize )
//STRIP001 {
//STRIP001 	rNewSize.Width()  -= 4;
//STRIP001 	rNewSize.Height() -= 4;
//STRIP001 
//STRIP001 	// Spalten und Reihen ermitteln
//STRIP001 	nCols = (USHORT) ( (float) rNewSize.Width() / (float) aItemSize.Width() + 0.5 );
//STRIP001 	nLines = (USHORT) ( (float) rNewSize.Height() / (float) aItemSize.Height() + 0.5 );
//STRIP001 	if( nLines == 0 )
//STRIP001 		nLines = 1;
//STRIP001 
//STRIP001 	// Scrollbar setzen/entfernen
//STRIP001 	WinBits nBits = aColorSet.GetStyle();
//STRIP001 	if ( nLines * nCols >= nCount )
//STRIP001 		nBits &= ~WB_VSCROLL;
//STRIP001 	else
//STRIP001 		nBits |= WB_VSCROLL;
//STRIP001 	aColorSet.SetStyle( nBits );
//STRIP001 
//STRIP001 	// ScrollBar ?
//STRIP001 	long nScrollWidth = aColorSet.GetScrollWidth();
//STRIP001 	if( nScrollWidth > 0 )
//STRIP001 	{
//STRIP001 		// Spalten mit ScrollBar berechnen
//STRIP001 		nCols = (USHORT) ( ( ( (float) rNewSize.Width() - (float) nScrollWidth ) )
//STRIP001 							/ (float) aItemSize.Width() + 0.5 );
//STRIP001 	}
//STRIP001 	if( nCols <= 1 )
//STRIP001 		nCols = 2;
//STRIP001 
//STRIP001 	// Max. Reihen anhand der gegebenen Spalten berechnen
//STRIP001 	USHORT nMaxLines = nCount / nCols;
//STRIP001 	if( nCount %  nCols )
//STRIP001 		nMaxLines++;
//STRIP001 
//STRIP001 	nLines = Min( nLines, nMaxLines );
//STRIP001 
//STRIP001 	// Groesse des Windows setzen
//STRIP001 	rNewSize.Width()  = nCols * aItemSize.Width() + nScrollWidth + 4;
//STRIP001 	rNewSize.Height() = nLines * aItemSize.Height() + 4;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Resize
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SvxColorDockingWindow::Resize()
//STRIP001 {
//STRIP001 	if ( !IsFloatingMode() || !GetFloatingWindow()->IsRollUp() )
//STRIP001 		SetSize();
//STRIP001 	SfxDockingWindow::Resize();
//STRIP001 }



//STRIP001 void SvxColorDockingWindow::GetFocus (void)
//STRIP001 {
//STRIP001 	SfxDockingWindow::GetFocus();
//STRIP001     // Grab the focus to the color value set so that it can be controlled
//STRIP001     // with the keyboard.
//STRIP001 	aColorSet.GrabFocus();
//STRIP001 }

//STRIP001 long SvxColorDockingWindow::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	long nRet = 0;
//STRIP001 	if( ( rNEvt.GetType() == EVENT_KEYINPUT ) )
//STRIP001 	{
//STRIP001 		KeyEvent aKeyEvt = *rNEvt.GetKeyEvent();
//STRIP001 		USHORT	 nKeyCode = aKeyEvt.GetKeyCode().GetCode();
//STRIP001 		switch( nKeyCode )
//STRIP001 		{
//STRIP001 			case KEY_ESCAPE:
//STRIP001 				GrabFocusToDocument();
//STRIP001 				nRet = 1;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet ? nRet : SfxDockingWindow::Notify( rNEvt );
//STRIP001 }
}
