/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_frminf.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:26:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _PAM_HXX
//STRIP001 #include <pam.hxx>          // GetSpaces
//STRIP001 #endif
//STRIP001 #ifndef _TXTCFG_HXX
//STRIP001 #include <txtcfg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FRMINF_HXX
//STRIP001 #include <frminf.hxx>		// SwTxtFrminfo
//STRIP001 #endif
//STRIP001 #ifndef _ITRTXT_HXX
//STRIP001 #include <itrtxt.hxx>       // SwTxtMargin
//STRIP001 #endif
//STRIP001 #ifndef _SWFONT_HXX
//STRIP001 #include <swfont.hxx>       // IsBullet()
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtMargin::GetTxtStart()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 xub_StrLen SwTxtMargin::GetTxtStart() const
//STRIP001 {
//STRIP001 	const XubString &rTxt = GetInfo().GetTxt();
//STRIP001 	const xub_StrLen nPos = nStart;
//STRIP001 	const xub_StrLen nEnd = nPos + pCurr->GetLen();
//STRIP001 	for( xub_StrLen i = nPos; i < nEnd; ++i )
//STRIP001 	{
//STRIP001 		const xub_Unicode aChar = rTxt.GetChar( i );
//STRIP001 		if( CH_TAB != aChar && ' ' != aChar )
//STRIP001 			return i;
//STRIP001 	}
//STRIP001 	return i;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtMargin::GetTxtEnd()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 xub_StrLen SwTxtMargin::GetTxtEnd() const
//STRIP001 {
//STRIP001 	const XubString &rTxt = GetInfo().GetTxt();
//STRIP001 	const xub_StrLen nPos = nStart;
//STRIP001 	const xub_StrLen nEnd = nPos + pCurr->GetLen();
//STRIP001 	for( long i = nEnd - 1; i >= nPos; --i )
//STRIP001 	{
//STRIP001 		xub_Unicode aChar = rTxt.GetChar( i );
//STRIP001 		if( CH_TAB != aChar && CH_BREAK != aChar && ' ' != aChar )
//STRIP001 			return i + 1;
//STRIP001 	}
//STRIP001 	return i + 1;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::IsOneLine()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Passt der Absatz in eine Zeile?
//STRIP001 sal_Bool SwTxtFrmInfo::IsOneLine() const
//STRIP001 {
//STRIP001 	const SwLineLayout *pLay = pFrm->GetPara();
//STRIP001 	if( !pLay )
//STRIP001 		return sal_False;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// 6575: bei Follows natuerlich sal_False
//STRIP001 		if( pFrm->GetFollow() )
//STRIP001 			return sal_False;
//STRIP001 		pLay = pLay->GetNext();
//STRIP001 		while( pLay )
//STRIP001 		{
//STRIP001 			if( pLay->GetLen() )
//STRIP001 				return sal_False;
//STRIP001 			pLay = pLay->GetNext();
//STRIP001 		}
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::IsFilled()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Ist die Zeile zu X% gefuellt?
//STRIP001 sal_Bool SwTxtFrmInfo::IsFilled( const sal_uInt8 nPercent ) const
//STRIP001 {
//STRIP001 	const SwLineLayout *pLay = pFrm->GetPara();
//STRIP001 	if( !pLay )
//STRIP001 		return sal_False;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nWidth = pFrm->Prt().Width();
//STRIP001 		nWidth *= nPercent;
//STRIP001 		nWidth /= 100;
//STRIP001 		return KSHORT(nWidth) <= pLay->Width();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::GetLineStart()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Wo beginnt der Text (ohne whitespaces)? ( Dokument global )
//STRIP001 SwTwips SwTxtFrmInfo::GetLineStart( const SwTxtCursor &rLine ) const
//STRIP001 {
//STRIP001 	SwTwips nTxtStart = rLine.GetTxtStart();
//STRIP001 	SwTwips nStart;
//STRIP001 	if( rLine.GetStart() == nTxtStart )
//STRIP001 		nStart = rLine.GetLineStart();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwRect aRect;
//STRIP001 		if( ((SwTxtCursor&)rLine).GetCharRect( &aRect, nTxtStart ) )
//STRIP001 			nStart = aRect.Left();
//STRIP001 		else
//STRIP001 			nStart = rLine.GetLineStart();
//STRIP001 	}
//STRIP001 	return nStart;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::GetLineStart()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Wo beginnt der Text (ohne whitespaces)? (rel. im Frame)
//STRIP001 SwTwips SwTxtFrmInfo::GetLineStart() const
//STRIP001 {
//STRIP001 	SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtCursor aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 	return GetLineStart( aLine ) - pFrm->Frm().Left() -	pFrm->Prt().Left();
//STRIP001 }
//STRIP001 
//STRIP001 // errechne die Position des Zeichens und gebe die Mittelposition zurueck
//STRIP001 SwTwips SwTxtFrmInfo::GetCharPos( xub_StrLen nChar, sal_Bool bCenter ) const
//STRIP001 {
//STRIP001     SWRECTFN( pFrm )
//STRIP001     SwFrmSwapper aSwapper( pFrm, sal_True );
//STRIP001 
//STRIP001     SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtCursor aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 
//STRIP001 	SwTwips nStt, nNext;
//STRIP001 	SwRect aRect;
//STRIP001 	if( ((SwTxtCursor&)aLine).GetCharRect( &aRect, nChar ) )
//STRIP001     {
//STRIP001         if ( bVert )
//STRIP001             pFrm->SwitchHorizontalToVertical( aRect );
//STRIP001 
//STRIP001         nStt = (aRect.*fnRect->fnGetLeft)();
//STRIP001     }
//STRIP001 	else
//STRIP001 		nStt = aLine.GetLineStart();
//STRIP001 
//STRIP001 	if( !bCenter )
//STRIP001         return nStt - (pFrm->Frm().*fnRect->fnGetLeft)();
//STRIP001 
//STRIP001 	if( ((SwTxtCursor&)aLine).GetCharRect( &aRect, nChar+1 ) )
//STRIP001     {
//STRIP001         if ( bVert )
//STRIP001             pFrm->SwitchHorizontalToVertical( aRect );
//STRIP001 
//STRIP001         nNext = (aRect.*fnRect->fnGetLeft)();
//STRIP001     }
//STRIP001 	else
//STRIP001 		nNext = aLine.GetLineStart();
//STRIP001 
//STRIP001     return (( nNext + nStt ) / 2 ) - (pFrm->Frm().*fnRect->fnGetLeft)();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::GetSpaces()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 SwPaM *AddPam( SwPaM *pPam, const SwTxtFrm* pTxtFrm,
//STRIP001 				const xub_StrLen nPos, const xub_StrLen nLen )
//STRIP001 {
//STRIP001 	if( nLen )
//STRIP001 	{
//STRIP001 		// Es koennte auch der erste sein.
//STRIP001 		if( pPam->HasMark() )
//STRIP001 		{
//STRIP001 			// liegt die neue Position genau hinter der aktuellen, dann
//STRIP001 			// erweiter den Pam einfach
//STRIP001 			if( nPos == pPam->GetPoint()->nContent.GetIndex() )
//STRIP001 			{
//STRIP001 				pPam->GetPoint()->nContent += nLen;
//STRIP001 				return pPam;
//STRIP001 			}
//STRIP001 			pPam = new SwPaM( *pPam );
//STRIP001 		}
//STRIP001 
//STRIP001 		SwIndex &rContent = pPam->GetPoint()->nContent;
//STRIP001 		rContent.Assign( (SwTxtNode*)pTxtFrm->GetTxtNode(), nPos );
//STRIP001 		pPam->SetMark();
//STRIP001 		rContent += nLen;
//STRIP001 	}
//STRIP001 	return pPam;
//STRIP001 }
//STRIP001 
//STRIP001 // Sammelt die whitespaces am Zeilenbeginn und -ende im Pam
//STRIP001 void SwTxtFrmInfo::GetSpaces( SwPaM &rPam, sal_Bool bWithLineBreak ) const
//STRIP001 {
//STRIP001 	SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtMargin aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 	SwPaM *pPam = &rPam;
//STRIP001 	sal_Bool bFirstLine = sal_True;
//STRIP001 	do {
//STRIP001 
//STRIP001 		if( aLine.GetCurr()->GetLen() )
//STRIP001 		{
//STRIP001 			xub_StrLen nPos = aLine.GetTxtStart();
//STRIP001 			// Bug 49649: von der ersten Line die Blanks/Tabs NICHT
//STRIP001 			//				mit selektieren
//STRIP001 			if( !bFirstLine && nPos > aLine.GetStart() )
//STRIP001 				pPam = AddPam( pPam, pFrm, aLine.GetStart(),
//STRIP001 								nPos - aLine.GetStart() );
//STRIP001 
//STRIP001 			// Bug 49649: von der letzten Line die Blanks/Tabs NICHT
//STRIP001 			//				mit selektieren
//STRIP001 			if( aLine.GetNext() )
//STRIP001 			{
//STRIP001 				nPos = aLine.GetTxtEnd();
//STRIP001 
//STRIP001 				if( nPos < aLine.GetEnd() )
//STRIP001 				{
//STRIP001 					MSHORT nOff = !bWithLineBreak && CH_BREAK ==
//STRIP001 								aLine.GetInfo().GetChar( aLine.GetEnd() - 1 )
//STRIP001 								? 1 : 0;
//STRIP001 					pPam = AddPam( pPam, pFrm, nPos, aLine.GetEnd() - nPos - nOff );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		bFirstLine = sal_False;
//STRIP001 	}
//STRIP001 	while( aLine.Next() );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::IsBullet()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Ist an der Textposition ein Bullet/Symbol etc?
//STRIP001 // Fonts: CharSet, SYMBOL und DONTKNOW
//STRIP001 sal_Bool SwTxtFrmInfo::IsBullet( xub_StrLen nTxtStart ) const
//STRIP001 {
//STRIP001 	SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtMargin aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 	aInf.SetIdx( nTxtStart );
//STRIP001 	return aLine.IsSymbol( nTxtStart );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::GetFirstIndent()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 // Ermittelt Erstzeileneinzug
//STRIP001 // Voraussetzung fuer pos. oder neg. EZE ist, dass alle
//STRIP001 // Zeilen ausser der ersten Zeile den selben linken Rand haben.
//STRIP001 // Wir wollen nicht so knauserig sein und arbeiten mit einer Toleranz
//STRIP001 // von TOLERANCE Twips.
//STRIP001 
//STRIP001 #define TOLERANCE 20
//STRIP001 
//STRIP001 SwTwips SwTxtFrmInfo::GetFirstIndent() const
//STRIP001 {
//STRIP001 	SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtCursor aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 	const SwTwips nFirst = GetLineStart( aLine );
//STRIP001 	if( !aLine.Next() )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SwTwips nLeft = GetLineStart( aLine );
//STRIP001 	while( aLine.Next() )
//STRIP001 	{
//STRIP001 		if( aLine.GetCurr()->GetLen() )
//STRIP001 		{
//STRIP001 			const SwTwips nCurrLeft = GetLineStart( aLine );
//STRIP001 			if( nLeft + TOLERANCE < nCurrLeft ||
//STRIP001 				nLeft - TOLERANCE > nCurrLeft )
//STRIP001 				return 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Vorerst wird nur +1, -1 und 0 returnt.
//STRIP001 	if( nLeft == nFirst )
//STRIP001 		return 0;
//STRIP001 	else
//STRIP001 		if( nLeft > nFirst )
//STRIP001 			return -1;
//STRIP001 		else
//STRIP001 			return +1;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001  *					 SwTxtFrmInfo::GetBigIndent()
//STRIP001  *************************************************************************/
//STRIP001 
//STRIP001 KSHORT SwTxtFrmInfo::GetBigIndent( xub_StrLen& rFndPos,
//STRIP001 									const SwTxtFrm *pNextFrm ) const
//STRIP001 {
//STRIP001 	SwTxtSizeInfo aInf( (SwTxtFrm*)pFrm );
//STRIP001 	SwTxtCursor aLine( (SwTxtFrm*)pFrm, &aInf );
//STRIP001 	SwTwips nNextIndent = 0;
//STRIP001 
//STRIP001 	if( pNextFrm )
//STRIP001 	{
//STRIP001 		// ich bin einzeilig
//STRIP001 		SwTxtSizeInfo aNxtInf( (SwTxtFrm*)pNextFrm );
//STRIP001 		SwTxtCursor aNxtLine( (SwTxtFrm*)pNextFrm, &aNxtInf );
//STRIP001 		nNextIndent = GetLineStart( aNxtLine );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// ich bin mehrzeilig
//STRIP001 		if( aLine.Next() )
//STRIP001 		{
//STRIP001 			nNextIndent = GetLineStart( aLine );
//STRIP001 			aLine.Prev();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nNextIndent <= GetLineStart( aLine ) )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	const Point aPoint( nNextIndent, aLine.Y() );
//STRIP001 	rFndPos = aLine.GetCrsrOfst( 0, aPoint, sal_False );
//STRIP001 	if( 1 >= rFndPos )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	// steht vor einem "nicht Space"
//STRIP001 	const XubString& rTxt = aInf.GetTxt();
//STRIP001 	xub_Unicode aChar = rTxt.GetChar( rFndPos );
//STRIP001 	if( CH_TAB == aChar || CH_BREAK == aChar || ' ' == aChar ||
//STRIP001 		(( CH_TXTATR_BREAKWORD == aChar || CH_TXTATR_INWORD == aChar ) &&
//STRIP001 			aInf.HasHint( rFndPos ) ) )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	// und hinter einem "Space"
//STRIP001 	aChar = rTxt.GetChar( rFndPos - 1 );
//STRIP001 	if( CH_TAB != aChar && CH_BREAK != aChar &&
//STRIP001 		( ( CH_TXTATR_BREAKWORD != aChar && CH_TXTATR_INWORD != aChar ) ||
//STRIP001 			!aInf.HasHint( rFndPos - 1 ) ) &&
//STRIP001 		// mehr als 2 Blanks !!
//STRIP001 		( ' ' != aChar || ' ' != rTxt.GetChar( rFndPos - 2 ) ) )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SwRect aRect;
//STRIP001 	return aLine.GetCharRect( &aRect, rFndPos )
//STRIP001 			? KSHORT( aRect.Left() - pFrm->Frm().Left() - pFrm->Prt().Left())
//STRIP001 			: 0;
//STRIP001 }



}
