/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unspnd.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:46:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
#include "doc.hxx"
#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
// auto strip #include "pam.hxx"
// auto strip #include "swtable.hxx"
#include "ndtxt.hxx"
#include "swundo.hxx"           // fuer die UndoIds

// auto strip #ifndef _SVX_BRKITEM_HXX //autogen
// auto strip #include <bf_svx/brkitem.hxx>
// auto strip #endif

// auto strip #ifndef _FMTPDSC_HXX //autogen
// auto strip #include <fmtpdsc.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
#include "undobj.hxx"
#include "rolbck.hxx"
#include "redline.hxx"
// auto strip #include "docary.hxx"
namespace binfilter {


//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const { return *pAktPam->GetDoc(); }


//------------------------------------------------------------------

// SPLITNODE


/*N*/ SwUndoSplitNode::SwUndoSplitNode( SwDoc* pDoc, const SwPosition& rPos,
/*N*/ 									BOOL bChkTable )
/*N*/ 	: SwUndo( UNDO_SPLITNODE ), nNode( rPos.nNode.GetIndex() ),
/*N*/ 		nCntnt( rPos.nContent.GetIndex() ), pHistory( 0 ),
/*N*/ 		bTblFlag( FALSE ), bChkTblStt( bChkTable ), pRedlData( 0 )
/*N*/ {
/*N*/ 	SwTxtNode* pTxtNd = pDoc->GetNodes()[ rPos.nNode ]->GetTxtNode();
/*N*/ 	ASSERT( pTxtNd, "nur beim TextNode rufen!" );
/*N*/ 	if( pTxtNd->GetpSwpHints() )
/*N*/ 	{
/*?*/ 		pHistory = new SwHistory;
/*?*/ 		pHistory->CopyAttr( pTxtNd->GetpSwpHints(), nNode, 0,
/*?*/ 							pTxtNd->GetTxt().Len(), FALSE );
/*?*/ 		if( !pHistory->Count() )
/*?*/ 			DELETEZ( pHistory );
/*N*/ 	}
/*N*/ 	// Redline beachten
/*N*/ 	if( pDoc->IsRedlineOn() )
/*N*/ 	{
/*?*/ 		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pRedlData = new SwRedlineData( REDLINE_INSERT, pDoc->GetRedlineAuthor() );
//STRIP001 /*?*/ 		SetRedlineMode( pDoc->GetRedlineMode() );
/*N*/ 	}
/*N*/ }




/*N*/ SwUndoSplitNode::~SwUndoSplitNode()
/*N*/ {
/*N*/ 	delete pHistory;
//STRIP001 /*?*/ 	delete pRedlData;
/*N*/ }



//STRIP001 void SwUndoSplitNode::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rUndoIter.GetDoc();
//STRIP001 	SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 	rPam.DeleteMark();
//STRIP001 	if( bTblFlag )
//STRIP001 	{
//STRIP001 		// dann wurde direkt vor der akt. Tabelle ein TextNode eingefuegt.
//STRIP001 		SwNodeIndex& rIdx = rPam.GetPoint()->nNode;
//STRIP001 		rIdx = nNode;
//STRIP001 		SwTxtNode* pTNd;
//STRIP001 		SwNode* pCurrNd = pDoc->GetNodes()[ nNode + 1 ];
//STRIP001 		SwTableNode* pTblNd = pCurrNd->FindTableNode();
//STRIP001 		if( pCurrNd->IsCntntNode() && pTblNd &&
//STRIP001 			0 != ( pTNd = pDoc->GetNodes()[ pTblNd->GetIndex()-1 ]->GetTxtNode() ))
//STRIP001 		{
//STRIP001 			// verschiebe die BreakAttribute noch
//STRIP001 			SwFrmFmt* pTableFmt = pTblNd->GetTable().GetFrmFmt();
//STRIP001 			const SfxItemSet* pNdSet = pTNd->GetpSwAttrSet();
//STRIP001 			if( pNdSet )
//STRIP001 			{
//STRIP001 				const SfxPoolItem *pItem;
//STRIP001 				if( SFX_ITEM_SET == pNdSet->GetItemState( RES_PAGEDESC, FALSE,
//STRIP001 					&pItem ) )
//STRIP001 					pTableFmt->SetAttr( *pItem );
//STRIP001 
//STRIP001 				if( SFX_ITEM_SET == pNdSet->GetItemState( RES_BREAK, FALSE,
//STRIP001 					 &pItem ) )
//STRIP001 					pTableFmt->SetAttr( *pItem );
//STRIP001 			}
//STRIP001 
//STRIP001 			// dann loesche den wieder
//STRIP001 			SwNodeIndex aDelNd( *pTblNd, -1 );
//STRIP001 			rPam.GetPoint()->nContent.Assign( (SwCntntNode*)pCurrNd, 0 );
//STRIP001 			RemoveIdxRel( aDelNd.GetIndex(), *rPam.GetPoint() );
//STRIP001 			pDoc->GetNodes().Delete( aDelNd );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwTxtNode * pTNd = pDoc->GetNodes()[ nNode ]->GetTxtNode();
//STRIP001 		if( pTNd )
//STRIP001 		{
//STRIP001 			rPam.GetPoint()->nNode = *pTNd;
//STRIP001 			rPam.GetPoint()->nContent.Assign( pTNd, pTNd->GetTxt().Len() );
//STRIP001 
//STRIP001 			if( IsRedlineOn( GetRedlineMode() ))
//STRIP001 			{
//STRIP001 				rPam.SetMark();
//STRIP001 				rPam.GetMark()->nNode++;
//STRIP001 				rPam.GetMark()->nContent.Assign( rPam.GetMark()->
//STRIP001 									nNode.GetNode().GetCntntNode(), 0 );
//STRIP001 				pDoc->DeleteRedline( rPam );
//STRIP001 				rPam.DeleteMark();
//STRIP001 			}
//STRIP001 
//STRIP001 			RemoveIdxRel( nNode+1, *rPam.GetPoint() );
//STRIP001 
//STRIP001 			pTNd->JoinNext();
//STRIP001 			if( pHistory )
//STRIP001 			{
//STRIP001 				rPam.GetPoint()->nContent = 0;
//STRIP001 				rPam.SetMark();
//STRIP001 				rPam.GetPoint()->nContent = pTNd->GetTxt().Len();
//STRIP001 
//STRIP001 				pDoc->RstTxtAttr( rPam, TRUE );
//STRIP001 				pHistory->TmpRollback( pDoc, 0, FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// setze noch den Cursor auf den Undo-Bereich
//STRIP001 	rPam.DeleteMark();
//STRIP001 	rPam.GetPoint()->nNode = nNode;
//STRIP001 	rPam.GetPoint()->nContent.Assign( rPam.GetCntntNode(), nCntnt );
//STRIP001 }


//STRIP001 void SwUndoSplitNode::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( UNDO_SPLITNODE == rUndoIter.GetLastUndoId() )
//STRIP001 		return;
//STRIP001 	rUndoIter.GetDoc().SplitNode( *rUndoIter.pAktPam->GetPoint(), bChkTblStt );
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 }


//STRIP001 void SwUndoSplitNode::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 	ULONG nOldNode = rPam.GetPoint()->nNode.GetIndex();
//STRIP001 	rPam.GetPoint()->nNode = nNode;
//STRIP001 	SwTxtNode * pTNd = rPam.GetNode()->GetTxtNode();
//STRIP001 	if( pTNd )              // sollte eigentlich immer ein TextNode sein !!
//STRIP001 	{
//STRIP001 		rPam.GetPoint()->nContent.Assign( pTNd, nCntnt );
//STRIP001 
//STRIP001 		SwDoc* pDoc = rPam.GetDoc();
//STRIP001 		pDoc->SplitNode( *rPam.GetPoint(), bChkTblStt );
//STRIP001 
//STRIP001 		if( pHistory )
//STRIP001 			pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 		if( ( pRedlData && IsRedlineOn( GetRedlineMode() )) ||
//STRIP001 			( !( REDLINE_IGNORE & GetRedlineMode() ) &&
//STRIP001 				pDoc->GetRedlineTbl().Count() ))
//STRIP001 		{
//STRIP001 			rPam.SetMark();
//STRIP001 			if( rPam.Move( fnMoveBackward ))
//STRIP001 			{
//STRIP001 				if( pRedlData && IsRedlineOn( GetRedlineMode() ))
//STRIP001 				{
//STRIP001 					SwRedlineMode eOld = pDoc->GetRedlineMode();
//STRIP001 					pDoc->SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 					pDoc->AppendRedline( new SwRedline( *pRedlData, rPam ));
//STRIP001 					pDoc->SetRedlineMode_intern( eOld );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pDoc->SplitRedline( rPam );
//STRIP001 				rPam.Exchange();
//STRIP001 			}
//STRIP001 			rPam.DeleteMark();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rPam.GetPoint()->nNode = nOldNode;
//STRIP001 }

}
