/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unoevtlstnr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:50:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _UNOEVTLSTNR_HXX
#include <unoevtlstnr.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_EVENTOBJECT_HPP_
#include <com/sun/star/lang/EventObject.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::uno;

/* -----------------22.04.99 11:24-------------------
 *
 * --------------------------------------------------*/
SV_IMPL_PTRARR(SwEvtLstnrArray, XEventListenerPtr);

/*-- 22.04.99 11:24:59---------------------------------------------------

  -----------------------------------------------------------------------*/
SwEventListenerContainer::SwEventListenerContainer( uno::XInterface* pxParent) :
	pListenerArr(0),
	pxParent(pxParent)
{
}
/*-- 22.04.99 11:24:59---------------------------------------------------

  -----------------------------------------------------------------------*/
SwEventListenerContainer::~SwEventListenerContainer()
{
	if(pListenerArr && pListenerArr->Count())
	{
		pListenerArr->DeleteAndDestroy(0, pListenerArr->Count());
	}
	delete pListenerArr;
}
/*-- 22.04.99 11:24:59---------------------------------------------------

  -----------------------------------------------------------------------*/
void 	SwEventListenerContainer::AddListener(const uno::Reference< lang::XEventListener > & rxListener)
{
	if(!pListenerArr)
		pListenerArr = new SwEvtLstnrArray;
	uno::Reference< lang::XEventListener > * pInsert = new uno::Reference< lang::XEventListener > ;
	*pInsert = rxListener;
	pListenerArr->Insert(pInsert, pListenerArr->Count());
}
/*-- 22.04.99 11:25:00---------------------------------------------------

  -----------------------------------------------------------------------*/
sal_Bool	SwEventListenerContainer::RemoveListener(const uno::Reference< lang::XEventListener > & rxListener)
{
	if(!pListenerArr)
		return sal_False;
	else
	{
	 	lang::XEventListener* pLeft = rxListener.get();
		for(sal_uInt16 i = 0; i < pListenerArr->Count(); i++)
		{
			XEventListenerPtr pElem = pListenerArr->GetObject(i);
		 	lang::XEventListener* pRight = pElem->get();
			if(pLeft == pRight)
			{
				pListenerArr->Remove(i);
				delete pElem;
				return sal_True;
			}
		}
	}
	return sal_False;
}
/*-- 22.04.99 11:25:00---------------------------------------------------

  -----------------------------------------------------------------------*/
void	SwEventListenerContainer::Disposing()
{
	if(!pListenerArr)
		return;

	lang::EventObject aObj(pxParent);
	for(sal_uInt16 i = 0; i < pListenerArr->Count(); i++)
	{
		XEventListenerPtr pElem = pListenerArr->GetObject(i);
		(*pElem)->disposing(aObj);
	}
	pListenerArr->DeleteAndDestroy(0, pListenerArr->Count());
}


}
