/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_ascfldlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:36:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif


#ifndef _RTL_TEXTENC_H //autogen wg. rtl_TextEncoding
#include <rtl/textenc.h>
#endif
// auto strip #ifndef _SVTOOLS_LINGUCFG_HXX_
// auto strip #include <svtools/lingucfg.hxx>
// auto strip #endif
// auto strip #ifndef _FONTCFG_HXX
// auto strip #include <fontcfg.hxx>
// auto strip #endif
// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _UNO_LINGU_HXX
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #endif

// auto strip #ifndef _SFX_PRINTER_HXX
// auto strip #include <bf_sfx2/printer.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FLSTITEM_HXX //autogen wg. SvxFontListItem
// auto strip #include <bf_svx/flstitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_DLGUTIL_HXX //autogen wg. GetLanguageString
// auto strip #include <bf_svx/dlgutil.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_FONTITEM_HXX //autogen wg. SvxFontItem
// auto strip #include <bf_svx/fontitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LANGITEM_HXX //autogen wg. SvxLanguageItem
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SCRIPTTYPEITEM_HXX
// auto strip #include <bf_svx/scripttypeitem.hxx>
// auto strip #endif
// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
// auto strip #ifndef _ASCFLDLG_HXX
// auto strip #include <ascfldlg.hxx>
// auto strip #endif
// auto strip #ifndef _SHELLIO_HXX
// auto strip #include <shellio.hxx>
// auto strip #endif
// auto strip #ifndef _SWDOCSH_HXX
// auto strip #include <docsh.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
// auto strip #ifndef _ERRHDL_HXX
// auto strip #include <errhdl.hxx>
// auto strip #endif

#ifndef _DIALOG_HRC
#include <dialog.hrc>
#endif
#ifndef _ASCFLDLG_HRC
#include <ascfldlg.hrc>
#endif

// #107253#
#ifndef _SWLINGUCONFIG_HXX
#include <swlinguconfig.hxx>
#endif
namespace binfilter {

using namespace ::com::sun::star;

const sal_Unicode cDialogExtraDataClose = '}';
const char __FAR_DATA sDialogImpExtraData[] = "EncImpDlg:{";
const char __FAR_DATA sDialogExpExtraData[] = "EncExpDlg:{";
const USHORT nDialogExtraDataLen = 11;	  	// 12345678901

//STRIP001 /*N*/ SwAsciiFilterDlg::SwAsciiFilterDlg( Window* pParent, SwDocShell& rDocSh,
//STRIP001 /*N*/ 									SvStream* pStream )
//STRIP001 /*N*/ 	: SfxModalDialog( pParent, SW_RES( DLG_ASCII_FILTER )),
//STRIP001 /*N*/     aFL( this, ResId( FL_1 )),
//STRIP001 /*N*/ 	aCharSetFT( this, ResId( FT_CHARSET )),
//STRIP001 /*N*/ 	aCharSetLB( this, ResId( LB_CHARSET )),
//STRIP001 /*N*/ 	aFontFT( this, ResId( FT_FONT )),
//STRIP001 /*N*/ 	aFontLB( this, ResId( LB_FONT )),
//STRIP001 /*N*/ 	aLanguageFT( this, ResId( FT_LANGUAGE )),
//STRIP001 /*N*/ 	aLanguageLB( this, ResId( LB_LANGUAGE )),
//STRIP001 /*N*/ 	aCRLF_FT( this, ResId( FT_CRLF )),
//STRIP001 /*N*/ 	aCRLF_RB( this, ResId( RB_CRLF )),
//STRIP001 /*N*/ 	aCR_RB( this, ResId( RB_CR )),
//STRIP001 /*N*/ 	aLF_RB( this, ResId( RB_LF )),
//STRIP001 /*N*/ 	aOkPB( this, ResId( PB_OK )),
//STRIP001 /*N*/ 	aCancelPB( this, ResId( PB_CANCEL )),
//STRIP001 /*N*/ 	aHelpPB( this, ResId( PB_HELP )),
//STRIP001 /*N*/ 	sSystemCharSet( ResId( STR_SYS_CHARSET )),
//STRIP001 /*N*/ 	bSaveLineStatus( TRUE )
//STRIP001 /*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	FreeResource();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	SwAsciiOptions aOpt;
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		const String& rFindNm = String::CreateFromAscii(
//STRIP001 /*?*/ 									pStream ? sDialogImpExtraData
//STRIP001 /*?*/ 									  		: sDialogExpExtraData);
//STRIP001 /*?*/ 		USHORT nEnd, nStt = GetExtraData().Search( rFindNm );
//STRIP001 /*?*/ 		if( STRING_NOTFOUND != nStt )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			nStt += nDialogExtraDataLen;
//STRIP001 /*?*/ 			nEnd = GetExtraData().Search( cDialogExtraDataClose, nStt );
//STRIP001 /*?*/ 			if( STRING_NOTFOUND != nEnd )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				aOpt.ReadUserData( GetExtraData().Copy( nStt, nEnd - nStt ));
//STRIP001 /*?*/ 				nStt -= nDialogExtraDataLen;
//STRIP001 /*?*/ 				GetExtraData().Erase( nStt, nEnd - nStt + 1 );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	// read the first chars and check the charset, (language - with L&H)
//STRIP001 /*?*/ 	if( pStream )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		char aBuffer[ 4098 ];
//STRIP001 /*?*/ 		ULONG nOldPos = pStream->Tell();
//STRIP001 /*?*/ 		ULONG nBytesRead = pStream->Read( aBuffer, 4096 );
//STRIP001 /*?*/ 		pStream->Seek( nOldPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( nBytesRead <= 4096 )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			aBuffer[ nBytesRead ] = '0';
//STRIP001 /*?*/ 			aBuffer[ nBytesRead+1 ] = '0';
//STRIP001 /*?*/ 			if( 0 != ( nBytesRead & 0x00000001 ) )
//STRIP001 /*?*/ 				aBuffer[ nBytesRead + 2 ] = '0';
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		BOOL bCR = FALSE, bLF = FALSE, bNoNormalChar = FALSE,
//STRIP001 /*?*/ 			bNullChar = FALSE;
//STRIP001 /*?*/ 		for( USHORT nCnt = 0; nCnt < nBytesRead; ++nCnt )
//STRIP001 /*?*/ 			switch( aBuffer[ nCnt ] )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				case 0x0:	bNullChar = TRUE; break;
//STRIP001 /*?*/ 				case 0xA:	bLF = TRUE; break;
//STRIP001 /*?*/ 				case 0xD:	bCR = TRUE; break;
//STRIP001 /*?*/ 				case 0xC:
//STRIP001 /*?*/ 				case 0x1A:
//STRIP001 /*?*/ 				case 0x9:	break;
//STRIP001 /*?*/ 				default:
//STRIP001 /*?*/ 					if( 0x20 > aBuffer[ nCnt ] )
//STRIP001 /*?*/ 						bNoNormalChar = TRUE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if( !bNullChar )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if( bCR )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				if( bLF )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					aOpt.SetParaFlags( LINEEND_CRLF );
//STRIP001 /*?*/ // have to check if of CharSet is type of ANSI
//STRIP001 /*?*/ //					aOpt.SetCharSet( CHARSET_ANSI );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					aOpt.SetParaFlags( LINEEND_CR );
//STRIP001 /*?*/ // have to check if CharSet is type of MAC
//STRIP001 /*?*/ //					aOpt.SetCharSet( CHARSET_MAC );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if( bLF )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				aOpt.SetParaFlags( LINEEND_LF );
//STRIP001 /*?*/ // have to check if of CharSet is type of ANSI
//STRIP001 /*?*/ //				aOpt.SetCharSet( CHARSET_ANSI );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/         SwDoc* pDoc = rDocSh.GetDoc();
//STRIP001 /*?*/         USHORT nAppScriptType = GetI18NScriptTypeOfLanguage( (USHORT)GetAppLanguage() );
//STRIP001 /*?*/         {
//STRIP001 /*?*/ 			BOOL bDelPrinter = FALSE;
//STRIP001 /*?*/             SfxPrinter* pPrt = pDoc ? pDoc->GetPrt() : 0;
//STRIP001 /*?*/ 			if( !pPrt )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 SfxItemSet* pSet = new SfxItemSet( rDocSh.GetPool(),
//STRIP001 /*?*/ 							SID_PRINTER_NOTFOUND_WARN, SID_PRINTER_NOTFOUND_WARN,
//STRIP001 /*?*/ 							SID_PRINTER_CHANGESTODOC, SID_PRINTER_CHANGESTODOC,
//STRIP001 /*?*/ 							0 );
//STRIP001 /*?*/ 				pPrt = new SfxPrinter( pSet );
//STRIP001 /*?*/ 				bDelPrinter = TRUE;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			const USHORT nCount = pPrt->GetFontCount();
//STRIP001 /*?*/ 			for (USHORT i = 0; i < nCount; ++i)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const String &rStr = pPrt->GetFont(i)->GetName();
//STRIP001 /*?*/ 				aFontLB.InsertEntry( rStr );
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( !aOpt.GetFontName().Len() )
//STRIP001 /*?*/             {
//STRIP001 /*?*/                 if(pDoc)
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     USHORT nFontRes = RES_CHRATR_FONT;
//STRIP001 /*?*/                     if(SCRIPTTYPE_ASIAN == nAppScriptType)
//STRIP001 /*?*/                         nFontRes = RES_CHRATR_CJK_FONT;
//STRIP001 /*?*/                     else if(SCRIPTTYPE_COMPLEX == nAppScriptType)
//STRIP001 /*?*/                         nFontRes = RES_CHRATR_CTL_FONT;
//STRIP001 /*?*/ 
//STRIP001 /*?*/                     aOpt.SetFontName( ((SvxFontItem&)pDoc->GetDefault(
//STRIP001 /*?*/                                     nFontRes )).GetFamilyName() );
//STRIP001 /*?*/                 }
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     USHORT nFontType = FONT_STANDARD;
//STRIP001 /*?*/                     if(SCRIPTTYPE_ASIAN == nAppScriptType)
//STRIP001 /*?*/                         nFontType = FONT_STANDARD_CJK;
//STRIP001 /*?*/                     else if(SCRIPTTYPE_COMPLEX == nAppScriptType)
//STRIP001 /*?*/                         nFontType = FONT_STANDARD_CTL;
//STRIP001 /*?*/                     aOpt.SetFontName(SW_MOD()->GetStdFontConfig()->GetFontFor(nFontType));
//STRIP001 /*?*/                 }
//STRIP001 /*?*/             }
//STRIP001 /*?*/ 			aFontLB.SelectEntry( aOpt.GetFontName() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if( bDelPrinter )
//STRIP001 /*?*/ 				delete pPrt;
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// initialisiere Sprache
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			if( !aOpt.GetLanguage() )
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/                 if(pDoc)
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     USHORT nWhich = GetWhichOfScript( RES_CHRATR_LANGUAGE, nAppScriptType);
//STRIP001 /*?*/                     aOpt.SetLanguage( ((SvxLanguageItem&)pDoc->
//STRIP001 /*?*/                                 GetDefault( nWhich )).GetLanguage());
//STRIP001 /*?*/                 }
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     SvtLinguOptions aLinguOpt;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// #107253# Replaced SvtLinguConfig with SwLinguConfig wrapper with UsageCount
//STRIP001 /*?*/                     SwLinguConfig().GetOptions( aLinguOpt );
//STRIP001 /*?*/                     switch(nAppScriptType)
//STRIP001 /*?*/                     {        
//STRIP001 /*?*/                         case SCRIPTTYPE_ASIAN: 
//STRIP001 /*?*/                             aOpt.SetLanguage(aLinguOpt.nDefaultLanguage_CJK);
//STRIP001 /*?*/                         break;
//STRIP001 /*?*/                         case SCRIPTTYPE_COMPLEX:
//STRIP001 /*?*/                             aOpt.SetLanguage(aLinguOpt.nDefaultLanguage_CTL);
//STRIP001 /*?*/                         break;
//STRIP001 /*?*/                         //SCRIPTTYPE_LATIN:
//STRIP001 /*?*/                         default:
//STRIP001 /*?*/                             aOpt.SetLanguage(aLinguOpt.nDefaultLanguage);
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                 }
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			aLanguageLB.SetLanguageList( LANG_LIST_ALL, TRUE, FALSE );
//STRIP001 /*?*/ 			aLanguageLB.SelectLanguage( aOpt.GetLanguage() );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 	else
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		// hide the used Control for the Export and move the
//STRIP001 /*?*/ 		// other behind the charset controls
//STRIP001 /*?*/ 		aFontFT.Hide();
//STRIP001 /*?*/ 		aFontLB.Hide();
//STRIP001 /*?*/ 		aLanguageFT.Hide();
//STRIP001 /*?*/ 		aLanguageLB.Hide();
//STRIP001 /*?*/ 
//STRIP001 /*?*/         long nY = aFontFT.GetPosPixel().Y() + 1;
//STRIP001 /*?*/ 		Point aPos( aCRLF_FT.GetPosPixel() );	aPos.Y() = nY;
//STRIP001 /*?*/ 		aCRLF_FT.SetPosPixel( aPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aPos = aCRLF_RB.GetPosPixel();	aPos.Y() = nY;
//STRIP001 /*?*/ 		aCRLF_RB.SetPosPixel( aPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aPos = aCR_RB.GetPosPixel();	aPos.Y() = nY;
//STRIP001 /*?*/ 		aCR_RB.SetPosPixel( aPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		aPos = aLF_RB.GetPosPixel();	aPos.Y() = nY;
//STRIP001 /*?*/ 		aLF_RB.SetPosPixel( aPos );
//STRIP001 /*?*/ 
//STRIP001 /*?*/         Size aSize = GetSizePixel();
//STRIP001 /*?*/         Size aTmpSz( 6, 6 );
//STRIP001 /*?*/         aTmpSz = LogicToPixel(aTmpSz, MAP_APPFONT);
//STRIP001 /*?*/         aSize.Height() = aHelpPB.GetPosPixel().Y() +
//STRIP001 /*?*/                          aHelpPB.GetSizePixel().Height() + aTmpSz.Height();
//STRIP001 /*?*/         SetSizePixel( aSize );
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	// initialisiere Zeichensatz
//STRIP001 /*?*/ 	aCharSetLB.FillFromTextEncodingTable( pStream != NULL );
//STRIP001 /*?*/ 	aCharSetLB.SelectTextEncoding( aOpt.GetCharSet()  );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	aCharSetLB.SetSelectHdl( LINK( this, SwAsciiFilterDlg, CharSetSelHdl ));
//STRIP001 /*?*/ 	aCRLF_RB.SetToggleHdl( LINK( this, SwAsciiFilterDlg, LineEndHdl ));
//STRIP001 /*?*/ 	aLF_RB.SetToggleHdl( LINK( this, SwAsciiFilterDlg, LineEndHdl ));
//STRIP001 /*?*/ 	aCR_RB.SetToggleHdl( LINK( this, SwAsciiFilterDlg, LineEndHdl ));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	SetCRLF( aOpt.GetParaFlags() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	aCRLF_RB.SaveValue();
//STRIP001 /*?*/ 	aLF_RB.SaveValue();
//STRIP001 /*?*/ 	aCR_RB.SaveValue();
//STRIP001 /*N*/ }


//STRIP001 /*?*/ SwAsciiFilterDlg::~SwAsciiFilterDlg()
//STRIP001 /*?*/ {
//STRIP001 /*?*/ }


//STRIP001 /*?*/ void SwAsciiFilterDlg::FillOptions( SwAsciiOptions& rOptions )
//STRIP001 /*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 	ULONG nCCode = aCharSetLB.GetSelectTextEncoding();
//STRIP001 /*?*/ 	String sFont;
//STRIP001 /*?*/ 	ULONG nLng = 0;
//STRIP001 /*?*/ 	if( aFontLB.IsVisible() )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		sFont = aFontLB.GetSelectEntry();
//STRIP001 /*?*/ 		nLng = (ULONG)aLanguageLB.GetSelectLanguage();
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	rOptions.SetFontName( sFont );
//STRIP001 /*?*/ 	rOptions.SetCharSet( rtl_TextEncoding( nCCode ) );
//STRIP001 /*?*/ 	rOptions.SetLanguage( USHORT( nLng ) );
//STRIP001 /*?*/ 	rOptions.SetParaFlags( GetCRLF() );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	// JP: Task #71802# save the user settings
//STRIP001 /*?*/ 	String sData;
//STRIP001 /*?*/ 	rOptions.WriteUserData( sData );
//STRIP001 /*?*/ 	if( sData.Len() )
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		const String& rFindNm = String::CreateFromAscii(
//STRIP001 /*?*/ 									aFontLB.IsVisible() ? sDialogImpExtraData
//STRIP001 /*?*/ 									  		: sDialogExpExtraData);
//STRIP001 /*?*/ 		USHORT nEnd, nStt = GetExtraData().Search( rFindNm );
//STRIP001 /*?*/ 		if( STRING_NOTFOUND != nStt )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// called twice, so remove "old" settings
//STRIP001 /*?*/ 			nEnd = GetExtraData().Search( cDialogExtraDataClose,
//STRIP001 /*?*/ 											nStt + nDialogExtraDataLen );
//STRIP001 /*?*/ 			if( STRING_NOTFOUND != nEnd )
//STRIP001 /*?*/ 				GetExtraData().Erase( nStt, nEnd - nStt + 1 );
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		String sTmp(GetExtraData());
//STRIP001 /*?*/ 		sTmp += rFindNm;
//STRIP001 /*?*/ 		sTmp += sData;
//STRIP001 /*?*/ 		sTmp += cDialogExtraDataClose;
//STRIP001 /*?*/ 		GetExtraData() = sTmp;
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ }

//STRIP001 void SwAsciiFilterDlg::SetCRLF( LineEnd eEnd )
//STRIP001 {
//STRIP001 	switch( eEnd )
//STRIP001 	{
//STRIP001 	case LINEEND_CR: 	aCR_RB.Check();		break;
//STRIP001 	case LINEEND_CRLF: 	aCRLF_RB.Check();	break;
//STRIP001 	case LINEEND_LF: 	aLF_RB.Check();		break;
//STRIP001 	}
//STRIP001 }

//STRIP001 LineEnd SwAsciiFilterDlg::GetCRLF() const
//STRIP001 {
//STRIP001 	LineEnd eEnd;
//STRIP001 	if( aCR_RB.IsChecked() )
//STRIP001 		eEnd = LINEEND_CR;
//STRIP001 	else if( aLF_RB.IsChecked() )
//STRIP001 		eEnd = LINEEND_LF;
//STRIP001 	else
//STRIP001 		eEnd = LINEEND_CRLF;
//STRIP001 	return eEnd;
//STRIP001 }

//STRIP001 IMPL_LINK( SwAsciiFilterDlg, CharSetSelHdl, SvxTextEncodingBox*, pBox )
//STRIP001 {
//STRIP001 	LineEnd eOldEnd = GetCRLF(), eEnd = (LineEnd)-1;
//STRIP001 	ULONG nLng = aFontLB.IsVisible()
//STRIP001 					? (ULONG)aLanguageLB.GetSelectLanguage()
//STRIP001 					: 0,
//STRIP001 			nOldLng = nLng;
//STRIP001 
//STRIP001 	rtl_TextEncoding nChrSet = pBox->GetSelectTextEncoding();
//STRIP001 	if( nChrSet == gsl_getSystemTextEncoding() )
//STRIP001 		eEnd = GetSystemLineEnd();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		switch( nChrSet )
//STRIP001 		{
//STRIP001 		case RTL_TEXTENCODING_MS_1252:
//STRIP001 #ifdef UNX
//STRIP001 			eEnd = LINEEND_LF;
//STRIP001 #else
//STRIP001 			eEnd = LINEEND_CRLF;				// ANSI
//STRIP001 #endif
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RTL_TEXTENCODING_APPLE_ROMAN:		// MAC
//STRIP001 			eEnd = LINEEND_CR;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RTL_TEXTENCODING_IBM_850:			// DOS
//STRIP001 			eEnd = LINEEND_CRLF;
//STRIP001 			break;
//STRIP001 
//STRIP001 		case RTL_TEXTENCODING_APPLE_ARABIC:
//STRIP001 		case RTL_TEXTENCODING_APPLE_CENTEURO:
//STRIP001 		case RTL_TEXTENCODING_APPLE_CROATIAN:
//STRIP001 		case RTL_TEXTENCODING_APPLE_CYRILLIC:
//STRIP001 		case RTL_TEXTENCODING_APPLE_DEVANAGARI:
//STRIP001 		case RTL_TEXTENCODING_APPLE_FARSI:
//STRIP001 		case RTL_TEXTENCODING_APPLE_GREEK:
//STRIP001 		case RTL_TEXTENCODING_APPLE_GUJARATI:
//STRIP001 		case RTL_TEXTENCODING_APPLE_GURMUKHI:
//STRIP001 		case RTL_TEXTENCODING_APPLE_HEBREW:
//STRIP001 		case RTL_TEXTENCODING_APPLE_ICELAND:
//STRIP001 		case RTL_TEXTENCODING_APPLE_ROMANIAN:
//STRIP001 		case RTL_TEXTENCODING_APPLE_THAI:
//STRIP001 		case RTL_TEXTENCODING_APPLE_TURKISH:
//STRIP001 		case RTL_TEXTENCODING_APPLE_UKRAINIAN:
//STRIP001 		case RTL_TEXTENCODING_APPLE_CHINSIMP:
//STRIP001 		case RTL_TEXTENCODING_APPLE_CHINTRAD:
//STRIP001 		case RTL_TEXTENCODING_APPLE_JAPANESE:
//STRIP001 		case RTL_TEXTENCODING_APPLE_KOREAN:
//STRIP001 			eEnd = LINEEND_CR;
//STRIP001 			break;
//STRIP001 
//STRIP001 #if 0
//STRIP001 which charset and language?
//STRIP001 		case RTL_TEXTENCODING_IBM_437:
//STRIP001 		case RTL_TEXTENCODING_IBM_860:
//STRIP001 		case RTL_TEXTENCODING_IBM_861:
//STRIP001 		case RTL_TEXTENCODING_IBM_863:
//STRIP001 		case RTL_TEXTENCODING_IBM_865:
//STRIP001 		case RTL_TEXTENCODING_ASCII_US:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_1:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_2:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_3:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_4:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_5:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_6:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_7:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_8:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_9:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_14:
//STRIP001 		case RTL_TEXTENCODING_ISO_8859_15:
//STRIP001 		case RTL_TEXTENCODING_IBM_737:
//STRIP001 		case RTL_TEXTENCODING_IBM_775:
//STRIP001 		case RTL_TEXTENCODING_IBM_852:
//STRIP001 		case RTL_TEXTENCODING_IBM_855:
//STRIP001 		case RTL_TEXTENCODING_IBM_857:
//STRIP001 		case RTL_TEXTENCODING_IBM_862:
//STRIP001 		case RTL_TEXTENCODING_IBM_864:
//STRIP001 		case RTL_TEXTENCODING_IBM_866:
//STRIP001 		case RTL_TEXTENCODING_IBM_869:
//STRIP001 		case RTL_TEXTENCODING_MS_874:
//STRIP001 		case RTL_TEXTENCODING_MS_1250:
//STRIP001 		case RTL_TEXTENCODING_MS_1251:
//STRIP001 		case RTL_TEXTENCODING_MS_1253:
//STRIP001 		case RTL_TEXTENCODING_MS_1254:
//STRIP001 		case RTL_TEXTENCODING_MS_1255:
//STRIP001 		case RTL_TEXTENCODING_MS_1256:
//STRIP001 		case RTL_TEXTENCODING_MS_1257:
//STRIP001 		case RTL_TEXTENCODING_MS_1258:
//STRIP001 		case RTL_TEXTENCODING_MS_932:
//STRIP001 		case RTL_TEXTENCODING_MS_936:
//STRIP001 		case RTL_TEXTENCODING_MS_949:
//STRIP001 		case RTL_TEXTENCODING_MS_950:
//STRIP001 		case RTL_TEXTENCODING_SHIFT_JIS:
//STRIP001 		case RTL_TEXTENCODING_GB_2312:
//STRIP001 		case RTL_TEXTENCODING_GBT_12345:
//STRIP001 		case RTL_TEXTENCODING_GBK:
//STRIP001 		case RTL_TEXTENCODING_BIG5:
//STRIP001 		case RTL_TEXTENCODING_EUC_JP:
//STRIP001 		case RTL_TEXTENCODING_EUC_CN:
//STRIP001 		case RTL_TEXTENCODING_EUC_TW:
//STRIP001 		case RTL_TEXTENCODING_ISO_2022_JP:
//STRIP001 		case RTL_TEXTENCODING_ISO_2022_CN:
//STRIP001 		case RTL_TEXTENCODING_KOI8_R:
//STRIP001 #endif
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	bSaveLineStatus = FALSE;
//STRIP001 	if( eEnd != (LineEnd)-1 )		// changed?
//STRIP001 	{
//STRIP001 		if( eOldEnd != eEnd )
//STRIP001 			SetCRLF( eEnd );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// restore old user choise (not the automatic!)
//STRIP001 		aCRLF_RB.Check( aCRLF_RB.GetSavedValue() );
//STRIP001 		aCR_RB.Check( aCR_RB.GetSavedValue() );
//STRIP001 		aLF_RB.Check( aLF_RB.GetSavedValue() );
//STRIP001 	}
//STRIP001 	bSaveLineStatus = TRUE;
//STRIP001 
//STRIP001 	if( nOldLng != nLng && aFontLB.IsVisible() )
//STRIP001 		aLanguageLB.SelectLanguage( nLng );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK( SwAsciiFilterDlg, LineEndHdl, RadioButton*, pBtn )
//STRIP001 {
//STRIP001 	if( bSaveLineStatus )
//STRIP001 		pBtn->SaveValue();
//STRIP001 	return 0;
//STRIP001 }

}
