/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_wrap.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 05:16:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include "hintids.hxx"
//STRIP001 
//STRIP001 #ifndef _SV_GRAPH_HXX
//STRIP001 #include <vcl/graph.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_HTMLMODE_HXX
//STRIP001 #include <bf_svx/htmlmode.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_OBJSH_HXX //autogen
//STRIP001 #include <bf_sfx2/objsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXINTITEM_HXX //autogen
//STRIP001 #include <svtools/intitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_OPAQITEM_HXX //autogen
//STRIP001 #include <bf_svx/opaqitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_ULSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/ulspitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_LRSPITEM_HXX //autogen
//STRIP001 #include <bf_svx/lrspitem.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #include "cmdid.h"
//STRIP001 #include "uitool.hxx"
//STRIP001 #include "wrtsh.hxx"
//STRIP001 #include "swmodule.hxx"
//STRIP001 #include "viewopt.hxx"
//STRIP001 #include "frmatr.hxx"
//STRIP001 #include "frmmgr.hxx"
//STRIP001 #include "globals.hrc"
//STRIP001 #include "frmui.hrc"
//STRIP001 #include "wrap.hrc"
//STRIP001 #include "wrap.hxx"
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 static USHORT __FAR_DATA aWrapPageRg[] = {
//STRIP001 	RES_LR_SPACE, RES_UL_SPACE,
//STRIP001 	RES_PROTECT, RES_SURROUND,
//STRIP001 	RES_PRINT, RES_PRINT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwWrapDlg::SwWrapDlg(Window* pParent, SfxItemSet& rSet, SwWrtShell* pSh, BOOL bDrawMode) :
//STRIP001 	SfxSingleTabDialog(pParent, rSet, 0),
//STRIP001 	pWrtShell(pSh)
//STRIP001 
//STRIP001 {
//STRIP001 	// TabPage erzeugen
//STRIP001 	SwWrapTabPage* pPage = (SwWrapTabPage*) SwWrapTabPage::Create(this, rSet);
//STRIP001 	pPage->SetFormatUsed(FALSE, bDrawMode);
//STRIP001 	pPage->SetShell(pWrtShell);
//STRIP001 	SetTabPage(pPage);
//STRIP001 
//STRIP001 	String sTitle(SW_RES(STR_FRMUI_WRAP));
//STRIP001 	SetText(sTitle);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwWrapDlg::~SwWrapDlg()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwWrapTabPage::SwWrapTabPage(Window *pParent, const SfxItemSet &rSet) :
//STRIP001 	SfxTabPage(pParent, SW_RES(TP_FRM_WRAP), rSet),
//STRIP001 
//STRIP001     aWrapFLC           (this, SW_RES(C_WRAP_FL)),
//STRIP001 	aNoWrapRB			(this, SW_RES(RB_NO_WRAP)),
//STRIP001 	aWrapLeftRB			(this, SW_RES(RB_WRAP_LEFT)),
//STRIP001 	aWrapRightRB		(this, SW_RES(RB_WRAP_RIGHT)),
//STRIP001 	aWrapParallelRB		(this, SW_RES(RB_WRAP_PARALLEL)),
//STRIP001 	aWrapThroughRB		(this, SW_RES(RB_WRAP_THROUGH)),
//STRIP001 	aIdealWrapRB		(this, SW_RES(RB_WRAP_IDEAL)),
//STRIP001 	aWrapAnchorOnlyCB	(this, SW_RES(CB_ANCHOR_ONLY)),
//STRIP001 	aWrapTransparentCB	(this, SW_RES(CB_TRANSPARENT)),
//STRIP001 	aWrapOutlineCB		(this, SW_RES(CB_OUTLINE)),
//STRIP001 	aWrapOutsideCB		(this, SW_RES(CB_ONLYOUTSIDE)),
//STRIP001     aOptionsFL          (this, SW_RES(FL_OPTION)),
//STRIP001     aOptionsSepFL       (this, SW_RES(FL_OPTION_SEP)),
//STRIP001 	aLeftMarginFT		(this, SW_RES(FT_LEFT_MARGIN)),
//STRIP001 	aLeftMarginED		(this, SW_RES(ED_LEFT_MARGIN)),
//STRIP001 	aRightMarginFT		(this, SW_RES(FT_RIGHT_MARGIN)),
//STRIP001 	aRightMarginED		(this, SW_RES(ED_RIGHT_MARGIN)),
//STRIP001 	aTopMarginFT		(this, SW_RES(FT_TOP_MARGIN)),
//STRIP001 	aTopMarginED		(this, SW_RES(ED_TOP_MARGIN)),
//STRIP001 	aBottomMarginFT		(this, SW_RES(FT_BOTTOM_MARGIN)),
//STRIP001 	aBottomMarginED		(this, SW_RES(ED_BOTTOM_MARGIN)),
//STRIP001     aMarginFL           (this, SW_RES(FL_MARGIN)),
//STRIP001 	aWrapIL				(SW_RES(IL_WRAP)),
//STRIP001     aWrapILH            (SW_RES(ILH_WRAP)),
//STRIP001     nHtmlMode(0),
//STRIP001 	bNew(TRUE),
//STRIP001 	bFormat(FALSE),
//STRIP001 	bHtmlMode(FALSE),
//STRIP001 	bContourImage(FALSE),
//STRIP001 	nAnchorId(0)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	Link aLk = LINK(this, SwWrapTabPage, RangeModifyHdl);
//STRIP001 	aLeftMarginED.SetUpHdl(aLk);
//STRIP001 	aLeftMarginED.SetDownHdl(aLk);
//STRIP001 	aLeftMarginED.SetFirstHdl(aLk);
//STRIP001 	aLeftMarginED.SetLastHdl(aLk);
//STRIP001 	aLeftMarginED.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aRightMarginED.SetUpHdl(aLk);
//STRIP001 	aRightMarginED.SetDownHdl(aLk);
//STRIP001 	aRightMarginED.SetFirstHdl(aLk);
//STRIP001 	aRightMarginED.SetLastHdl(aLk);
//STRIP001 	aRightMarginED.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aTopMarginED.SetUpHdl(aLk);
//STRIP001 	aTopMarginED.SetDownHdl(aLk);
//STRIP001 	aTopMarginED.SetFirstHdl(aLk);
//STRIP001 	aTopMarginED.SetLastHdl(aLk);
//STRIP001 	aTopMarginED.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aBottomMarginED.SetUpHdl(aLk);
//STRIP001 	aBottomMarginED.SetDownHdl(aLk);
//STRIP001 	aBottomMarginED.SetFirstHdl(aLk);
//STRIP001 	aBottomMarginED.SetLastHdl(aLk);
//STRIP001 	aBottomMarginED.SetLoseFocusHdl(aLk);
//STRIP001 
//STRIP001 	aLk = LINK(this, SwWrapTabPage, WrapTypeHdl);
//STRIP001 	aNoWrapRB.SetClickHdl(aLk);
//STRIP001 	aWrapLeftRB.SetClickHdl(aLk);
//STRIP001 	aWrapRightRB.SetClickHdl(aLk);
//STRIP001 	aWrapParallelRB.SetClickHdl(aLk);
//STRIP001 	aWrapThroughRB.SetClickHdl(aLk);
//STRIP001 	aIdealWrapRB.SetClickHdl(aLk);
//STRIP001     ApplyImageList();
//STRIP001 	aWrapOutlineCB.SetClickHdl(LINK(this, SwWrapTabPage, ContourHdl));
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwWrapTabPage::~SwWrapTabPage()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SfxTabPage* SwWrapTabPage::Create(Window *pParent, const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	return new SwWrapTabPage(pParent, rSet);
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwWrapTabPage::Reset(const SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	//Contour fuer Draw, Grafik und OLE (Einfuegen/Grafik/Eigenschaften fehlt noch!)
//STRIP001 	if( bDrawMode )
//STRIP001 	{
//STRIP001 		aWrapOutlineCB.Show();
//STRIP001 		aWrapOutsideCB.Show();
//STRIP001 
//STRIP001 		aWrapTransparentCB.Check( 0 == ((const SfxInt16Item&)rSet.Get(
//STRIP001 										FN_DRAW_WRAP_DLG)).GetValue() );
//STRIP001 		aWrapTransparentCB.SaveValue();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		BOOL bShowCB = bFormat;
//STRIP001 		if( !bFormat )
//STRIP001 		{
//STRIP001 			int nSelType = pWrtSh->GetSelectionType();
//STRIP001 			if( ( nSelType & SwWrtShell::SEL_GRF ) ||
//STRIP001 			    ( nSelType & SwWrtShell::SEL_OLE && GRAPHIC_NONE !=
//STRIP001 				            pWrtSh->GetIMapGraphic().GetType() ))
//STRIP001 				bShowCB = TRUE;
//STRIP001 		}
//STRIP001 		if( bShowCB )
//STRIP001 		{
//STRIP001 			aWrapOutlineCB.Show();
//STRIP001 			aWrapOutsideCB.Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nHtmlMode = ::binfilter::GetHtmlMode((const SwDocShell*)SfxObjectShell::Current());
//STRIP001 	bHtmlMode = nHtmlMode & HTMLMODE_ON ? TRUE : FALSE;
//STRIP001 
//STRIP001 	FieldUnit aMetric = ::GetDfltMetric(bHtmlMode);
//STRIP001 	SetMetric( aLeftMarginED  , aMetric );
//STRIP001 	SetMetric( aRightMarginED , aMetric );
//STRIP001 	SetMetric( aTopMarginED   , aMetric );
//STRIP001 	SetMetric( aBottomMarginED, aMetric );
//STRIP001 
//STRIP001 	const SwFmtSurround& rSurround = (const SwFmtSurround&)rSet.Get(RES_SURROUND);
//STRIP001 
//STRIP001 	USHORT nSur = rSurround.GetSurround();
//STRIP001 	const SwFmtAnchor &rAnch = (const SwFmtAnchor&)rSet.Get(RES_ANCHOR);
//STRIP001 	nAnchorId = rAnch.GetAnchorId();
//STRIP001 
//STRIP001 	if ( (nAnchorId == FLY_AT_CNTNT || nAnchorId == FLY_AUTO_CNTNT) && nSur != SURROUND_NONE )
//STRIP001 		aWrapAnchorOnlyCB.Check( rSurround.IsAnchorOnly() );
//STRIP001 	else
//STRIP001 		aWrapAnchorOnlyCB.Enable( FALSE );
//STRIP001 
//STRIP001 	BOOL bContour = rSurround.IsContour();
//STRIP001 	aWrapOutlineCB.Check( bContour );
//STRIP001 	aWrapOutsideCB.Check( rSurround.IsOutside() );
//STRIP001 	aWrapThroughRB.Enable(!aWrapOutlineCB.IsChecked());
//STRIP001 	bContourImage = !bContour;
//STRIP001 
//STRIP001 	ImageRadioButton* pBtn = NULL;
//STRIP001 
//STRIP001 	switch (nSur)
//STRIP001 	{
//STRIP001 		case SURROUND_NONE:
//STRIP001 		{
//STRIP001 			pBtn = &aNoWrapRB;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SURROUND_THROUGHT:
//STRIP001 		{
//STRIP001 			// transparent ?
//STRIP001 			pBtn = &aWrapThroughRB;
//STRIP001 
//STRIP001 			if (!bDrawMode)
//STRIP001 			{
//STRIP001 				const SvxOpaqueItem& rOpaque = (const SvxOpaqueItem&)rSet.Get(RES_OPAQUE);
//STRIP001 				aWrapTransparentCB.Check(!rOpaque.GetValue());
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SURROUND_PARALLEL:
//STRIP001 		{
//STRIP001 			pBtn = &aWrapParallelRB;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SURROUND_IDEAL:
//STRIP001 		{
//STRIP001 			pBtn = &aIdealWrapRB;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		default:
//STRIP001 		{
//STRIP001 			if (nSur == SURROUND_LEFT)
//STRIP001 				pBtn = &aWrapLeftRB;
//STRIP001 			else if (nSur == SURROUND_RIGHT)
//STRIP001 				pBtn = &aWrapRightRB;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (pBtn)
//STRIP001 	{
//STRIP001 		pBtn->Check();
//STRIP001 		WrapTypeHdl(pBtn);
//STRIP001 		// Hier wird fuer Zeichenobjekte, die im Moment auf Durchlauf stehen,
//STRIP001 		// schon mal der Default "Kontur an" vorbereitet, falls man spaeter auf
//STRIP001 		// irgendeinen Umlauf umschaltet.
//STRIP001 		if (bDrawMode && !aWrapOutlineCB.IsEnabled())
//STRIP001 			aWrapOutlineCB.Check();
//STRIP001 	}
//STRIP001 	aWrapTransparentCB.Enable( pBtn == &aWrapThroughRB && !bHtmlMode );
//STRIP001 
//STRIP001 	const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)rSet.Get(RES_UL_SPACE);
//STRIP001 	const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)rSet.Get(RES_LR_SPACE);
//STRIP001 
//STRIP001 	// Abstand zum Text
//STRIP001 	aLeftMarginED.SetValue(aLeftMarginED.Normalize(rLR.GetLeft()), FUNIT_TWIP);
//STRIP001 	aRightMarginED.SetValue(aRightMarginED.Normalize(rLR.GetRight()), FUNIT_TWIP);
//STRIP001 	aTopMarginED.SetValue(aTopMarginED.Normalize(rUL.GetUpper()), FUNIT_TWIP);
//STRIP001 	aBottomMarginED.SetValue(aBottomMarginED.Normalize(rUL.GetLower()), FUNIT_TWIP);
//STRIP001 
//STRIP001 	ContourHdl(0);
//STRIP001 	ActivatePage( rSet );
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Attribute in den Set stopfen bei OK
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwWrapTabPage::FillItemSet(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	const SfxPoolItem* pOldItem;
//STRIP001 
//STRIP001 	const SwFmtSurround& rOldSur = (const SwFmtSurround&)GetItemSet().Get(RES_SURROUND);
//STRIP001 	SwFmtSurround aSur( rOldSur );
//STRIP001 
//STRIP001 	SvxOpaqueItem aOp;
//STRIP001 
//STRIP001 	if (!bDrawMode)
//STRIP001 	{
//STRIP001 		const SvxOpaqueItem& rOpaque = (const SvxOpaqueItem&)GetItemSet().Get(RES_OPAQUE);
//STRIP001 		SvxOpaqueItem aOp = rOpaque;
//STRIP001 		aOp.SetValue(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (aNoWrapRB.IsChecked())
//STRIP001 		aSur.SetSurround(SURROUND_NONE);
//STRIP001 	else if (aWrapLeftRB.IsChecked())
//STRIP001 		aSur.SetSurround(SURROUND_LEFT);
//STRIP001 	else if (aWrapRightRB.IsChecked())
//STRIP001 		aSur.SetSurround(SURROUND_RIGHT);
//STRIP001 	else if (aWrapParallelRB.IsChecked())
//STRIP001 		aSur.SetSurround(SURROUND_PARALLEL);
//STRIP001 	else if (aWrapThroughRB.IsChecked())
//STRIP001 	{
//STRIP001 		aSur.SetSurround(SURROUND_THROUGHT);
//STRIP001 		if (aWrapTransparentCB.IsChecked() && !bDrawMode)
//STRIP001 			aOp.SetValue(FALSE);
//STRIP001 	}
//STRIP001 	else if (aIdealWrapRB.IsChecked())
//STRIP001 		aSur.SetSurround(SURROUND_IDEAL);
//STRIP001 
//STRIP001 	aSur.SetAnchorOnly( aWrapAnchorOnlyCB.IsChecked() );
//STRIP001 	BOOL bContour = aWrapOutlineCB.IsChecked() && aWrapOutlineCB.IsEnabled();
//STRIP001 	aSur.SetContour( bContour );
//STRIP001 
//STRIP001 	if ( bContour )
//STRIP001 		aSur.SetOutside(aWrapOutsideCB.IsChecked());
//STRIP001 
//STRIP001 	if(0 == (pOldItem = GetOldItem( rSet, RES_SURROUND )) ||
//STRIP001 				aSur != *pOldItem )
//STRIP001 	{
//STRIP001 		rSet.Put(aSur);
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bDrawMode)
//STRIP001 	{
//STRIP001 		if(0 == (pOldItem = GetOldItem( rSet, FN_OPAQUE )) ||
//STRIP001 					aOp != *pOldItem )
//STRIP001 		{
//STRIP001 			rSet.Put(aOp);
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bTopMod = aTopMarginED.IsValueModified();
//STRIP001 	BOOL bBottomMod = aBottomMarginED.IsValueModified();
//STRIP001 
//STRIP001 	SvxULSpaceItem aUL;
//STRIP001 	aUL.SetUpper((USHORT)aTopMarginED.Denormalize(aTopMarginED.GetValue(FUNIT_TWIP)));
//STRIP001 	aUL.SetLower((USHORT)aBottomMarginED.Denormalize(aBottomMarginED.GetValue(FUNIT_TWIP)));
//STRIP001 
//STRIP001 	if ( bTopMod || bBottomMod )
//STRIP001 	{
//STRIP001 		if(0 == (pOldItem = GetOldItem(rSet, RES_UL_SPACE)) ||
//STRIP001 				aUL != *pOldItem )
//STRIP001 		{
//STRIP001 			rSet.Put( aUL, RES_UL_SPACE );
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bLeftMod = aLeftMarginED.IsValueModified();
//STRIP001 	BOOL bRightMod = aRightMarginED.IsValueModified();
//STRIP001 
//STRIP001 	SvxLRSpaceItem aLR;
//STRIP001 	aLR.SetLeft((USHORT)aLeftMarginED.Denormalize(aLeftMarginED.GetValue(FUNIT_TWIP)));
//STRIP001 	aLR.SetRight((USHORT)aRightMarginED.Denormalize(aRightMarginED.GetValue(FUNIT_TWIP)));
//STRIP001 
//STRIP001 	if ( bLeftMod || bRightMod )
//STRIP001 	{
//STRIP001 		if( 0 == (pOldItem = GetOldItem(rSet, RES_LR_SPACE)) ||
//STRIP001 				aLR != *pOldItem )
//STRIP001 		{
//STRIP001 			rSet.Put(aLR, RES_LR_SPACE);
//STRIP001 			bModified = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bDrawMode )
//STRIP001 	{
//STRIP001 		BOOL bChecked = aWrapTransparentCB.IsChecked() & aWrapTransparentCB.IsEnabled();
//STRIP001 		if (aWrapTransparentCB.GetSavedValue() != bChecked)
//STRIP001 			bModified |= 0 != rSet.Put(SfxInt16Item(FN_DRAW_WRAP_DLG, bChecked ? 0 : 1));
//STRIP001 	}
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Bsp - Update
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwWrapTabPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	// Anchor
//STRIP001 	const SwFmtAnchor &rAnch = (const SwFmtAnchor&)rSet.Get(RES_ANCHOR);
//STRIP001 	nAnchorId = rAnch.GetAnchorId();
//STRIP001 	BOOL bEnable = nAnchorId != FLY_IN_CNTNT;
//STRIP001 
//STRIP001 	if (!bDrawMode)
//STRIP001 	{
//STRIP001 		SwWrtShell* pSh = bFormat ? ::GetActiveWrtShell() : pWrtSh;
//STRIP001 		SwFlyFrmAttrMgr aMgr( bNew, pSh, (const SwAttrSet&)GetItemSet() );
//STRIP001 		SwFrmValid		aVal;
//STRIP001 
//STRIP001 		// Size
//STRIP001 		const SwFmtFrmSize& rFrmSize = (const SwFmtFrmSize&)rSet.Get(RES_FRM_SIZE);
//STRIP001 		Size aSize = rFrmSize.GetSize();
//STRIP001 
//STRIP001 		// Rand
//STRIP001 		const SvxULSpaceItem& rUL = (const SvxULSpaceItem&)rSet.Get(RES_UL_SPACE);
//STRIP001 		const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)rSet.Get(RES_LR_SPACE);
//STRIP001 		nOldLeftMargin  = rLR.GetLeft();
//STRIP001 		nOldRightMargin = rLR.GetRight();
//STRIP001 		nOldUpperMargin = rUL.GetUpper();
//STRIP001 		nOldLowerMargin = rUL.GetLower();
//STRIP001 
//STRIP001 		// Position
//STRIP001 		const SwFmtHoriOrient& rHori = (const SwFmtHoriOrient&)rSet.Get(RES_HORI_ORIENT);
//STRIP001 		const SwFmtVertOrient& rVert = (const SwFmtVertOrient&)rSet.Get(RES_VERT_ORIENT);
//STRIP001 
//STRIP001 		aVal.eArea = (RndStdIds)nAnchorId;
//STRIP001 		aVal.bAuto = rFrmSize.GetSizeType() == ATT_MIN_SIZE;
//STRIP001 		aVal.bMirror = rHori.IsPosToggle();
//STRIP001 
//STRIP001 		aVal.eHori = rHori.GetHoriOrient();
//STRIP001 		aVal.eVert = (SvxFrameVertOrient)rVert.GetVertOrient();
//STRIP001 
//STRIP001 		aVal.nHPos = rHori.GetPos();
//STRIP001 		aVal.eHRel = rHori.GetRelationOrient();
//STRIP001 		aVal.nVPos = rVert.GetPos();
//STRIP001 		aVal.eVRel = rVert.GetRelationOrient();
//STRIP001 
//STRIP001 		if (rFrmSize.GetWidthPercent() && rFrmSize.GetWidthPercent() != 0xff)
//STRIP001 			aSize.Width() = aSize.Width() * rFrmSize.GetWidthPercent() / 100;
//STRIP001 
//STRIP001 		if (rFrmSize.GetHeightPercent() && rFrmSize.GetHeightPercent() != 0xff)
//STRIP001 			aSize.Height() = aSize.Height() * rFrmSize.GetHeightPercent() / 100;
//STRIP001 
//STRIP001 		aVal.nWidth  = aSize.Width();
//STRIP001 		aVal.nHeight = aSize.Height();
//STRIP001 		aFrmSize = aSize;
//STRIP001 
//STRIP001 		aMgr.ValidateMetrics(aVal);
//STRIP001 
//STRIP001 		SwTwips nLeft;
//STRIP001 		SwTwips nRight;
//STRIP001 		SwTwips nTop;
//STRIP001 		SwTwips nBottom;
//STRIP001 
//STRIP001 		nLeft	= aVal.nHPos - aVal.nMinHPos;
//STRIP001 		nRight	= aVal.nMaxWidth - aVal.nWidth;
//STRIP001 		nTop	= aVal.nVPos - aVal.nMinVPos;
//STRIP001 		nBottom	= aVal.nMaxHeight - aVal.nHeight;
//STRIP001 
//STRIP001 		if (bHtmlMode && 0 == (nHtmlMode & HTMLMODE_FULL_ABS_POS))
//STRIP001 		{
//STRIP001 			nLeft = nRight = ( nLeft + nRight ) / 2;
//STRIP001 			nTop = nBottom = ( nTop + nBottom ) / 2;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if (aVal.eArea == FLY_IN_CNTNT)
//STRIP001 			{
//STRIP001 				nLeft = nRight;
//STRIP001 
//STRIP001 				if (aVal.nVPos < 0)
//STRIP001 				{
//STRIP001 					if (aVal.nVPos <= aVal.nMaxHeight)
//STRIP001 						nTop = aVal.nMaxVPos - aVal.nHeight;
//STRIP001 					else
//STRIP001 						nTop = nBottom = 0;	// Kein Umlauf
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nTop = aVal.nMaxVPos - aVal.nHeight - aVal.nVPos;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				nLeft += nRight;
//STRIP001 				nTop += nBottom;
//STRIP001 			}
//STRIP001 
//STRIP001 			nBottom	= nTop;
//STRIP001 			nRight = nLeft;
//STRIP001 		}
//STRIP001 
//STRIP001 		aLeftMarginED.SetMax(aLeftMarginED.Normalize(nLeft), FUNIT_TWIP);
//STRIP001 		aRightMarginED.SetMax(aRightMarginED.Normalize(nRight), FUNIT_TWIP);
//STRIP001 
//STRIP001 		aTopMarginED.SetMax(aTopMarginED.Normalize(nTop), FUNIT_TWIP);
//STRIP001 		aBottomMarginED.SetMax(aBottomMarginED.Normalize(nBottom), FUNIT_TWIP);
//STRIP001 
//STRIP001 		RangeModifyHdl(&aLeftMarginED);
//STRIP001 		RangeModifyHdl(&aTopMarginED);
//STRIP001 	}
//STRIP001 
//STRIP001 	const SwFmtSurround& rSurround = (const SwFmtSurround&)rSet.Get(RES_SURROUND);
//STRIP001 	USHORT nSur = rSurround.GetSurround();
//STRIP001 
//STRIP001 	aWrapTransparentCB.Enable( bEnable && !bHtmlMode && nSur == SURROUND_THROUGHT );
//STRIP001 	if(bHtmlMode)
//STRIP001 	{
//STRIP001 		BOOL bSomeAbsPos = 0 != (nHtmlMode & HTMLMODE_SOME_ABS_POS);
//STRIP001 		const SwFmtHoriOrient& rHori = (const SwFmtHoriOrient&)rSet.Get(RES_HORI_ORIENT);
//STRIP001 		SwHoriOrient eHOrient = rHori.GetHoriOrient();
//STRIP001 		SwRelationOrient  eHRelOrient = rHori.GetRelationOrient();
//STRIP001 		aWrapOutlineCB.Hide();
//STRIP001 		BOOL bAllHtmlModes = (nAnchorId == FLY_AT_CNTNT || nAnchorId == FLY_AUTO_CNTNT) &&
//STRIP001 							(eHOrient == HORI_RIGHT || eHOrient == HORI_LEFT);
//STRIP001 		aWrapAnchorOnlyCB.Enable( bAllHtmlModes && nSur != SURROUND_NONE );
//STRIP001 		aWrapOutsideCB.Hide();
//STRIP001 		aIdealWrapRB.Enable( FALSE );
//STRIP001 
//STRIP001 
//STRIP001 		aWrapTransparentCB.Enable( FALSE );
//STRIP001 		aNoWrapRB.Enable( FLY_AT_CNTNT == nAnchorId );
//STRIP001 		aWrapParallelRB.Enable( FALSE  );
//STRIP001 		aWrapLeftRB		  .Enable( FLY_AT_CNTNT == nAnchorId ||
//STRIP001 							(FLY_AUTO_CNTNT == nAnchorId && eHOrient == HORI_RIGHT && eHRelOrient == PRTAREA));
//STRIP001 		aWrapRightRB	  .Enable( FLY_AT_CNTNT == nAnchorId ||
//STRIP001 							( FLY_AUTO_CNTNT == nAnchorId && eHOrient == HORI_LEFT && eHRelOrient == PRTAREA));
//STRIP001 
//STRIP001 		aWrapThroughRB.Enable( (FLY_PAGE == nAnchorId ||
//STRIP001 								(FLY_AUTO_CNTNT == nAnchorId && eHRelOrient != PRTAREA) || FLY_AT_CNTNT == nAnchorId )
//STRIP001 									&& bSomeAbsPos &&
//STRIP001 										eHOrient != HORI_RIGHT);
//STRIP001 		if(aNoWrapRB.IsChecked() && !aNoWrapRB.IsEnabled())
//STRIP001 		{
//STRIP001 			if(aWrapThroughRB.IsEnabled())
//STRIP001 				aWrapThroughRB.Check(TRUE);
//STRIP001 			else if(aWrapLeftRB.IsEnabled())
//STRIP001 				aWrapLeftRB.Check();
//STRIP001 			else if(aWrapRightRB.IsEnabled())
//STRIP001 				aWrapRightRB.Check();
//STRIP001 
//STRIP001 		}
//STRIP001 		if(aWrapLeftRB.IsChecked() && !aWrapLeftRB.IsEnabled())
//STRIP001 		{
//STRIP001 			if(aWrapRightRB.IsEnabled())
//STRIP001 				aWrapRightRB.Check();
//STRIP001 			else if(aWrapThroughRB.IsEnabled())
//STRIP001 				aWrapThroughRB.Check();
//STRIP001 		}
//STRIP001 		if(aWrapRightRB.IsChecked() && !aWrapRightRB.IsEnabled())
//STRIP001 		{
//STRIP001 			if(aWrapLeftRB.IsEnabled())
//STRIP001 				aWrapLeftRB.Check();
//STRIP001 			else if(aWrapThroughRB.IsEnabled())
//STRIP001 				aWrapThroughRB.Check();
//STRIP001 		}
//STRIP001 		if(aWrapThroughRB.IsChecked() && !aWrapThroughRB.IsEnabled())
//STRIP001 			if(aNoWrapRB.IsEnabled())
//STRIP001 				aNoWrapRB.Check();
//STRIP001 
//STRIP001 		if(aWrapParallelRB.IsChecked() && !aWrapParallelRB.IsEnabled())
//STRIP001 			aWrapThroughRB.Check();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aNoWrapRB.Enable( bEnable );
//STRIP001 		aWrapLeftRB.Enable( bEnable );
//STRIP001 		aWrapRightRB.Enable( bEnable );
//STRIP001 		aIdealWrapRB.Enable( bEnable );
//STRIP001 		aWrapThroughRB.Enable( bEnable );
//STRIP001 		aWrapParallelRB.Enable( bEnable );
//STRIP001 		aWrapAnchorOnlyCB.Enable( (nAnchorId == FLY_AT_CNTNT || nAnchorId == FLY_AUTO_CNTNT)
//STRIP001 				&& nSur != SURROUND_NONE );
//STRIP001 	}
//STRIP001 	ContourHdl(0);
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 int SwWrapTabPage::DeactivatePage(SfxItemSet* pSet)
//STRIP001 {
//STRIP001 	if(pSet)
//STRIP001 		FillItemSet(*pSet);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:	Bereichspruefung
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwWrapTabPage, RangeModifyHdl, MetricField *, pEdit )
//STRIP001 {
//STRIP001 	if(bHtmlMode && 0 == (nHtmlMode & HTMLMODE_FULL_ABS_POS))
//STRIP001 	{
//STRIP001 		long nValue = pEdit->GetValue();
//STRIP001 		if (pEdit == &aLeftMarginED)
//STRIP001 			aRightMarginED.SetUserValue(nValue, FUNIT_NONE);
//STRIP001 		else if (pEdit == &aRightMarginED)
//STRIP001 			aLeftMarginED.SetUserValue(nValue, FUNIT_NONE);
//STRIP001 		else if (pEdit == &aTopMarginED)
//STRIP001 			aBottomMarginED.SetUserValue(nValue, FUNIT_NONE);
//STRIP001 		else if (pEdit == &aBottomMarginED)
//STRIP001 			aTopMarginED.SetUserValue(nValue, FUNIT_NONE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nValue = pEdit->GetValue();
//STRIP001 		MetricField *pOpposite;
//STRIP001 
//STRIP001 		if (pEdit == &aLeftMarginED)
//STRIP001 			pOpposite = &aRightMarginED;
//STRIP001 		else if (pEdit == &aRightMarginED)
//STRIP001 			pOpposite = &aLeftMarginED;
//STRIP001 		else if (pEdit == &aTopMarginED)
//STRIP001 			pOpposite = &aBottomMarginED;
//STRIP001 		else if (pEdit == &aBottomMarginED)
//STRIP001 			pOpposite = &aTopMarginED;
//STRIP001 
//STRIP001 		long nOpposite = pOpposite->GetValue();
//STRIP001 
//STRIP001 		if (nValue + nOpposite > Max(pEdit->GetMax(), pOpposite->GetMax()))
//STRIP001 			pOpposite->SetValue(pOpposite->GetMax() - nValue);
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwWrapTabPage, WrapTypeHdl, ImageRadioButton *, pBtn )
//STRIP001 {
//STRIP001 	BOOL bWrapThrough = (pBtn == &aWrapThroughRB);
//STRIP001 	aWrapTransparentCB.Enable( bWrapThrough && !bHtmlMode );
//STRIP001 	bWrapThrough |= ( nAnchorId == FLY_IN_CNTNT );
//STRIP001 	aWrapOutlineCB.Enable( !bWrapThrough && pBtn != &aNoWrapRB);
//STRIP001 	aWrapOutsideCB.Enable( !bWrapThrough && aWrapOutlineCB.IsChecked() );
//STRIP001 	aWrapAnchorOnlyCB.Enable( (nAnchorId == FLY_AT_CNTNT || nAnchorId == FLY_AUTO_CNTNT) &&
//STRIP001 		(pBtn != &aNoWrapRB) );
//STRIP001 
//STRIP001 	ContourHdl(0);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwWrapTabPage, ContourHdl, CheckBox *, pBtn )
//STRIP001 {
//STRIP001 	BOOL bEnable = !(aWrapOutlineCB.IsChecked() && aWrapOutlineCB.IsEnabled());
//STRIP001 
//STRIP001 	aWrapOutsideCB.Enable(!bEnable);
//STRIP001 
//STRIP001 	bEnable =  !aWrapOutlineCB.IsChecked();
//STRIP001 	if (bEnable == bContourImage) // damit es nicht immer flackert
//STRIP001 	{
//STRIP001         bContourImage = !bEnable;
//STRIP001         ApplyImageList();
//STRIP001     }
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 USHORT* SwWrapTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return aWrapPageRg;
//STRIP001 }
//STRIP001 /* -----------------------------08.05.2002 14:28------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwWrapTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 
//STRIP001     SfxTabPage::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 /* -----------------------------08.05.2002 14:28------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwWrapTabPage::ApplyImageList()
//STRIP001 {
//STRIP001     ImageList& rImgLst = GetDisplayBackground().GetColor().IsDark() ?
//STRIP001         aWrapILH : aWrapIL;
//STRIP001 
//STRIP001     aWrapThroughRB.SetImage(rImgLst.GetImage(IMG_THROUGH));
//STRIP001     BOOL bWrapOutline =  !aWrapOutlineCB.IsChecked();
//STRIP001     if(bWrapOutline)
//STRIP001     {
//STRIP001         aNoWrapRB.SetImage(rImgLst.GetImage(IMG_NONE));
//STRIP001         aWrapLeftRB.SetImage(rImgLst.GetImage(IMG_LEFT));
//STRIP001         aWrapRightRB.SetImage(rImgLst.GetImage(IMG_RIGHT));
//STRIP001         aWrapParallelRB.SetImage(rImgLst.GetImage(IMG_PARALLEL));
//STRIP001         aIdealWrapRB.SetImage(rImgLst.GetImage(IMG_IDEAL));
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         aNoWrapRB.SetImage(rImgLst.GetImage( IMG_KON_NONE ));
//STRIP001         aWrapLeftRB.SetImage(rImgLst.GetImage( IMG_KON_LEFT ));
//STRIP001         aWrapRightRB.SetImage(rImgLst.GetImage( IMG_KON_RIGHT ));
//STRIP001         aWrapParallelRB.SetImage(rImgLst.GetImage(IMG_KON_PARALLEL ));
//STRIP001         aIdealWrapRB.SetImage(rImgLst.GetImage( IMG_KON_IDEAL ));
//STRIP001     }
//STRIP001 }
}
