/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_prcntfld.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:05:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop
// auto strip #include <tools/debug.hxx>
#include "prcntfld.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

/*N*/ PercentField::PercentField( Window* pWin, const ResId& rResId ) :
/*N*/ 		MetricField	( pWin, rResId ),
/*N*/ 
/*N*/ 		eOldUnit	(FUNIT_NONE),
/*N*/ 		nOldMin		(0),
/*N*/ 		nOldMax		(0),
/*N*/ 		nLastPercent(-1L),
/*N*/         nLastValue  (-1L),
/*N*/         bLockAutoCalculation(sal_False)
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	nOldSpinSize = GetSpinSize();
//STRIP001 	nRefValue = Denormalize(MetricField::GetMax(FUNIT_TWIP));
//STRIP001 	nOldDigits = GetDecimalDigits();
//STRIP001 	SetCustomUnitText('%');
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::SetRefValue(long nValue)
//STRIP001 {
//STRIP001 	long nRealValue = GetRealValue(eOldUnit);
//STRIP001 
//STRIP001 	nRefValue = nValue;
//STRIP001 
//STRIP001     if (!bLockAutoCalculation && (GetUnit() == FUNIT_CUSTOM))
//STRIP001         SetPrcntValue(nRealValue, eOldUnit);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::ShowPercent(BOOL bPercent)
//STRIP001 {
//STRIP001 	if ((bPercent && GetUnit() == FUNIT_CUSTOM) ||
//STRIP001 		(!bPercent && GetUnit() != FUNIT_CUSTOM))
//STRIP001 		return;
//STRIP001 
//STRIP001 	long nOldValue;
//STRIP001 
//STRIP001 	if (bPercent)
//STRIP001 	{
//STRIP001 		long nAktWidth, nPercent;
//STRIP001 
//STRIP001 		nOldValue = GetValue();
//STRIP001 
//STRIP001 		eOldUnit = GetUnit();
//STRIP001 		nOldDigits = GetDecimalDigits();
//STRIP001 		nOldMin = GetMin();
//STRIP001 		nOldMax = GetMax();
//STRIP001 		nOldSpinSize = GetSpinSize();
//STRIP001 		nOldBaseValue = GetBaseValue();
//STRIP001 		SetUnit(FUNIT_CUSTOM);
//STRIP001 		SetDecimalDigits( 0 );
//STRIP001 
//STRIP001 		nAktWidth = ConvertValue(nOldMin, 0, nOldDigits, eOldUnit, FUNIT_TWIP);
//STRIP001 		// Um 0.5 Prozent aufrunden
//STRIP001 		nPercent = ((nAktWidth * 10) / nRefValue + 5) / 10;
//STRIP001 
//STRIP001 		MetricField::SetMin(Max(1L, nPercent));
//STRIP001 		MetricField::SetMax(100);
//STRIP001 		SetSpinSize(5);
//STRIP001 		MetricField::SetBaseValue(0);
//STRIP001 		if (nOldValue != nLastValue)
//STRIP001 		{
//STRIP001 			nAktWidth = ConvertValue(nOldValue, 0, nOldDigits, eOldUnit, FUNIT_TWIP);
//STRIP001 			nPercent = ((nAktWidth * 10) / nRefValue + 5) / 10;
//STRIP001             MetricFormatter::SetValue(nPercent);
//STRIP001 			nLastPercent = nPercent;
//STRIP001 			nLastValue = nOldValue;
//STRIP001 		}
//STRIP001 		else
//STRIP001             MetricFormatter::SetValue(nLastPercent);
//STRIP001 //		SetValue(100, FUNIT_CUSTOM);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nOldPercent = GetValue(FUNIT_CUSTOM);
//STRIP001 
//STRIP001 		nOldValue = Convert(GetValue(), GetUnit(), eOldUnit);
//STRIP001 
//STRIP001 		SetUnit(eOldUnit);
//STRIP001 		SetDecimalDigits(nOldDigits);
//STRIP001 		MetricField::SetMin(nOldMin);
//STRIP001 		MetricField::SetMax(nOldMax);
//STRIP001 		SetSpinSize(nOldSpinSize);
//STRIP001 		MetricField::SetBaseValue(nOldBaseValue);
//STRIP001 
//STRIP001 		if (nOldPercent != nLastPercent)
//STRIP001 		{
//STRIP001             SetPrcntValue(nOldValue, eOldUnit);
//STRIP001 			nLastPercent = nOldPercent;
//STRIP001 			nLastValue = nOldValue;
//STRIP001 		}
//STRIP001 		else
//STRIP001             SetPrcntValue(nLastValue, eOldUnit);
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/
//STRIP001 void PercentField::SetValue(long nNewValue, FieldUnit eInUnit)
//STRIP001 {
//STRIP001    MetricFormatter::SetValue(nNewValue, eInUnit);
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/
//STRIP001 void PercentField::SetPrcntValue(long nNewValue, FieldUnit eInUnit)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM || eInUnit == FUNIT_CUSTOM)
//STRIP001         MetricFormatter::SetValue(Convert(nNewValue, eInUnit, GetUnit()));
//STRIP001 
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Ausgangswert ueberschreiben, nicht spaeter restaurieren
//STRIP001 		long nPercent, nAktWidth;
//STRIP001 		if(eInUnit == FUNIT_TWIP)
//STRIP001 		{
//STRIP001 			nAktWidth = ConvertValue(nNewValue, 0, nOldDigits, FUNIT_TWIP, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			long nValue = Convert(nNewValue, eInUnit, eOldUnit);
//STRIP001 			nAktWidth = ConvertValue(nValue, 0, nOldDigits, eOldUnit, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		nPercent = ((nAktWidth * 10) / nRefValue + 5) / 10;
//STRIP001         MetricFormatter::SetValue(nPercent);
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::SetUserValue( long nNewValue, FieldUnit eInUnit )
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM || eInUnit == FUNIT_CUSTOM)
//STRIP001 		MetricField::SetUserValue(Convert(nNewValue, eInUnit, GetUnit()),FUNIT_NONE);
//STRIP001 
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Ausgangswert ueberschreiben, nicht spaeter restaurieren
//STRIP001 		long nPercent, nAktWidth;
//STRIP001 		if(eInUnit == FUNIT_TWIP)
//STRIP001 		{
//STRIP001 			nAktWidth = ConvertValue(nNewValue, 0, nOldDigits, FUNIT_TWIP, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			long nValue = Convert(nNewValue, eInUnit, eOldUnit);
//STRIP001 			nAktWidth = ConvertValue(nValue, 0, nOldDigits, eOldUnit, FUNIT_TWIP);
//STRIP001 		}
//STRIP001 		nPercent = ((nAktWidth * 10) / nRefValue + 5) / 10;
//STRIP001 		MetricField::SetUserValue(nPercent,FUNIT_NONE);
//STRIP001 	}
//STRIP001 
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::SetBaseValue(long nNewValue, FieldUnit eInUnit)
//STRIP001 {
//STRIP001 	if (GetUnit() == FUNIT_CUSTOM)
//STRIP001 		nOldBaseValue = ConvertValue(nNewValue, 0, nOldDigits, eInUnit, eOldUnit);
//STRIP001 	else
//STRIP001 		MetricField::SetBaseValue(nNewValue, eInUnit);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::GetValue( FieldUnit eOutUnit )
//STRIP001 {
//STRIP001 	return Convert(MetricField::GetValue(), GetUnit(), eOutUnit);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::SetMin(long nNewMin, FieldUnit eInUnit)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM)
//STRIP001 		MetricField::SetMin(nNewMin, eInUnit);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (eInUnit == FUNIT_NONE)
//STRIP001 			eInUnit = eOldUnit;
//STRIP001 		nOldMin = Convert(nNewMin, eInUnit, eOldUnit);
//STRIP001 
//STRIP001 		long nPercent = Convert(nNewMin, eInUnit, FUNIT_CUSTOM);
//STRIP001 		MetricField::SetMin(Max(1L, nPercent));
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 void PercentField::SetMax(long nNewMax, FieldUnit eInUnit)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM)
//STRIP001 		MetricField::SetMax(nNewMax, eInUnit);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (eInUnit == FUNIT_NONE)
//STRIP001 			eInUnit = eOldUnit;
//STRIP001 //		SetRefValue(Convert(nNewMax, eInUnit, FUNIT_TWIP));
//STRIP001 	}
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::Normalize(long nValue)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM)
//STRIP001 		nValue = MetricField::Normalize(nValue);
//STRIP001 	else
//STRIP001 		nValue = nValue * ImpPower10(nOldDigits);
//STRIP001 
//STRIP001 	return nValue;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::Denormalize(long nValue)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM)
//STRIP001 		nValue = MetricField::Denormalize(nValue);
//STRIP001 	else
//STRIP001 	{
//STRIP001 		long nFactor = ImpPower10(nOldDigits);
//STRIP001 		nValue = ((nValue+(nFactor/2)) / nFactor);
//STRIP001 	}
//STRIP001 
//STRIP001 	return nValue;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 BOOL PercentField::IsValueModified()
//STRIP001 {
//STRIP001 	if (GetUnit() == FUNIT_CUSTOM)
//STRIP001 		return TRUE;
//STRIP001 	else
//STRIP001 		return MetricField::IsValueModified();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::ImpPower10( USHORT n )
//STRIP001 {
//STRIP001 	USHORT i;
//STRIP001 	long   nValue = 1;
//STRIP001 
//STRIP001 	for ( i=0; i < n; i++ )
//STRIP001 		nValue *= 10;
//STRIP001 
//STRIP001 	return nValue;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::GetRealValue(FieldUnit eOutUnit)
//STRIP001 {
//STRIP001 	if (GetUnit() != FUNIT_CUSTOM)
//STRIP001 		return GetValue(eOutUnit);
//STRIP001 	else
//STRIP001 		return Convert(GetValue(), GetUnit(), eOutUnit);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/

//STRIP001 long PercentField::Convert(long nValue, FieldUnit eInUnit, FieldUnit eOutUnit)
//STRIP001 {
//STRIP001 	if (eInUnit == eOutUnit ||
//STRIP001 		(eInUnit == FUNIT_NONE && eOutUnit == GetUnit()) ||
//STRIP001 		(eOutUnit == FUNIT_NONE && eInUnit == GetUnit()))
//STRIP001 		return nValue;
//STRIP001 
//STRIP001 	if (eInUnit == FUNIT_CUSTOM)
//STRIP001 	{
//STRIP001 		// Umrechnen in Metrik
//STRIP001 		long nTwipValue = (nRefValue * nValue + 50) / 100;
//STRIP001 
//STRIP001 		if (eOutUnit == FUNIT_TWIP)	// Nur wandeln, wenn unbedingt notwendig
//STRIP001 			return Normalize(nTwipValue);
//STRIP001 		else
//STRIP001 			return ConvertValue(Normalize(nTwipValue), 0, nOldDigits, FUNIT_TWIP, eOutUnit);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (eOutUnit == FUNIT_CUSTOM)
//STRIP001 	{
//STRIP001 		// Umrechnen in Prozent
//STRIP001 		long nAktWidth;
//STRIP001 		nValue = Denormalize(nValue);
//STRIP001 
//STRIP001 		if (eInUnit == FUNIT_TWIP)	// Nur wandeln, wenn unbedingt notwendig
//STRIP001 			nAktWidth = nValue;
//STRIP001 		else
//STRIP001 			nAktWidth = ConvertValue(nValue, 0, nOldDigits, eInUnit, FUNIT_TWIP);
//STRIP001 		// Um 0.5 Prozent runden
//STRIP001 		return ((nAktWidth * 1000) / nRefValue + 5) / 10;
//STRIP001 	}
//STRIP001 
//STRIP001 	return ConvertValue(nValue, 0, nOldDigits, eInUnit, eOutUnit);
//STRIP001 }


}
