/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmloff_XMLChangedRegionImportContext.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:19:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLCHANGEDREGIONIMPORTCONTEXT_HXX
#include "XMLChangedRegionImportContext.hxx"
#endif

#ifndef _XMLOFF_XMLCHANGEELEMENTIMPORTCONTEXT_HXX
#include "XMLChangeElementImportContext.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include <com/sun/star/util/DateTime.hpp>
#endif

// auto strip #ifndef _COM_SUN_STAR_TEXT_XTEXTCURSOR_HPP_
// auto strip #include <com/sun/star/text/XTextCursor.hpp>
// auto strip #endif

#ifndef _XMLOFF_XMLIMP_HXX
#include "xmlimp.hxx"
#endif

#ifndef _XMLOFF_XMLNMSPE_HXX
#include "xmlnmspe.hxx"
#endif

#ifndef _XMLOFF_NMSPMAP_HXX
#include "nmspmap.hxx"
#endif

// auto strip #ifndef _XMLOFF_XMLTOKEN_HXX
// auto strip #include "xmltoken.hxx"
// auto strip #endif

#ifndef _XMLOFF_XMLUCONV_HXX
#include "xmluconv.hxx"
#endif
namespace binfilter {


using namespace ::binfilter::xmloff::token;

using ::rtl::OUString;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::text::XTextCursor;
using ::com::sun::star::util::DateTime;
using ::com::sun::star::xml::sax::XAttributeList;


	
TYPEINIT1(XMLChangedRegionImportContext, SvXMLImportContext);

XMLChangedRegionImportContext::XMLChangedRegionImportContext(
	SvXMLImport& rImport,
	sal_uInt16 nPrefix,
	const OUString& rLocalName) :
        SvXMLImportContext(rImport, nPrefix, rLocalName),
        bMergeLastPara(sal_True)
{
}

XMLChangedRegionImportContext::~XMLChangedRegionImportContext()
{
}

void XMLChangedRegionImportContext::StartElement(
	const Reference<XAttributeList> & xAttrList)
{
	// process attributes: id
	sal_Int16 nLength = xAttrList->getLength();
	for(sal_Int16 nAttr = 0; nAttr < nLength; nAttr++)
	{
		OUString sLocalName;
		sal_uInt16 nPrefix = GetImport().GetNamespaceMap().
			GetKeyByAttrName( xAttrList->getNameByIndex(nAttr), 
							  &sLocalName );

        const OUString sValue = xAttrList->getValueByIndex(nAttr);
		if ( XML_NAMESPACE_TEXT == nPrefix ) 
        {
            if( IsXMLToken( sLocalName, XML_ID ) )
            {
                sID = sValue;
            }
            else if( IsXMLToken( sLocalName, XML_MERGE_LAST_PARAGRAPH ) )
            {
                sal_Bool bTmp;
                if( SvXMLUnitConverter::convertBool(bTmp, sValue) )
                {
                    bMergeLastPara = bTmp;
                }
            }
        }
	}
}

SvXMLImportContext* XMLChangedRegionImportContext::CreateChildContext(
	sal_uInt16 nPrefix,
	const OUString& rLocalName,
	const Reference<XAttributeList> & xAttrList)
{
	SvXMLImportContext* pContext = NULL;

	if (XML_NAMESPACE_TEXT == nPrefix)
	{
		if ( IsXMLToken( rLocalName, XML_INSERTION ) || 
             IsXMLToken( rLocalName, XML_DELETION ) || 
             IsXMLToken( rLocalName, XML_FORMAT_CHANGE ) )
		{
			// create XMLChangeElementImportContext for all kinds of changes
			pContext = new XMLChangeElementImportContext(
			   GetImport(), nPrefix, rLocalName, 
			   IsXMLToken( rLocalName, XML_DELETION ),
			   *this);
		}
		// else: it may be a text element, see below
	}

	if (NULL == pContext)
	{
		pContext = SvXMLImportContext::CreateChildContext(nPrefix, rLocalName, 
														  xAttrList);

		// was it a text element? If not, use default!
		if (NULL == pContext)
		{
			pContext = SvXMLImportContext::CreateChildContext(
				nPrefix, rLocalName, xAttrList);
		}
	}

	return pContext;
}

void XMLChangedRegionImportContext::EndElement()
{
	// restore old XCursor (if necessary)
	if (xOldCursor.is())
	{
		// delete last paragraph 
		// (one extra paragraph was inserted in the beginning)
		UniReference<XMLTextImportHelper> rHelper = 
			GetImport().GetTextImport();
		rHelper->DeleteParagraph();

		GetImport().GetTextImport()->SetCursor(xOldCursor);
		xOldCursor = NULL;
	}
}

void XMLChangedRegionImportContext::SetChangeInfo(
	const OUString& rType,
	const OUString& rAuthor,
	const OUString& rComment,
	const OUString& rDate)
{
	DateTime aDateTime;
	if (SvXMLUnitConverter::convertDateTime(aDateTime, rDate))
	{
		GetImport().GetTextImport()->RedlineAdd(
			rType, sID, rAuthor, rComment, aDateTime, bMergeLastPara);
	}
}

void XMLChangedRegionImportContext::UseRedlineText()
{
	// if we haven't already installed the redline cursor, do it now
	if (! xOldCursor.is())
	{
		// get TextImportHelper and old Cursor
		UniReference<XMLTextImportHelper> rHelper(GetImport().GetTextImport());
		Reference<XTextCursor> xCursor( rHelper->GetCursor() );

		// create Redline and new Cursor 
		Reference<XTextCursor> xNewCursor = 
			rHelper->RedlineCreateText(xCursor, sID);

		if (xNewCursor.is())
		{
			// save old cursor and install new one
			xOldCursor = xCursor;
			rHelper->SetCursor( xNewCursor );
		}
		// else: leave as is
	}
}
}//end of namespace binfilter
