/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlgctrl.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:16:55 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_DLG_CTRL_HXX
#define _SVX_DLG_CTRL_HXX

// include ---------------------------------------------------------------

#ifndef _CTRLBOX_HXX //autogen
#include <svtools/ctrlbox.hxx>
#endif
#ifndef _SFXTABDLG_HXX //autogen
#include <bf_sfx2/tabdlg.hxx>
#endif

#ifndef _SVX_RECTENUM_HXX //autogen
#include <bf_svx/rectenum.hxx>
#endif
#ifndef _SV_GRAPH_HXX //autogen
#include <vcl/graph.hxx>
#endif
#ifndef _XTABLE_HXX
namespace binfilter {
class XBitmapEntry;
class XBitmapList;
class XColorEntry;
class XColorTable;
class XDash;
class XDashEntry;
class XDashList;
class XGradient;
class XGradientEntry;
class XGradientList;
class XHatch;
class XHatchEntry;
class XHatchList;
class XLineEndEntry;
class XLineEndList;
class XFillAttrSetItem;
} //end of namespace binfilter
#endif
namespace binfilter {
class XOBitmap;
class XOutputDevice;
class XOutdevItemPool;

//STRIP008 namespace com { namespace sun { namespace star { namespace awt {
//STRIP001 	struct Point;
//STRIP008 } } } };

/*************************************************************************
|*
|* Von SfxTabPage abgeleitet, um vom Control ueber virtuelle Methode
|* benachrichtigt werden zu koennen.
|*
\************************************************************************/
//STRIP001 class SvxTabPage : public SfxTabPage
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxTabPage( Window* pParent, ResId Id, const SfxItemSet& rInAttrs  ) :
//STRIP001 		SfxTabPage( pParent, Id, rInAttrs ) {}
//STRIP001 
//STRIP001 	virtual void PointChanged( Window* pWindow, RECT_POINT eRP ) = 0;
//STRIP001 };

/*************************************************************************
|*
|*	Control zur Darstellung und Auswahl der Eckpunkte (und Mittelpunkt)
|*	eines Objekts
|*
\************************************************************************/
//STRIP001 typedef UINT16 CTL_STATE;
//STRIP001 #define CS_NOHORZ	1		// no horizontal input information is used
//STRIP001 #define CS_NOVERT	2		// no vertikal input information is used

//STRIP001 class SvxRectCtlAccessibleContext;

//STRIP001 class SvxRectCtl : public Control
//STRIP001 {
//STRIP001 private:
//STRIP001 	void				InitSettings( BOOL bForeground, BOOL bBackground );
//STRIP001 	void				InitBitmap( void );
//STRIP001 	inline Bitmap*		GetBitmap( void );
//STRIP001     void                Resize_Impl();
//STRIP001 
//STRIP001 protected:
//STRIP001 	SvxRectCtlAccessibleContext*	pAccContext;
//STRIP001 	USHORT							nBorderWidth;
//STRIP001 	USHORT							nRadius;
//STRIP001 	Size							aSize;
//STRIP001 	Point							aPtLT, aPtMT, aPtRT;
//STRIP001 	Point							aPtLM, aPtMM, aPtRM;
//STRIP001 	Point							aPtLB, aPtMB, aPtRB;
//STRIP001 	Point							aPtNew;
//STRIP001 	RECT_POINT						eRP, eDefRP;
//STRIP001 	CTL_STYLE						eCS;
//STRIP001 	Bitmap*							pBitmap;
//STRIP001 	CTL_STATE						m_nState;
//STRIP001 
//STRIP001 	// #103516# Added a possibility to completely disable this control
//STRIP001 	sal_Bool						mbCompleteDisable;
//STRIP001 
//STRIP001 	RECT_POINT			GetRPFromPoint( Point ) const;
//STRIP001 	Point				GetPointFromRP( RECT_POINT ) const;
//STRIP001 	void				SetFocusRect( const Rectangle* pRect = NULL );		// pRect == NULL -> calculate rectangle in method
//STRIP001 	Point				SetActualRPWithoutInvalidate( RECT_POINT eNewRP );	// returns the last point
//STRIP001 
//STRIP001 	virtual void		GetFocus();
//STRIP001 	virtual void		LoseFocus();
//STRIP001 
//STRIP001 	Point				GetApproxLogPtFromPixPt( const Point& rRoughPixelPoint ) const;
//STRIP001 public:
//STRIP001 	SvxRectCtl( Window* pParent, const ResId& rResId, RECT_POINT eRpt = RP_MM,
//STRIP001 				USHORT nBorder = 200, USHORT nCircle = 80, CTL_STYLE eStyle = CS_RECT );
//STRIP001 	virtual ~SvxRectCtl();
//STRIP001 
//STRIP001 	virtual void 		Paint( const Rectangle& rRect );
//STRIP001 	virtual void 		MouseButtonDown( const MouseEvent& rMEvt );
//STRIP001     virtual void        KeyInput( const KeyEvent& rKeyEvt );
//STRIP001 	virtual void		StateChanged( StateChangedType nStateChange );
//STRIP001 	virtual void		DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001     virtual void        Resize();
//STRIP001 
//STRIP001 	void				Reset();
//STRIP001 	RECT_POINT			GetActualRP() const;
//STRIP001 	void				SetActualRP( RECT_POINT eNewRP );
//STRIP001 
//STRIP001 	void				SetState( CTL_STATE nState );
//STRIP001 
//STRIP001 	UINT8				GetNumOfChilds( void ) const;	// returns number of usable radio buttons
//STRIP001 
//STRIP001 	Rectangle			CalculateFocusRectangle( void ) const;
//STRIP001 	Rectangle			CalculateFocusRectangle( RECT_POINT eRectPoint ) const;
//STRIP001 
//STRIP001     virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > CreateAccessible();
//STRIP001 
//STRIP001 	RECT_POINT			GetApproxRPFromPixPt( const ::com::sun::star::awt::Point& rPixelPoint ) const;
//STRIP001 
//STRIP001 	// #103516# Added a possibility to completely disable this control
//STRIP001 	sal_Bool IsCompletelyDisabled() const { return mbCompleteDisable; }
//STRIP001 	void DoCompletelyDisable(sal_Bool bNew);
//STRIP001 };

/*************************************************************************
|*
|*	Control zur Darstellung und Auswahl des Winkels der Eckpunkte
|*	eines Objekts
|*
\************************************************************************/
//STRIP001 class SvxAngleCtl : public SvxRectCtl
//STRIP001 {
//STRIP001 private:
//STRIP001 	void	Initialize();
//STRIP001 
//STRIP001 protected:
//STRIP001 	Font	aFont;
//STRIP001 	Size	aFontSize;
//STRIP001 	BOOL	bPositive;
//STRIP001 
//STRIP001 public:
//STRIP001 			SvxAngleCtl( Window* pParent, const ResId& rResId );
//STRIP001 			SvxAngleCtl( Window* pParent, const ResId& rResId, Size aSize );
//STRIP001 
//STRIP001 	void	ChangeMetric()
//STRIP001 				{ bPositive = !bPositive; }
//STRIP001 	virtual void Paint( const Rectangle& rRect );
//STRIP001 };

/*************************************************************************
|*
|*	Preview-Control zur Darstellung von Bitmaps
|*
\************************************************************************/

//STRIP001 class SvxBitmapCtl
//STRIP001 {
//STRIP001 protected:
//STRIP001 	Size			aSize;
//STRIP001 	USHORT			nLines;
//STRIP001 	Color			aPixelColor, aBackgroundColor;
//STRIP001 	const USHORT*	pBmpArray;
//STRIP001 
//STRIP001 public:
//STRIP001 			SvxBitmapCtl( Window* pParent, const Size& rSize );
//STRIP001 			~SvxBitmapCtl();
//STRIP001 
//STRIP001 	XOBitmap	GetXBitmap();
//STRIP001 
//STRIP001 	void	SetBmpArray( const USHORT* pPixel ) { pBmpArray = pPixel; }
//STRIP001 	void	SetLines( USHORT nLns ) { nLines = nLns; }
//STRIP001 	void	SetPixelColor( Color aColor ) { aPixelColor = aColor; }
//STRIP001 	void	SetBackgroundColor( Color aColor ) { aBackgroundColor = aColor; }
//STRIP001 };

/*************************************************************************
|*
|*	Control zum Editieren von Bitmaps
|*
\************************************************************************/
//STRIP001 class SvxPixelCtl : public Control
//STRIP001 {
//STRIP001 protected:
//STRIP001 	USHORT		nLines, nSquares;
//STRIP001 	Color		aPixelColor;
//STRIP001 	Color		aBackgroundColor;
//STRIP001 	Color		aLineColor;
//STRIP001 	Size		aRectSize;
//STRIP001 	USHORT* 	pPixel;
//STRIP001 	BOOL		bPaintable;
//STRIP001 
//STRIP001 	void	ChangePixel( USHORT nPixel );
//STRIP001 
//STRIP001 public:
//STRIP001 			SvxPixelCtl( Window* pParent, const ResId& rResId,
//STRIP001 						USHORT nNumber = 8 );
//STRIP001 			~SvxPixelCtl();
//STRIP001 
//STRIP001 	virtual void Paint( const Rectangle& rRect );
//STRIP001 	virtual void MouseButtonDown( const MouseEvent& rMEvt );
//STRIP001 
//STRIP001 	void	SetXBitmap( const XOBitmap& rXOBitmap );
//STRIP001 
//STRIP001 	void	SetPixelColor( const Color& rCol ) { aPixelColor = rCol; }
//STRIP001 	void	SetBackgroundColor( const Color& rCol ) { aBackgroundColor = rCol; }
//STRIP001 	void	SetLineColor( const Color& rCol ) { aLineColor = rCol; }
//STRIP001 
//STRIP001 	USHORT	GetLineCount() const { return nLines; }
//STRIP001 	Color	GetPixelColor() const { return aPixelColor; }
//STRIP001 	Color	GetBackgroundColor() const { return aBackgroundColor; }
//STRIP001 
//STRIP001 	USHORT	GetPixel( const USHORT nPixelNumber );
//STRIP001 	USHORT* GetPixelPtr() { return pPixel; }
//STRIP001 
//STRIP001 	void	SetPaintable( BOOL bTmp ) { bPaintable = bTmp; }
//STRIP001 	void	Reset();
//STRIP001 };

/*************************************************************************
|*
|* ColorLB kann mit Farben und Namen gefuellt werden
|*
\************************************************************************/
//STRIP001 class ColorLB : public ColorListBox
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 		 ColorLB( Window* pParent, ResId Id ) : ColorListBox( pParent, Id ) {}
//STRIP001 		 ColorLB( Window* pParent, WinBits aWB ) : ColorListBox( pParent, aWB ) {}
//STRIP001 
//STRIP001 	virtual void Fill( const XColorTable* pTab );
//STRIP001 
//STRIP001 	void Append( XColorEntry* pEntry, Bitmap* pBmp = NULL );
//STRIP001 	void Modify( XColorEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
//STRIP001 };

/*************************************************************************
|*
|* HatchingLB
|*
\************************************************************************/
//STRIP001 class HatchingLB : public ListBox
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 		 HatchingLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );
//STRIP001 		 HatchingLB( Window* pParent, WinBits aWB, BOOL bUserDraw = TRUE );
//STRIP001 
//STRIP001 	virtual void Fill( const XHatchList* pList );
//STRIP001 	virtual void UserDraw( const UserDrawEvent& rUDEvt );
//STRIP001 
//STRIP001 	void	Append( XHatchEntry* pEntry, Bitmap* pBmp = NULL );
//STRIP001 	void	Modify( XHatchEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
//STRIP001 	void	SelectEntryByList( const XHatchList* pList, const String& rStr,
//STRIP001 						const XHatch& rXHatch, USHORT nDist = 0 );
//STRIP001 
//STRIP001 private:
//STRIP001 	XHatchList*		mpList;
//STRIP001 	BOOL			mbUserDraw;
//STRIP001 };

/*************************************************************************
|*
|* GradientLB
|*
\************************************************************************/
//STRIP001 class GradientLB : public ListBox
//STRIP001 {
//STRIP001 public:
//STRIP001 	GradientLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );
//STRIP001 	GradientLB( Window* pParent, WinBits aWB, BOOL bUserDraw = TRUE );
//STRIP001 
//STRIP001 	virtual void Fill( const XGradientList* pList );
//STRIP001 	virtual void UserDraw( const UserDrawEvent& rUDEvt );
//STRIP001 
//STRIP001 	void	Append( XGradientEntry* pEntry, Bitmap* pBmp = NULL );
//STRIP001 	void	Modify( XGradientEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
//STRIP001 	void	SelectEntryByList( const XGradientList* pList, const String& rStr,
//STRIP001 						const XGradient& rXGradient, USHORT nDist = 0 );
//STRIP001 
//STRIP001 private:
//STRIP001 	XGradientList* mpList;
//STRIP001 	BOOL			mbUserDraw;
//STRIP001 };

/*************************************************************************
|*
|* BitmapLB
|*
\************************************************************************/
//STRIP001 class BitmapLB : public ListBox
//STRIP001 {
//STRIP001 public:
//STRIP001 		 BitmapLB( Window* pParent, ResId Id, BOOL bUserDraw = TRUE );
//STRIP001 
//STRIP001 	virtual void Fill( const XBitmapList* pList );
//STRIP001 	virtual void UserDraw( const UserDrawEvent& rUDEvt );
//STRIP001 
//STRIP001 	void	Append( XBitmapEntry* pEntry, Bitmap* pBmp = NULL );
//STRIP001 	void	Modify( XBitmapEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
//STRIP001 	void	SelectEntryByList( const XBitmapList* pList, const String& rStr,
//STRIP001 						const Bitmap& rBmp);
//STRIP001 
//STRIP001 private:
//STRIP001 	VirtualDevice	aVD;
//STRIP001 	Bitmap			aBitmap;
//STRIP001 
//STRIP001 	XBitmapList*	mpList;
//STRIP001 	BOOL			mbUserDraw;
//STRIP001 
//STRIP001 	void SetVirtualDevice();
//STRIP001 };

/*************************************************************************
|*
|* FillAttrLB vereint alle Fuellattribute in einer ListBox
|*
\************************************************************************/
//STRIP001 class FillAttrLB : public ColorListBox
//STRIP001 {
//STRIP001 private:
//STRIP001 	VirtualDevice	aVD;
//STRIP001 	Bitmap			aBitmap;
//STRIP001 
//STRIP001 	void SetVirtualDevice();
//STRIP001 
//STRIP001 public:
//STRIP001 		 FillAttrLB( Window* pParent, ResId Id );
//STRIP001 		 FillAttrLB( Window* pParent, WinBits aWB );
//STRIP001 
//STRIP001 	virtual void Fill( const XColorTable* pTab );
//STRIP001 	virtual void Fill( const XHatchList* pList );
//STRIP001 	virtual void Fill( const XGradientList* pList );
//STRIP001 	virtual void Fill( const XBitmapList* pList );
//STRIP001 
//STRIP001 	void	SelectEntryByList( const XBitmapList* pList, const String& rStr,
//STRIP001 						const Bitmap& rBmp);
//STRIP001 };

/*************************************************************************
|*
|* FillTypeLB
|*
\************************************************************************/
//STRIP001 class FillTypeLB : public ListBox
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 		 FillTypeLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
//STRIP001 		 FillTypeLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}
//STRIP001 
//STRIP001 	virtual void Fill();
//STRIP001 };

/*************************************************************************
|*
|* LineLB
|*
\************************************************************************/
//STRIP001 class LineLB : public ListBox
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 		 LineLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
//STRIP001 		 LineLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}
//STRIP001 
//STRIP001 	virtual void Fill( const XDashList* pList );
//STRIP001 
//STRIP001 	void Append( XDashEntry* pEntry, Bitmap* pBmp = NULL );
//STRIP001 	void Modify( XDashEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL );
//STRIP001 	void SelectEntryByList( const XDashList* pList, const String& rStr,
//STRIP001 							const XDash& rDash, USHORT nDist = 0 );
//STRIP001 };

/*************************************************************************
|*
|* LineEndsLB
|*
\************************************************************************/
//STRIP001 class LineEndLB : public ListBox
//STRIP001 {
//STRIP001 
//STRIP001 public:
//STRIP001 		 LineEndLB( Window* pParent, ResId Id ) : ListBox( pParent, Id ) {}
//STRIP001 		 LineEndLB( Window* pParent, WinBits aWB ) : ListBox( pParent, aWB ) {}
//STRIP001 
//STRIP001 	virtual void Fill( const XLineEndList* pList, BOOL bStart = TRUE );
//STRIP001 
//STRIP001 	void	Append( XLineEndEntry* pEntry, Bitmap* pBmp = NULL,
//STRIP001 					BOOL bStart = TRUE );
//STRIP001 	void	Modify( XLineEndEntry* pEntry, USHORT nPos, Bitmap* pBmp = NULL,
//STRIP001 					BOOL bStart = TRUE );
//STRIP001 };

/*************************************************************************
|*
|* SvxLinePreview
|*
\************************************************************************/
//STRIP001 class SvxXLinePreview : public Control
//STRIP001 {
//STRIP001 private:
//STRIP001 	Point			aPtA, aPtB;
//STRIP001 	XOutputDevice*	pXOutDev;
//STRIP001 
//STRIP001 	//#58425# Symbole auf einer Linie (z.B. StarChart)
//STRIP001 	Graphic *pGraphic;
//STRIP001 	BOOL bWithSymbol;
//STRIP001 	Size aSymbolSize;
//STRIP001 
//STRIP001 	void			InitSettings( BOOL bForeground, BOOL bBackground );
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxXLinePreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut );
//STRIP001 
//STRIP001 	void 			ShowSymbol( BOOL b ) { bWithSymbol = b; };
//STRIP001 	void			SetSymbol( Graphic* p, const Size& s );
//STRIP001 	void			ResizeSymbol( const Size& s );
//STRIP001 
//STRIP001 
//STRIP001 	virtual void	Paint( const Rectangle& rRect );
//STRIP001 	virtual void	StateChanged( StateChangedType nStateChange );
//STRIP001 	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 };

/*************************************************************************
|*
|* SvxXRectPreview
|*
\************************************************************************/
//STRIP001 class SvxXRectPreview : public Control
//STRIP001 {
//STRIP001 private:
//STRIP001 	Rectangle		aRect;
//STRIP001 	XOutputDevice*	pXOutDev;
//STRIP001 
//STRIP001 	void			InitSettings( BOOL bForeground, BOOL bBackground );
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxXRectPreview( Window* pParent, const ResId& rResId, XOutputDevice* pXOut );
//STRIP001 
//STRIP001 	virtual void	Paint( const Rectangle& rRect );
//STRIP001 	virtual void	StateChanged( StateChangedType nStateChange );
//STRIP001 	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 };

/*************************************************************************
|*
|* SvxXShadowPreview
|*
\************************************************************************/
//STRIP001 class SvxXShadowPreview : public Control
//STRIP001 {
//STRIP001 private:
//STRIP001 	XOutputDevice*		pXOutDev;
//STRIP001 	XOutdevItemPool*	pXPool;
//STRIP001 	Rectangle			aRect;
//STRIP001 	Rectangle			aShadow;
//STRIP001 	XFillAttrSetItem*	pRectItem;
//STRIP001 	XFillAttrSetItem*	pShadowItem;
//STRIP001 	Point				aShadowPos;
//STRIP001 
//STRIP001 	void				InitSettings( BOOL bForeground, BOOL bBackground );
//STRIP001 
//STRIP001 public:
//STRIP001 	SvxXShadowPreview( Window* pParent, const ResId& rResId,
//STRIP001 					   XOutputDevice* pXOut, XOutdevItemPool* pXInPool );
//STRIP001 	~SvxXShadowPreview();
//STRIP001 
//STRIP001 	void			SetRect( const Rectangle& rRect ) { aRect = rRect; }
//STRIP001 	void			SetRectAttr( XFillAttrSetItem* pSetItem );
//STRIP001 	void			SetShadow( const Rectangle& rShadow ) { aShadow = rShadow; }
//STRIP001 	void			SetShadowAttr( XFillAttrSetItem* pSetItem );
//STRIP001 	void			SetShadowPos( Point aPos ) { aShadowPos = aPos; }
//STRIP001 
//STRIP001 	virtual void	Paint( const Rectangle& rRect );
//STRIP001 	virtual void	StateChanged( StateChangedType nStateChange );
//STRIP001 	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
//STRIP001 };

}//end of namespace binfilter
#endif // _SVX_DLG_CTRL_HXX

