/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pptimport.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2008/01/17 08:05:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef OOX_POWERPOINT_POWERPOINTIMPORT_HXX
#define OOX_POWERPOINT_POWERPOINTIMPORT_HXX

#include "oox/core/xmlfilterbase.hxx"

#include <com/sun/star/animations/XAnimationNode.hpp>
#include <oox/drawingml/theme.hxx>
#include "oox/ppt/presentationfragmenthandler.hxx"
#include "oox/ppt/slidepersist.hxx"
#include "tokens.hxx"
#include <vector>
#include <map>

namespace oox { namespace ppt {

// ---------------------------------------------------------------------

class PowerPointImport : public oox::core::XmlFilterBase
{
public:

	PowerPointImport( const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory > & rSMgr  );
	virtual ~PowerPointImport();

    // from FilterBase
    virtual bool importDocument() throw();
    virtual bool exportDocument() throw();

    virtual sal_Int32 getSchemeClr( sal_Int32 nColorSchemeToken ) const;

	virtual const oox::vml::DrawingPtr getDrawings();

	void													setActualSlidePersist( SlidePersistPtr pActualSlidePersist ){ mpActualSlidePersist = pActualSlidePersist; };
	std::map< rtl::OUString, oox::drawingml::ThemePtr >&	getThemes(){ return maThemes; };
	std::vector< SlidePersistPtr >&							getDrawPages(){ return maDrawPages; };
	std::vector< SlidePersistPtr >&							getMasterPages(){ return maMasterPages; };
	std::vector< SlidePersistPtr >&							getNotesPages(){ return maNotesPages; };

private:
    virtual ::rtl::OUString implGetImplementationName() const;

private:
	SlidePersistPtr										mpActualSlidePersist;
	std::map< rtl::OUString, oox::drawingml::ThemePtr > maThemes;

	std::vector< SlidePersistPtr > maDrawPages;
	std::vector< SlidePersistPtr > maMasterPages;
	std::vector< SlidePersistPtr > maNotesPages;
};

} }

#endif // OOX_POWERPOINT_POWERPOINTIMPORT_HXX
