/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: chartobjecttable.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/12 12:03:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/chartobjecttable.hxx"
#include "oox/helper/containerhelper.hxx"

using ::rtl::OUString;
using ::com::sun::star::uno::Any;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::Exception;
using ::com::sun::star::uno::UNO_QUERY;
using ::com::sun::star::uno::UNO_QUERY_THROW;
using ::com::sun::star::chart2::XChartDocument;

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

ChartObjectTable::ChartObjectTable( const Reference< XChartDocument >& rxDoc,
        const OUString& rServiceName, const OUString& rObjNameBase ) :
    mxFactory( rxDoc, UNO_QUERY ),
    maServiceName( rServiceName ),
    maObjNameBase( rObjNameBase ),
    mnIndex( 0 )
{
    OSL_ENSURE( mxFactory.is(), "ChartObjectTable::ChartObjectTable - missing service factory" );
}

Any ChartObjectTable::getObject( const OUString& rObjName )
{
    createContainer();
    if( mxContainer.is() ) try
    {
        return mxContainer->getByName( rObjName );
    }
    catch( Exception& )
    {
        OSL_ENSURE( false, "ChartObjectTable::getObject - object not found" );
    }
    return Any();
}

OUString ChartObjectTable::insertObject( const Any& rObj )
{
    createContainer();
    if( mxContainer.is() )
        return ContainerHelper::insertByUnusedName( mxContainer, rObj, maObjNameBase + OUString::valueOf( ++mnIndex ), ' ' );
    return OUString();
}

void ChartObjectTable::createContainer()
{
    if( !mxContainer.is() && mxFactory.is() ) try
    {
        mxContainer.set( mxFactory->createInstance( maServiceName ), UNO_QUERY_THROW );
    }
    catch( Exception& )
    {
    }
    OSL_ENSURE( mxContainer.is(), "ChartObjectTable::createContainer - container not found" );
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

