/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: charttypeinfo.cxx,v $
 *
 *  $Revision: 1.1.2.5 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/15 15:41:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/charttypeinfo.hxx"
#include "oox/helper/helper.hxx"

using ::rtl::OUString;

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

namespace {

// chart type service names
const sal_Char SERVICE_CHART2_AREA[]    = "com.sun.star.chart2.AreaChartType";
const sal_Char SERVICE_CHART2_CANDLE[]  = "com.sun.star.chart2.CandleStickChartType";
const sal_Char SERVICE_CHART2_COLUMN[]  = "com.sun.star.chart2.ColumnChartType";
const sal_Char SERVICE_CHART2_LINE[]    = "com.sun.star.chart2.LineChartType";
const sal_Char SERVICE_CHART2_NET[]     = "com.sun.star.chart2.NetChartType";
const sal_Char SERVICE_CHART2_PIE[]     = "com.sun.star.chart2.PieChartType";
const sal_Char SERVICE_CHART2_SCATTER[] = "com.sun.star.chart2.ScatterChartType";
const sal_Char SERVICE_CHART2_SURFACE[] = "com.sun.star.chart2.ColumnChartType";    // Todo

static const ChartTypeInfo spTypeInfos[] =
{
    // type-id          type-category         service                 varied-point-color   combi  supp3d 3dwall polar  area2d area3d 1stvis xcateg swap   stack  revers betw
    { TYPEID_BAR,       TYPECATEGORY_BAR,     SERVICE_CHART2_COLUMN,  VARPOINTMODE_SINGLE, true,  true,  true,  false, true,  true,  false, true,  false, true,  false, true  },
    { TYPEID_HORBAR,    TYPECATEGORY_BAR,     SERVICE_CHART2_COLUMN,  VARPOINTMODE_SINGLE, false, true,  true,  false, true,  true,  false, true,  true,  true,  false, true  },
    { TYPEID_LINE,      TYPECATEGORY_LINE,    SERVICE_CHART2_LINE,    VARPOINTMODE_SINGLE, true,  true,  true,  false, false, true,  false, true,  false, true,  false, true  },
    { TYPEID_AREA,      TYPECATEGORY_LINE,    SERVICE_CHART2_AREA,    VARPOINTMODE_NONE,   true,  true,  true,  false, true,  true,  false, true,  false, true,  true,  false },
    { TYPEID_STOCK,     TYPECATEGORY_LINE,    SERVICE_CHART2_CANDLE,  VARPOINTMODE_NONE,   true,  false, false, false, false, false, false, true,  false, true,  false, true  },
    { TYPEID_RADARLINE, TYPECATEGORY_RADAR,   SERVICE_CHART2_NET,     VARPOINTMODE_SINGLE, false, false, false, true,  false, true,  false, true,  false, false, false, false },
    { TYPEID_RADARAREA, TYPECATEGORY_RADAR,   SERVICE_CHART2_NET,     VARPOINTMODE_NONE,   false, false, false, true,  true,  true,  false, true,  false, false, false, false },
    { TYPEID_PIE,       TYPECATEGORY_PIE,     SERVICE_CHART2_PIE,     VARPOINTMODE_MULTI,  false, true,  false, true,  true,  true,  true,  true,  false, false, false, false },
    { TYPEID_DOUGHNUT,  TYPECATEGORY_PIE,     SERVICE_CHART2_PIE,     VARPOINTMODE_MULTI,  false, true,  false, true,  true,  true,  false, true,  false, false, true,  false },
    { TYPEID_OFPIE,     TYPECATEGORY_PIE,     SERVICE_CHART2_PIE,     VARPOINTMODE_MULTI,  false, true,  false, true,  true,  true,  true,  true,  false, false, false, false },
    { TYPEID_SCATTER,   TYPECATEGORY_SCATTER, SERVICE_CHART2_SCATTER, VARPOINTMODE_SINGLE, true,  true,  false, false, false, true,  false, false, false, false, false, false },
    { TYPEID_BUBBLE,    TYPECATEGORY_SCATTER, SERVICE_CHART2_SCATTER, VARPOINTMODE_SINGLE, false, true,  false, false, true,  true,  false, false, false, false, false, false },
    { TYPEID_SURFACE,   TYPECATEGORY_SURFACE, SERVICE_CHART2_SURFACE, VARPOINTMODE_NONE,   false, true,  true,  false, true,  true,  false, true,  false, false, false, false },
    { TYPEID_UNKNOWN,   TYPECATEGORY_BAR,     SERVICE_CHART2_COLUMN,  VARPOINTMODE_SINGLE, true,  true,  true,  false, true,  true,  false, true,  false, true,  false, true  }
};

} // namespace

// ============================================================================

ChartTypeInfoProvider::ChartTypeInfoProvider()
{
    const ChartTypeInfo* pEnd = STATIC_ARRAY_END( spTypeInfos );
    for( const ChartTypeInfo* pIt = spTypeInfos; pIt != pEnd; ++pIt )
        maInfoMap[ pIt->meTypeId ] = pIt;
}

const ChartTypeInfo& ChartTypeInfoProvider::getTypeInfo( ChartTypeId eTypeId ) const
{
    TypeInfoMap::const_iterator aIt = maInfoMap.find( eTypeId );
    OSL_ENSURE( aIt != maInfoMap.end(), "ChartTypeInfoProvider::getTypeInfo - unknown chart type" );
    return (aIt == maInfoMap.end()) ? *maInfoMap.rbegin()->second : *aIt->second;
}

const ChartTypeInfo& ChartTypeInfoProvider::getTypeInfoFromService( const OUString& rServiceName ) const
{
    for( TypeInfoMap::const_iterator aIt = maInfoMap.begin(), aEnd = maInfoMap.end(); aIt != aEnd; ++aIt )
        if( rServiceName.equalsAscii( aIt->second->mpcServiceName ) )
            return *aIt->second;
    OSL_ENSURE( false, "ChartTypeInfoProvider::getTypeInfoFromService - unknown service name" );
    return getTypeInfo( TYPEID_UNKNOWN );
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

