/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: layoutcontext.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: dr $ $Date: 2008/02/18 14:40:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "oox/drawingml/chart/layoutcontext.hxx"
#include "oox/drawingml/chart/layoutmodel.hxx"

using ::oox::core::ContextHandler2Helper;
using ::oox::core::ContextWrapper;

namespace oox {
namespace drawingml {
namespace chart {

// ============================================================================

LayoutContext::LayoutContext( ContextHandler2Helper& rParent, LayoutModel& rModel ) :
    ChartContextBase< LayoutModel >( rParent, rModel )
{
}

LayoutContext::~LayoutContext()
{
}

// oox.core.ContextHandler2Helper interface -----------------------------------

ContextWrapper LayoutContext::onCreateContext( sal_Int32 nElement, const AttributeList& rAttribs )
{
    switch( getCurrentElement() )
    {
        case C_TOKEN( layout ):
            return  (nElement == C_TOKEN( manualLayout ));

        case C_TOKEN( manualLayout ):
            switch( nElement )
            {
                case C_TOKEN( x ):
                    getModel().getData().mfX = rAttribs.getDouble( XML_val, 0.0 );
                    return false;
                case C_TOKEN( y ):
                    getModel().getData().mfY = rAttribs.getDouble( XML_val, 0.0 );
                    return false;
                case C_TOKEN( w ):
                    getModel().getData().mfW = rAttribs.getDouble( XML_val, 0.0 );
                    return false;
                case C_TOKEN( h ):
                    getModel().getData().mfH = rAttribs.getDouble( XML_val, 0.0 );
                    return false;
                case C_TOKEN( xMode ):
                    getModel().getData().mnXMode = rAttribs.getToken( XML_val, XML_factor );
                    return false;
                case C_TOKEN( yMode ):
                    getModel().getData().mnYMode = rAttribs.getToken( XML_val, XML_factor );
                    return false;
                case C_TOKEN( wMode ):
                    getModel().getData().mnWMode = rAttribs.getToken( XML_val, XML_factor );
                    return false;
                case C_TOKEN( hMode ):
                    getModel().getData().mnHMode = rAttribs.getToken( XML_val, XML_factor );
                    return false;
                case C_TOKEN( layoutTarget ):
                    getModel().getData().mnTarget = rAttribs.getToken( XML_val, XML_outer );
                    return false;
            }
        break;
    }
    return false;
}

// ============================================================================

} // namespace chart
} // namespace drawingml
} // namespace oox

