Summary: Open Motif 2.1.30 - Development libraries and header files
Name: openmotif-devel
Version: 2.1.30
Release: 4_MLI
Copyright: Open Group Public License
Group: Development/Libraries
Vendor: Metro Link Incorporated
Buildroot: /Golden40/Build/pkgopenmotifroot
URL: http://www.metrolink.com/openmotif
Requires: openmotif

%description
This is the Open Motif 2.1.30 development environment.  It includes the Motif
header files and static libraries, plus the Motif UIL (User Interface Language)
compiler and the man pages for the Motif widgets and library functions.

%install

%post
ln -sf ../X11R6/include/Mrm /usr/include
ln -sf ../X11R6/include/Xm /usr/include
ln -sf ../X11R6/include/uil /usr/include

# Replace Motif.tmpl and Motif.rules with our versions
MOTIFTMPL="/usr/X11R6/lib/X11/config/Motif.tmpl"
[ -f $MOTIFTMPL ] && mv -f $MOTIFTMPL $MOTIFTMPL.orig
ln -f $MOTIFTMPL.openmotif $MOTIFTMPL

MOTIFRULES="/usr/X11R6/lib/X11/config/Motif.rules"
[ -f $MOTIFRULES ] && mv -f $MOTIFRULES $MOTIFRULES.orig
ln -f $MOTIFRULES.openmotif $MOTIFRULES

# Set TopLevelProject to Motif in site.def.
SITEDEF="/usr/X11R6/lib/X11/config/site.def"
grep "^\#define TopLevelProject Motif" $SITEDEF > /dev/null 2>&1
if [ $? -ne 0 ]; then
	[ ! -f $SITEDEF.orig ] && mv -f $SITEDEF $SITEDEF.orig
	sed -e '/^\#ifdef BeforeVendorCF$/a\
\
\#define TopLevelProject Motif\
' < $SITEDEF.orig > $SITEDEF
fi
exit 0

%postun
if [ "$1" = 0 ]; then
    rm -f /usr/include/Mrm /usr/include/Xm /usr/include/uil

    # Restore original versions of Motif.tmpl, Motif.rules, and site.def
    MOTIFTMPL="/usr/X11R6/lib/X11/config/Motif.tmpl"
    rm -f $MOTIFTMPL
    [ -f $MOTIFTMPL.orig ] && mv -f $MOTIFTMPL.orig $MOTIFTMPL

    MOTIFRULES="/usr/X11R6/lib/X11/config/Motif.rules"
    rm -f $MOTIFRULES
    [ -f $MOTIFRULES.orig ] && mv -f $MOTIFRULES.orig $MOTIFRULES

    SITEDEF="/usr/X11R6/lib/X11/config/site.def"
    [ -f $SITEDEF.orig ] && mv -f $SITEDEF.orig $SITEDEF
fi

exit 0

%clean

%files
%dir %attr( 0755 bin bin ) /usr/X11R6/include/Mrm
%dir %attr( 0755 bin bin ) /usr/X11R6/include/uil
%dir %attr( 0755 bin bin ) /usr/X11R6/include/Xm
%dir %attr( 0755 bin bin ) /usr/X11R6/man/man7
%attr( 0755 bin bin ) /usr/X11R6/bin/uil
%attr( 0444 bin bin ) /usr/X11R6/include/Mrm/MrmAppl.h
%attr( 0444 bin bin ) /usr/X11R6/include/Mrm/MrmDecls.h
%attr( 0444 bin bin ) /usr/X11R6/include/Mrm/MrmosI.h
%attr( 0444 bin bin ) /usr/X11R6/include/Mrm/MrmPublic.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/UilDBDef.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/UilDef.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/Uil.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/UilSymDef.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/UilSymGl.h
%attr( 0444 bin bin ) /usr/X11R6/include/uil/XmAppl.uil
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/AccColorT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/AccTextT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ActivatableT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ArrowBG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ArrowBGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ArrowB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ArrowBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/AtomMgr.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/BaseClassP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/BulletinB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/BulletinBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CacheP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CareVisualT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CascadeBG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CascadeBGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CascadeB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CascadeBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ClipWindowP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ColorObjP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ColorP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ComboBox.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ComboBoxP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Command.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CommandP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Container.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ContainerP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ContainerT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ContItemT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/CutPaste.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DesktopP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DialogSavvyT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DialogSEP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DialogS.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DialogSP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Display.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DisplayP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragC.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragCP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragDrop.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragIcon.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragIconP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragOverS.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DragOverSP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DrawingA.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DrawingAP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DrawnB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DrawnBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DrawP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DropSMgr.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DropSMgrP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DropTrans.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/DropTransP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ExtObjectP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/FileSB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/FileSBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Form.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/FormP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Frame.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/FrameP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Gadget.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/GadgetP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/GrabShell.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/GrabShellP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconFile.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconFileP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconH.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/IconHP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/JoinSideT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/LabelG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/LabelGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Label.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/LabelP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/LayoutT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/List.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ListP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MainW.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MainWP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Manager.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ManagerP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuProcP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuShell.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuShellP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuStateP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MenuUtilP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MessageB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MessageBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/MwmUtil.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/NavigatorT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Notebook.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/NotebookP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PanedW.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PanedWP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PointInT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Primitive.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PrimitiveP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Print.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PrintSP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Protocols.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ProtocolsP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PushBG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PushBGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PushB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/PushBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/RCLayoutP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/RCMenuP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/RepType.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/RowColumn.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/RowColumnP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SashP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Scale.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScaleP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Screen.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScreenP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScrollBar.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScrollBarP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScrolledW.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScrolledWP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ScrollFrameT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SelectioB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SelectioBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SeparatoG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SeparatoGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Separator.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SeparatorP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ShellEP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SpecRenderT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SpinB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SpinBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SSpinB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/SSpinBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TakesDefT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TearOffBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TearOffP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextF.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextFP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextFSelP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Text.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextInP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextOutP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextSelP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TextStrSoP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ToggleBG.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ToggleBGP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ToggleB.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/ToggleBP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TraitP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Transfer.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TransferP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TransferT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TransltnsP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TravConT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/TxtPropCv.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/UnhighlightT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/UnitTypeT.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VaSimpleP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VendorSEP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VendorS.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VendorSP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VirtKeys.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/VirtKeysP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XmAll.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Xmfuncs.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/Xm.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XmIm.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XmosP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XmP.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XmStrDefs.h
%attr( 0444 bin bin ) /usr/X11R6/include/Xm/XpmP.h
%attr( 0644 bin bin ) /usr/X11R6/lib/libMrm.a
%attr( 0644 bin bin ) /usr/X11R6/lib/libUil.a
%attr( 0644 bin bin ) /usr/X11R6/lib/libXm.a
%attr( 0444 bin bin ) /usr/X11R6/lib/X11/config/Motif.rules.openmotif
%attr( 0444 bin bin ) /usr/X11R6/lib/X11/config/Motif.tmpl.openmotif
%attr( 0444 bin bin ) /usr/X11R6/man/man1/uil.1x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/ApplicationShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Composite.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Constraint.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Core.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmCloseHierarchy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchBitmapLiteral.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchColorLiteral.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchIconLiteral.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchLiteral.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchSetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchWidget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmFetchWidgetOverride.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmInitialize.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmOpenHierarchy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmOpenHierarchyFromBuffer.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmOpenHierarchyPerDisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmRegisterClass.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmRegisterNames.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/MrmRegisterNamesInHierarchy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Object.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/OverrideShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/RectObj.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Shell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/TopLevelShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/TransientShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/Uil.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/UilDumpSymbolTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/VendorShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/VirtualBindings.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/WMShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmActivateProtocol.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmActivateWMProtocol.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddProtocolCallback.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddProtocols.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddTabGroup.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddToPostFromList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddWMProtocolCallback.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmAddWMProtocols.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmArrowButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmArrowButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmBulletinBoard.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCascadeButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCascadeButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCascadeButtonGadgetHighlight.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCascadeButtonHighlight.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmChangeColor.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardCancelCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardCopyByName.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardEndCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardEndRetrieve.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardInquireCount.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardInquireFormat.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardInquireLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardInquirePendingItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardLock.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardRegisterFormat.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardRetrieve.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardStartCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardStartRetrieve.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardUndoCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardUnlock.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmClipboardWithdrawFormat.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBoxAddItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBoxDeletePos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBoxSelectItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBoxSetItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmComboBoxUpdate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCommand.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCommandAppendValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCommandError.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCommandGetChild.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCommandSetValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainer.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerCopyLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerCut.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerGetItemChildren.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerPaste.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerPasteLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerRelayout.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmContainerReorder.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmConvertStringToUnits.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmConvertUnits.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateArrowButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateArrowButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateBulletinBoard.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateBulletinBoardDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateCascadeButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateCascadeButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateComboBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateCommand.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateCommandDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateContainer.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDialogShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDragIcon.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDrawingArea.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDrawnButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDropDownComboBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateDropDownList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateErrorDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateFileSelectionBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateFileSelectionDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateForm.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateFormDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateFrame.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateIconGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateInformationDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateLabel.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateLabelGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateMainWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateMenuBar.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateMenuShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateMessageBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateMessageDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateNotebook.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateOptionMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePanedWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePopupMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePromptDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePulldownMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePushButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreatePushButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateQuestionDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateRadioBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateRowColumn.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateScale.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateScrollBar.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateScrolledList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateScrolledText.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateScrolledWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSelectionBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSelectionDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSeparator.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSeparatorGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimpleCheckBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimpleMenuBar.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimpleOptionMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimplePopupMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimplePulldownMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimpleRadioBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSimpleSpinBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateSpinBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateTemplateDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateText.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateTextField.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateToggleButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateToggleButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateWarningDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateWorkArea.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCreateWorkingDialog.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtByteStreamToXmString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtCTToXmString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtStringToUnitType.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtTextPropertyToXmStringTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtXmStringTableToTextProperty.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtXmStringToByteStream.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmCvtXmStringToCT.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDeactivateProtocol.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDeactivateWMProtocol.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDestroyPixmap.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDialogShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDirection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDirectionMatch.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDirectionMatchPartial.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDirectionToStringDirection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDragCancel.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDragContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDragIcon.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDragStart.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDrawingArea.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDrawnButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSite.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteConfigureStackingOrder.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteEndUpdate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteQueryStackingOrder.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteRegister.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteRegistered.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteRetrieve.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteStartUpdate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteUnregister.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropSiteUpdate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropTransfer.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropTransferAdd.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmDropTransferStart.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFileSelectionBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFileSelectionBoxGetChild.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFileSelectionDoSearch.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListAdd.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListAppendEntry.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListEntryCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListEntryFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListEntryGetFont.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListEntryGetTag.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListEntryLoad.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListFreeFontContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListGetNextFont.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListInitFontContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListNextEntry.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFontListRemoveEntry.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmForm.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmFrame.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetAtomName.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetColorCalculation.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetColors.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetDestination.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetDragContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetFocusWidget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetMenuCursor.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetPixmap.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetPixmapByDepth.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetPostedFromWidget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetScaledPixmap.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetSecondaryResourceData.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetTabGroup.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetTearOffControl.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetVisibility.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetXmDisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmGetXmScreen.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmIconGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImCloseXIM.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImFreeXIC.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImGetXIC.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImGetXIM.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImMbLookupString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImMbResetIC.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImRegister.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImSetFocusValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImSetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImSetXIC.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImUnregister.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImUnsetFocus.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImVaSetFocusValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmImVaSetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmInstallImage.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmInternAtom.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmIsMotifWMRunning.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmIsTraversable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmLabel.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmLabelGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListAddItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListAddItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListAddItemsUnselected.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListAddItemUnselected.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeleteAllItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeleteItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeleteItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeleteItemsPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeletePos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeletePositions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeselectAllItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeselectItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListDeselectPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListGetKbdItemPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListGetMatchPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListGetSelectedPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListItemExists.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListItemPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListPosSelected.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListPosToBounds.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListReplaceItems.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListReplaceItemsPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListReplaceItemsPosUnselected.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListReplaceItemsUnselected.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListReplacePositions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSelectItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSelectPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetAddMode.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetBottomItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetBottomPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetHorizPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetKbdItemPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListSetPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListUpdateSelectedList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmListYToPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMainWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMainWindowSep1.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMainWindowSep2.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMainWindowSep3.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMainWindowSetAreas.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmManager.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMapSegmentEncoding.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMenuPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMenuShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMessageBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmMessageBoxGetChild.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmNotebook.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmNotebookGetPageInfo.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmObjectAtPoint.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmOptionButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmOptionLabelGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPanedWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseMapping.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseMappingCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseMappingFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseMappingGetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseMappingSetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmParseTableFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPrimitive.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPrintPopupPDM.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPrintSetup.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPrintShell.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPrintToFile.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmProcessTraversal.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPushButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmPushButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRedisplayWidget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRegisterSegmentEncoding.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveFromPostFromList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveProtocolCallback.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveProtocols.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveTabGroup.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveWMProtocolCallback.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRemoveWMProtocols.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableAddRenditions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableCvtFromProp.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableCvtToProp.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableGetRendition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableGetRenditions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableGetTags.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenderTableRemoveRenditions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRendition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenditionCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenditionFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenditionRetrieve.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRenditionUpdate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeAddReverse.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeGetId.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeGetNameList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeGetRecord.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeGetRegistered.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeInstallTearOffModelConverter.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeRegister.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRepTypeValidValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmResolveAllPartOffsets.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmResolvePartOffsets.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmRowColumn.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScale.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScaleGetValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScaleSetTicks.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScaleSetValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScreen.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrollBar.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrollBarGetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrollBarSetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrolledWindow.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrolledWindowSetAreas.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmScrollVisible.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSelectionBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSelectionBoxGetChild.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSeparator.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSeparatorGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetColorCalculation.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetFontUnit.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetFontUnits.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetMenuCursor.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetProtocolHooks.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSetWMProtocolHooks.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSimpleSpinBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSimpleSpinBoxAddItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSimpleSpinBoxDeletePos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSimpleSpinBoxSetItem.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSpinBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmSpinBoxValidatePosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringBaseline.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringByteCompare.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringByteStreamLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCompare.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringComponentCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringComponentType.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringConcat.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringConcatAndFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCreateLocalized.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCreateLtoR.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringCreateSimple.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDirection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDirectionCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDirectionToDirection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDraw.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDrawImage.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringDrawUnderline.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringEmpty.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringExtent.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringFreeContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringGenerate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringGetLtoR.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringGetNextComponent.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringGetNextSegment.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringGetNextTriple.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringHasSubstring.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringHeight.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringInitContext.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringIsVoid.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringLineCount.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringNConcat.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringNCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringParseText.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringPeekNextComponent.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringPeekNextTriple.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringPutRendition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringSegmentCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringSeparatorCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringTableParseStringArray.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringTableProposeTablist.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringTableToXmString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringTableUnparse.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringToXmStringTable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringUnparse.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmStringWidth.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTab.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabCreate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabGetValues.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabList.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListFree.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListGetTab.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListInsertTabs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListRemoveTabs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListReplacePositions.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabListTabCount.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTabSetValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTargetsAreCompatible.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmText.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextClearSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextCopyLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextCut.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextDisableRedisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextEnableRedisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextField.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldClearSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldCopy.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldCopyLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldCut.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetBaseline.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetEditable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetInsertionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetLastPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetMaxLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetSelectionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetSelectionWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetStringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetSubstring.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldGetSubstringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldInsert.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldInsertWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldPaste.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldPasteLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldPosToXY.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldRemove.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldReplace.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldReplaceWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetAddMode.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetEditable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetHighlight.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetInsertionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetMaxLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldSetStringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldShowPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFieldXYToPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFindString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextFindStringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetBaseline.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetCenterline.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetEditable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetInsertionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetLastPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetMaxLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSelectionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSelectionWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSource.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetStringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSubstring.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetSubstringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextGetTopCharacter.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextInsert.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextInsertWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextPaste.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextPasteLink.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextPosToXY.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextRemove.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextReplace.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextReplaceWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextScroll.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetAddMode.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetEditable.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetHighlight.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetInsertionPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetMaxLength.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetSelection.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetSource.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetString.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetStringWcs.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextSetTopCharacter.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextShowPosition.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTextXYToPos.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButton.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonGadget.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonGadgetGetState.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonGadgetSetState.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonGetState.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonSetState.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmToggleButtonSetValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTrackingEvent.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTrackingLocate.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTransferDone.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTransferSendRequest.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTransferSetParameters.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTransferStartRequest.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTransferValue.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmTranslateKey.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmUninstallImage.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmUpdateDisplay.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimpleCheckBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimpleMenuBar.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimpleOptionMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimplePopupMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimplePulldownMenu.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmVaCreateSimpleRadioBox.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmWidgetGetBaselines.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man3/XmWidgetGetDisplayRect.3x
%attr( 0444 bin bin ) /usr/X11R6/man/man7/Traits.7x
%attr( 0444 bin bin ) /usr/X11R6/man/man7/UIL.7x
%attr( 0444 bin bin ) /usr/X11R6/man/man7/WML.7x
