/* 
 *  @OPENGROUP_COPYRIGHT@
 *  COPYRIGHT NOTICE
 *  Copyright (c) 1990, 1991, 1992, 1993 Open Software Foundation, Inc.
 *  Copyright (c) 1996, 1997, 1998, 1999, 2000 The Open Group
 *  ALL RIGHTS RESERVED (MOTIF). See the file named COPYRIGHT.MOTIF for
 *  the full copyright text.
 *  
 *  This software is subject to an open license. It may only be
 *  used on, with or for operating systems which are themselves open
 *  source systems. You must contact The Open Group for a license
 *  allowing distribution and sublicensing of this software on, with,
 *  or for operating systems which are not Open Source programs.
 *  
 *  See http://www.opengroup.org/openmotif/license for full
 *  details of the license agreement. Any use, reproduction, or
 *  distribution of the program constitutes recipient's acceptance of
 *  this agreement.
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE PROGRAM IS
 *  PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 *  WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY
 *  OR FITNESS FOR A PARTICULAR PURPOSE
 *  
 *  EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER RECIPIENT
 *  NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 *  DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED
 *  AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE
 *  EXERCISE OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGES.
*/ 
/* 
 * HISTORY
*/ 
#ifdef REV_INFO
#ifndef lint
static char rcsid[] = "$XConsortium: Navigation9.c /main/9 1995/07/13 19:45:52 drk $"
#endif
#endif
/*
*  (c) Copyright 1987, 1988, 1989 HEWLETT-PACKARD COMPANY */
	/* test for PIR 1356 */

#include <X11/Xlib.h>
#include <testlib.h>


/*************Some Globals***********************/

Widget bb;
Widget Frame1, Frame2, Frame3, Frame4, Frame5, Frame6, Frame7;
Widget Draw1, Draw2;
Widget rc1, rc2, rc3, rc4, rc6, rc7;
Widget btn1, btn2, btn3;
Widget toggle1;
Widget misc1, misc2;
Widget toggle21, toggle22;
Widget btn31, btn32, btn33, btn34, btn35, btn36;
Widget toggle31, toggle32, toggle33;
Widget btn41, btn42;
Widget toggle41, toggle42;
Widget PromptDia;

/********************* Some supporting routines ******************/


void toggleGCB();
void PrintFocus (Widget w, XtPointer client_data, XtPointer call_data);


static XtCallbackRec valuechangedCR[] = {{ toggleGCB, (caddr_t)NULL},
                                           { NULL, NULL }, };
static XtCallbackRec armCR[] = {{ toggleGCB, (caddr_t)NULL},
                                           { NULL, NULL }, };
static XtCallbackRec disarmCR[] = {{ toggleGCB, (caddr_t)NULL},
                                           { NULL, NULL }, };

void toggleGCB(w, client_data, call_data)
Widget   w;
XtPointer  client_data;
XtPointer  call_data;
{
    printf("ToggleG Callback Structure:\n    Reason:   ");
    switch( ((XmToggleButtonCallbackStruct*)call_data)->reason) {
        case XmCR_VALUE_CHANGED: printf("XmCR_VALUE_CHANGED\n"); break;
        case XmCR_ARM:          printf("XmCR_ARM\n"); break;
        case XmCR_DISARM:       printf("XmCR_DISARM\n"); break;
        default:                printf("Oops - unknown callback reason!\n");
                                break;
    }
}

/*******************************************************/


void main (argc, argv)
unsigned int argc;
char **argv;

{
    Arg args[15];
    int n, i;
    Widget child[20];
    XmString tcs;
    Widget init_focus[4];
    Widget red_button;

    /*  initialize toolkit  */
    CommonTestInit(argc, argv);

    bb = XmCreateBulletinBoard(Shell1, "bb", (ArgList) args, 0);
    XtManageChild(bb);

/* We want to test navigation across different widgets on the Bulletin
	Board as well as Navigation within the Frames within the BB, thus
	we are creating a set of three frames within the Bulleting Board,
	and they will each have a set of buttons within them.  */

	 n = 0;
	 XtSetArg(args[n], XmNx, 10); n++;
	 XtSetArg(args[n], XmNy, 10); n++;
	 XtSetArg (args[n], XmNnavigationType, XmTAB_GROUP); n++;
	 Frame1 = XmCreateFrame (bb, "Frame1", args, n);
	 XtManageChild (Frame1);

/* Let's make this Frame contain a RowColumn with three buttons.
	All the buttons will be added to the Tab Group. */

	 n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(args[n], XmNnumColumns, 1); n++;
    rc1 = XmCreateRowColumn(Frame1, "rc1", (ArgList) args, n);
    XtManageChild(rc1);

/* Create the children of the row column manager. The children are
	buttons. */

	 n = 0;
   XtSetArg(args[n], XmNtraversalOn, True); n++;
   XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
   XtSetArg(args[n], XmNhighlightThickness, 2); n++;
   XtSetArg(args[n], XmNactivateCallback, (XtArgVal) NULL); n++;
	  XtSetArg(args[n], XmNdefaultButtonShadowThickness, 2); n++;
   btn1 = XmCreatePushButton(rc1, "btn1",(ArgList)args, n);
   XtManageChild(btn1);
   btn2 = XmCreatePushButton(rc1, "btn2", (ArgList) args, n);
   XtManageChild(btn2);
   btn3 = XmCreatePushButton(rc1, "btn3", (ArgList) args, n);
   XtManageChild(btn3);
/* Lets do a toggle now... */
    n = 0;
    tcs = XmStringLtoRCreate("Toggle1", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle1 = XmCreateToggleButtonGadget(rc1,"toggle1",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle1);







/* Create the other Frame/Children combos. */
/* First the Frame */
	 n = 0;
	 XtSetArg(args[n], XmNx, 100); n++;
	 XtSetArg(args[n], XmNy, 10); n++;
	 XtSetArg (args[n], XmNnavigationType, XmTAB_GROUP); n++;
	 Frame2 = XmCreateFrame (bb, "Frame2", args, n);
	 XtManageChild (Frame2);
/* Let's make this Frame contain a RowColumn with two buttons.
	All the buttons will be added to the Tab Group. */

	 n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(args[n], XmNnumColumns, 1); n++;
    rc2 = XmCreateRowColumn(Frame2, "rc2", (ArgList) args, n);
    XtManageChild(rc2);


/* create the  children now. */
   n = 0;
   XtSetArg(args[n], XmNtraversalOn, True); n++;
   XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
   XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	  XtSetArg(args[n], XmNdefaultButtonShadowThickness, 2); n++;
   misc1 = XmCreatePushButton(rc2, "misc1", (ArgList) args, n);
   XtManageChild(misc1);
   misc2 = XmCreatePushButton(rc2, "misc2", (ArgList) args, n);
   XtManageChild(misc2);
/* Lets do a couple of  toggles now... */
    n = 0;
    tcs = XmStringLtoRCreate("Toggle21", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle21 = XmCreateToggleButtonGadget(rc2,"toggle21",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle21);
/* and another... */
    n = 0;
    tcs = XmStringLtoRCreate("Toggle22", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle22 = XmCreateToggleButtonGadget(rc2,"toggle22",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle22);


/*Two down, many to go... */

	 n = 0;
	 XtSetArg(args[n], XmNx, 200); n++;
	 XtSetArg(args[n], XmNy, 10); n++;
	 XtSetArg (args[n], XmNnavigationType, XmTAB_GROUP); n++;
	 Frame3 = XmCreateFrame (bb, "Frame3", args, n);
	 XtManageChild (Frame3);
/* Let's make this Frame contain a RowColumn with six buttons.
	All the buttons will be added to the Tab Group. */

	 n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(args[n], XmNnumColumns, 2); n++;
    rc3 = XmCreateRowColumn(Frame3, "rc3", (ArgList) args, n);
    XtManageChild(rc3);


/* create the  children now. */
   n = 0;
   XtSetArg(args[n], XmNtraversalOn, True); n++;
   XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
   XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	  XtSetArg(args[n], XmNdefaultButtonShadowThickness, 2); n++;
   btn31 = XmCreatePushButton(rc3, "btn31", (ArgList) args, n);
   XtManageChild(btn31);
   btn32 = XmCreatePushButton(rc3, "btn32", (ArgList) args, n);
   XtManageChild(btn32);
   btn33 = XmCreatePushButton(rc3, "btn33", (ArgList) args, n);
   XtManageChild(btn33);
   btn34 = XmCreatePushButton(rc3, "btn34", (ArgList) args, n);
   XtManageChild(btn34);
   btn35 = XmCreatePushButton(rc3, "btn35", (ArgList) args, n);
   XtManageChild(btn35);
   btn36 = XmCreatePushButton(rc3, "btn36", (ArgList) args, n);
   XtManageChild(btn36);

/* Toggle another... */
    n = 0;
    tcs = XmStringLtoRCreate("Toggle31", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle31 = XmCreateToggleButtonGadget(rc3,"toggle31",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle31);
    n = 0;
    tcs = XmStringLtoRCreate("Toggle32", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle32 = XmCreateToggleButtonGadget(rc3,"toggle32",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle32);
    n = 0;
    tcs = XmStringLtoRCreate("Toggle33", XmSTRING_DEFAULT_CHARSET);
    XtSetArg(args[n], XmNlabelString, tcs);  n++;
    XtSetArg(args[n], XmNindicatorOn, True);  n++;
    XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
    XtSetArg(args[n], XmNarmCallback, armCR);  n++;
    XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
    toggle33 = XmCreateToggleButtonGadget(rc3,"toggle33",(ArgList) args, n);
    if(tcs) XmStringFree(tcs);
    XtManageChild(toggle33);


    /* process UserData. We can put the initial focus on btn31 by setting
       it to any one of 3 levels of nested widgets, as follows:
	UserData	Widget with initialFocus
	-------- 	------------------------
	   1			Frame3
	   2			Frame3/rc3
	   3			Frame3/rc3/btn31
       If UserData was not set, we'll use level 3 by default.
       Note, that to set initialFocus to some nested primitive,
       you must set XmNinitialFocus to all managers in between.

       Before doing anything, initialize the init_focus array.
       init_focus[0] is the bulletin board parent. We don't
       actually set initialFocus to this, but we can use this
       scheme in the SetValues code - you need to know the
       parent of the widget you're setting...

       We will set the "red button" to either btn31 or
       btn33, to simplify instructions for the user.
       The focus should be on the red button.
    */

    
    init_focus[0] = bb;
    init_focus[1] = NULL;
    init_focus[2] = NULL;
    init_focus[3] = NULL;

    if (UserData) {
	if ((strcmp (UserData, "1")) == 0) { init_focus[1] = Frame3;
					     red_button = btn31;
					   }

	if ((strcmp (UserData, "2")) == 0) { init_focus[1] = Frame3;
	                                     init_focus[2] = rc3;
					     red_button = btn31;
					   }
	if ((strcmp (UserData, "3")) == 0) { init_focus[1] = Frame3;
	                                     init_focus[2] = rc3;
	                                     init_focus[3] = btn33;
					     red_button = btn33;
					   }
      }
    else { init_focus[1] = Frame3;
	   init_focus[2] = rc3;
	   init_focus[3] = btn33;
	   red_button = btn33;
	   UserData = "3";
	 }

    for (i = 1; i <= atoi(UserData); i++) {
      n = 0;
      if (init_focus[i]) {
	XtSetArg (args[n], XmNinitialFocus, init_focus[i]);
	n++;
	}
        XtSetValues (init_focus[i - 1], args, n);
        printf ("Setting initialFocus of %s to %s\n",
		XtName (init_focus[i-1]),
		XtName (init_focus[i]));

    }

    n = 0;
    XtSetArg (args[n], XmNbackground, CommonGetColor("red")); n++;
    XtSetValues (red_button, args, n);

    n = 0;
    XtSetArg (args[n], XmNdefaultButton, btn1); n++;
    XtSetValues (init_focus[0], args, n);


	 n = 0;
	 XtSetArg(args[n], XmNx, 375); n++;
	 XtSetArg(args[n], XmNy, 10); n++;
	 XtSetArg (args[n], XmNnavigationType, XmTAB_GROUP); n++;
	 Frame4 = XmCreateFrame (bb, "Frame4", args, n);
	 XtManageChild (Frame4);
/* Let's make this Frame contain a RowColumn with two buttons and two toggles.
	All the buttons will be added to the Tab Group. */

	 n = 0;
    XtSetArg(args[n], XmNpacking, XmPACK_COLUMN); n++;
    XtSetArg(args[n], XmNnumColumns, 1); n++;
    rc4 = XmCreateRowColumn(Frame4, "rc4", (ArgList) args, n);
    XtManageChild(rc4);

/* create the  children now. */
   n = 0;
   XtSetArg(args[n], XmNtraversalOn, True); n++;
   XtSetArg(args[n], XmNhighlightOnEnter, True); n++;
   XtSetArg(args[n], XmNhighlightThickness, 2); n++;
	  XtSetArg(args[n], XmNdefaultButtonShadowThickness, 2); n++;
   btn41 = XmCreatePushButton(rc4, "btn41", (ArgList) args, n);
   XtManageChild(btn41);
   btn42 = XmCreatePushButton(rc4, "btn42", (ArgList) args, n);
   XtManageChild(btn42);
   n = 0;
   tcs = XmStringLtoRCreate("Toggle41", XmSTRING_DEFAULT_CHARSET);
   XtSetArg(args[n], XmNlabelString, tcs);  n++;
   XtSetArg(args[n], XmNindicatorOn, True);  n++;
   XtSetArg(args[n], XmNvalueChangedCallback, valuechangedCR);  n++;
   XtSetArg(args[n], XmNarmCallback, armCR);  n++;
   XtSetArg(args[n], XmNdisarmCallback, disarmCR);  n++;
   toggle41 = XmCreateToggleButtonGadget(rc4,"toggle41",(ArgList) args, n);
   if(tcs) XmStringFree(tcs);
   XtManageChild(toggle41);


	n = 0;
	XtSetArg (args[n], XmNx, 485); n++;
        XtSetArg (args[n], XmNy, 10); n++;
	XtSetArg(args[n], XmNborderWidth, 5); n++;
	XtSetArg (args[n], XmNnavigationType, XmTAB_GROUP); n++;
	Frame5 = XmCreateFrame (bb, "Frame5", args, n);
	XtManageChild (Frame5);
	n = 0;
   XtSetArg(args[n], XmNwidth, 135);  n++;
   XtSetArg(args[n], XmNheight,135);  n++;
	XtSetArg(args[n], XmNarrowDirection, XmARROW_RIGHT);  n++;
	Draw1 = XmCreateArrowButton (Frame5,"Draw1", args, n);
	XtManageChild (Draw1);


/* Now lets make two more RCs with nothing on them! */

	 n = 0;
	 XtSetArg (args[n], XmNx, 650); n++;
	 XtSetArg (args[n], XmNy, 10); n++;
	 XtSetArg(args[n], XmNborderWidth, 5); n++;
	 XtSetArg(args[n], XmNheight, 5); n++;
	 XtSetArg(args[n], XmNwidth, 5); n++;
	 Frame6 = XmCreateFrame (bb, "Frame6", args, n);
	 XtManageChild (Frame6);
	 n = 0;
	 XtSetArg(args[n], XmNborderWidth, 5); n++;
	 XtSetArg(args[n], XmNwidth, 20); n++;
    rc6 = XmCreateRowColumn(Frame6, "rc6", (ArgList) args, n);
    XtManageChild(rc6);

	 n = 0;
	 XtSetArg (args[n], XmNx, 700); n++;
	 XtSetArg (args[n], XmNy, 10); n++;
	 XtSetArg(args[n], XmNborderWidth, 5); n++;
	 XtSetArg(args[n], XmNheight, 5); n++;
	 XtSetArg(args[n], XmNwidth, 5); n++;
	 Frame7 = XmCreateFrame (bb, "Frame7", args, n);
	 XtManageChild (Frame7);
	 n = 0;
	 XtSetArg(args[n], XmNborderWidth, 5); n++;
	 XtSetArg(args[n], XmNwidth, 5); n++;
    rc7 = XmCreateRowColumn(Frame7, "rc7", (ArgList) args, n);
    XtManageChild(rc7);

    XtRealizeWidget (Shell1);
    CommonPause (); /* tab around */
    CommonPause (); /* ditto */

    XtAddCallback  (bb, XmNfocusCallback, PrintFocus, NULL);
    XtSetSensitive (red_button, False);
    CommonPause();

    n = 0;
    PromptDia = XmCreatePromptDialog (Shell1, "PromptDia", args, n);
    init_focus[0] = XmSelectionBoxGetChild (PromptDia, XmDIALOG_OK_BUTTON);
    n = 0;
    XtSetArg (args[n], XmNinitialFocus, init_focus[0]); n++;
    XtSetValues (PromptDia, args, n);
    XtManageChild (PromptDia);

    XtSetSensitive (red_button, True);

    CommonPause();

    CommonPause (); /* end */
    XtAppMainLoop(app_context);
}

void PrintFocus (Widget w, XtPointer client_data, XtPointer call_data)
{
   Widget fw;

   fw = XmGetFocusWidget (w);

   printf ("Widget %s has focus\n", XtName(fw));
   fflush (stdout);
}

