/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.Locale;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import widgets.LaunchIt;
import xmlObjects.Group;
import xmlObjects.ValDesc;
import xmlObjects.VtEnv;
import help.Config;
import help.GenerateScript;
import help.LoadConfig;
import help.MyComponentHandler;
import help.SaveConfig;
import help.myMouseListener;
import help.Text;
import grpFilt.Filtering;
import grpFilt.General;
import grpFilt.Grouping;
import grpFilt.GrpFiltWidget;
import grpFilt.SymbolGroupTable;



/***
 * This class creates an Window and shows the main parts of the Gui.
 * It implements the VampirTrace Enviroment (vtEnv) that Load GuiInformation from
 * a xml file. with the help of this Information the left menu is set and the content
 * is shown.
 * *******/



public class vtsetup {
    
	private static String envPath = null;
	private static String stdGroupsPath = null;
	private static String UserManualPath = null;
	
	private static JPanel panel = new JPanel();
   	private static JFrame frame = new JFrame(Config.TITLE);
   	private static String srcFolder = "/src/";
   	private static final Text mytext = new Text();
   	
   	/**
   	 * save gui information, tooltip and {@link GrpFiltWidget Filter and Group} widget 
   	 */
    private static VtEnv env = null;
    /**
     * is true if the advanced settings are visible otherwise false
     */
    private static boolean advancedVisible = false;
    public static Group curPage = null;
    private static String curPageDesc = null; 
    private static SaveConfig saveFile = null; 
    private static GenerateScript generator = null;
    private static JSplitPane splitPane = null;
    private static JSplitPane splitPane_main = null;
    private static JButton advanced = null;
    private static JButton tooltip = null;
    private static Icon icon_advanced2 = null;
    private static Icon icon_advanced = null;
    private static Icon icon_tooltipimage = null;
    private static Icon icon_tooltipimage_off = null;
    /***
     * main method of this program
     */
	public static void main(String[] args) {
		
		if(args.length < 3)
		{			
			JOptionPane.showMessageDialog(null, mytext.getText("error_NoParameter"), "Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		}
		//get path to external sources 
		envPath = args[0];
		stdGroupsPath = args[1];
		UserManualPath = args[2];
		
		if(!(new File(envPath).isFile() && new File(stdGroupsPath).isFile() && new File(UserManualPath).isFile()))
		{
			JOptionPane.showMessageDialog(null, mytext.getText("error_NoCorrectPathes"), "Error", JOptionPane.ERROR_MESSAGE);
			System.exit(1);
		}
		
			
			env = new VtEnv(mytext,envPath,stdGroupsPath,UserManualPath);
			if(args.length >= 4)
			{
				env.executable = args[3].trim();
				for(int i=4;i<args.length;i++)
					env.arguments += args[i]+" ";
			}
			
			if(vtsetup.class.getProtectionDomain().getCodeSource().getLocation().getPath().endsWith(".jar"))
			{
				srcFolder = "/";
			    VtEnv.srcFolder = "/";
			}
			try {
			     // Set Look and Feel
				try{
					UIManager.setLookAndFeel("javax.swing.plaf.mac.MacLookAndFeel");
				}catch(Exception ex)
				{
					try{
						UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
					}catch(Exception err)
					{
						UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
					}
				}

		         Toolkit.getDefaultToolkit().setDynamicLayout(true);
		         // Set Language
		         Locale.setDefault(Locale.ENGLISH);
		         JComponent.setDefaultLocale(Locale.ENGLISH);
		        
		    }
			catch (Exception ex)
			{
				Config.errorHandler(ex);
			}
		    
		    
	        javax.swing.SwingUtilities.invokeLater(new Runnable() {
	            public void run() {
	                initGui();
	            }
	            
	        });
    }

	/***
	 * initialize Gui elements and set up frame settings
	 */
	public static void initGui()
	{
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		ImageIcon icon = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_ICON) );
        frame.setIconImage(icon.getImage());
        /********* CREATE a PANEL to store the widgets on **************/
        panel.setLayout(new BorderLayout());
        frame.setSize(new Dimension(1000,400));
        frame.setMinimumSize(new Dimension(720,400));
    //    frame.setExtendedState(Frame.MAXIMIZED_BOTH);     
        curPage = env.getAllGroups().get(0);
        /************ LOAD all content Panels ***********/
        for(int i=0;i<env.getGroups().size();i++)
        	env.getGroups().get(i).getPanel(true);
        
        env.hasChanged=false;
        
        /*********** BUILD_UP Gui ****************/
      try{       

    	JPanel bars = new JPanel(new BorderLayout());
        bars.add(init_menubar(),BorderLayout.BEFORE_FIRST_LINE);
        bars.add(init_toolbar(),BorderLayout.AFTER_LAST_LINE);
        panel.add(bars,BorderLayout.PAGE_START);
        
        splitPane_main = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT, true, init_leftMenu(),init_content());
        splitPane_main.setOneTouchExpandable(true);
        splitPane_main.setResizeWeight(0);
        splitPane_main.setDividerLocation(280);
        splitPane_main.getComponent(0).setMinimumSize(new Dimension(200,100));
        splitPane_main.getComponent(1).setMinimumSize(new Dimension(400,100));
        panel.add( splitPane_main,BorderLayout.CENTER);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        splitPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT, true, panel,init_tooltip());
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(1);
        splitPane.getComponent(1).setMinimumSize(new Dimension(100,150));
        env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
       
      }
      catch(Exception e)
      {
    	  Config.errorHandler(e);
      }
      
        /************ SHOW PANEL *****************/
        frame.getContentPane().add(splitPane);
        //Display the window.
        frame.setVisible(true);
        frame.pack();
        splitPane.setDividerLocation(frame.getHeight()-200);
      
        
        /************* Listener ********************/

	}

	/****
	 * Creates the menubar and containts all handler for the top menu
	 * @return Component used as menubar
	 */
	public static Component init_menubar()
	{
        /********** CREATE a JMenubar *********************/
        JMenuBar menubar = new JMenuBar();
        //Menus in menubar
        JMenu menu_file = new JMenu(mytext.getText("launch_menuBar_FILE"));
        JMenu menu_generate = new JMenu(mytext.getText("launch_menuBar_Generate"));
        JMenu menu_view = new JMenu(mytext.getText("launch_menuBar_View"));
        JMenu menu_help = new JMenu(mytext.getText("launch_menuBar_Help"));
        
        menubar.add(menu_file);
        menubar.add(menu_generate);
        menubar.add(menu_view);
        menubar.add(menu_help);
        
        //Filemenu
        JMenuItem menu_quit = new JMenuItem(mytext.getText("launch_menuBar_FILE_quit"));
        JMenuItem menu_nconfig = new JMenuItem(mytext.getText("launch_menuBar_FILE_new"));
        JMenuItem menu_oconfig = new JMenuItem(mytext.getText("launch_menuBar_FILE_open"));
        JMenuItem menu_sconfig = new JMenuItem(mytext.getText("launch_menuBar_FILE_save"));
        JMenuItem menu_sconfigas = new JMenuItem(mytext.getText("launch_menuBar_FILE_saveas"));
        menu_file.add(menu_nconfig);
        menu_file.add(menu_oconfig);
        menu_file.add(menu_sconfig);
        menu_file.add(menu_sconfigas);
        menu_file.addSeparator();
        menu_file.add(menu_quit);
        
        //Generate
        JMenuItem smenu_generate = new JMenuItem(mytext.getText("launch_menuBar_Generate_generate"));
        
        JMenuItem menu_gen_bash = new JMenuItem(mytext.getText("launch_menuBar_Generate_bash"));
        JMenuItem menu_gen_csh = new JMenuItem(mytext.getText("launch_menuBar_Generate_csh"));
        JMenuItem menu_gen_batch = new JMenuItem(mytext.getText("launch_menuBar_Generate_batch"));

        
        menu_generate.add(menu_gen_bash);
        menu_generate.add(menu_gen_csh);
        menu_generate.add(menu_gen_batch);


        //View
        JMenuItem menu_tooltip = new JMenuItem(Config.ToolBoxTitle+" on/off");
        JMenuItem menu_advanced = new JMenuItem(mytext.getText("launch_menuBar_View_advanced"));
        menu_view.add(menu_tooltip);
        menu_view.add(menu_advanced);
        
        //help
        JMenuItem menu_about = new JMenuItem(mytext.getText("launch_menuBar_Help_About"));
        menu_help.add(menu_about);
        
        // display it on Panel
    
        menu_nconfig.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	
                	boolean makeDefault = true;
            		if(vtsetup.env.hasChanged)
            		{
            			String[] options = { mytext.getText("misc_save"), mytext.getText("misc_dont_save"), mytext.getText("misc_cancel") };
        
            			int answer = JOptionPane.showOptionDialog(null, mytext.getText("dialog_save_changes"), mytext.getText("dialog_save_changes_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
            			if(answer == 0)
            				vtsetup.saveFileAS();
            			
            			if(answer == 2)
            				makeDefault = false;
            		}
            			if(makeDefault)
            			{
            				MyComponentHandler help = new MyComponentHandler();
            				help.SetAllDefault(env);
            				env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
            				saveFile=null;
            				vtsetup.advancedVisible = false;
            				advanced.setIcon(icon_advanced);
            				vtsetup.env.hasChanged=false;
            			}
                }
        	}
        });
        menu_oconfig.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	if(env.getGrpFiltWidget() == null)
					{
					   env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
					}
                	
                	boolean loadEntrys = true;
            		if(vtsetup.env.hasChanged)
            		{
            			String[] options = { mytext.getText("misc_yes"), mytext.getText("misc_no")};
            			int answer = JOptionPane.showOptionDialog(null, mytext.getText("dialog_chanches_lost"), mytext.getText("dialog_chanches_lost_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
            			
            			if(answer== 1)
            				loadEntrys = false;
            		}
            		
            		if(loadEntrys)
            		{
            			 LoadConfig load = new LoadConfig(env);
            			 load.setFile(advancedVisible);
                		 vtsetup.env.hasChanged=false;
                		 if(saveFile == null)
                			 saveFile = new SaveConfig();
                		 saveFile.setFile(load.getFile());
            		}
                		
                }
        	}
        });
        
        menu_sconfig.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	if(saveFile == null || saveFile.getFile() == null)
                	{
                		saveFile = new SaveConfig();
                	    saveFile.setFile();
                	}
                	
                	if(saveFile != null)
                		saveFile.SaveFile(env);
                }
        	}
        });
        menu_sconfigas.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	saveFileAS();
                }
        	}
        });
        

        menu_advanced.addActionListener(new ActionListener(){
        	 public void actionPerformed(ActionEvent event) {
                 if (event.getID() == ActionEvent.ACTION_PERFORMED)
                 {
                	 if(advancedVisible)
                	 {
                		 ((JMenuItem)event.getSource()).setText("show Advanced options");
                		 advancedVisible = false;
                		 advanced.setIcon(icon_advanced);
                		 reloadContent();
                	 }else{
                		 ((JMenuItem)event.getSource()).setText("hide Advanced options");
                		 advancedVisible = true;
                		 advanced.setIcon(icon_advanced2);
                		 reloadContent();
                	 }
              	   	((JEditorPane) ((JScrollPane)splitPane_main.getComponent(0)).getViewport().getComponent(0)).setText(VtEnv.getMenu(advancedVisible,curPage,curPageDesc));
                 }
        	 }
        	
        });
        menu_tooltip.addActionListener(new ActionListener() {
        	 public void actionPerformed(ActionEvent event) {
                 if (event.getID() == ActionEvent.ACTION_PERFORMED)
                 {
                	 Component pane = splitPane.getComponent(1);//panel.getComponent(panel.getComponentCount()-2);
                	 if(pane.isVisible())
                	 {
                		 pane.setVisible(false);
                		 tooltip.setIcon(icon_tooltipimage_off);
                		 splitPane.setOneTouchExpandable(false);
                	 }
                	 else
                	 {
                		 pane.setVisible(true);
                		 tooltip.setIcon(icon_tooltipimage);
                		 splitPane.setDividerLocation(frame.getHeight()-200);
                		 splitPane.setOneTouchExpandable(true);
                	 }
                	 frame.setPreferredSize(frame.getSize());
                	 frame.pack();
                	 
                 }
        	 }
        });
        menu_quit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {

               if (event.getID() == ActionEvent.ACTION_PERFORMED)
            	   System.exit(0);
            }
        });
        
        smenu_generate.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.ALL);
        	}
	    });
	    menu_gen_bash.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.SHELL);
        	}
	    });
	    menu_gen_csh.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.CSHELL);
        	}
	    });
	    menu_gen_batch.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.BATCH);
        	}
	    });
/*	    menu_gen_apple.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.APPLE);
        	}
	    });
	*/    
	    menu_about.addActionListener(new ActionListener(){
	    	
	    	public void actionPerformed(ActionEvent e)
	    	{
	    		JOptionPane.showMessageDialog(frame, Config.ABOUT_Text(env.getVtenversion()), Config.ABOUT_TITLE, JOptionPane.PLAIN_MESSAGE);
	    	}
	    });
	    
	    
	    
	    return menubar;
	}

	/****
	 * initialize main content frame with the first group 
	 * @return component of the main window
	 */
	public static Component init_content()
	{

		  JScrollPane ScrollPane = new JScrollPane((env.getGroups().get(0)).getPanel(advancedVisible));
	      ScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
	      //ScrollPane.setPreferredSize(new Dimension(300,vtsetup.frame.getSize().height));
	      curPage = env.getGroups().get(0);
	      ScrollPane.getVerticalScrollBar().setUnitIncrement(17);	      
	      
		return ScrollPane;
	}

	/***
	 * initialize toolbar with the new, save, load and generate button
	 * @return component of the main window
	 */
	public static Component init_toolbar()
	{
		
		final Icon icon_new = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_NEW) );
		Icon icon_load = new ImageIcon(vtsetup.class.getClass().getResource(srcFolder+Config.Image_LOAD));
		Icon icon_save = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_SAVE) );
		Icon icon_generate = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_GENERATE) );
		
		icon_tooltipimage = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_TOOLBOX) );
		icon_tooltipimage_off = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_TOOLBOX_off) );
		
		final ImageIcon icon_MAGIC = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_Execute) );
		
		
		icon_advanced = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_ADVANCEDMODE) );
		icon_advanced2 = new ImageIcon( vtsetup.class.getClass().getResource(srcFolder+Config.Image_DEFAULTMODE) );

	    final JButton newFile = new JButton( null, icon_new );
	    JButton loadFile = new JButton( null, icon_load );
	    JButton saveFile = new JButton( null, icon_save );
	    JButton generate = new JButton( null, icon_generate );
	    tooltip = new JButton( null, icon_tooltipimage );
	    JButton MAGICBTN = new JButton( null, icon_MAGIC );
	    advanced = new JButton( null, icon_advanced );
	    JMenuBar toolbar = new JMenuBar();
	    
	    String osName = System.getProperty("os.name" );
		if((osName.toLowerCase().contains("linux") ||osName.toLowerCase().contains("mac")))
			MAGICBTN.setVisible(true);
		else
			MAGICBTN.setVisible(false);
		
	    
	    newFile.setMargin(new Insets(0,0,0,0));
	    loadFile.setMargin(new Insets(0,0,0,0));
	    saveFile.setMargin(new Insets(0,0,0,0));
	    generate.setMargin(new Insets(0,0,0,0));
	    advanced.setMargin(new Insets(0,0,0,0));
	    MAGICBTN.setMargin(new Insets(0,0,0,0));
	    tooltip.setMargin(new Insets(0,0,0,0));
	    newFile.setContentAreaFilled(false);
	    loadFile.setContentAreaFilled(false);
	    saveFile.setContentAreaFilled(false);
	    generate.setContentAreaFilled(false);
	    advanced.setContentAreaFilled(false);
	    MAGICBTN.setContentAreaFilled(false);
	    tooltip.setContentAreaFilled(false);
	    newFile.setBorderPainted(false);
	    loadFile.setBorderPainted(false);
	    saveFile.setBorderPainted(false);
	    generate.setBorderPainted(false);
	    advanced.setBorderPainted(false);
	    MAGICBTN.setBorderPainted(false);
	    tooltip.setBorderPainted(false);

		
	    MAGICBTN.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e) {
		        javax.swing.SwingUtilities.invokeLater(new Runnable() {
		            public void run() {
		            	new LaunchIt(icon_MAGIC.getImage(),env);
		            }
		            
		        });
			}
	    	
	    });
	    
        newFile.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                		MyComponentHandler help = new MyComponentHandler();
                		boolean makeDefault = true;
                		if(vtsetup.env.hasChanged)
                		{
                			String[] options = { mytext.getText("misc_save"), mytext.getText("misc_dont_save"), mytext.getText("misc_cancel") };
                			int answer = JOptionPane.showOptionDialog(null, mytext.getText("dialog_save_changes"), mytext.getText("dialog_save_changes_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
                			if(answer == 0)
                				vtsetup.saveFileAS();
                			
                			if(answer == 2)
                				makeDefault = false;
                		}
                		
                		if(makeDefault)
                		{
                			vtsetup.advancedVisible = false;
                			advanced.setIcon(icon_advanced);
                			help.SetAllDefault(env);
                			env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
                			vtsetup.saveFile=null;
                			vtsetup.env.hasChanged = false;
                		}
                }
        	}
        });
        
        loadFile.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	if(env.getGrpFiltWidget() == null)
					   {
						   env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
					   }
                	boolean loadEntrys = true;
            		if(vtsetup.env.hasChanged)
            		{
            			String[] options = { "yes", "no"};
            			int answer = JOptionPane.showOptionDialog(null, mytext.getText("dialog_chanches_lost"), mytext.getText("dialog_chanches_lost_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
            			
            			if(answer == 1)
            				loadEntrys = false;
            		}
            		
            		if(loadEntrys)
            		{
            			 LoadConfig load = new LoadConfig(env);
            			 load.setFile(advancedVisible);
                		 vtsetup.env.hasChanged=false;
                		 if(vtsetup.saveFile == null)
                			 vtsetup.saveFile = new SaveConfig();
                		 vtsetup.saveFile.setFile(load.getFile());
            		}
                }
        	}
        });
        
	    saveFile.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
                	vtsetup.saveFile();
                }
        	}
        });
	    
	    
	    generate.addActionListener(new ActionListener(){
        	public void actionPerformed(ActionEvent event) {
        		generate(GenerateScript.ALL);
        	}
	    });
	    
	    tooltip.addActionListener(new ActionListener(){
	    	public void actionPerformed(ActionEvent e)
	    	{
	    		if (e.getID() == ActionEvent.ACTION_PERFORMED)
                {
               	 Component pane = splitPane.getComponent(1);//panel.getComponent(panel.getComponentCount()-2);
               	 if(pane.isVisible())
               	 {
               		 pane.setVisible(false);
               		 tooltip.setIcon(icon_tooltipimage_off);
               		 splitPane.setOneTouchExpandable(false);
               	 }
               	 else
               	 {
               		 pane.setVisible(true);
               		 tooltip.setIcon(icon_tooltipimage);
               		 splitPane.setDividerLocation(frame.getHeight()-200);
               		 splitPane.setOneTouchExpandable(true);
               	 }
               	 frame.setPreferredSize(frame.getSize());
               	 frame.pack();
               	 
                }
	    	}
	    });

	    newFile.setToolTipText("<html><body bgcolor=\"#FFFF00\">"+ mytext.getText("launch_toolBar_new")+"</body></html>");
	    generate.setToolTipText("<html><body bgcolor=\"#FFFF00\">"+ mytext.getText("launch_toolBar_generate")+"</body></html>");
	    loadFile.setToolTipText( "<html><body bgcolor=\"#FFFF00\">"+mytext.getText("launch_toolBar_load")+"</body></html>");
	    saveFile.setToolTipText( "<html><body bgcolor=\"#FFFF00\">"+mytext.getText("launch_toolBar_save")+"</body></html>");
	    tooltip.setToolTipText( "<html><body bgcolor=\"#FFFF00\">"+mytext.getText("tooltip_default")+"</body></html>");
	    advanced.setToolTipText( "<html><body bgcolor=\"#FFFF00\">"+mytext.getText("launch_toolBar_advanced")+"</body></html>");
	    MAGICBTN.setToolTipText("<html><body bgcolor=\"#FFFF00\">"+ mytext.getText("launch_toolBar_magic")+"</body></html>");
	    
	    myMouseListener l = new myMouseListener();
	    l.setToolTip(env);
	    l.setText(Config.setToolTipString(mytext.getText("launch_toolBar_generate_title"), mytext.getText("launch_toolBar_generate")));
	    generate.addMouseListener(l);
	    l = new myMouseListener();
	    l.setToolTip(env);
	    l.setText(Config.setToolTipString(mytext.getText("launch_toolBar_new_title"), mytext.getText("launch_toolBar_new")));
	    newFile.addMouseListener(l);
	    l = new myMouseListener();
	    l.setToolTip(env);
	    l.setText(Config.setToolTipString(mytext.getText("launch_toolBar_advanced_title"), mytext.getText("launch_toolBar_advanced")));
	    advanced.addMouseListener(l);
	    l = new myMouseListener();
	    l.setToolTip(env);
	    l.setText(Config.setToolTipString(mytext.getText("launch_toolBar_magic_title"), mytext.getText("launch_toolBar_magic")));
	    MAGICBTN.addMouseListener(l);
	    
	    l = new myMouseListener();
	    l.setToolTip(env);
	    l.setText(Config.setToolTipString(mytext.getText("tooltip_default_title"), mytext.getText("tooltip_default")));
	    tooltip.addMouseListener(l);	    
	    
	    saveFile.addMouseListener(new MouseListener()
		{
			public void mousePressed(MouseEvent e){;}
			public void mouseEntered(MouseEvent e){
				
				String text = new String();
				String savefile = " - ";
				if(vtsetup.saveFile != null && vtsetup.saveFile.getFile() != null)
				{
					savefile = vtsetup.saveFile.getFile();
					if(savefile.contains("/"))
							savefile = savefile.substring(savefile.lastIndexOf("/")+1);
					if(savefile.contains("\\"))
						savefile = savefile.substring(savefile.lastIndexOf("\\")+1);
				}
					
				
				text = mytext.getText("launch_toolBar_save");
				text +="<br/><br/><b>current save fileDefault:</b> "+savefile;
				
				
				
				env.ToolTipView.setText(Config.setToolTipString(mytext.getText("launch_toolBar_save_title"), text));
				if(env.getToolTip().getComponent(0) != env.ToolTipView)
				{
					env.getToolTip().removeAll();
					env.getToolTip().add(env.ToolTipView);
				}
			}
			public void mouseClicked(MouseEvent e){;}
			public void mouseReleased(MouseEvent e){;}
			public void mouseExited(MouseEvent e) {
				
			}
		});
	    
	    loadFile.addMouseListener(new MouseListener()
		{
			public void mousePressed(MouseEvent e){;}
			public void mouseEntered(MouseEvent e){
			
				
				env.ToolTipView.setText(Config.setToolTipString(mytext.getText("launch_toolBar_load_title"),mytext.getText("launch_toolBar_load")));
				if(env.getToolTip().getComponent(0) != env.ToolTipView)
				{
					env.getToolTip().removeAll();
					env.getToolTip().add(env.ToolTipView);
				}
			}
			public void mouseExited(MouseEvent e){
			}
			public void mouseClicked(MouseEvent e){;}
			public void mouseReleased(MouseEvent e){;}
		});
	    
	    advanced.addActionListener(new ActionListener(){
       	 public void actionPerformed(ActionEvent event) {
                if (event.getID() == ActionEvent.ACTION_PERFORMED)
                {
               	 if(advancedVisible)
               	 {
               		 advancedVisible = false;
               		 advanced.setIcon(icon_advanced);
               		 reloadContent();
               	 }else{
               		 advancedVisible = true;
               		advanced.setIcon(icon_advanced2);
               		 reloadContent();
               	 }
               	 
               	 if(env.getGrpFiltWidget().cur == 1)
               		 curPageDesc = "general";
               	 
             	 ((JEditorPane) ((JScrollPane)splitPane_main.getComponent(0)).getViewport().getComponent(0)).setText(VtEnv.getMenu(advancedVisible,curPage,curPageDesc));
                }
       	 }
       	
       });
	    
	    toolbar.add(newFile);
	    toolbar.add(loadFile);
	    toolbar.add(saveFile);
	    toolbar.add(generate);
	    toolbar.add(advanced);
	    toolbar.add(tooltip);
	    toolbar.add(MAGICBTN);
	    
	    return toolbar;
	}

	/******
	 * Creates the menu with the help of the getMenu() Method from vtEnv class. 
	 * Here you can find also the event listener that is used for specials like grouping and filtering. 
	 * @return Component of the left menu
	 */
	public static Component init_leftMenu()
	{
	   	final JEditorPane leftMenu = new JEditorPane();	
	   	VtEnv.menu = leftMenu;
		JScrollPane menuScrollPane = new JScrollPane(leftMenu);
        menuScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        menuScrollPane.setPreferredSize(new Dimension(200,vtsetup.frame.getSize().height));
        menuScrollPane.setMinimumSize(new Dimension(10, 10));
        menuScrollPane.getVerticalScrollBar().setUnitIncrement(17);

	   leftMenu.setAutoscrolls(true);
       leftMenu.setContentType("text/html");
       leftMenu.setEditable(false);
	   leftMenu.setText(VtEnv.getMenu(advancedVisible,curPage,curPageDesc));
	   
	   
	   /******************* Event Listener *************/
	  leftMenu.addHyperlinkListener(new HyperlinkListener(){
		 // String old="";
		  public void hyperlinkUpdate(HyperlinkEvent e){
			  
			  if(e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
			  {
				  
				  
				  Component comp = null;
				  
				  if(e.getDescription().startsWith("FiltGrp"))
				  {
					  curPageDesc = "general";
					  comp = new JPanel();
					   if(env.getGrpFiltWidget() == null)
					   {
						   env.setGrpFiltWidget(new GrpFiltWidget(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)),env.getGroupById("FiltGrp"),advancedVisible,env,mytext,stdGroupsPath));
					   }
					   else
					   {
						   env.getGrpFiltWidget().setViewport(((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)));
					   }
					   
					   SymbolGroupTable sTable = env.getGrpFiltWidget().getSymbolGroupTable(); 
					  if((!env.executableLoaded || VtEnv.executableAnswer <= 1) && !(env.getItemById("VTSetup_EXECUTABLE").getValue().get(0)).getCurrent().trim().equals(""))
					  {
						  	
				  			sTable.getSymbolsFromExecutable((env.getItemById("VTSetup_EXECUTABLE").getValue().get(0)).getCurrent().trim(),"exec",true);
				  			sTable.executablesLoded = true;
				  			env.executableLoaded = true;
				  			VtEnv.executableAnswer = 3;
					  }
					  
				  	  if(e.getDescription().endsWith("General"))
				  	  {
				  		 env.getGrpFiltWidget().setGeneral(advancedVisible);
				  		 curPageDesc = "general";
				  	  }
				  	  else
					  if(e.getDescription().endsWith("Grouping"))
					  {
						  env.getGrpFiltWidget().setGrouping(advancedVisible);
						  curPageDesc = "grouping";
					  }
					  else
					  if(e.getDescription().endsWith("Filtering"))
					  {
						  env.getGrpFiltWidget().setFiltering(advancedVisible);
						  curPageDesc = "filtering";
					  }
					  else
						  env.getGrpFiltWidget().setGeneral(advancedVisible);
					  curPage = null;
			
				  }else
				  {
					  curPageDesc = null;  
				  }
					
				  if(comp == null)
				  {
					  comp = env.getGroupById(e.getDescription()).getPanel(advancedVisible);
					  
						((JScrollPane)splitPane_main.getComponent(1)).getViewport().removeAll();
						((JScrollPane)splitPane_main.getComponent(1)).getViewport().add(comp);
						curPage = env.getGroupById(e.getDescription());
				  }
			      
				  leftMenu.setText(VtEnv.getMenu(advancedVisible,curPage,curPageDesc));
			  }
			  
			  if(e.getEventType() == HyperlinkEvent.EventType.ENTERED)
			  {
				  
				  
				  Group grp = env.getGroupById(e.getDescription());
				  if(grp == null)
				  {
					  grp = env.getGroupById("FiltGrp");
				  }
				try{  
					env.ToolTipView.setText(Config.setToolTipString(grp.getName(), grp.getDescription()));
					if(env.getToolTip().getComponent(0) != env.ToolTipView)
					{
						env.getToolTip().removeAll();
						env.getToolTip().add(env.ToolTipView);
					}
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
				  
				  
			  }
			  
	/*		  if(e.getEventType() == HyperlinkEvent.EventType.EXITED)
			  {
				  try{
					  if(old.startsWith("file:"))
						  env.getToolTip().setPage(old);
					  else
						  env.getToolTip().setText(old);
				  }catch(Exception ex)
				  {
					  Config.errorHandler(ex);
				  }
			  }*/  
		  }
	  });
	  
	  return menuScrollPane;
	}

	/***
	 * initialize tooltip. in this method you can set up the default text.
	 * @return component of the main window
	 */
	public static Component init_tooltip()
	{

		
		JScrollPane editorScrollPane = new JScrollPane(env.ToolTipView);
        editorScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
       editorScrollPane.setPreferredSize(new Dimension(vtsetup.frame.getSize().width,200));
   
        editorScrollPane.setBorder(BorderFactory.createEmptyBorder(0,0,0,0));
        env.ToolTipView.setBorder(BorderFactory.createEmptyBorder());

        /*********** Set tooltip hover *************/
        MyComponentHandler help = new MyComponentHandler();
        env.setToolTip(editorScrollPane.getViewport());
        help.setAllDesc(env);
        env.hasChanged = false;
        //load config if xml file is set
        if(env.executable.endsWith(".xml"))
        {
	        LoadConfig load = new LoadConfig(env);
	        load.setFile_silent(advancedVisible, env.executable);
			vtsetup.env.hasChanged=false;
			if(saveFile == null)
				 saveFile = new SaveConfig();
			saveFile.setFile(load.getFile());
		}
        VtEnv.UserManualView.setContentType("text/html; charset=EUC-JP");
        VtEnv.UserManualView.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);

    	env.ToolTipView.setContentType("text/html");
    	VtEnv.UserManualView.setEditable(false);
    	env.ToolTipView.setEditable(false);    

        try{
        	
        	VtEnv.UserManualView.setPage(new URL("file://"+UserManualPath));
        	env.getToolTip().removeAll();
        	env.getToolTip().add(env.ToolTipView);

        }catch(Exception e){
        	env.ToolTipView = env.ToolTipView;
        	env.ToolTipView.setText(Config.setToolTipString(mytext.getText("tooltip_default_title"),mytext.getText("tooltip_default") ));
        	env.getToolTip().removeAll();
        	env.getToolTip().add(env.ToolTipView);
        	Config.errorHandler(e);
        }  
        
        return editorScrollPane;
	}
	
	/*****
	 * method to reload the content
	 */
	public static void reloadContent()
	{
		
		Component comp = null;
		if(curPage == null)
		{
			comp = ((JViewport)((JScrollPane)splitPane_main.getComponent(1)).getComponent(0)).getComponent(0);
			
			if(comp.getClass() == JPanel.class)
			{
				comp = ((JPanel)comp).getComponent(1);
				if(((JPanel)comp).getComponent(0).getClass() == General.class || comp.getClass() == Grouping.class || comp.getClass() == Filtering.class)
					env.getGrpFiltWidget().getPanel(advancedVisible);
			}
			
		}
		else
		{
			comp = curPage.getPanel(advancedVisible);
			((JScrollPane)splitPane_main.getComponent(1)).getViewport().removeAll();
			((JScrollPane)splitPane_main.getComponent(1)).getViewport().add(comp);
		}
	}
	
/******
 * saves the current configuration with the help of the attribute {@link VtEnv VtEnv}
 * This method asks for filepath only if no filepath is known.   
 */
	public static void saveFile()
	{
		if(saveFile == null || saveFile.getFile() == null)
		{
    		saveFile = new SaveConfig();
    		saveFile.setFile();
		}
    	
    	if(saveFile.getFile() != null)
    		saveFile.SaveFile(env);
    	
    	env.hasChanged=false;
	}
	
	/******
	 * saves the current configuration with the help of the Attribute {@link VtEnv VtEnv}
	 */
	public static void saveFileAS()
	{
    	saveFile = new SaveConfig();
    	saveFile.setFile();
    	
    	if(saveFile.getFile() != null)
    		saveFile.SaveFile(env);
    	
    	env.hasChanged=false;
	}
	
	/*******
	 * Generates a script with the help of {@link VtEnv VtEnv} and the {@link GenerateScript GenerateScript} class.
	 * @param Regel is parameter given by the GenerateScript class, that sets what kind of script should be generated. 
	 * 
	 */
	public static void generate(int Regel)
	{
		
		if(generator == null)
			generator = new GenerateScript( env.getItems());
		if(generator.setFilename(Regel))
			generator.generate(env.getGrpFiltWidget());
	}
	
}
