/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package xmlObjects;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JPanel;



/*********
 * 
 * @author Mathias Korepkat
***/
/***
 * This class contains informations about a Item given by the gui_VTSetup.xml.
 */
public class Item {

	private boolean isdeprecated = false;
	private int priority = 999;
	private String descname=null;
	private boolean isadvanced = false;
	private Group group = null;
	private String envname =null;
	private String desc=null;
	
	private String warning=null;
	private ArrayList<ValDesc> valueL = new ArrayList<ValDesc>();
	
	private int major; 
	private int minor;
	private int patch;
	private boolean available = false;
	private String anchor=null;
	
	private Component comp = null;
	private Component valComp = null;
	
	
	/****
	 * 
	 * @param isdep true if the item is deprecated
	 * @param priority number of priority. low numbers are higher in priority then high numbers.
	 * @param descname Name that is shown in the gui.
	 * @param isadvanced true if it is an advanced setting otherwise false
	 * @param group group id of the group, this item belongs to.
	 * @param env environment name, used by vampirTrace. 
	 */
	public Item(boolean isdep, int priority,String descname,boolean isadvanced, Group group, String env)
	{
		this.isdeprecated = isdep;
		this.isadvanced = isadvanced;
		this.priority = priority;
		this.descname = descname;
		this.group = group;
		this.envname = env;
	}
	
	/* Set methods */
	public void setDesc(String desc)
	{
		this.desc = desc;
	}
	public void setAvailable(boolean avail)
	{
		this.available = avail;
	}
	public void setAnchor(String anchor)
	{
		this.anchor = anchor;
	}
	public void setWarning(String warning)
	{
		if(this.warning == null)
			this.warning = new String(warning);
		else
			this.warning = warning;
	}
	//set Value
	public Component getComponent()
	{
		return this.comp;
	}
	public void setComponent(Component comp)
	{
		this.comp = comp;
	}
	public Component getValComponent()
	{
		return this.valComp;
	}
	public void setValComponent(Component comp)
	{
		this.valComp = comp;
	}
	
	
	public void addValue(String type, String valDefault, String enumid, boolean noDefault, int min,int max)
	{
		ValDesc value = new ValDesc(type,valDefault,enumid,noDefault, min, max);
		valueL.add(value);
	}
	public void addValue(String type, String valDefault, String enumid, boolean noDefault)
	{
		ValDesc value = new ValDesc(type,valDefault,enumid,noDefault);
		valueL.add(value);
	}
	public void addValue(String type, String valDefault, String enumid)
	{
		ValDesc value = new ValDesc(type,valDefault,enumid);
		valueL.add(value);
	}
	public void addValue(String type, String valDefault, boolean noDefault)
	{
		ValDesc value = new ValDesc(type,valDefault,noDefault);
		valueL.add(value);
	}
	public void addValue(String type, String valDefault)
	{
		ValDesc value = new ValDesc(type,valDefault);
		valueL.add(value);
	}
	public void addValue(ValDesc valDesc)
	{
		valueL.add(valDesc);
	}
	
	//Set since
	public void setMajorSince(int major)
	{
		this.major = major;
	}
	public void setMinorSince(int minor)
	{
		this.minor = minor;
	}
	public void setPatchSince(int patch)
	{
		this.patch = patch;
	}
	public void setSince(int major,int minor, int patch)
	{
		this.major = major;
		this.minor = minor;
		this.patch = patch;
	}
	
	
	/* Get methods */
	public boolean isDeprecated()
	{
		return this.isdeprecated;
	}
	public boolean isAdvanced()
	{
		return this.isadvanced;
	}
	public boolean isAvailable()
	{
		return this.available;
	}

	public int getPriority()
	{
		return this.priority;
	}
	public String getDescname()
	{
		return this.descname;
	}
	public Group getGroup()
	{
		return this.group;
	}
	public String getEnvname()
	{
		return this.envname;
	}
	public String getDescription()
	{
		return this.desc;
	}
	public String getAnchor()
	{
		return this.anchor;
	}
	public int getSinceMajor()
	{
		return this.major;
	}
	public int getSinceMinor()
	{
		return this.minor;
	}
	public int getSincePatch()
	{
		return this.patch;
	}

	public String getWarning()
	{
		if(this.warning == null)
			return "";
		else
			return this.warning;
	}
	
	/**
	 * returns an ArrayList of all {@link ValDesc Value descriptions} of this item
	 * @return ArrayList of all ValueDescription
	 */
	public ArrayList<ValDesc> getValue()
	{
		return this.valueL;
	}
	
	
	/****
	 * Enables or disables the components of this item
	 * @param val true if the components are enabled otherwise false
	 */
	public void setEnabled(boolean val)
	{
		for(int i=0;i<this.valueL.size();i++)
		{
			this.valueL.get(i).getComponent().setEnabled(val);
			if(this.valueL.get(i).getComponent().getClass() == new JPanel().getClass())
			{
				for(int j=0;j<((JPanel)this.valueL.get(i).getComponent()).getComponentCount();j++)
				{
					((JPanel)this.valueL.get(i).getComponent()).getComponent(j).setEnabled(val);
					if(((JPanel)this.valueL.get(i).getComponent()).getComponent(j).getClass() == new JPanel().getClass())
					{
						for(int k=0;k<((JPanel)((JPanel)this.valueL.get(i).getComponent()).getComponent(j)).getComponentCount();k++)
						{
							((JPanel)((JPanel)this.valueL.get(i).getComponent()).getComponent(j)).getComponent(k).setEnabled(val);
						}
						
					}
				}
				
			}
			
			
		}
	}
	/****
	 * true if this item is set to its default
	 * @return true if this item is set to its default
	 */
	public boolean isDefault()
	{
		for(int i=0;i < valueL.size();i++)
		{
			if(!valueL.get(i).isDefault())
				return false;
		}
		return true;
	}
}