/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;

import help.Config;
import help.myMouseListener;
import help.Text;

import java.awt.BorderLayout;
import java.awt.Font;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import xmlObjects.Group;
import xmlObjects.VtEnv;


/***
 * Class to collect all grouping and filtering views and control it
 *
 */
public class GrpFiltWidget {

	private General general = null;
	private Grouping grouping = null;
	private Filtering filtering = null;
	private SymbolGroupTable sTable = null;
	private JViewport viewElement = null;
	public  int cur = -1;
	private Group group = null;
	private VtEnv env = null;
	private DefaultGroups defGroups = null;	
	private JLabel emptycell2 = new JLabel(" ");
	private Text mytext = null;


	/***
	 * initialization of this collection
	 * @param view viewport were the widgets are view
	 * @param group {@link Group Group} information for the Grouping and Filtering
	 * @param advanced true if this widget is in advanced view otherwise false
	 * @param toolTip JEditorPane to view setting informations
	 */
	public GrpFiltWidget(JViewport view,Group group,boolean advanced,VtEnv env,Text mytext,String defGroupsPath)
	{
		defGroups = new DefaultGroups(defGroupsPath);
		this.mytext = mytext;
		this.env = env;
		sTable = new SymbolGroupTable(mytext);
		myMouseListener l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString("SimbolTable", "This Table shows you all Symbols on which you can generate filter and group files."));
		sTable.addMouseListener(l);
		sTable.setDefGroups(defGroups);
		general = new General(sTable,group,advanced,env,mytext);
		grouping = new Grouping(sTable,env,defGroups,mytext);
		filtering = new Filtering(sTable,env,defGroups,mytext);
		viewElement = view;
		this.group = group;
		
	}
	
	/***
	 * show the {@link General General} class
	 * @param advanced true if this widget is in advanced view otherwise false
	 */
	public void setGeneral(boolean advanced)
	{
		this.cur = 1;
		JPanel output = new JPanel();
		output.setLayout(new BorderLayout());
		output.add(getTopPanel(),BorderLayout.NORTH);
		grouping.setSTable(sTable);
		general.setSTable(sTable);
		
		JPanel help = new JPanel(new BorderLayout());
		help.add(general.getPanel(advanced),BorderLayout.NORTH);
		output.add(help,BorderLayout.CENTER);

		
		viewElement.removeAll();
		viewElement.add(output);
	}
	
	/***
	 * show the {@link Grouping Grouping} class
	 */
	public void setGrouping(boolean advanced)
	{
		this.cur = 2;
		JPanel output = new JPanel();
		output.setLayout(new BorderLayout());
		output.add(getTopPanel(),BorderLayout.NORTH);
		if(sTable.simbolIsSet)
		{
			grouping.setSTable(sTable);
			output.add(grouping.getPanel(advanced),BorderLayout.CENTER);
		}
		else
		{
			noSymbols help = new noSymbols(mytext,this,advanced,group,"");
			output.add(help,BorderLayout.CENTER);
		}
		viewElement.removeAll();
		viewElement.add(output);

	}
	
	/***
	 * show the {@link Filtering Filtering} class
	 */
	public void setFiltering(boolean advanced)
	{
		this.cur = 3;
		

			JPanel output = new JPanel();
			output.setLayout(new BorderLayout());
			
			output.add(getTopPanel(),BorderLayout.NORTH);
			if(sTable.simbolIsSet)
			{
				filtering.setSTable(sTable);
				output.add(filtering.getPanel(advanced),BorderLayout.CENTER);
			}
			else
			{	
				noSymbols help = new noSymbols(mytext,this,advanced,group,"");
				output.add(help,BorderLayout.CENTER);
			}
			emptycell2.setVisible(!advanced);
				
		
		viewElement.removeAll();
		viewElement.add(output);
	}
	
	/***
	 * returns the current {@link SymbolGroupTable SymbolGroupTable}
	 * @return {@link SymbolGroupTable SymbolGroupTable}
	 */
	public SymbolGroupTable getSymbolGroupTable()
	{
		return sTable;
	}
	
	/***
	 * sets the viewport
	 * @param view viewport were the widgets are shown that appears in the main window
	 */
	public void setViewport(JViewport view)
	{
		this.viewElement = view;
	}
	
	/***
	 * returns the current Panel
	 * @param advancedVisible true if this widget is in advanced view otherwise false
	 */
	public void getPanel(boolean advancedVisible)
	{
		switch(cur)
		{
			case 1:	setGeneral(advancedVisible);break;
			case 2:	setGrouping(advancedVisible);break;
			case 3:	setFiltering(advancedVisible);break;
		}
	}
	
	/***
	 * generates a Panel that appears as timeline at the top of this widget
	 * @return Panel with informations about current step
	 */
	private JPanel getTopPanel()
	{
		JPanel output = new JPanel();
		output.setLayout(new BoxLayout(output, BoxLayout.PAGE_AXIS));
		JLabel title = new JLabel(" Filtering and Grouping");
		title.setFont(title.getFont().deriveFont(Font.BOLD));
		title.setFont(title.getFont().deriveFont((float)22));
		output.add(title);
		JLabel emptycell = new JLabel("  ");
		emptycell.setFont(title.getFont());
		output.add(emptycell);
		JLabel subtitle = new JLabel();
		switch(cur)
		{
			case 1:	subtitle.setText(this.mytext.getText("left_Menu_fltGrp_General"));break;
			case 2:	subtitle.setText(this.mytext.getText("left_Menu_fltGrp_Grouping"));break;
			case 3:	subtitle.setText(this.mytext.getText("left_Menu_fltGrp_Filtering"));break;
		}
		subtitle.setFont(title.getFont().deriveFont(Font.BOLD));
		subtitle.setFont(title.getFont().deriveFont((float)20));
		
		output.add(subtitle);
		

		
		emptycell2.setFont(subtitle.getFont());
		output.add(emptycell2);
		
		return output;
		
	}
	
	/***
	 * set this widget to default settings
	 */
	public void setDefault()
	{
		sTable = new SymbolGroupTable(mytext);
		myMouseListener l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString("SimbolTable", "This Table shows you all Symbols on which you can generate filter and group files."));
		sTable.addMouseListener(l);
		sTable.setDefGroups(defGroups);
		boolean repaint = false;
		
		if(general.isShowing()|| grouping.isShowing() || filtering.isShowing())
			repaint = true;
		
		general = new General(sTable,group,false,env,mytext);
		grouping = new Grouping(sTable,env,defGroups,mytext);
		filtering = new Filtering(sTable,env,defGroups,mytext);
		if(repaint)
		{
			getPanel(false);
		}
	}
	
	/***
	 * Generates a filter and a group file
	 * @param groupFile file path were the group file should be saved
	 * @param filterFile file path were the  filter file should be saved
	 */
	public void generateFilterFile(String groupFile,String filterFile)
	{
			BufferedWriter out = null;
			filtering.generateFilterFile(filterFile);
			if(groupFile != null && !groupFile.trim().equals(""))
			{
				try{
					out = new BufferedWriter(
			                new OutputStreamWriter(
			                        new FileOutputStream( groupFile ) 
			                        ) 
			        );
	
				out.write(grouping.generateGroupFile());
				
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
				
				try{
					if(out != null)
						out.close();
				}catch(Exception ex)
				{
					Config.errorHandler(ex);
				}
			}				
			
			
	}
	
	
	/***
	 * Generates a string that can be saved and used to restore the settings
	 * @return String with informations about grouping and filtering
	 */
	public String saveFile()
	{
		String output="";
		output += grouping.generateSaveString(); 
		output += "\n######\n";
		output += filtering.generateSaveString();
		return output;
	}
	
	
	/***
	 * restore settings with the help of loadString and repaint widget if it is currently shown
	 * @param loadString String that contains information to restore settings
	 * @param advanced true if this widget is in advanced view otherwise false
	 */
	public void loadFile(String loadString,boolean advanced)
	{
		boolean repaint = false;
		if(
				(viewElement != null && viewElement.getComponentCount() > 0 && viewElement.getComponent(0) != null && 
				((JPanel)viewElement.getComponent(0)).getComponentCount() > 1 &&
				((JPanel)viewElement.getComponent(0)).getComponent(1) != null)
				&&
				(
				((JPanel)viewElement.getComponent(0)).getComponent(1) == general || 
				((JPanel)viewElement.getComponent(0)).getComponent(1) == grouping ||
				((JPanel)viewElement.getComponent(0)).getComponent(1) == filtering
				)
			)
			repaint = true;
		
		sTable = new SymbolGroupTable(mytext);
		myMouseListener l = new myMouseListener();
		l.setToolTip(env);
		l.setText(Config.setToolTipString("SimbolTable", "This Table shows you all Symbols on which you can generate filter and group files."));
		sTable.addMouseListener(l);
		sTable.setDefGroups(defGroups);
		general = new General(sTable,group,advanced,env,mytext);
		grouping = new Grouping(sTable,env,defGroups,mytext);
		filtering = new Filtering(sTable,env,defGroups,mytext);
		
		
		if(loadString != null && loadString.contains("######"))
		{
			String[] array = loadString.split("######");
			grouping.loadSettings(array[0]);
			filtering.loadSettings(array[1],sTable);
		}
		
		if(repaint)
		{
			switch(cur)
			{
				case 1:	setGeneral(advanced);break;
				case 2:	setGrouping(advanced);break;
				case 3:	setFiltering(advanced);break;
			}
		}
	}
}

