/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package grpFilt;


import help.Text;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import xmlObjects.Group;
import xmlObjects.VtEnv;



/****
 * 	Is a Panel that contains all Components and Gui elements for grouping.
 */
public class noSymbols extends javax.swing.JPanel{

	/**
	 * generated Serial finalVersionUID
	 */
	private static final long serialVersionUID = -2195660139809147848L;
	
	/****
	 * initialize all components of this widget
	 * @param sTable SymbolGroupTable used by this class and General and Filtering class.
	 * @param toolTip a panel that is used to show information about setting options
	 * @param defGroups this {@link DefaultGroups Class} contains all informations about default simbols and groups
	 */
	public noSymbols(Text text,final GrpFiltWidget widget,final boolean advanced,final Group curPage,final String group)
	{	
		
		JPanel panel = new JPanel(new GridBagLayout());
		//panel.setBorder(BorderFactory.createTitledBorder("Warning"));
		panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), "Warning", TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
		GridBagConstraints c = new GridBagConstraints();	
		this.setLayout(new BorderLayout());
		
		c.gridx=c.gridy=0;
		c.insets = new Insets(10,10,10,20);
		c.anchor = GridBagConstraints.FIRST_LINE_START;
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 1;
		
		JLabel label = new JLabel(text.getText("nSymbols_label"));
		
		
		
		label.setFont(label.getFont().deriveFont(Font.BOLD));
		label.setFont(label.getFont().deriveFont((float)22));
		JButton button = new JButton(text.getText("nSymbols_button"));
		panel.add(label,c);
		
		c.gridy++;
		c.weightx = 0;
		c.fill = GridBagConstraints.NONE;
		panel.add(button,c);
		panel.setPreferredSize(null);
		this.add(panel,BorderLayout.NORTH);
		panel.setPreferredSize(new Dimension(100,200));
		
		button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e)
			{
				
				VtEnv.menu.setText(VtEnv.getMenu(advanced, null, "general"));
				widget.setGeneral(advanced);
				widget.cur = 1;
			}
		});
	}

}
