/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;

import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;



import xmlObjects.Group;
import xmlObjects.Item;
import xmlObjects.ValDesc;
import xmlObjects.VtEnv;


import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;

import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;


import org.w3c.dom.Document;
import org.w3c.dom.Element;

/***
 * Class to save current settings.
 */
public class SaveConfig {
	private String file = null;

	public SaveConfig() {
		;
	}

	/****
	 * opens a file dialog to set the filename
	 */
	public void setFile() {
		JFileChooser chooser = new JFileChooser();
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setLocale(Locale.ENGLISH);
		chooser.setMultiSelectionEnabled(false);

		FileNameExtensionFilter filter = new FileNameExtensionFilter("XML",
				"xml");
		chooser.removeChoosableFileFilter(chooser.getChoosableFileFilters()[0]);
		chooser.addChoosableFileFilter(filter);

		File f = null;
		try {
			f = new File(new File(".").getCanonicalPath());
			chooser.setCurrentDirectory(f);
		} catch (Exception ex) {
			Config.errorHandler(ex);
		}

		chooser.showSaveDialog(null);

		if (chooser.getSelectedFile() != null) {
			try {
				this.file = chooser.getSelectedFile().getCanonicalPath();
				if (!this.file.endsWith(".xml")) {
					this.file += ".xml";
				}
			} catch (Exception e) {
				Config.errorHandler(e);
			}
		}
	}

	/***
	 * returns the file path 
	 * @return path to the file that was saved lastly
	 */
	public String getFile() {
		return file;
	}

	/***
	 * set the file path 
	 * @param file path to the file that was saved lastly
	 */
	public void setFile(String file) {
		if(this.file == null)
			this.file = new String();
		this.file = file;
	}
	/**
	 * This method is used by SaveFile to create a xml document from the
	 * environment
	 * 
	 * @param env environment with all settings that should be saved
	 * @return Document in a xml structure.
	 */
	private Document setDocument(VtEnv env) {
		DocumentBuilderFactory docBFac;
		DocumentBuilder docBuild;
		Document doc = null;

		try {
			docBFac = DocumentBuilderFactory.newInstance();
			docBuild = docBFac.newDocumentBuilder();
			doc = docBuild.newDocument();
			doc.createComment("VTSetup config file");
		} catch (Exception e) {
			Config.errorHandler(e);
		}
		if (doc == null)
			return null;

		ArrayList<Group> groups = env.getAllGroups();
		Element root = doc.createElement("vtconfig");

		Element vers = doc.createElement("version");
		vers.setAttribute("vtversion", env.getVtversion());
		vers.setAttribute("vtconfigversion", "1.0");
		root.appendChild(vers);

		for (int i = 0; i < groups.size(); i++) {
			ArrayList<Item> items = groups.get(i).getItems();

			for (int j = 0; j < items.size(); j++) {
				Element item = doc.createElement("item");

				Element name = doc.createElement("name");
				name.setTextContent(items.get(j).getEnvname());
				item.appendChild(name);

				ArrayList<ValDesc> values = items.get(j).getValue();
				for (int k = 0; k < values.size(); k++) {
					Element val = doc.createElement("value");
					val.setAttribute("type", values.get(k).getType());

					Element def = doc.createElement("default");
					def.setTextContent(values.get(k).getValue());

					Element cur = doc.createElement("current");
					cur.setTextContent(values.get(k).getCurrent());

					val.appendChild(def);
					val.appendChild(cur);
					item.appendChild(val);
				}

				root.appendChild(item);
			}
		}

		// save group and filter settings.
		Element item = doc.createElement("grpFilt");
		if (env.getGrpFiltWidget() == null) {
			item.setTextContent("");
		} else
			item.setTextContent(env.getGrpFiltWidget().saveFile());

		root.appendChild(item);

		doc.appendChild(root);

		return doc;

	}

	/***
	 * Save the document created with the {@link #setDocument(VtEnv) setDocument} method
	 * 
	 * @param env environment with all elements that should be saved.
	 */
	public void SaveFile(VtEnv env) {

		if (file != null) {
			try {

			    
				TransformerFactory transformerFactory = TransformerFactory
						.newInstance();

				transformerFactory.setAttribute("indent-number", new Integer(2));
				Transformer transformer = transformerFactory.newTransformer();
				transformer.setOutputProperty(OutputKeys.INDENT, "yes");
				transformer.setOutputProperty(OutputKeys.METHOD, "xml");
				transformer.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
				
				DOMSource source = new DOMSource(setDocument(env));
				StreamResult result = new StreamResult(file);
				transformer.transform(source, result);
				env.hasChanged = false;

			} catch (Exception ex) {
				Config.errorHandler(ex);
			}
		}
	}
}
