/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2011, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package xmlObjects;

import help.Config;
import help.Convertions;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Hashtable;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.ListCellRenderer;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import widgets.CounterWidget;
import widgets.FloatPanel;
import widgets.IntegerPanel;
import widgets.myFileDialog;



/***
 *	This class contains informations about a group given by the gui_VTSetup.xml.
 * 
 */

public class Group {
		
		//Required Values 
		private String identifier = null;
		private String descname= null;
		private int priority = 9999;
		private String desc = null;
		private ArrayList<Integer> IndexSmallElements = new ArrayList<Integer>();
		ArrayList<Integer> nAvailComp = new ArrayList<Integer>();
		/***
		 * if this group is a subgroup, the attribute hasParent is set true 
		 */
		private boolean hasParent = false;
		
		/***
		 * SubGroups contains all Groups that are subgroups of this group
		 */
		private ArrayList<Group> subGroups = new ArrayList<Group>();
		/***
		 * items contains all items of this group
		 */
		private ArrayList<Item> items = new ArrayList<Item>();
		
		private ArrayList<Component> componentsList = new ArrayList<Component>();
		ArrayList<Integer> advancedID = new ArrayList<Integer>();
		Hashtable<Integer,Integer> subGroupInPanel = new Hashtable<Integer,Integer>();
		public boolean hasadvancedview = false;
		public boolean hasdefaultview = false;
		
		private VtEnv vtenv = null;
		
		private GridBagConstraints c = new GridBagConstraints();
		
		
		/***
		 * initialization of class Group
		 * @param id unique group id
		 * @param descname name that is shown in the gui
		 * @param priority position in the menu 
		 * @param vtenv environment of type {@link VtEnv VtEnv}
		 */
		public Group(String id,String descname,int priority,VtEnv vtenv)
		{
			this.identifier = new String(id);
			this.descname = new String(descname);
			this.priority = priority;
			this.vtenv = vtenv;
		}
		
		public Group() {
			;
		}

		/*****
		 * Add a subgroup to this group
		 * @param group new subgroup that should be added to this group
		 */
		public void addSubGroup(Group group)
		{
			this.subGroups.add(group);
		}
		
		/***
		 * set description for this group
		 * @param desc descriptipn of this group
		 */
		public void setDesc(String desc)
		{
			this.desc = desc;
		}
		
		/***
		 * Add an Item to this Group
		 * @param item Item that should be added to this group 
		 */
		public void addItems(Item item)
		{
			this.items.add(item);
		}
		/****
		 * Add an Item to this Group
		 * @param k position of the Item in the items ArrayList
		 * @param item item that is add.
		 */
		public void addItems(int k,Item item)
		{
			this.items.add(k,item);
		}
		
		/***
		 * set if this group has an parent group or not
		 * @param b true if this group is an sub group of another
		 */
		public void setHasParent(boolean b)
		{
			this.hasParent = b;
		}

		/**
		 * return the unique group id
		 * @return the group id
		 * @throws Exception if group id is null
		 */
		public String getId() throws Exception
		{
			if(this.identifier == null)
				throw new Exception("Error: no identifier");
			return this.identifier;
		}
		

		/**
		 * return the group name
		 * @return the group name
		 * @throws Exception if group name is null
		 */
		public String getName() throws Exception
		{
			if(this.descname == null )
				throw new Exception("Error: no name defined");
			return this.descname;
		}
		
		/**
		 * return the priority of this group
		 * @return returns the priority
		 */
		public int getPriority()
		{
			return this.priority;
		}
		
		/**
		 * return the full Description of this Group
		 * @return group description
		 * @throws Exception if description is null
		 */
		public String getDescription() throws Exception
		{
			if(this.desc == null)
				throw new Exception("Error: there is no discriotion");
			return this.desc;
		}

		/***
		 * return an ArrayList of all Groups that are sub groups of this group
		 * @return ArrayList of all sub groups
		 */
		public ArrayList<Group> getSubGroups()
		{
			return this.subGroups;
		}
		
		/**
		 * returns an ArrayList of all Items of this group
		 * @return ArrayLost of all group items
		 */
		public ArrayList<Item> getItems()
		{
			return this.items;
		}

		
		/*****
		 * Creates a Component with all Gui elements for this Group and there subgroups
		 * @param advanced true if the view is in advanced mode, false if the advanced settings are hidden
		 * @return JPanel component with all GuiElements of this Group and there SubGroups 
		 */
		
		public JPanel getPanel(boolean advanced)
		{
			
			
			if(this.componentsList.isEmpty())
			{
				JPanel panel = new JPanel(new GridLayout(0,2,0,0));			
				

				JLabel head = new JLabel();
				head.setText(this.descname.trim());
				if(!this.hasParent)
				{
					head.setFont(head.getFont().deriveFont(Font.BOLD));
					head.setFont(head.getFont().deriveFont((float)20.1));
					panel.add(head);
					componentsList.add(head);
					componentsList.add(null);
				}

				addItems(panel,this.items);
				
				// ******** add subgroups ********** /
				for(int k=0;k<this.subGroups.size();k++)
				{
					if(this.subGroups.get(k).getItems().isEmpty())
						continue;
					componentsList.add(null);
				
				//	panel.add(this.subGroups.get(k).getPanel(advanced));
					JPanel compHelp = this.subGroups.get(k).getPanel(false);
					if(compHelp.getComponentCount() == 1)
					{
						if(((JPanel) compHelp.getComponent(0)).getComponentCount() == 0)
							nAvailComp.add(componentsList.size());
					}
						componentsList.add(this.subGroups.get(k).getPanel(true));
						subGroupInPanel.put(componentsList.size()-1, k);
						componentsList.add(null);
						if(!hasadvancedview && subGroups.get(k).hasadvancedview)
							hasadvancedview = true;
						if(!hasdefaultview && subGroups.get(k).hasdefaultview)
							hasdefaultview = true;
					
					JLabel blankLabel = new JLabel("  ");
					blankLabel.setPreferredSize(new Dimension(1,1));

				}
				
			}
			
			
			JPanel returnPanel = new JPanel(new BorderLayout());
			JPanel resgui = new JPanel(new GridBagLayout());
			//returnPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
			
			
			
			if(!this.hasParent)
			{
				c.insets = new Insets(10,10,10,10);
			}
			
			
			c.gridx = 0;
			c.gridy = 0;
			c.fill = GridBagConstraints.HORIZONTAL;
			c.anchor = GridBagConstraints.WEST;
			
			if(advanced)
			{
				for(int i=0;i<this.componentsList.size();i++)
				{
					
					// get Panel from subGroup
					if(subGroupInPanel.containsKey(i))
					{
						JPanel comp = subGroups.get(subGroupInPanel.get(i)).getPanel(true);
						
						if(comp.getComponentCount() == 0)
							continue;
						c.gridwidth=2;
						c.weightx = 1;
						resgui.add(comp,c);
						c.weightx = 0;
						c.gridx++;
						c.gridwidth = 1;

						continue;
					}
					
					// Add Elements from this group
					if(this.componentsList.get(i) != null)
					{
						if(c.gridx == 0 && this.componentsList.get(i+1) == null)
							c.gridwidth = 2;
						else
							c.gridwidth = 1;
						Component comp = this.componentsList.get(i);
						if(comp.getClass() == new JLabel().getClass())
						{
							//resize labels in front...
							comp.setPreferredSize(new Dimension(VtEnv.maxLabelWidth_adv,comp.getPreferredSize().height));
							c.weightx = 0;
							c.anchor = GridBagConstraints.WEST;
						}
						resgui.add(comp,c);
						c.weightx = 1;
						c.gridx++;
					}
					else
					{
						c.gridx = 0;
						c.gridy++;
					}
				}
			}
			else
			{
				for(int i=0;i<this.componentsList.size();i++)
				{
					if(nAvailComp.contains(i))
						continue;
					
					if(subGroupInPanel.containsKey(i))
					{
						JPanel comp = subGroups.get(subGroupInPanel.get(i)).getPanel(false);
						if(comp.getComponentCount() == 2)
							continue;
						
						if(comp.getComponentCount() == 0)
							continue;
						c.gridwidth=2;
						resgui.add(comp,c);
						c.gridx++;
						c.gridwidth = 1;
						continue;
					}
					
					if(!advancedID.contains(i))
					{
						if(this.componentsList.get(i) != null)
						{
							if(c.gridx == 0 && this.componentsList.get(i+1) == null)
								c.gridwidth = 2;
							else
								c.gridwidth = 1;
							Component comp = this.componentsList.get(i);
							if(comp.getClass() == new JLabel().getClass())
							{
								//resize labels in front...
								comp.setPreferredSize(new Dimension(VtEnv.maxLabelWidth,comp.getPreferredSize().height));
								c.weightx = 0;
								c.anchor = GridBagConstraints.WEST;
							}
							resgui.add(comp,c);
							c.weightx = 1;
							c.gridx++;
						}
						else
						{
							c.gridx = 0;
							c.gridy++;
						}
					}
				}
				
			}
			
			returnPanel.add(resgui,BorderLayout.NORTH);
			
			if(this.hasParent)
			{
				returnPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0,Color.GRAY), this.descname.trim(), TitledBorder.DEFAULT_JUSTIFICATION,TitledBorder.DEFAULT_POSITION));
				if(!advanced && !hasdefaultview)
					return new JPanel();
			}
			
		//
			/*
			for(int i=0;i<this.items.size();i++)
			{
				if(!(items.get(i).isAvailable()) &&!advanced)
					items.get(i).setVisible(false);
				else
					items.get(i).setVisible(true);
			}
			*/
		/*		
			//	 
				if(returnPanel.getPreferredSize().width < Config.subGroup_min_width)
					returnPanel.setPreferredSize(new Dimension(Config.subGroup_min_width, returnPanel.getPreferredSize().height));
				if(!advanced && !hasdefaultview)
					return new JPanel();
			}else
			{
				if(returnPanel.getPreferredSize().width < Config.subGroup_min_width+10)
					returnPanel.setPreferredSize(new Dimension(Config.subGroup_min_width+10, returnPanel.getPreferredSize().height));
			}
			*/
			
			
			return returnPanel;
		}
		
		
		
		/*****
		 * Method is used by getPanel to add items and there Components to the groupPanel.
		 * @param orgPanel current Panel 
		 * @param items List of all Items in that should be add.
		 */
		private JPanel addItems(JPanel orgPanel,final ArrayList<Item> items)
		{
			hasdefaultview = false;
			hasadvancedview = false;
			boolean isResized = false;
			for(int i=0;i<items.size();i++)
			{
				isResized = false;
				JPanel panel = new JPanel(new GridBagLayout());
				GridBagConstraints d = new GridBagConstraints();
				d.fill = GridBagConstraints.HORIZONTAL;
				d.insets = new Insets(5,5,5,5);
				d.anchor = GridBagConstraints.WEST;
				panel.setBorder(BorderFactory.createEmptyBorder());
				final String NAME_TEMP = items.get(i).getDescname(); //TODO VALNA
				
				for(int m=0;m<items.get(i).getValue().size();m++)
				{
					d.weightx = 0;
					ValDesc val = items.get(i).getValue().get(m);
					
					if(val.getType().trim().compareTo("special") == 0)
					{
						try{
							Component comp = addSpecial(items.get(i));
							d.weightx = 1;
							isResized = true;
							panel.add(comp,d);
							d.weightx = 0;
							val.setComponent(comp);
							
						}catch(Exception ex)
						{
							Config.errorHandler(ex);
						}
					}
					// ****** If item is bool ***** /
					if(val.getType().trim().compareTo("bool") == 0)
					{
						JCheckBox check = new JCheckBox("");
						if(val.getValue().compareTo("1")==0)
							check.setSelected(true);
						
						check.addChangeListener(new ChangeListener(){
							public void stateChanged(ChangeEvent e){
								vtenv.hasChanged=true;}
						});
						panel.add(check,d);
						val.setComponent(check);
						
						
					}
					
					
					// ****** If item is string ***** /
					if(val.getType().trim().compareTo("string") == 0)
					{
						JFormattedTextField text = new JFormattedTextField();
		//					text.setColumns(25);
						text.setText(val.getValue());
						d.weightx = 1;
						isResized = true;
						panel.add(text,d);
						val.setComponent(text);
						text.addCaretListener(new CaretListener(){
							public void caretUpdate(CaretEvent e){
								vtenv.hasChanged=true;
								;}
						});
						
					}
					
					// ****** If item is path ***** /
					if(val.getType().trim().compareTo("path") == 0 || val.getType().trim().compareTo("filepath") == 0)
					{			
						
						String defaultVal =val.getValue();
						myFileDialog fdialog = new myFileDialog(defaultVal);
												
						fdialog.setIObehavior(val.getIOBehavior());
						
						if(val.getType().trim().compareTo("filepath") == 0)
							fdialog.setIsFile(true);
						if(val.getType().trim().compareTo("path") == 0)
							fdialog.setIsPath(true);
						fdialog.showDialog();
						
						
						((JFormattedTextField)fdialog.getComponent(0)).addCaretListener(new CaretListener(){
							public void caretUpdate(CaretEvent e){
								vtenv.hasChanged=true;
								}
						});
						((JButton)fdialog.getComponent(1)).addActionListener(new ActionListener()
						{
							public void actionPerformed(ActionEvent e){
								vtenv.hasChanged=true;}
						});
						d.weightx = 1;
						isResized = true;
						panel.add(fdialog,d);
						val.setComponent(fdialog);
					
											
					}
					
					// ****** If item is integer ***** /
					if(val.getType().trim().compareTo("integer") == 0)
					{	
						if(val.isRangeSet() && val.getMax() <= 100000)
						{
							
							
							long min,max;
							try{
								min = (long) Math.ceil(val.getMin());
								max = (long) Math.ceil(val.getMax());
							}catch(Exception e)
							{
								Config.errorHandler(e);
								min=Long.MIN_VALUE;
								max=Long.MAX_VALUE;
								
							}
							long def = Convertions.getLong(val.getValue());
							IntegerPanel intPanel = new IntegerPanel(min, max, def);
							
							((JSlider)intPanel.getComponent(0)).addChangeListener(new ChangeListener(){
							public void stateChanged(ChangeEvent e){
								vtenv.hasChanged=true;}
						});
							((JFormattedTextField)intPanel.getComponent(1)).addCaretListener(new CaretListener(){
								public void caretUpdate(CaretEvent e){
									vtenv.hasChanged=true;
									}
							});

							panel.add(intPanel,d);
							panel.add(new JLabel(""),d);
							val.setComponent(intPanel);
						}
						else
						{
							
							
							
							
							final JFormattedTextField text = new JFormattedTextField();
							text.addCaretListener(new CaretListener(){
								public void caretUpdate(CaretEvent e){
									vtenv.hasChanged=true;
									}
							});
							
							text.setText(val.getValue());
							d.weightx = 1;
							isResized = true;
							panel.add(text,d);

							val.setComponent(text);
													
							text.addKeyListener(new KeyListener(){
								public void keyPressed(KeyEvent e) {;}
	
								
								public void keyReleased(KeyEvent e) {
									int key = (int) e.getKeyChar();
									if(key >= 32 && key <= 126)
									{
										text.setText(Convertions.validateAsNumber(text.getText()));
									}
									
								}
	
								
								public void keyTyped(KeyEvent e) {;}
	
								
							});
						}
					}
					
	//				 ****** If item is float ***** /
					if(val.getType().trim().compareTo("float") == 0)
					{	
						if(val.isRangeSet() && val.getMax() <= 100000)
						{
							
							double min,max;
							try{
								min = (double)val.getMin();
								max = (double)val.getMax();
							}catch(Exception e)
							{
								Config.errorHandler(e);
								min=Double.MIN_VALUE;
								max=Double.MAX_VALUE;;
								
							}

							double def = Convertions.getDouble(val.getValue());
							FloatPanel floatPanel = new FloatPanel(min, max, def);
							

							((JSlider)floatPanel.getComponent(0)).addChangeListener(new ChangeListener(){
							public void stateChanged(ChangeEvent e){
								vtenv.hasChanged=true;}
						});
							((JFormattedTextField)floatPanel.getComponent(0)).addCaretListener(new CaretListener(){
								public void caretUpdate(CaretEvent e){
									vtenv.hasChanged=true;
									}
							});
							
							panel.add(floatPanel,d);
							panel.add(new JLabel(""),d);
							val.setComponent(floatPanel);
						}
						else
						{
							
							JFormattedTextField text = new JFormattedTextField();
							text.addCaretListener(new CaretListener(){
								public void caretUpdate(CaretEvent e){
									vtenv.hasChanged=true;
									;}
							});
							d.weightx = 1;
							isResized = true;
							text.setText(val.getValue());
							panel.add(text);
							val.setComponent(text);
						}					
					}
					
					// ************* If item is Enum ***********/
					if(val.getType().trim().compareTo("enum") == 0)
					{
						
						EnumClass myenum = null;
						try{
							myenum = vtenv.getEnumById(val.getEnumId());
						}catch(Exception e)
						{
							Config.errorHandler(e);
						}
						
						
						JComboBox combo = new JComboBox(myenum.getEntrys().toArray());
						combo.setSelectedIndex(myenum.getEntrys().indexOf(val.getValue()));
						if(items.get(i).getEnvname().trim().equals("VT_BUFFER_SIZE"))
							combo.setRenderer(new ListCellRenderer(){

								@Override
								public Component getListCellRendererComponent(
										JList arg0, Object arg1, int arg2,
										boolean arg3, boolean arg4) {
									JLabel out = new JLabel(arg1.toString()+"B");
									out.setBackground(arg0.getBackground());
									out.setForeground(arg0.getForeground());
									if(arg3)
									{
										out.setOpaque(true);
										out.setBackground(arg0.getSelectionBackground());
										out.setForeground(arg0.getSelectionForeground());
										
										
									}
									return out;
								}
								
							});
						
						combo.addActionListener(new ActionListener(){
							public void actionPerformed(ActionEvent e){
										vtenv.hasChanged=true;
							}
						});
						
						combo.setAlignmentX(Component.LEFT_ALIGNMENT);
						d.anchor = GridBagConstraints.LINE_START;
						panel.add(combo,d);
						val.setComponent(combo);
					}
					
					// ************* If item is Enumselect ***********/
					if(val.getType().trim().compareTo("enumselection") == 0)
					{
						EnumSelectionClass myenum = null;
						try{
							myenum = vtenv.getEnumSelectionById(val.getEnumId());
						}catch(Exception e)
						{
							Config.errorHandler(e);
						}
						
						
						String help1 = val.getValue();
						String valDefault[] = {};
						if(help1 != null)
						{
							valDefault = help1.split(";");
						}
						
						
						final JPanel enumsel = new JPanel(new GridBagLayout());
						
						GridBagConstraints gbc = new GridBagConstraints();
						
						gbc.gridx = gbc.gridy = 0;
						gbc.anchor = GridBagConstraints.LINE_START;
						enumsel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
						for(int j=0;j < myenum.getEntrys().size();j++)
						{
							JCheckBox check = new JCheckBox(myenum.getEntrys().get(j));
							check.setSelected(false);
							check.addChangeListener(new ChangeListener(){
								public void stateChanged(ChangeEvent e){
									vtenv.hasChanged=true;}
							});
							
							
							for(int k=0; k < valDefault.length;k++)
							{
								if(valDefault[k].compareTo(myenum.getEntrys().get(j))==0)
								{
									check.setSelected(true);
									break;
								}
							}

							enumsel.add(check,gbc);
							if(gbc.gridx == 3)
								gbc.gridy++;
							gbc.gridx = (gbc.gridx +1)%4;
							if(myenum.isOneRequired())
								check.addMouseListener(new MouseListener(){

									public void mouseClicked(MouseEvent e) {
										boolean flag = true;
										for(int i=0; i<enumsel.getComponentCount();i++)
										{
											
											if(((JCheckBox)enumsel.getComponent(i)).isSelected())
											{
												flag = false;
												break;
											}
										}
										if(flag)
										{
											JOptionPane.showMessageDialog(null, "At least one is required!", "Warning", JOptionPane.WARNING_MESSAGE);
											((JCheckBox)e.getSource()).setSelected(true);
										}
										
										
									;}
									public void mouseEntered(MouseEvent e) {;}
									public void mouseExited(MouseEvent e) {;}
									public void mousePressed(MouseEvent e) {;}
									public void mouseReleased(MouseEvent e) {;}
									
								});
						}
	
					
						panel.add(enumsel,d);
						
						val.setComponent(enumsel);
					}
					
				}
				
				if(panel.getComponentCount() != 0)
				{
					
					JLabel label = new JLabel(items.get(i).getDescname()+": ");

					
					if(items.get(i).isAdvanced())
					{
						ImageIcon advanced = new ImageIcon(Group.class.getClass().getResource(VtEnv.srcFolder+Config.Image_ADVANCED));
						
						Image img = advanced.getImage();  
						BufferedImage bi = new BufferedImage(20, 20, BufferedImage.TYPE_INT_ARGB);  
						Graphics g = bi.createGraphics();  
						g.drawImage(img, 0, 0, 20, 20, null, null);  
						
						Icon newadvanced = new ImageIcon(bi); 
						label.setIcon(newadvanced);
						label.setFont(label.getFont().deriveFont(Font.BOLD));
					}else
					{
						if(VtEnv.maxLabelWidth < label.getPreferredSize().width)
							VtEnv.maxLabelWidth = label.getPreferredSize().width;
					}
						
					
					if(items.get(i).getDescname().trim().equals(""))
						label.setText("");
					
					if(VtEnv.maxLabelWidth_adv < label.getPreferredSize().width)
					{
						VtEnv.maxLabelWidth_adv = label.getPreferredSize().width;
					}
					
					JPanel help = new JPanel(new GridBagLayout());
					GridBagConstraints c = new GridBagConstraints();
					
					c.fill = GridBagConstraints.HORIZONTAL;
					if(isResized)
					{
						c.fill = GridBagConstraints.HORIZONTAL;
						c.weightx = 1;
					}
					else
						c.weightx = 0;

					c.anchor = GridBagConstraints.WEST;
					c.gridx = c.gridy=0;
					
			//		panel.setBorder(BorderFactory.createEtchedBorder());
			//		help.setBorder(BorderFactory.createEtchedBorder());
					help.add(panel,c);
					
					c.gridx=1;
					c.weightx = 0;
					//add help button
					Icon helpicon = new ImageIcon(Group.class.getClass().getResource(VtEnv.srcFolder+Config.Image_BROWSER));
					
					final Item item = items.get(i);
					
						help.add(new JButton(),c);
						JButton helpBtn = ((JButton)help.getComponent(1));
						helpBtn.setVerticalAlignment(SwingConstants.TOP);
						helpBtn.setHorizontalAlignment(SwingConstants.LEFT);
						helpBtn.setIcon(helpicon);
						
						helpBtn.setContentAreaFilled(false);
					    helpBtn.setBorderPainted(false);
						
						
						helpBtn.addActionListener(new ActionListener(){
							public void actionPerformed(ActionEvent e)
							{
								if(VtEnv.infoBox == null)
									VtEnv.windowing();
								
								try{
	
									String anchor =item.getAnchor();
									
									while(VtEnv.visitedLinks.size()>VtEnv.LinkPointer+1)
										VtEnv.visitedLinks.remove(VtEnv.LinkPointer+1);
									VtEnv.visitedLinks.add("file://"+VtEnv.getUserManualPath()+"#"+anchor);
									VtEnv.LinkPointer = VtEnv.visitedLinks.size() -1;
									VtEnv.UserManualView.setPage("file://"+VtEnv.getUserManualPath()+"#"+anchor);
									
										
								}catch(Exception ex)
								{
									Config.errorHandler(ex);
								}								
								VtEnv.infoBox.setVisible(true);
								
							}
						});
						
					//Space if there is no Helpbutton
					if(!(item.getAnchor() != null && !item.getAnchor().trim().equals("")))
					{
						JLabel label1 = new JLabel("");
						label1.setPreferredSize(helpBtn.getPreferredSize());
						helpBtn.setEnabled(false);
						helpBtn.setVisible(false);
						help.add(label1,c);

					}
					
					//Space if it is not resized
					if(!isResized)
					{
						c.weightx = 1;
						JLabel label1 = new JLabel("");
						help.add(label1,c);
					}					
						
					if(items.get(i).isAdvanced())
					{
						hasadvancedview = true;
						advancedID.add(componentsList.size());
						advancedID.add(componentsList.size()+1);
						if(label.getText().toString().equals("metrics counter: "))
							advancedID.add(componentsList.size()+2);
					}else
					{
						if(items.get(i).isAvailable())
							hasdefaultview = true;
					}
					
					if(items.get(i).isAvailable() == false)
					{
						items.get(i).setEnabled(false);
						label.setEnabled(false);
					}

					items.get(i).setComponent(label);
					if(items.get(i).isAvailable() == false)
						nAvailComp.add(componentsList.size());
					componentsList.add(label);
					
					
								
				
					if(label.getText().toString().equals("metrics counter: "))
					{
						if(items.get(i).isAvailable() == false)
							nAvailComp.add(componentsList.size());
						componentsList.add(null);
					}
					
					if(label.getText().toString().equals(""))
					{
						if(items.get(i).isAvailable() == false)
							nAvailComp.add(componentsList.size());
						componentsList.add(null);
					}
					
					
					if(isResized)
						IndexSmallElements.add(componentsList.size());
					if(items.get(i).isAvailable() == false)
						nAvailComp.add(componentsList.size());
					componentsList.add(help);
					if(items.get(i).isAvailable() == false)
						nAvailComp.add(componentsList.size());
					componentsList.add(null);
					
					orgPanel.add(label);
					orgPanel.add(help);
					
					
					items.get(i).setValComponent(help);
					
				}
				
				
			}
			return orgPanel;
		}		
		
		/*****
		 * Method is used by addItems to add special Items. 
		 * @param val id of the special Component.
		 * @return if the id is known the method returns the component otherwise a text field.
		 */
		private Component addSpecial(Item val)
		{
			Component widget =  null;
			try{			

				if(val.getValue().get(0).getEnumId().trim().compareTo("papiCounter") == 0)
				{
					CounterWidget comp = new CounterWidget();
					comp.setValue(val.getValue().get(0).getValue());
					if(!val.isAvailable() || val.isDeprecated())
					{
						comp.setDisabled();
					}
					return comp;
				}
			}catch(Exception ex)
			{
				Config.errorHandler(ex);
			}
			
			widget = new JFormattedTextField();
			((JFormattedTextField)widget).setColumns(25);
			
			return widget;
		}
		
		
		
}
