/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/
package widgets;

import help.Config;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;


import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Locale;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;

import xmlObjects.ValDesc;
import xmlObjects.VtEnv;


/***
 * This class is a component to manage files. it Consists of a text field, a button and
 * a filechooser component that is displayed when the button is pressed. 
 */
public class myFileDialog extends javax.swing.JPanel{
	
	/**
	 * standard serialVersionUID
	 */
	private static final long serialVersionUID = 1L;
	
	public JFormattedTextField text = new JFormattedTextField();
	public JButton button = new JButton();
	private boolean isOutputFile = false;
	private boolean isPath = false;
	private boolean isFile = false;
	private VtEnv env = null;
	/***
	 * initialize my FileDialog
	 */
	public myFileDialog()
	{
		setPorpertys();
	}

	/***
	 * initialize my FileDialog
	 * @param defaultVal default path in the textbox
	 */
	public myFileDialog(String defaultVal)
	{
		this.text.setText(defaultVal);
		setPorpertys();
	}
	
	/***
	 * method to set if it is a path to a directory or not.
	 * @param isPath true if a path to a directory is allowed
	 */
	public void setIsPath(boolean isPath)
	{
		this.isPath = isPath;
	}
	
	/***
	 * method to set if it is a path to a file or not.
	 * @param isFile true if a path to a file is allowed
	 */
	public void setIsFile(boolean isFile)
	{
		this.isFile = isFile;
	}
	
	/****
	 * You can set the behavior of this file to input file or output file.  
	 * @param io parameter to set it as input or output file. you can set it to
	 * in, out or in/out
	 */
	public void setIObehavior(String io)
	{
		if(io.trim().compareTo("out") == 0 || io.trim().compareTo("in/out") == 0)
			this.isOutputFile = true;
	}
	
	
	/***
	 * this method is used by myFileDialog to set the properties of the components 
	 */
	private void setPorpertys()
	{
		//text.setColumns(25);
		
		button.setText("...");
		button.setPreferredSize(new Dimension(30, 17));
	}
	
	/***
	 * shows an dialog uses {@link #showOpenDialog() showOpenDialog} or {@link #showSaveDialog() showSaveDialog} depending
	 * on the isOutputFile parameter 
	 */
	public void showDialog()
	{
		if(this.isOutputFile)
			showSaveDialog();
		else
			showOpenDialog();
	}
	
	/***
	 * shows an open dialog to enter a path  
	 */
	public void showOpenDialog()
	{
		this.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.5;
		this.add(this.text,c);
		c.weightx = 0;
		this.add(this.button,c);
		this.button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				
				final JFileChooser chooser = new JFileChooser();
				
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				chooser.setDialogType(JFileChooser.OPEN_DIALOG);
				chooser.setLocale(Locale.ENGLISH);	
				
				
				
				if(!isPath && isFile)
					chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				
				if(text.getText().trim().length() >= 1)
				{
					chooser.setCurrentDirectory(new File(text.getText()));
				}
				else
				{
					File f = null;
				    try{
				    	f = new File(new File(".").getCanonicalPath());
				    }catch(Exception ex)
				    {
				    	Config.errorHandler(ex);
				    }
				    chooser.setCurrentDirectory(f);
				}
			    chooser.showOpenDialog(null);

			    if(chooser.getSelectedFile() != null)
			    {
			    
			    	boolean flag = true;
				    try{
				    	String curFile = chooser.getSelectedFile().getCanonicalPath();
				    	if (isFile && !(new File(curFile).exists()))
				    	{
				    		JOptionPane.showMessageDialog(null, "File not found!", "Warning", JOptionPane.WARNING_MESSAGE);
				    		flag = false;
				    	}
				    	
				    	if (isFile && new File(curFile).isDirectory())
				    	{
				    		JOptionPane.showMessageDialog(null, "File not found!", "Warning", JOptionPane.WARNING_MESSAGE);
				    		flag = false;
				    	}
				    	
				    	if (isPath && !new File(curFile).isDirectory())
				    	{
				    		JOptionPane.showMessageDialog(null, "The Directory does not exists!", "Warning", JOptionPane.WARNING_MESSAGE);
				    		flag = false;
				    	}
				    	
				    	if(flag)
				    	{
				    		String out = "";
				    		myFileDialog.this.text.setText(curFile);
				    		if( env != null)
				    		{
				    			env.executable = curFile;
				    			
									String Text = curFile;
									
									if(!VtEnv.nm.trim().equals(""))
									{
										try {
											
											Process p = Runtime.getRuntime().exec(VtEnv.nm+" "+Text,null);
											BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));   
											String line;
											
											line = br.readLine();
											if(line != null)   
												out += line;
											
											out = out.trim();
											p.waitFor();
											br.close();
											p.destroy();
											
											if(out.equals(""))
											{
												JOptionPane.showMessageDialog(null, "Nm can't get symbol information from this executable!"); 
												out = "no";
											}
										} catch (Exception err) {
											
											Config.errorHandler(err);
										}
									}
									
									if(!out.equals("no") && env.executableLoaded)
									{
										String[] options = { VtEnv.mytext.getText("dialog_chanche_exec_takenew"),VtEnv.mytext.getText("dialog_chanche_exec_merge"),VtEnv.mytext.getText("dialog_chanche_exec_takeold")};
				            			int answer = JOptionPane.showOptionDialog(null, VtEnv.mytext.getText("dialog_chanche_exec"), VtEnv.mytext.getText("dialog_chanche_exec_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
				            			VtEnv.executableAnswer = answer;
				            				
									}
									if(!out.equals("no") && ((ValDesc)env.getItemById("VT_FILE_PREFIX").getValue().get(0)).isDefault())
									{
										if(Text.contains("/"))
											Text = Text.substring(Text.lastIndexOf("/")+1);
										if(Text.contains("."))
											Text = Text.substring(0,Text.lastIndexOf("."));
										if(!Text.trim().equals(""))
											((JFormattedTextField) env.getItemById("VT_FILE_PREFIX").getValue().get(0).getComponent()).setText(Text);
									
										if(env.executableLoaded)
										{
											String[] options = { VtEnv.mytext.getText("dialog_chanche_exec_takenew"),VtEnv.mytext.getText("dialog_chanche_exec_merge"),VtEnv.mytext.getText("dialog_chanche_exec_takeold")};
					            			int answer = JOptionPane.showOptionDialog(null, VtEnv.mytext.getText("dialog_chanche_exec"), VtEnv.mytext.getText("dialog_chanche_exec_title"),JOptionPane.DEFAULT_OPTION, JOptionPane.WARNING_MESSAGE,null, options, options[0]);
					            			VtEnv.executableAnswer = answer;
										}
									}
							}
				    		
				    	}
				    }catch(Exception ex)
				    {
				    	Config.errorHandler(ex);
				    }
			    }
				
			}
		});
	}
	
	public void setEnabled(boolean enabled)
	{
		this.text.setEnabled(enabled);
		this.button.setEnabled(enabled);
	}
	/***
	 * shows an save dialog to enter a path  
	 */
	public void showSaveDialog()
	{
		
		this.setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.HORIZONTAL;
		c.weightx = 0.5;
		this.add(this.text,c);
		c.weightx = 0;
		this.add(this.button,c);
		this.button.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				JFileChooser chooser = new JFileChooser();
			   // chooser.setApproveButtonText("open");
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				chooser.setLocale(Locale.ENGLISH);
				if(!isPath && isFile)
					chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
				
				if(text.getText().trim().length() >= 1)
				{
					chooser.setCurrentDirectory(new File(text.getText()));
				}
				else
				{
				    File f = null;
				    try{
				    	f = new File(new File(".").getCanonicalPath());
				    }catch(Exception ex)
				    {
				    	Config.errorHandler(ex);
				    }
				    chooser.setCurrentDirectory(f);
				}
			    chooser.showSaveDialog(null);
			    if(chooser.getSelectedFile() != null)
			    {
				    try{
				    	String curFile = chooser.getSelectedFile().getCanonicalPath();
				    	boolean flag = true;
				    	if (isFile && new File(curFile).isDirectory())
				    	{
				    		JOptionPane.showMessageDialog(null, "Using a Directory as File, is not permitted!", "Warning", JOptionPane.WARNING_MESSAGE);
				    		flag = false;
				    	}
				    	
				    	if(flag)
				    	{
				    		myFileDialog.this.text.setText(curFile);
				    	}
				    	
				    }catch(Exception ex)
				    {
				    	Config.errorHandler(ex);
				    }
			    }
				
			}
		});
	}
	
	/***
	 * set the size of the textbox. 
	 * @param size new size of the textbox
	 */
	public void setSize(int size)
	{
		text.setColumns(size);
	}
	
	public void setIsVTLExecutable(VtEnv env)
	{
		this.env = env;
	}
}
