/**
 * VampirTrace
 * http://www.tu-dresden.de/zih/vampirtrace
 *
 * Copyright (c) 2005-2012, ZIH, TU Dresden, Federal Republic of Germany
 *
 * Copyright (c) 1998-2005, Forschungszentrum Juelich, Juelich Supercomputing
 *                          Centre, Federal Republic of Germany
 *
 * See the file COPYING in the package base directory for details
 **/

package help;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

/***
 * @author Mathias Korepkat
 */

/***
 * static class to set some options
 */
public class Config {

	/**
	 * Programm Title
	 */
	public static String TITLE = "VTSetup";
	
	/**
	 * Title of the About menu
	 */
	public static String ABOUT_TITLE = "About";
	
	/**
	 * number of digits for rounding in float widget
	 */
	public static int rounding = 4;
	
	/**
	 * name of the info Box
	 */
	public static String ToolBoxTitle = "Infobox";
	
	/***
	 * used images in this application
	 */
	public static String Image_ICON = "dvampir.gif";
	public static String Image_NEW = "vts-new-a.png";//"document-new.png";
	public static String Image_LOAD = "vts-load-a.png";//"document-open.png";
	public static String Image_SAVE = "vts-save-a.png";//"media-floppy.png";
	public static String Image_GENERATE = "vts-generate-a.png";//"system-run.png";
	public static String Image_ADVANCEDMODE = "vts-advanced-a.png";//"svampir.gif";
	public static String Image_DEFAULTMODE = "vts-advanced-b.png";//"dvampir.gif";
	public static String Image_TOOLBOX = "vts-infobox-b.png";//"preferences-user-information.png";
	public static String Image_TOOLBOX_off = "vts-infobox-a.png";//"preferences-user-information.png";
	public static String Image_ADVANCED = "vts-advanced-b.png";//"svampir.gif";
	public static String Image_Execute = "vts-konsole-a.png";//"utilities-terminal.png";
	public static String Image_TABCLOSE = "dialog-close.png";
	public static String Image_TABCLOSE_OVER = "dialog-cancel.png";
	public static String Image_BROWSER_BACK = "go-previous.png";
	public static String Image_BROWSER_BACKg = "go-previousg.png";
	public static String Image_BROWSER_Forward = "go-next.png";
	public static String Image_BROWSER_Forwardg = "go-nextg.png";
	public static String Image_BROWSER = "help-browser.png";

	/***
	 * set the Text in the About dialog
	 * @param version version id taken from the  Gui xml-file it is saved in the VtEnv Class 
	 * @return Label with the text body for the About dialog
	 */
	public static Component ABOUT_Text(String version)
	{   
		JEditorPane output = new JEditorPane();
		output.setContentType("text/html;charset=EUC-JP");
		output.setText("<h2>"+TITLE+"</h2> <h3>Version "+version+"</h3><br/>Copyright (c) 2005-2012<br/>Center for Information Services and HPC (ZIH)<br/>Technische Universitaet Dresden<br>All Rights Reserved.<br><br/><i>Please, report bugs, wishes, and suggestions to &lt;vampirsupport@zih.tu-dresden.de&gt;.</i>");
		
		JScrollPane editorScrollPane = new JScrollPane(output);
        editorScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
        editorScrollPane.setPreferredSize(new Dimension(400,250));
        editorScrollPane.setMinimumSize(new Dimension(200, 10));
		return editorScrollPane;
	}
	
	
	/***
	 * Error Handler 
	 * @param e Exception that is thrown.
	 */
	public static void errorHandler(Exception e)
	{
		System.out.println("error: "+e.getMessage());
		e.printStackTrace();
	}
	
	/***
	 * creates a Formated String to view in the tooltip box
	 * @param title title of the described value in the tool tip
	 * @param text String that is shown in the tooltip box.
	 * @return formatted String
	 */
	public static String setToolTipString(String title,String text)
	{
		String output = "";
	
		output = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\"><HTML><HEAD><TITLE>ToolTip</TITLE><STYLE TYPE=\"text/css\">a {color:#FF0000;font-weight:600;}</STYLE></HEAD><BODY><TABLE BORDER=\"0\"><TR><TD ROWSPAN=\"2\" WIDTH=\"200\" valign=\"top\"><H1>"+ToolBoxTitle+":</H1></TD>";
		output +="<TD><H2>"+title+":</H2></TD></TR><TR><TD>";
		output += text;
		output +="</TD></TR></TABLE></BODY></HTML>";
		
		return output;
	}
}
