/*
 * Copyright (c) 2004-2005 The Trustees of Indiana University and Indiana
 *                         University Research and Technology
 *                         Corporation.  All rights reserved.
 * Copyright (c) 2004-2005 The University of Tennessee and The University
 *                         of Tennessee Research Foundation.  All rights
 *                         reserved.
 * Copyright (c) 2004-2005 High Performance Computing Center Stuttgart, 
 *                         University of Stuttgart.  All rights reserved.
 * Copyright (c) 2004-2005 The Regents of the University of California.
 *                         All rights reserved.
 * Copyright (c) 2012-2013 Los Alamos National Security, Inc.  All rights reserved. 
 * $COPYRIGHT$
 * 
 * Additional copyrights may follow
 * 
 * $HEADER$
 */

#include "ompi_config.h"

#include <stdio.h>

#include "ompi/constants.h"
#include "opal/class/opal_list.h"
#include "opal/util/output.h"
#include "opal/mca/mca.h"
#include "opal/mca/base/base.h"


#include "ompi/mca/topo/base/base.h"

/*
 * The static-component.h is generated by the configure script. It contains
 * statements and the definition of an array of pointers to each component's
 * public mca_base_component_t struct.
 */
#include "ompi/mca/topo/base/static-components.h"

OBJ_CLASS_INSTANCE(mca_topo_base_module_t, opal_object_t,
                   NULL, NULL);

static int mca_topo_base_close(void) 
{
    return mca_base_framework_components_close(&ompi_topo_base_framework, NULL);
}

/**
 * Function for finding and opening either all the MCA topo components, or
 * the one that specifically requested via a MCA parameter.
 */
static int mca_topo_base_open(mca_base_open_flag_t flags) 
{
    return mca_base_framework_components_open(&ompi_topo_base_framework, flags);
}

MCA_BASE_FRAMEWORK_DECLARE(ompi, topo, "OMPI Topo", NULL,
                           mca_topo_base_open, mca_topo_base_close,
                           mca_topo_base_static_components, 0);

