/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.xml.AbstractTreeReader;
import org.dom4j.Document;
import org.dom4j.Element;

public class Dom4JReader
extends AbstractTreeReader {
    private Element currentElement;

    public Dom4JReader(Element rootElement) {
        super(rootElement);
    }

    public Dom4JReader(Document document) {
        this(document.getRootElement());
    }

    public String getNodeName() {
        return this.currentElement.getName();
    }

    public String getValue() {
        return this.currentElement.getText();
    }

    public String getAttribute(String name) {
        return this.currentElement.attributeValue(name);
    }

    protected Object getParent() {
        return this.currentElement.getParent();
    }

    protected Object getChild(int index) {
        return this.currentElement.elements().get(index);
    }

    protected int getChildCount() {
        return this.currentElement.elements().size();
    }

    protected void reassignCurrentElement(Object current) {
        this.currentElement = (Element)current;
    }

    public void appendErrors(ErrorWriter errorWriter) {
        errorWriter.add("xpath", this.currentElement.getPath());
    }
}

