/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.AllAttrInfoVisitor;
import proguard.classfile.instruction.AllInstructionVisitor;
import proguard.classfile.util.ClassFileClassForNameReferenceInitializer;
import proguard.classfile.util.ClassFileHierarchyInitializer;
import proguard.classfile.util.ClassFileReferenceInitializer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassFileHierarchyTraveler;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.LibraryClassFileFilter;
import proguard.classfile.visitor.ReferencedClassFileVisitor;
import proguard.util.ClassNameListMatcher;

public class Initializer {
    private Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        int n3 = classPool2.size();
        ClassFileHierarchyInitializer classFileHierarchyInitializer = new ClassFileHierarchyInitializer(classPool, classPool2, this.configuration.warn);
        classPool.classFilesAccept(classFileHierarchyInitializer);
        ClassFileHierarchyInitializer classFileHierarchyInitializer2 = new ClassFileHierarchyInitializer(classPool, classPool2, false);
        classPool2.classFilesAccept(classFileHierarchyInitializer2);
        ClassFileClassForNameReferenceInitializer classFileClassForNameReferenceInitializer = new ClassFileClassForNameReferenceInitializer(classPool, classPool2, this.configuration.note, this.createNoteExceptionMatcher(this.configuration.keep));
        classPool.classFilesAccept(new AllMethodVisitor(new AllAttrInfoVisitor(new AllInstructionVisitor(classFileClassForNameReferenceInitializer))));
        ClassFileReferenceInitializer classFileReferenceInitializer = new ClassFileReferenceInitializer(classPool, classPool2, this.configuration.warn);
        classPool.classFilesAccept(classFileReferenceInitializer);
        classPool2.clear();
        classPool.classFilesAccept(new ReferencedClassFileVisitor(new LibraryClassFileFilter(new ClassFileHierarchyTraveler(true, true, true, false, new LibraryClassFileFilter(new ClassPoolFiller(classPool2, false))))));
        ClassFileReferenceInitializer classFileReferenceInitializer2 = new ClassFileReferenceInitializer(classPool, classPool2, false);
        classPool2.classFilesAccept(classFileReferenceInitializer2);
        int n4 = classFileClassForNameReferenceInitializer.getNoteCount();
        if (n4 > 0) {
            System.err.println("Note: there were " + n4 + " class casts of dynamically created class instances.");
            System.err.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.err.println("      their implementations (using '-keep').");
        }
        if ((n2 = classFileHierarchyInitializer.getWarningCount()) > 0) {
            if (classPool.size() == 0) {
                throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
            }
            System.err.println("Warning: there were " + n2 + " unresolved references to superclasses or interfaces.");
            System.err.println("         You may need to specify additional library jars (using '-libraryjars'),");
            System.err.println("         or perhaps the '-dontskipnonpubliclibraryclasses' option.");
        }
        if ((n = classFileReferenceInitializer.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile them and try again.");
        }
        if (!(n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            System.err.println("         If you are sure the mentioned classes are not used anyway,");
            System.err.println("         you could try your luck using the '-ignorewarnings' option.");
            throw new IOException("Please correct the above warnings first.");
        }
        if (this.configuration.verbose) {
            System.out.println("Removed unused library classes...");
            System.out.println("  Original number of library classes: " + n3);
            System.out.println("  Final number of library classes:    " + classPool2.size());
        }
    }

    private ClassNameListMatcher createNoteExceptionMatcher(List list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                ClassSpecification classSpecification = (ClassSpecification)list.get(i);
                if (!classSpecification.markClassFiles) continue;
                String string2 = classSpecification.className;
                if (string2 != null) {
                    arrayList.add(string2);
                }
                if ((string = classSpecification.extendsClassName) == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ClassNameListMatcher(arrayList);
            }
        }
        return null;
    }
}

