/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.io.ClassFileFilter;
import proguard.io.ClassFileReader;
import proguard.io.DataEntryReader;
import proguard.io.DirectoryPump;

public class InputReader {
    private Configuration configuration;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        this.readInput("Reading program ", this.configuration.programJars, this.createDataEntryClassPoolFiller(classPool, false));
        if (classPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, this.createDataEntryClassPoolFiller(classPool2, true));
        }
    }

    private DataEntryReader createDataEntryClassPoolFiller(ClassPool classPool, boolean bl) {
        return new ClassFileFilter(new ClassFileReader(bl, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, this.configuration.note, new ClassPoolFiller(classPool, this.configuration.note)));
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    public void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")");
        }
    }
}

