/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;

public class BranchInstruction
extends Instruction {
    public int branchOffset;

    public BranchInstruction() {
    }

    public BranchInstruction(byte by, int n) {
        this.opcode = by;
        this.branchOffset = n;
    }

    public BranchInstruction copy(BranchInstruction branchInstruction) {
        this.opcode = branchInstruction.opcode;
        this.branchOffset = branchInstruction.branchOffset;
        return this;
    }

    public Instruction shrink() {
        if (this.branchOffset << 16 >> 16 == this.branchOffset) {
            if (this.opcode == -56) {
                this.opcode = (byte)-89;
            } else if (this.opcode == -55) {
                this.opcode = (byte)-88;
            }
        }
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        this.branchOffset = BranchInstruction.readSignedValue(byArray, n, this.branchOffsetSize());
    }

    protected void writeInfo(byte[] byArray, int n) {
        BranchInstruction.writeValue(byArray, n, this.branchOffset, this.branchOffsetSize());
    }

    public int length(int n) {
        return 1 + this.branchOffsetSize();
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitBranchInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + " (offset=" + this.branchOffset + ", target=" + (n + this.branchOffset) + ")";
    }

    public String toString() {
        return this.getName() + " (offset=" + this.branchOffset + ")";
    }

    private int branchOffsetSize() {
        return this.opcode == -56 || this.opcode == -55 ? 4 : 2;
    }
}

