/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.MemberInfoObfuscator;
import proguard.obfuscate.SpecialNameFactory;

public class MemberInfoSpecialNameFilter
implements MemberInfoVisitor {
    private MemberInfoVisitor memberInfoVisitor;

    public MemberInfoSpecialNameFilter(MemberInfoVisitor memberInfoVisitor) {
        this.memberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (MemberInfoSpecialNameFilter.isSpecialName(programFieldInfo)) {
            this.memberInfoVisitor.visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (MemberInfoSpecialNameFilter.isSpecialName(programMethodInfo)) {
            this.memberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        if (MemberInfoSpecialNameFilter.isSpecialName(libraryFieldInfo)) {
            this.memberInfoVisitor.visitLibraryFieldInfo(libraryClassFile, libraryFieldInfo);
        }
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        if (MemberInfoSpecialNameFilter.isSpecialName(libraryMethodInfo)) {
            this.memberInfoVisitor.visitLibraryMethodInfo(libraryClassFile, libraryMethodInfo);
        }
    }

    private static boolean isSpecialName(MemberInfo memberInfo) {
        return SpecialNameFactory.isSpecialName(MemberInfoObfuscator.newMemberName(memberInfo));
    }
}

