/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.attribute.ConstantValueAttrInfo;
import proguard.classfile.attribute.DeprecatedAttrInfo;
import proguard.classfile.attribute.EnclosingMethodAttrInfo;
import proguard.classfile.attribute.ExceptionsAttrInfo;
import proguard.classfile.attribute.InnerClassesAttrInfo;
import proguard.classfile.attribute.LineNumberTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTableAttrInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttrInfo;
import proguard.classfile.attribute.SignatureAttrInfo;
import proguard.classfile.attribute.SourceDirAttrInfo;
import proguard.classfile.attribute.SourceFileAttrInfo;
import proguard.classfile.attribute.SyntheticAttrInfo;
import proguard.classfile.attribute.UnknownAttrInfo;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttrInfo;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttrInfo;
import proguard.classfile.editor.CodeAttrInfoEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.SideEffectInstructionChecker;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.TracedVariables;
import proguard.optimize.evaluation.Variables;
import proguard.optimize.evaluation.value.InstructionOffsetValue;
import proguard.optimize.evaluation.value.ReferenceValue;
import proguard.optimize.evaluation.value.ReferenceValueFactory;
import proguard.optimize.evaluation.value.Value;
import proguard.optimize.evaluation.value.ValueFactory;

public class EvaluationSimplifier
implements MemberInfoVisitor,
AttrInfoVisitor,
InstructionVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG_ANALYSIS = false;
    private static final boolean DEBUG = false;
    private static final int INITIAL_CODE_LENGTH = 1024;
    private static final int INITIAL_VALUE_COUNT = 32;
    private InstructionVisitor extraPushInstructionVisitor;
    private InstructionVisitor extraBranchInstructionVisitor;
    private InstructionVisitor extraDeletedInstructionVisitor;
    private PartialEvaluator partialEvaluator = new PartialEvaluator();
    private SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private ClassFileCleaner classFileCleaner = new ClassFileCleaner();
    private CodeAttrInfoEditor codeAttrInfoEditor = new CodeAttrInfoEditor(1024);
    private Variables parameters = new TracedVariables(32);
    private boolean[] isNecessary = new boolean[1024];
    private boolean[] isSimplified = new boolean[1024];

    public EvaluationSimplifier() {
        this(null, null, null);
    }

    public EvaluationSimplifier(InstructionVisitor instructionVisitor, InstructionVisitor instructionVisitor2, InstructionVisitor instructionVisitor3) {
        this.extraPushInstructionVisitor = instructionVisitor;
        this.extraBranchInstructionVisitor = instructionVisitor2;
        this.extraDeletedInstructionVisitor = instructionVisitor3;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        try {
            programMethodInfo.attributesAccept(programClassFile, this);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while optimizing after partial evaluation:");
            System.err.println("  ClassFile   = [" + programClassFile.getName() + "]");
            System.err.println("  Method      = [" + programMethodInfo.getName(programClassFile) + programMethodInfo.getDescriptor(programClassFile) + "]");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    public void visitUnknownAttrInfo(ClassFile classFile, UnknownAttrInfo unknownAttrInfo) {
    }

    public void visitInnerClassesAttrInfo(ClassFile classFile, InnerClassesAttrInfo innerClassesAttrInfo) {
    }

    public void visitEnclosingMethodAttrInfo(ClassFile classFile, EnclosingMethodAttrInfo enclosingMethodAttrInfo) {
    }

    public void visitConstantValueAttrInfo(ClassFile classFile, FieldInfo fieldInfo, ConstantValueAttrInfo constantValueAttrInfo) {
    }

    public void visitExceptionsAttrInfo(ClassFile classFile, MethodInfo methodInfo, ExceptionsAttrInfo exceptionsAttrInfo) {
    }

    public void visitLineNumberTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LineNumberTableAttrInfo lineNumberTableAttrInfo) {
    }

    public void visitLocalVariableTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTableAttrInfo localVariableTableAttrInfo) {
    }

    public void visitLocalVariableTypeTableAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, LocalVariableTypeTableAttrInfo localVariableTypeTableAttrInfo) {
    }

    public void visitSourceFileAttrInfo(ClassFile classFile, SourceFileAttrInfo sourceFileAttrInfo) {
    }

    public void visitSourceDirAttrInfo(ClassFile classFile, SourceDirAttrInfo sourceDirAttrInfo) {
    }

    public void visitDeprecatedAttrInfo(ClassFile classFile, DeprecatedAttrInfo deprecatedAttrInfo) {
    }

    public void visitSyntheticAttrInfo(ClassFile classFile, SyntheticAttrInfo syntheticAttrInfo) {
    }

    public void visitSignatureAttrInfo(ClassFile classFile, SignatureAttrInfo signatureAttrInfo) {
    }

    public void visitRuntimeVisibleAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleAnnotationsAttrInfo runtimeVisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleAnnotationsAttrInfo runtimeInvisibleAnnotationsAttrInfo) {
    }

    public void visitRuntimeVisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeVisibleParameterAnnotationsAttrInfo runtimeVisibleParameterAnnotationsAttrInfo) {
    }

    public void visitRuntimeInvisibleParameterAnnotationAttrInfo(ClassFile classFile, RuntimeInvisibleParameterAnnotationsAttrInfo runtimeInvisibleParameterAnnotationsAttrInfo) {
    }

    public void visitAnnotationDefaultAttrInfo(ClassFile classFile, AnnotationDefaultAttrInfo annotationDefaultAttrInfo) {
    }

    public void visitCodeAttrInfo(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        Instruction instruction;
        int n;
        int n2;
        this.initializeParameters(classFile, methodInfo, codeAttrInfo);
        this.initializeNecessary(codeAttrInfo);
        Value value = this.partialEvaluator.evaluate(classFile, methodInfo, codeAttrInfo, this.parameters);
        codeAttrInfo.exceptionsAccept(classFile, methodInfo, this.classFileCleaner);
        int n3 = codeAttrInfo.u4codeLength;
        this.codeAttrInfoEditor.reset(n3);
        codeAttrInfo.instructionsAccept(classFile, methodInfo, this);
        boolean bl = methodInfo.getName(classFile).equals("<init>");
        int n4 = 0;
        int n5 = 0;
        do {
            if (!this.partialEvaluator.isTraced(n5)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttrInfo.code, n5);
            if (instruction2.opcode == 42) {
                n4 = n5;
                continue;
            }
            if (bl && instruction2.opcode == -73 && this.partialEvaluator.stackProducerOffsets(n5).contains(n4)) {
                bl = false;
                this.isNecessary[n5] = true;
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(classFile, methodInfo, codeAttrInfo, n5, instruction2)) continue;
            this.isNecessary[n5] = true;
        } while (++n5 < n3);
        int n6 = n3;
        n5 = n3 - 1;
        do {
            n2 = n5 - 1;
            if (this.isNecessary[n5]) {
                n6 = n5;
            }
            n2 = this.markStraddlingBranches(n5, this.partialEvaluator.branchTargets(n5), true, n6, n2);
            if (this.isNecessary[n5] && !this.isSimplified[n5]) {
                n2 = this.markProducers(n5, n2);
            }
            if (this.isNecessary[n5]) {
                n6 = n5;
            }
            n2 = this.markStraddlingBranches(n5, this.partialEvaluator.branchOrigins(n5), false, n6, n2);
            if (!this.isNecessary[n5]) continue;
            n6 = n5;
        } while ((n5 = n2) >= 0);
        n5 = n3 - 1;
        do {
            if (!this.partialEvaluator.isTraced(n5)) continue;
            Instruction instruction3 = InstructionFactory.create(codeAttrInfo.code, n5);
            if (this.isNecessary[n5]) {
                this.fixPushInstruction(classFile, codeAttrInfo, n5, instruction3);
            } else {
                this.fixDupInstruction(classFile, codeAttrInfo, n5, instruction3);
            }
            if (this.isNecessary[n5]) continue;
            this.fixPopInstruction(classFile, codeAttrInfo, n5, instruction3);
        } while (--n5 >= 0);
        n6 = n3;
        n5 = n3 - 1;
        do {
            n = n5 - 1;
            if (this.isNecessary[n5]) {
                n6 = n5;
            }
            n = this.markAndSimplifyStraddlingBranches(n5, this.partialEvaluator.branchTargets(n5), n6, n);
            if (this.isNecessary[n5]) {
                n6 = n5;
            }
            n = this.markAndSimplifyStraddlingBranches(this.partialEvaluator.branchOrigins(n5), n5, n6, n);
            if (!this.isNecessary[n5]) continue;
            n6 = n5;
        } while ((n5 = n) >= 0);
        n5 = 0;
        do {
            if ((n = this.partialEvaluator.initializedVariable(n5)) == -1 || this.isNecessary[n5] || !this.isVariableReferenced(codeAttrInfo, n)) continue;
            int n7 = this.partialEvaluator.variableValueAfter(n5, n).computationalType();
            this.increaseStackSize(n5, n7, false);
        } while (++n5 < n3);
        n5 = 0;
        do {
            instruction = InstructionFactory.create(codeAttrInfo.code, n5);
            if (this.isNecessary[n5]) continue;
            this.codeAttrInfoEditor.deleteInstruction(n5);
            this.codeAttrInfoEditor.insertBeforeInstruction(n5, null);
            this.codeAttrInfoEditor.replaceInstruction(n5, null);
            this.codeAttrInfoEditor.insertAfterInstruction(n5, null);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(classFile, methodInfo, codeAttrInfo, n5, this.extraDeletedInstructionVisitor);
        } while ((n5 += instruction.length(n5)) < n3);
        this.codeAttrInfoEditor.visitCodeAttrInfo(classFile, methodInfo, codeAttrInfo);
    }

    private int markProducers(int n, int n2) {
        n2 = this.markProducers(this.partialEvaluator.varProducerOffsets(n), n2);
        n2 = this.markProducers(this.partialEvaluator.stackProducerOffsets(n), n2);
        return n2;
    }

    private int markProducers(InstructionOffsetValue instructionOffsetValue, int n) {
        if (instructionOffsetValue != null) {
            int n2 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n2; ++i) {
                int n3 = instructionOffsetValue.instructionOffset(i);
                if (n3 <= -1 || this.isNecessary[n3]) continue;
                this.isNecessary[n3] = true;
                if (n >= n3) continue;
                n = n3;
            }
        }
        return n;
    }

    private int markStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, boolean bl, int n2, int n3) {
        if (instructionOffsetValue != null) {
            int n4 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                n3 = bl ? this.markStraddlingBranch(n, n5, n2, n3) : this.markStraddlingBranch(n5, n, n2, n3);
            }
        }
        return n3;
    }

    private int markStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isNecessary[n] && this.isStraddlingBranch(n, n2, n3)) {
            this.isNecessary[n] = true;
            if (n4 < n) {
                n4 = n;
            }
        }
        return n4;
    }

    private int markAndSimplifyStraddlingBranches(int n, InstructionOffsetValue instructionOffsetValue, int n2, int n3) {
        int n4;
        if (instructionOffsetValue != null && !this.isNecessary[n] && (n4 = instructionOffsetValue.instructionOffsetCount()) > 0) {
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                if (this.isStraddlingBranch(n, n5, n2)) continue;
                return n3;
            }
            n3 = this.markAndSimplifyStraddlingBranch(n, instructionOffsetValue.instructionOffset(0), n2, n3);
        }
        return n3;
    }

    private int markAndSimplifyStraddlingBranches(InstructionOffsetValue instructionOffsetValue, int n, int n2, int n3) {
        if (instructionOffsetValue != null) {
            int n4 = instructionOffsetValue.instructionOffsetCount();
            for (int i = 0; i < n4; ++i) {
                int n5 = instructionOffsetValue.instructionOffset(i);
                n3 = this.markAndSimplifyStraddlingBranch(n5, n, n2, n3);
            }
        }
        return n3;
    }

    private int markAndSimplifyStraddlingBranch(int n, int n2, int n3, int n4) {
        if (!this.isNecessary[n] && this.isStraddlingBranch(n, n2, n3)) {
            this.isNecessary[n] = true;
            Instruction instruction = new BranchInstruction(-56, n2 - n).shrink();
            this.codeAttrInfoEditor.replaceInstruction(n, instruction);
            if (n4 < n) {
                n4 = n;
            }
        }
        return n4;
    }

    private boolean isStraddlingBranch(int n, int n2, int n3) {
        return n <= n3 ^ n2 <= n3;
    }

    private void fixPushInstruction(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        boolean bl;
        int n2 = instruction.stackPushCount(classFile);
        if (n2 > 0 && !(bl = this.isStackEntryNecessaryAfter(n, 0, false))) {
            if (instruction.opcode != -88 && instruction.opcode != -55) {
                this.decreaseStackSize(n, n2, false, false);
            } else {
                this.replaceBranchInstruction(n, instruction);
            }
        }
    }

    private void fixDupInstruction(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        int n2 = instruction.opcode;
        int n3 = 0;
        boolean bl = false;
        switch (n2) {
            case 89: {
                boolean bl2 = this.isStackEntryNecessaryAfter(n, 0, false);
                boolean bl3 = this.isStackEntryNecessaryAfter(n, 1, false);
                if (!bl2 && !bl3) break;
                bl = true;
                if (!bl2 || !bl3) break;
                n3 = 89;
                break;
            }
            case 90: {
                int n4;
                boolean bl2 = this.isStackEntryNecessaryAfter(n, 0, false);
                boolean bl4 = this.isStackEntryNecessaryAfter(n, 1, false);
                boolean bl5 = this.isStackEntryNecessaryAfter(n, 2, false);
                if (!bl2 && !bl5) break;
                bl = true;
                if (!bl5) break;
                int n5 = n4 = bl4 ? 1 : 0;
                if (bl2) {
                    n3 = (byte)(89 + n4);
                    break;
                }
                if (n4 != 1) break;
                n3 = 95;
                break;
            }
            case 91: {
                boolean bl2 = this.isStackEntryNecessaryAfter(n, 0, false);
                boolean bl6 = this.isStackEntryNecessaryAfter(n, 1, false);
                boolean bl7 = this.isStackEntryNecessaryAfter(n, 2, false);
                boolean bl8 = this.isStackEntryNecessaryAfter(n, 3, false);
                if (!bl2 && !bl8) break;
                bl = true;
                if (!bl8) break;
                int n6 = (bl6 ? 1 : 0) + (bl7 ? 1 : 0);
                if (bl2) {
                    n3 = (byte)(89 + n6);
                    break;
                }
                if (n6 == 1) {
                    n3 = 95;
                    break;
                }
                if (n6 != 2) break;
                throw new IllegalArgumentException("Can't handle dup_x2 instruction moving original element across two elements");
            }
            case 92: {
                boolean bl2 = this.isStackEntriesNecessaryAfter(n, 0, 1, false);
                boolean bl9 = this.isStackEntriesNecessaryAfter(n, 2, 3, false);
                if (!bl2 && !bl9) break;
                bl = true;
                if (!bl2 || !bl9) break;
                n3 = 92;
                break;
            }
            case 93: {
                int n7;
                boolean bl2 = this.isStackEntriesNecessaryAfter(n, 0, 1, false);
                boolean bl10 = this.isStackEntryNecessaryAfter(n, 2, false);
                boolean bl11 = this.isStackEntriesNecessaryAfter(n, 3, 4, false);
                if (!bl2 && !bl11) break;
                bl = true;
                if (!bl11) break;
                int n8 = n7 = bl10 ? 1 : 0;
                if (bl2) {
                    n3 = (byte)(92 + n7);
                    break;
                }
                if (n7 <= 0) break;
                throw new IllegalArgumentException("Can't handle dup2_x1 instruction moving original element across " + n7 + " elements");
            }
            case 94: {
                boolean bl2 = this.isStackEntriesNecessaryAfter(n, 0, 1, false);
                boolean bl12 = this.isStackEntryNecessaryAfter(n, 2, false);
                boolean bl13 = this.isStackEntryNecessaryAfter(n, 3, false);
                boolean bl14 = this.isStackEntriesNecessaryAfter(n, 4, 5, false);
                if (!bl2 && !bl14) break;
                bl = true;
                if (!bl14) break;
                int n9 = (bl12 ? 1 : 0) + (bl13 ? 1 : 0);
                if (bl2) {
                    n3 = (byte)(92 + n9);
                    break;
                }
                if (n9 <= 0) break;
                throw new IllegalArgumentException("Can't handle dup2_x2 instruction moving original element across " + n9 + " elements");
            }
            case 95: {
                boolean bl2 = this.isStackEntryNecessaryAfter(n, 0, false);
                boolean bl15 = this.isStackEntryNecessaryAfter(n, 1, false);
                if (!bl2 && !bl15) break;
                bl = true;
                if (!bl2 || !bl15) break;
                n3 = 95;
            }
        }
        if (bl) {
            this.isNecessary[n] = true;
            if (n3 == 0) {
                this.codeAttrInfoEditor.deleteInstruction(n);
            } else if (n3 != n2) {
                SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n3);
                this.codeAttrInfoEditor.replaceInstruction(n, simpleInstruction);
            }
        }
    }

    private void fixPopInstruction(ClassFile classFile, CodeAttrInfo codeAttrInfo, int n, Instruction instruction) {
        int n2 = instruction.stackPopCount(classFile);
        if (n2 > 0 && (this.partialEvaluator.stackProducerOffsets(n).contains(-1) || this.isStackEntryNecessaryBefore(n, 0, false) && !this.isStackEntryNecessaryBefore(n, 0, true))) {
            byte by = instruction.opcode;
            if (by == 87 || by == 88) {
                this.isNecessary[n] = true;
            } else {
                this.decreaseStackSize(n, n2, true, true);
            }
        }
    }

    private void increaseStackSize(int n, int n2, boolean bl) {
        this.isNecessary[n] = true;
        int n3 = n2 == 1 ? 3 : (n2 == 2 ? 9 : (n2 == 3 ? 11 : (n2 == 4 ? 14 : (n2 == 5 ? 1 : 0))));
        SimpleInstruction simpleInstruction = new SimpleInstruction((byte)n3);
        this.codeAttrInfoEditor.insertBeforeInstruction(n, simpleInstruction);
        if (bl) {
            this.codeAttrInfoEditor.deleteInstruction(n);
        }
    }

    private void decreaseStackSize(int n, int n2, boolean bl, boolean bl2) {
        SimpleInstruction simpleInstruction;
        byte by;
        int n3;
        this.isNecessary[n] = true;
        boolean bl3 = !bl;
        int n4 = n2;
        if (bl2) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttrInfoEditor.replaceInstruction(n, simpleInstruction);
            n4 -= n3;
            bl = true;
            bl3 = true;
        }
        if (bl && n4 > 0) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttrInfoEditor.insertBeforeInstruction(n, simpleInstruction);
            n4 -= n3;
        }
        if (bl3 && n4 > 0) {
            n3 = n4 == 1 ? 1 : 2;
            by = n3 == 1 ? (byte)87 : 88;
            simpleInstruction = new SimpleInstruction(by);
            this.codeAttrInfoEditor.insertAfterInstruction(n, simpleInstruction);
            n4 -= n3;
        }
        if (n4 > 0) {
            throw new IllegalArgumentException("Unsupported stack size reduction [" + n2 + "]");
        }
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        if (this.partialEvaluator.isTraced(n)) {
            switch (simpleInstruction.opcode) {
                case -128: 
                case -126: 
                case -120: 
                case -117: 
                case -114: 
                case -111: 
                case -110: 
                case -109: 
                case 46: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 100: 
                case 104: 
                case 108: 
                case 112: 
                case 116: 
                case 120: 
                case 122: 
                case 124: 
                case 126: {
                    this.replaceIntegerPushInstruction(n, simpleInstruction);
                    break;
                }
                case -127: 
                case -125: 
                case -123: 
                case -116: 
                case -113: 
                case 47: 
                case 97: 
                case 101: 
                case 105: 
                case 109: 
                case 113: 
                case 117: 
                case 121: 
                case 123: 
                case 125: 
                case 127: {
                    this.replaceLongPushInstruction(n, simpleInstruction);
                    break;
                }
                case -122: 
                case -119: 
                case -112: 
                case 48: 
                case 98: 
                case 102: 
                case 106: 
                case 110: 
                case 114: 
                case 118: {
                    this.replaceFloatPushInstruction(n, simpleInstruction);
                    break;
                }
                case -121: 
                case -118: 
                case -115: 
                case 49: 
                case 99: 
                case 103: 
                case 107: 
                case 111: 
                case 115: 
                case 119: {
                    this.replaceDoublePushInstruction(n, simpleInstruction);
                    break;
                }
                case 50: {
                    this.replaceReferencePushInstruction(n, simpleInstruction);
                }
            }
        }
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        if (this.partialEvaluator.isTraced(n)) {
            switch (variableInstruction.opcode) {
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    this.replaceIntegerPushInstruction(n, variableInstruction);
                    break;
                }
                case 22: 
                case 30: 
                case 31: 
                case 32: 
                case 33: {
                    this.replaceLongPushInstruction(n, variableInstruction);
                    break;
                }
                case 23: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    this.replaceFloatPushInstruction(n, variableInstruction);
                    break;
                }
                case 24: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    this.replaceDoublePushInstruction(n, variableInstruction);
                    break;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.replaceReferencePushInstruction(n, variableInstruction);
                }
            }
        }
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -89: 
            case -88: 
            case -56: 
            case -55: {
                break;
            }
            default: {
                this.replaceBranchInstruction(n, branchInstruction);
            }
        }
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.replaceBranchInstruction(n, tableSwitchInstruction);
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.replaceBranchInstruction(n, lookUpSwitchInstruction);
    }

    private void replaceIntegerPushInstruction(int n, Instruction instruction) {
        int n2;
        Value value = this.partialEvaluator.stackTopValueAfter(n, 0);
        if (value.isSpecific() && (n2 = value.integerValue().value()) << 16 >> 16 == n2) {
            this.replacePushInstruction(n, (byte)17, n2);
        }
    }

    private void replaceLongPushInstruction(int n, Instruction instruction) {
        long l;
        Value value = this.partialEvaluator.stackTopValueAfter(n, 0);
        if (value.isSpecific() && ((l = value.longValue().value()) == 0L || l == 1L)) {
            this.replacePushInstruction(n, (byte)(9L + l), 0);
        }
    }

    private void replaceFloatPushInstruction(int n, Instruction instruction) {
        float f;
        Value value = this.partialEvaluator.stackTopValueAfter(n, 0);
        if (value.isSpecific() && ((f = value.floatValue().value()) == 0.0f || f == 1.0f || f == 2.0f)) {
            this.replacePushInstruction(n, (byte)(11.0f + f), 0);
        }
    }

    private void replaceDoublePushInstruction(int n, Instruction instruction) {
        double d;
        Value value = this.partialEvaluator.stackTopValueAfter(n, 0);
        if (value.isSpecific() && ((d = value.doubleValue().value()) == 0.0 || d == 1.0)) {
            this.replacePushInstruction(n, (byte)(14.0 + d), 0);
        }
    }

    private void replaceReferencePushInstruction(int n, Instruction instruction) {
        ReferenceValue referenceValue;
        Value value = this.partialEvaluator.stackTopValueAfter(n, 0);
        if (value.isSpecific() && (referenceValue = value.referenceValue()).isNull() == 1) {
            this.replacePushInstruction(n, (byte)1, 0);
        }
    }

    private void replacePushInstruction(int n, byte by, int n2) {
        Instruction instruction = new SimpleInstruction(by, n2).shrink();
        this.codeAttrInfoEditor.replaceInstruction(n, instruction);
        this.isSimplified[n] = true;
        if (this.extraPushInstructionVisitor != null) {
            this.extraPushInstructionVisitor.visitSimpleInstruction(null, null, null, n, null);
        }
    }

    private void replaceBranchInstruction(int n, Instruction instruction) {
        InstructionOffsetValue instructionOffsetValue;
        if (this.partialEvaluator.isTraced(n) && (instructionOffsetValue = this.partialEvaluator.branchTargets(n)) != null && instructionOffsetValue.instructionOffsetCount() == 1) {
            int n2 = instructionOffsetValue.instructionOffset(0) - n;
            if (n2 == instruction.length(n)) {
                this.codeAttrInfoEditor.deleteInstruction(n);
            } else {
                Instruction instruction2 = new BranchInstruction(-56, n2).shrink();
                this.codeAttrInfoEditor.replaceInstruction(n, instruction2);
                this.isSimplified[n] = true;
                if (this.extraBranchInstructionVisitor != null) {
                    this.extraBranchInstructionVisitor.visitBranchInstruction(null, null, null, n, null);
                }
            }
        }
    }

    private void initializeParameters(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo) {
        boolean bl = (methodInfo.getAccessFlags() & 8) != 0;
        String string = methodInfo.getDescriptor(classFile);
        int n = (bl ? 0 : 1) + ClassUtil.internalMethodParameterSize(string);
        this.parameters.reset(n);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
        int n2 = 0;
        if (!bl) {
            this.parameters.store(n2++, ReferenceValueFactory.create(false));
        }
        while (internalTypeEnumeration.hasMoreTypes()) {
            String string2 = internalTypeEnumeration.nextType();
            Value value = ValueFactory.create(string2);
            this.parameters.store(n2, value);
            n2 += value.isCategory2() ? 2 : 1;
        }
    }

    private void initializeNecessary(CodeAttrInfo codeAttrInfo) {
        int n = codeAttrInfo.u4codeLength;
        if (this.isNecessary.length < n) {
            this.isNecessary = new boolean[n];
            this.isSimplified = new boolean[n];
        } else {
            for (int i = 0; i < n; ++i) {
                this.isNecessary[i] = false;
                this.isSimplified[i] = false;
            }
        }
    }

    private boolean isVariableReferenced(CodeAttrInfo codeAttrInfo, int n) {
        int n2 = codeAttrInfo.u4codeLength;
        for (int i = 0; i < n2; ++i) {
            if (!this.isNecessary[i] || this.isSimplified[i] || this.partialEvaluator.variableValueBefore(i, n) == null || !this.isVariableNecessaryBefore(i, n, false)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryBefore(int n, int n2, boolean bl) {
        return this.isNecessary(this.partialEvaluator.variableProducerOffsetsBefore(n, n2), true, bl);
    }

    private boolean isStackEntriesNecessaryAfter(int n, int n2, int n3, boolean bl) {
        boolean bl2;
        boolean bl3 = this.isStackEntryNecessaryAfter(n, n2, bl);
        if (bl3 ^ (bl2 = this.isStackEntryNecessaryAfter(n, n3, bl))) {
            throw new IllegalArgumentException("Can't handle partial use of dup2 instructions");
        }
        return bl3 || bl2;
    }

    private boolean isStackEntryNecessaryBefore(int n, int n2, boolean bl) {
        return this.isNecessary(this.partialEvaluator.stackTopConsumerOffsetsBefore(n, n2), false, bl);
    }

    private boolean isStackEntryNecessaryAfter(int n, int n2, boolean bl) {
        return this.isNecessary(this.partialEvaluator.stackTopConsumerOffsetsAfter(n, n2), false, bl);
    }

    private boolean isNecessary(InstructionOffsetValue instructionOffsetValue, boolean bl, boolean bl2) {
        int n = instructionOffsetValue.instructionOffsetCount();
        for (int i = 0; i < n; ++i) {
            int n2 = instructionOffsetValue.instructionOffset(i);
            if (!(bl2 ^ (this.isNecessary[n2] && (bl || !this.isSimplified[n2])))) continue;
            return !bl2;
        }
        return bl2;
    }
}

