/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassFileCleaner;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.classfile.visitor.MultiClassFileVisitor;
import proguard.shrink.ClassFileShrinker;
import proguard.shrink.InnerUsageMarker;
import proguard.shrink.InterfaceUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFileFilter;

public class Shrinker {
    private Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    public ClassPool execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        classPool.classFilesAccept(new ClassFileCleaner());
        classPool2.classFilesAccept(new ClassFileCleaner());
        UsageMarker usageMarker = this.configuration.whyAreYouKeeping == null ? new UsageMarker() : new ShortestUsageMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, (ClassFileVisitor)usageMarker, (MemberInfoVisitor)usageMarker);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool.classFilesAccept(new InterfaceUsageMarker(usageMarker));
        classPool.classFilesAccept(new InnerUsageMarker(usageMarker));
        if (this.configuration.whyAreYouKeeping != null) {
            System.out.println();
            object = new ShortestUsagePrinter((ShortestUsageMarker)usageMarker, this.configuration.verbose);
            ClassPoolVisitor classPoolVisitor2 = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.whyAreYouKeeping, (ClassFileVisitor)object, (MemberInfoVisitor)object);
            classPool.accept(classPoolVisitor2);
            classPool2.accept(classPoolVisitor2);
        }
        if (this.configuration.printUsage != null) {
            object = this.isFile(this.configuration.printUsage) ? new PrintStream(new BufferedOutputStream(new FileOutputStream(this.configuration.printUsage))) : System.out;
            classPool.classFilesAcceptAlphabetically(new UsagePrinter(usageMarker, true, (PrintStream)object));
            if (object != System.out) {
                ((PrintStream)object).close();
            }
        }
        object = new ClassPool();
        classPool.classFilesAccept(new UsedClassFileFilter(usageMarker, new MultiClassFileVisitor(new ClassFileVisitor[]{new ClassFileShrinker(usageMarker, 1024), new ClassPoolFiller((ClassPool)object, false)})));
        return object;
    }

    private boolean isFile(File file) {
        return file.getPath().length() > 0;
    }
}

