/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicatorCriteria;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.utility.NumberUtility;

public class GraphicalIndicator {
    private ProjectFile m_projectFile;
    private FieldType m_fieldType;
    private boolean m_displayGraphicalIndicators;
    private boolean m_summaryRowsInheritFromNonSummaryRows;
    private boolean m_projectSummaryInheritsFromSummaryRows;
    private boolean m_showDataValuesInToolTips;
    private List m_nonSummaryRowCriteria = new LinkedList();
    private List m_summaryRowCriteria = new LinkedList();
    private List m_projectSummaryCriteria = new LinkedList();

    public GraphicalIndicator(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    public int evaluate(FieldContainer container) {
        Task task;
        List criteria = container instanceof Task ? (NumberUtility.getInt((task = (Task)container).getUniqueID()) == 0 ? (!this.m_projectSummaryInheritsFromSummaryRows ? this.m_projectSummaryCriteria : (!this.m_summaryRowsInheritFromNonSummaryRows ? this.m_summaryRowCriteria : this.m_nonSummaryRowCriteria)) : (task.getSummary() ? (!this.m_summaryRowsInheritFromNonSummaryRows ? this.m_summaryRowCriteria : this.m_nonSummaryRowCriteria) : this.m_nonSummaryRowCriteria)) : this.m_nonSummaryRowCriteria;
        int result = -1;
        Iterator iter = criteria.iterator();
        while (iter.hasNext()) {
            result = ((GraphicalIndicatorCriteria)iter.next()).evaluate(container);
            if (result != -1) break;
        }
        if (result == -1) {
            result = 0;
        }
        return result;
    }

    public void setFieldType(FieldType fieldType) {
        this.m_fieldType = fieldType;
    }

    public FieldType getFieldType() {
        return this.m_fieldType;
    }

    public boolean getDisplayGraphicalIndicators() {
        return this.m_displayGraphicalIndicators;
    }

    public void setDisplayGraphicalIndicators(boolean displayGraphicalIndicators) {
        this.m_displayGraphicalIndicators = displayGraphicalIndicators;
    }

    public List getNonSummaryRowCriteria() {
        return this.m_nonSummaryRowCriteria;
    }

    public List getProjectSummaryCriteria() {
        return this.m_projectSummaryCriteria;
    }

    public List getSummaryRowCriteria() {
        return this.m_summaryRowCriteria;
    }

    public boolean getProjectSummaryInheritsFromSummaryRows() {
        return this.m_projectSummaryInheritsFromSummaryRows;
    }

    public void setProjectSummaryInheritsFromSummaryRows(boolean projectSummaryInheritsFromSummaryRows) {
        this.m_projectSummaryInheritsFromSummaryRows = projectSummaryInheritsFromSummaryRows;
    }

    public boolean getSummaryRowsInheritFromNonSummaryRows() {
        return this.m_summaryRowsInheritFromNonSummaryRows;
    }

    public void setSummaryRowsInheritFromNonSummaryRows(boolean summaryRowsInheritFromNonSummaryRows) {
        this.m_summaryRowsInheritFromNonSummaryRows = summaryRowsInheritFromNonSummaryRows;
    }

    public boolean getShowDataValuesInToolTips() {
        return this.m_showDataValuesInToolTips;
    }

    public void setShowDataValuesInToolTips(boolean showDataValuesInToolTips) {
        this.m_showDataValuesInToolTips = showDataValuesInToolTips;
    }

    public void addNonSummaryRowCriteria(GraphicalIndicatorCriteria criteria) {
        this.m_nonSummaryRowCriteria.add(criteria);
    }

    public void addSummaryRowCriteria(GraphicalIndicatorCriteria criteria) {
        this.m_summaryRowCriteria.add(criteria);
    }

    public void addProjectSummaryCriteria(GraphicalIndicatorCriteria criteria) {
        this.m_projectSummaryCriteria.add(criteria);
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[GraphicalIndicator");
        pw.println(" FieldType=" + this.m_fieldType);
        pw.println(" DisplayGraphicalIndicators=" + this.m_displayGraphicalIndicators);
        pw.println(" SummaryRowsInheritFromNonSummaryRows=" + this.m_summaryRowsInheritFromNonSummaryRows);
        pw.println(" ProjectSummaryInheritsFromSummaryRows=" + this.m_projectSummaryInheritsFromSummaryRows);
        pw.println(" ShowDataValuesInToolTips=" + this.m_showDataValuesInToolTips);
        pw.println(" NonSummaryRowCriteria=");
        Iterator iter = this.m_nonSummaryRowCriteria.iterator();
        while (iter.hasNext()) {
            pw.println("  " + iter.next());
        }
        pw.println(" SummaryRowCriteria=");
        iter = this.m_summaryRowCriteria.iterator();
        while (iter.hasNext()) {
            pw.println("  " + iter.next());
        }
        pw.println(" ProjectSummaryCriteria=");
        iter = this.m_projectSummaryCriteria.iterator();
        while (iter.hasNext()) {
            pw.println("  " + iter.next());
        }
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

