/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.Filter;
import net.sf.mpxj.GraphicalIndicator;
import net.sf.mpxj.Group;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.Table;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.View;
import net.sf.mpxj.ViewState;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.utility.NumberUtility;

public final class ProjectFile {
    private int m_taskUniqueID;
    private int m_calendarUniqueID;
    private int m_taskID;
    private int m_resourceUniqueID;
    private int m_resourceID;
    private List m_allResources = new LinkedList();
    private List m_allTasks = new LinkedList();
    private List m_childTasks = new LinkedList();
    private List m_allResourceAssignments = new LinkedList();
    private List m_baseCalendars = new LinkedList();
    private List m_resourceCalendars = new LinkedList();
    private FileCreationRecord m_fileCreationRecord = new FileCreationRecord(this);
    private ProjectHeader m_projectHeader = new ProjectHeader(this);
    private char m_delimiter = (char)44;
    private boolean m_autoWBS;
    private boolean m_autoOutlineLevel;
    private boolean m_autoOutlineNumber;
    private boolean m_autoTaskUniqueID;
    private boolean m_autoCalendarUniqueID;
    private boolean m_autoTaskID;
    private boolean m_autoResourceUniqueID;
    private boolean m_autoResourceID;
    private Map m_taskFieldAlias = new HashMap();
    private Map m_aliasTaskField = new HashMap();
    private Map m_resourceFieldAlias = new HashMap();
    private Map m_aliasResourceField = new HashMap();
    private Map m_taskUniqueIDMap = new HashMap();
    private Map m_taskIDMap = new HashMap();
    private Map m_resourceUniqueIDMap = new HashMap();
    private Map m_resourceIDMap = new HashMap();
    private Map m_calendarUniqueIDMap = new HashMap();
    private List m_projectListeners;
    private int m_mppFileType;
    private List m_views = new ArrayList();
    private List m_tables = new ArrayList();
    private Map m_graphicalIndicators = new HashMap();
    private Map m_taskTablesByName = new HashMap();
    private Map m_resourceTablesByName = new HashMap();
    private List m_taskFilters = new ArrayList();
    private List m_resourceFilters = new ArrayList();
    private Map m_filtersByName = new HashMap();
    private List m_groups = new ArrayList();
    private Map m_groupsByName = new HashMap();
    private SubProject m_resourceSubProject;
    private boolean m_autoFilter;
    private ViewState m_viewState;

    public char getDelimiter() {
        return this.m_delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.m_delimiter = delimiter;
    }

    public void updateUniqueIdentifiers() {
        for (Task task : this.m_allTasks) {
            if (task.getUniqueID() != null) continue;
            task.setUniqueID(task.getID());
        }
        for (Resource resource : this.m_allResources) {
            if (resource.getUniqueID() != null) continue;
            resource.setUniqueID(resource.getID());
        }
    }

    void addTask(Task task) {
        this.m_allTasks.add(task);
    }

    public Task addTask() {
        Task task = new Task(this, null);
        this.m_allTasks.add(task);
        this.m_childTasks.add(task);
        return task;
    }

    public void removeTask(Task task) {
        List childTaskList;
        this.m_allTasks.remove(task);
        this.m_taskUniqueIDMap.remove(task.getUniqueID());
        this.m_taskIDMap.remove(task.getID());
        Task parentTask = task.getParentTask();
        if (parentTask != null) {
            parentTask.removeChildTask(task);
        } else {
            this.m_childTasks.remove(task);
        }
        Iterator iter = this.m_allResourceAssignments.iterator();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            if (assignment.getTask() != task) continue;
            assignment.getResource().removeResourceAssignment(assignment);
            iter.remove();
        }
        while (!(childTaskList = task.getChildTasks()).isEmpty()) {
            this.removeTask((Task)childTaskList.get(0));
        }
    }

    public void synchronizeTaskIDs() {
        if (!this.m_allTasks.isEmpty()) {
            Collections.sort(this.m_allTasks);
            Task firstTask = (Task)this.m_allTasks.get(0);
            int id = NumberUtility.getInt(firstTask.getID());
            if (id != 0) {
                id = 1;
            }
            Iterator iter = this.m_allTasks.iterator();
            while (iter.hasNext()) {
                ((Task)iter.next()).setID(new Integer(id++));
            }
        }
    }

    public void synchronizeResourceIDs() {
        if (!this.m_allResources.isEmpty()) {
            Collections.sort(this.m_allResources);
            int id = 1;
            for (Resource resource : this.m_allResources) {
                resource.setID(new Integer(id++));
            }
        }
    }

    public List getChildTasks() {
        return this.m_childTasks;
    }

    public List getAllTasks() {
        return this.m_allTasks;
    }

    public void setAutoWBS(boolean flag) {
        this.m_autoWBS = flag;
    }

    public void setAutoOutlineLevel(boolean flag) {
        this.m_autoOutlineLevel = flag;
    }

    public void setAutoOutlineNumber(boolean flag) {
        this.m_autoOutlineNumber = flag;
    }

    public void setAutoTaskUniqueID(boolean flag) {
        this.m_autoTaskUniqueID = flag;
    }

    public void setAutoCalendarUniqueID(boolean flag) {
        this.m_autoCalendarUniqueID = flag;
    }

    public void setAutoTaskID(boolean flag) {
        this.m_autoTaskID = flag;
    }

    public boolean getAutoWBS() {
        return this.m_autoWBS;
    }

    public boolean getAutoOutlineLevel() {
        return this.m_autoOutlineLevel;
    }

    public boolean getAutoOutlineNumber() {
        return this.m_autoOutlineNumber;
    }

    public boolean getAutoTaskUniqueID() {
        return this.m_autoTaskUniqueID;
    }

    public boolean getAutoCalendarUniqueID() {
        return this.m_autoCalendarUniqueID;
    }

    public boolean getAutoTaskID() {
        return this.m_autoTaskID;
    }

    public int getTaskUniqueID() {
        return ++this.m_taskUniqueID;
    }

    int getCalendarUniqueID() {
        return ++this.m_calendarUniqueID;
    }

    public int getTaskID() {
        return ++this.m_taskID;
    }

    public void setAutoResourceUniqueID(boolean flag) {
        this.m_autoResourceUniqueID = flag;
    }

    public void setAutoResourceID(boolean flag) {
        this.m_autoResourceID = flag;
    }

    public boolean getAutoResourceUniqueID() {
        return this.m_autoResourceUniqueID;
    }

    public boolean getAutoResourceID() {
        return this.m_autoResourceID;
    }

    public int getResourceUniqueID() {
        return ++this.m_resourceUniqueID;
    }

    public int getResourceID() {
        return ++this.m_resourceID;
    }

    public FileCreationRecord getFileCreationRecord() {
        return this.m_fileCreationRecord;
    }

    public ProjectCalendar addResourceCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this, false);
        this.m_resourceCalendars.add(calendar);
        return calendar;
    }

    public ProjectCalendar addBaseCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this, true);
        this.m_baseCalendars.add(calendar);
        return calendar;
    }

    public void removeCalendar(ProjectCalendar calendar) {
        Resource resource = calendar.getResource();
        if (resource == null) {
            this.m_baseCalendars.remove(calendar);
        } else {
            this.m_resourceCalendars.remove(calendar);
            resource.setResourceCalendar(null);
        }
    }

    public ProjectCalendar addDefaultBaseCalendar() throws MPXJException {
        ProjectCalendar calendar = this.addBaseCalendar();
        calendar.setName("Standard");
        calendar.setWorkingDay(Day.SUNDAY, false);
        calendar.setWorkingDay(Day.MONDAY, true);
        calendar.setWorkingDay(Day.TUESDAY, true);
        calendar.setWorkingDay(Day.WEDNESDAY, true);
        calendar.setWorkingDay(Day.THURSDAY, true);
        calendar.setWorkingDay(Day.FRIDAY, true);
        calendar.setWorkingDay(Day.SATURDAY, false);
        calendar.addDefaultCalendarHours();
        return calendar;
    }

    public ProjectCalendar getDefaultResourceCalendar() {
        ProjectCalendar calendar = new ProjectCalendar(this, false);
        calendar.setWorkingDay(Day.SUNDAY, 2);
        calendar.setWorkingDay(Day.MONDAY, 2);
        calendar.setWorkingDay(Day.TUESDAY, 2);
        calendar.setWorkingDay(Day.WEDNESDAY, 2);
        calendar.setWorkingDay(Day.THURSDAY, 2);
        calendar.setWorkingDay(Day.FRIDAY, 2);
        calendar.setWorkingDay(Day.SATURDAY, 2);
        return calendar;
    }

    public List getBaseCalendars() {
        return this.m_baseCalendars;
    }

    public List getResourceCalendars() {
        return this.m_resourceCalendars;
    }

    public ProjectHeader getProjectHeader() {
        return this.m_projectHeader;
    }

    public Resource addResource() {
        Resource resource = new Resource(this);
        this.m_allResources.add(resource);
        return resource;
    }

    public void removeResource(Resource resource) {
        this.m_allResources.remove(resource);
        this.m_resourceUniqueIDMap.remove(resource.getUniqueID());
        this.m_resourceIDMap.remove(resource.getID());
        Iterator iter = this.m_allResourceAssignments.iterator();
        Integer resourceUniqueID = resource.getUniqueID();
        while (iter.hasNext()) {
            ResourceAssignment assignment = (ResourceAssignment)iter.next();
            if (!NumberUtility.equals(assignment.getResourceUniqueID(), resourceUniqueID)) continue;
            assignment.getTask().removeResourceAssignment(assignment);
            iter.remove();
        }
        ProjectCalendar calendar = resource.getResourceCalendar();
        if (calendar != null) {
            calendar.remove();
        }
    }

    public List getAllResources() {
        return this.m_allResources;
    }

    public List getAllResourceAssignments() {
        return this.m_allResourceAssignments;
    }

    void addResourceAssignment(ResourceAssignment assignment) {
        this.m_allResourceAssignments.add(assignment);
    }

    void removeResourceAssignment(ResourceAssignment assignment) {
        this.m_allResourceAssignments.remove(assignment);
        assignment.getTask().removeResourceAssignment(assignment);
        assignment.getResource().removeResourceAssignment(assignment);
    }

    public ResourceAssignment newResourceAssignment(Task task) {
        return new ResourceAssignment(this, task);
    }

    public ProjectCalendar getBaseCalendar(String calendarName) {
        ProjectCalendar calendar2 = null;
        if (calendarName != null && calendarName.length() != 0) {
            for (ProjectCalendar calendar2 : this.m_baseCalendars) {
                String name = calendar2.getName();
                if (name != null && name.equalsIgnoreCase(calendarName)) break;
                calendar2 = null;
            }
        }
        return calendar2;
    }

    public ProjectCalendar getBaseCalendarByUniqueID(Integer calendarID) {
        return (ProjectCalendar)this.m_calendarUniqueIDMap.get(calendarID);
    }

    int getChildTaskCount() {
        return this.m_childTasks.size();
    }

    public Duration getDuration(Date startDate, Date endDate) throws MPXJException {
        return this.getDuration("Standard", startDate, endDate);
    }

    public Duration getDuration(String calendarName, Date startDate, Date endDate) throws MPXJException {
        ProjectCalendar calendar = this.getBaseCalendar(calendarName);
        if (calendar == null) {
            throw new MPXJException("Invalid calendar: " + calendarName);
        }
        return calendar.getDuration(startDate, endDate);
    }

    public Task getTaskByID(Integer id) {
        return (Task)this.m_taskIDMap.get(id);
    }

    public Task getTaskByUniqueID(Integer id) {
        return (Task)this.m_taskUniqueIDMap.get(id);
    }

    public Resource getResourceByID(Integer id) {
        return (Resource)this.m_resourceIDMap.get(id);
    }

    public Resource getResourceByUniqueID(Integer id) {
        return (Resource)this.m_resourceUniqueIDMap.get(id);
    }

    /*
     * Unable to fully structure code
     */
    public void updateStructure() {
        block5: {
            if (this.m_allTasks.size() <= 1) break block5;
            Collections.sort(this.m_allTasks);
            this.m_childTasks.clear();
            lastTask = null;
            lastLevel = -1;
            for (Task task : this.m_allTasks) {
                block6: {
                    block7: {
                        if (task.getNull()) continue;
                        task.clearChildTasks();
                        level = NumberUtility.getInt(task.getOutlineLevel());
                        parent = null;
                        if (lastTask == null) break block6;
                        if (level != lastLevel) break block7;
                        parent = lastTask.getParentTask();
                        break block6;
                    }
                    if (level <= lastLevel) ** GOTO lbl22
                    parent = lastTask;
                    break block6;
                    while ((parent = lastTask.getParentTask()) != null) {
                        lastLevel = NumberUtility.getInt(parent.getOutlineLevel());
                        lastTask = parent;
lbl22:
                        // 2 sources

                        if (level <= lastLevel) continue;
                    }
                }
                lastTask = task;
                lastLevel = level;
                if (this.getAutoWBS()) {
                    task.generateWBS(parent);
                }
                if (this.getAutoOutlineNumber()) {
                    task.generateOutlineNumber(parent);
                }
                if (parent == null) {
                    this.m_childTasks.add(task);
                    continue;
                }
                parent.addChildTask(task);
            }
        }
    }

    public void updateUniqueCounters() {
        int uniqueID;
        for (Task task : this.m_allTasks) {
            uniqueID = NumberUtility.getInt(task.getUniqueID());
            if (uniqueID <= this.m_taskUniqueID) continue;
            this.m_taskUniqueID = uniqueID;
        }
        for (Resource resource : this.m_allResources) {
            uniqueID = NumberUtility.getInt(resource.getUniqueID());
            if (uniqueID <= this.m_resourceUniqueID) continue;
            this.m_resourceUniqueID = uniqueID;
        }
        for (ProjectCalendar calendar : this.m_baseCalendars) {
            uniqueID = NumberUtility.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
        for (ProjectCalendar calendar : this.m_resourceCalendars) {
            uniqueID = NumberUtility.getInt(calendar.getUniqueID());
            if (uniqueID <= this.m_calendarUniqueID) continue;
            this.m_calendarUniqueID = uniqueID;
        }
    }

    public Date getStartDate() {
        Date startDate = null;
        for (Task task : this.m_allTasks) {
            Date taskStartDate;
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            if (task.getMilestone()) {
                taskStartDate = task.getActualFinish();
                if (taskStartDate == null) {
                    taskStartDate = task.getFinish();
                }
            } else {
                taskStartDate = task.getActualStart();
                if (taskStartDate == null) {
                    taskStartDate = task.getStart();
                }
            }
            if (taskStartDate == null) continue;
            if (startDate == null) {
                startDate = taskStartDate;
                continue;
            }
            if (taskStartDate.getTime() >= startDate.getTime()) continue;
            startDate = taskStartDate;
        }
        return startDate;
    }

    public Date getFinishDate() {
        Date finishDate = null;
        for (Task task : this.m_allTasks) {
            if (NumberUtility.getInt(task.getUniqueID()) == 0) continue;
            Date taskFinishDate = task.getActualFinish();
            if (taskFinishDate == null) {
                taskFinishDate = task.getFinish();
            }
            if (taskFinishDate == null) continue;
            if (finishDate == null) {
                finishDate = taskFinishDate;
                continue;
            }
            if (taskFinishDate.getTime() <= finishDate.getTime()) continue;
            finishDate = taskFinishDate;
        }
        return finishDate;
    }

    public void fireTaskReadEvent(Task task) {
        if (this.m_projectListeners != null) {
            Iterator iter = this.m_projectListeners.iterator();
            while (iter.hasNext()) {
                ((ProjectListener)iter.next()).taskRead(task);
            }
        }
    }

    public void fireTaskWrittenEvent(Task task) {
        if (this.m_projectListeners != null) {
            Iterator iter = this.m_projectListeners.iterator();
            while (iter.hasNext()) {
                ((ProjectListener)iter.next()).taskWritten(task);
            }
        }
    }

    public void fireResourceReadEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            Iterator iter = this.m_projectListeners.iterator();
            while (iter.hasNext()) {
                ((ProjectListener)iter.next()).resourceRead(resource);
            }
        }
    }

    public void fireResourceWrittenEvent(Resource resource) {
        if (this.m_projectListeners != null) {
            Iterator iter = this.m_projectListeners.iterator();
            while (iter.hasNext()) {
                ((ProjectListener)iter.next()).resourceWritten(resource);
            }
        }
    }

    public void addProjectListener(ProjectListener listener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList();
        }
        this.m_projectListeners.add(listener);
    }

    public void removeProjectListener(ProjectListener listener) {
        if (this.m_projectListeners != null) {
            this.m_projectListeners.remove(listener);
        }
    }

    public void setTaskFieldAlias(TaskField field, String alias) {
        if (alias != null && alias.length() != 0) {
            this.m_taskFieldAlias.put(field, alias);
            this.m_aliasTaskField.put(alias, field);
        }
    }

    public String getTaskFieldAlias(TaskField field) {
        return (String)this.m_taskFieldAlias.get(field);
    }

    public TaskField getAliasTaskField(String alias) {
        return (TaskField)this.m_aliasTaskField.get(alias);
    }

    public void setResourceFieldAlias(ResourceField field, String alias) {
        if (alias != null && alias.length() != 0) {
            this.m_resourceFieldAlias.put(field, alias);
            this.m_aliasResourceField.put(alias, field);
        }
    }

    public String getResourceFieldAlias(ResourceField field) {
        return (String)this.m_resourceFieldAlias.get(field);
    }

    public ResourceField getAliasResourceField(String alias) {
        return (ResourceField)this.m_aliasResourceField.get(alias);
    }

    public Map getTaskFieldAliasMap() {
        return this.m_taskFieldAlias;
    }

    public Map getResourceFieldAliasMap() {
        return this.m_resourceFieldAlias;
    }

    void unmapTaskUniqueID(Integer id) {
        this.m_taskUniqueIDMap.remove(id);
    }

    void mapTaskUniqueID(Integer id, Task task) {
        this.m_taskUniqueIDMap.put(id, task);
    }

    void unmapTaskID(Integer id) {
        this.m_taskIDMap.remove(id);
    }

    void mapTaskID(Integer id, Task task) {
        this.m_taskIDMap.put(id, task);
    }

    void unmapResourceUniqueID(Integer id) {
        this.m_resourceUniqueIDMap.remove(id);
    }

    void mapResourceUniqueID(Integer id, Resource resource) {
        this.m_resourceUniqueIDMap.put(id, resource);
    }

    void unmapResourceID(Integer id) {
        this.m_resourceIDMap.remove(id);
    }

    void mapResourceID(Integer id, Resource resource) {
        this.m_resourceIDMap.put(id, resource);
    }

    void unmapCalendarUniqueID(Integer id) {
        this.m_calendarUniqueIDMap.remove(id);
    }

    void mapCalendarUniqueID(Integer id, ProjectCalendar calendar) {
        this.m_calendarUniqueIDMap.put(id, calendar);
    }

    public int getMppFileType() {
        return this.m_mppFileType;
    }

    public void setMppFileType(int fileType) {
        this.m_mppFileType = fileType;
    }

    public void addView(View view) {
        this.m_views.add(view);
    }

    public List getViews() {
        return this.m_views;
    }

    public void addTable(Table table) {
        this.m_tables.add(table);
        if (!table.getResourceFlag()) {
            this.m_taskTablesByName.put(table.getName(), table);
        } else {
            this.m_resourceTablesByName.put(table.getName(), table);
        }
    }

    public List getTables() {
        return this.m_tables;
    }

    public void addFilter(Filter filter) {
        if (filter.isTaskFilter()) {
            this.m_taskFilters.add(filter);
        }
        if (filter.isResourceFilter()) {
            this.m_resourceFilters.add(filter);
        }
        this.m_filtersByName.put(filter.getName(), filter);
    }

    public void removeFilter(String filterName) {
        Filter filter = this.getFilterByName(filterName);
        if (filter != null) {
            if (filter.isTaskFilter()) {
                this.m_taskFilters.remove(filter);
            }
            if (filter.isResourceFilter()) {
                this.m_resourceFilters.remove(filter);
            }
            this.m_filtersByName.remove(filterName);
        }
    }

    public List getAllResourceFilters() {
        return this.m_resourceFilters;
    }

    public List getAllTaskFilters() {
        return this.m_taskFilters;
    }

    public Filter getFilterByName(String name) {
        return (Filter)this.m_filtersByName.get(name);
    }

    public List getAllGroups() {
        return this.m_groups;
    }

    public Group getGroupByName(String name) {
        return (Group)this.m_groupsByName.get(name);
    }

    public void addGroup(Group group) {
        this.m_groups.add(group);
        this.m_groupsByName.put(group.getName(), group);
    }

    public void addGraphicalIndicator(FieldType field, GraphicalIndicator indicator) {
        this.m_graphicalIndicators.put(field, indicator);
    }

    public GraphicalIndicator getGraphicalIndicator(FieldType field) {
        return (GraphicalIndicator)this.m_graphicalIndicators.get(field);
    }

    public Table getTaskTableByName(String name) {
        return (Table)this.m_taskTablesByName.get(name);
    }

    public Table getResourceTableByName(String name) {
        return (Table)this.m_resourceTablesByName.get(name);
    }

    public void setResourceSubProject(SubProject project) {
        this.m_resourceSubProject = project;
    }

    public SubProject getResourceSubProject() {
        return this.m_resourceSubProject;
    }

    public boolean getAutoFilter() {
        return this.m_autoFilter;
    }

    public void setAutoFilter(boolean autoFilter) {
        this.m_autoFilter = autoFilter;
    }

    public void setViewState(ViewState viewState) {
        this.m_viewState = viewState;
    }

    public ViewState getViewState() {
        return this.m_viewState;
    }
}

