/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

public final class TestOperator {
    public static final int IS_ANY_VALUE_VALUE = 0;
    public static final int IS_WITHIN_VALUE = 1;
    public static final int IS_GREATER_THAN_VALUE = 2;
    public static final int IS_LESS_THAN_VALUE = 3;
    public static final int IS_GREATER_THAN_OR_EQUAL_TO_VALUE = 4;
    public static final int IS_LESS_THAN_OR_EQUAL_TO_VALUE = 5;
    public static final int EQUALS_VALUE = 6;
    public static final int DOES_NOT_EQUAL_VALUE = 7;
    public static final int CONTAINS_VALUE = 8;
    public static final int IS_NOT_WITHIN_VALUE = 9;
    public static final int DOES_NOT_CONTAIN_VALUE = 10;
    public static final int CONTAINS_EXACTLY_VALUE = 11;
    public static final int MAX_TYPE_VALUES = 12;
    public static final TestOperator EQUALS = new TestOperator(6);
    public static final TestOperator DOES_NOT_EQUAL = new TestOperator(7);
    public static final TestOperator IS_GREATER_THAN = new TestOperator(2);
    public static final TestOperator IS_GREATER_THAN_OR_EQUAL_TO = new TestOperator(4);
    public static final TestOperator IS_LESS_THAN = new TestOperator(3);
    public static final TestOperator IS_LESS_THAN_OR_EQUAL_TO = new TestOperator(5);
    public static final TestOperator IS_WITHIN = new TestOperator(1);
    public static final TestOperator IS_NOT_WITHIN = new TestOperator(9);
    public static final TestOperator CONTAINS = new TestOperator(8);
    public static final TestOperator DOES_NOT_CONTAIN = new TestOperator(10);
    public static final TestOperator CONTAINS_EXACTLY = new TestOperator(11);
    public static final TestOperator IS_ANY_VALUE = new TestOperator(0);
    private static final TestOperator[] TYPE_VALUES = new TestOperator[]{IS_ANY_VALUE, IS_WITHIN, IS_GREATER_THAN, IS_LESS_THAN, IS_GREATER_THAN_OR_EQUAL_TO, IS_LESS_THAN_OR_EQUAL_TO, EQUALS, DOES_NOT_EQUAL, CONTAINS, IS_NOT_WITHIN, DOES_NOT_CONTAIN, CONTAINS_EXACTLY};
    private static final String[] NAME_VALUES = new String[]{"IS_ANY_VALUE", "IS_WITHIN", "IS_GREATER_THAN", "IS_LESS_THAN", "IS_GREATER_THAN_OR_EQUAL_TO", "IS_LESS_THAN_OR_EQUAL_TO", "EQUALS", "DOES_NOT_EQUAL", "CONTAINS", "IS_NOT_WITHIN", "DOES_NOT_CONTAIN", "CONTAINS_EXACTLY"};
    private int m_type;

    private TestOperator(int type) {
        this.m_type = type;
    }

    public static TestOperator getInstance(int type) {
        if (type < 0 || type >= TYPE_VALUES.length) {
            type = 0;
        }
        return TYPE_VALUES[type];
    }

    public int getType() {
        return this.m_type;
    }

    public boolean evaluate(Object lhs, Object rhs) {
        boolean result = false;
        switch (this.m_type) {
            case 0: {
                result = true;
                break;
            }
            case 1: {
                result = this.evaluateWithin(lhs, rhs);
                break;
            }
            case 2: {
                result = this.evaluateCompareTo(lhs, rhs) > 0;
                break;
            }
            case 3: {
                result = this.evaluateCompareTo(lhs, rhs) < 0;
                break;
            }
            case 4: {
                result = this.evaluateCompareTo(lhs, rhs) >= 0;
                break;
            }
            case 5: {
                result = this.evaluateCompareTo(lhs, rhs) <= 0;
                break;
            }
            case 6: {
                if (lhs == null) {
                    result = lhs == this.getSingleOperand(rhs);
                    break;
                }
                result = lhs.equals(this.getSingleOperand(rhs));
                break;
            }
            case 7: {
                if (lhs == null) {
                    result = lhs != this.getSingleOperand(rhs);
                    break;
                }
                result = !lhs.equals(this.getSingleOperand(rhs));
                break;
            }
            case 8: {
                result = this.evaluateContains(lhs, rhs);
                break;
            }
            case 9: {
                result = !this.evaluateWithin(lhs, rhs);
                break;
            }
            case 10: {
                result = !this.evaluateContains(lhs, rhs);
                break;
            }
            case 11: {
                result = this.evaluateContainsExactly(lhs, rhs);
            }
        }
        return result;
    }

    private Object getSingleOperand(Object operand) {
        if (operand instanceof Object[]) {
            Object[] list = (Object[])operand;
            operand = list[0];
        }
        return operand;
    }

    private boolean evaluateWithin(Object lhs, Object rhs) {
        boolean result = false;
        if (lhs != null && rhs instanceof Object[]) {
            Comparable lhsComparable = (Comparable)lhs;
            Object[] rhsList = (Object[])rhs;
            if (rhsList[0] != null && rhsList[1] != null) {
                result = lhsComparable.compareTo(rhsList[0]) >= 0 && lhsComparable.compareTo(rhsList[1]) <= 0;
            }
        }
        return result;
    }

    private int evaluateCompareTo(Object lhs, Object rhs) {
        rhs = this.getSingleOperand(rhs);
        int result = lhs == null || rhs == null ? (lhs == rhs ? 0 : (lhs == null ? 1 : -1)) : ((Comparable)lhs).compareTo(rhs);
        return result;
    }

    private boolean evaluateContains(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).toUpperCase().indexOf(((String)rhs).toUpperCase()) != -1;
        }
        return result;
    }

    private boolean evaluateContainsExactly(Object lhs, Object rhs) {
        boolean result = false;
        rhs = this.getSingleOperand(rhs);
        if (lhs instanceof String && rhs instanceof String) {
            result = ((String)lhs).indexOf((String)rhs) != -1;
        }
        return result;
    }

    public String toString() {
        return NAME_VALUES[this.m_type];
    }
}

