/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.junit;

import java.text.SimpleDateFormat;
import java.util.List;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.junit.MPXJTestCase;
import net.sf.mpxj.mpd.MPDDatabaseReader;
import net.sf.mpxj.mpp.MPPReader;

public class MppResourceTest
extends MPXJTestCase {
    public void testMpp9Resource() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9resource.mpp");
        this.testResources(mpp);
    }

    public void testMpp12Resource() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12resource.mpp");
        this.testResources(mpp);
    }

    public void testMpd9Resource() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9resource.mpd");
        this.testResources(mpp);
    }

    public void testMpp9Assignment() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp9resource.mpp");
        this.testResourceAssignments(mpp);
    }

    public void testMpp12Assignment() throws Exception {
        ProjectFile mpp = new MPPReader().read(String.valueOf(this.m_basedir) + "/mpp12resource.mpp");
        this.testResourceAssignments(mpp);
    }

    public void testMpd9Assignment() throws Exception {
        ProjectFile mpp = new MPDDatabaseReader().read(String.valueOf(this.m_basedir) + "/mpp9resource.mpd");
        this.testResourceAssignments(mpp);
    }

    private void testResources(ProjectFile mpp) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List listAllResources = mpp.getAllResources();
        MppResourceTest.assertTrue((listAllResources != null ? 1 : 0) != 0);
        Resource resourceWade = mpp.getResourceByID(new Integer(1));
        Resource resourceJon = mpp.getResourceByID(new Integer(2));
        Resource resourceBrian = mpp.getResourceByID(new Integer(3));
        Resource resourceConcrete = mpp.getResourceByID(new Integer(4));
        MppResourceTest.assertEquals((String)"Wade Golden", (String)resourceWade.getName());
        MppResourceTest.assertEquals((String)"Jon Iles", (String)resourceJon.getName());
        MppResourceTest.assertEquals((String)"Brian Leach", (String)resourceBrian.getName());
        MppResourceTest.assertEquals((String)"Concrete", (String)resourceConcrete.getName());
        MppResourceTest.assertEquals((Object)ResourceType.WORK, (Object)resourceWade.getType());
        MppResourceTest.assertEquals((Object)ResourceType.MATERIAL, (Object)resourceConcrete.getType());
        MppResourceTest.assertEquals((String)"WG", (String)resourceWade.getInitials());
        MppResourceTest.assertEquals((String)"Steelray", (String)resourceWade.getGroup());
        MppResourceTest.assertEquals((String)"Tapsterrock", (String)resourceJon.getGroup());
        MppResourceTest.assertEquals((String)"Steelray", (String)resourceBrian.getGroup());
        MppResourceTest.assertEquals((String)"Mat", (String)resourceConcrete.getGroup());
        MppResourceTest.assertEquals((Object)new Double(100.0), (Object)resourceWade.getMaxUnits());
        Rate rate = new Rate(50.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceWade.getStandardRate());
        rate = new Rate(75.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceJon.getStandardRate());
        rate = new Rate(100.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceBrian.getStandardRate());
        rate = new Rate(100.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceWade.getOvertimeRate());
        rate = new Rate(150.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceJon.getOvertimeRate());
        rate = new Rate(200.0, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)rate, (Object)resourceBrian.getOvertimeRate());
        MppResourceTest.assertEquals((Object)new Double(500.0), (Object)resourceConcrete.getCostPerUse());
        MppResourceTest.assertEquals((Object)AccrueType.END, (Object)resourceWade.getAccrueAt());
        MppResourceTest.assertEquals((Object)AccrueType.PRORATED, (Object)resourceJon.getAccrueAt());
        MppResourceTest.assertEquals((Object)AccrueType.START, (Object)resourceConcrete.getAccrueAt());
        MppResourceTest.assertEquals((String)"10", (String)resourceWade.getCode());
        MppResourceTest.assertEquals((String)"20", (String)resourceJon.getCode());
        MppResourceTest.assertEquals((String)"30", (String)resourceBrian.getCode());
        MppResourceTest.assertEquals((int)1, (int)resourceWade.getCost1().intValue());
        MppResourceTest.assertEquals((int)2, (int)resourceWade.getCost2().intValue());
        MppResourceTest.assertEquals((int)3, (int)resourceWade.getCost3().intValue());
        MppResourceTest.assertEquals((int)4, (int)resourceWade.getCost4().intValue());
        MppResourceTest.assertEquals((int)5, (int)resourceWade.getCost5().intValue());
        MppResourceTest.assertEquals((int)6, (int)resourceWade.getCost6().intValue());
        MppResourceTest.assertEquals((int)7, (int)resourceWade.getCost7().intValue());
        MppResourceTest.assertEquals((int)8, (int)resourceWade.getCost8().intValue());
        MppResourceTest.assertEquals((int)9, (int)resourceWade.getCost9().intValue());
        MppResourceTest.assertEquals((int)10, (int)resourceWade.getCost10().intValue());
        MppResourceTest.assertEquals((String)"wade.golden@steelray.com", (String)resourceWade.getEmailAddress());
        MppResourceTest.assertEquals((String)"01/01/2006", (String)df.format(resourceWade.getDate1()));
        MppResourceTest.assertEquals((String)"02/01/2006", (String)df.format(resourceWade.getDate2()));
        MppResourceTest.assertEquals((String)"03/01/2006", (String)df.format(resourceWade.getDate3()));
        MppResourceTest.assertEquals((String)"04/01/2006", (String)df.format(resourceWade.getDate4()));
        MppResourceTest.assertEquals((String)"05/01/2006", (String)df.format(resourceWade.getDate5()));
        MppResourceTest.assertEquals((String)"06/01/2006", (String)df.format(resourceWade.getDate6()));
        MppResourceTest.assertEquals((String)"07/01/2006", (String)df.format(resourceWade.getDate7()));
        MppResourceTest.assertEquals((String)"08/01/2006", (String)df.format(resourceWade.getDate8()));
        MppResourceTest.assertEquals((String)"09/01/2006", (String)df.format(resourceWade.getDate9()));
        MppResourceTest.assertEquals((String)"10/01/2006", (String)df.format(resourceWade.getDate10()));
        MppResourceTest.assertEquals((String)"01/02/2006", (String)df.format(resourceWade.getStart1()));
        MppResourceTest.assertEquals((String)"02/02/2006", (String)df.format(resourceWade.getStart2()));
        MppResourceTest.assertEquals((String)"03/02/2006", (String)df.format(resourceWade.getStart3()));
        MppResourceTest.assertEquals((String)"04/02/2006", (String)df.format(resourceWade.getStart4()));
        MppResourceTest.assertEquals((String)"05/02/2006", (String)df.format(resourceWade.getStart5()));
        MppResourceTest.assertEquals((String)"06/02/2006", (String)df.format(resourceWade.getStart6()));
        MppResourceTest.assertEquals((String)"07/02/2006", (String)df.format(resourceWade.getStart7()));
        MppResourceTest.assertEquals((String)"08/02/2006", (String)df.format(resourceWade.getStart8()));
        MppResourceTest.assertEquals((String)"09/02/2006", (String)df.format(resourceWade.getStart9()));
        MppResourceTest.assertEquals((String)"10/02/2006", (String)df.format(resourceWade.getStart10()));
        MppResourceTest.assertEquals((String)"01/03/2006", (String)df.format(resourceWade.getFinish1()));
        MppResourceTest.assertEquals((String)"02/03/2006", (String)df.format(resourceWade.getFinish2()));
        MppResourceTest.assertEquals((String)"03/03/2006", (String)df.format(resourceWade.getFinish3()));
        MppResourceTest.assertEquals((String)"04/03/2006", (String)df.format(resourceWade.getFinish4()));
        MppResourceTest.assertEquals((String)"05/03/2006", (String)df.format(resourceWade.getFinish5()));
        MppResourceTest.assertEquals((String)"06/03/2006", (String)df.format(resourceWade.getFinish6()));
        MppResourceTest.assertEquals((String)"07/03/2006", (String)df.format(resourceWade.getFinish7()));
        MppResourceTest.assertEquals((String)"08/03/2006", (String)df.format(resourceWade.getFinish8()));
        MppResourceTest.assertEquals((String)"09/03/2006", (String)df.format(resourceWade.getFinish9()));
        MppResourceTest.assertEquals((String)"10/03/2006", (String)df.format(resourceWade.getFinish10()));
        MppResourceTest.assertEquals((int)1, (int)((int)resourceWade.getDuration1().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration1().getUnits());
        MppResourceTest.assertEquals((int)2, (int)((int)resourceWade.getDuration2().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration2().getUnits());
        MppResourceTest.assertEquals((int)3, (int)((int)resourceWade.getDuration3().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration3().getUnits());
        MppResourceTest.assertEquals((int)4, (int)((int)resourceWade.getDuration4().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration4().getUnits());
        MppResourceTest.assertEquals((int)5, (int)((int)resourceWade.getDuration5().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration5().getUnits());
        MppResourceTest.assertEquals((int)6, (int)((int)resourceWade.getDuration6().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration6().getUnits());
        MppResourceTest.assertEquals((int)7, (int)((int)resourceWade.getDuration7().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration7().getUnits());
        MppResourceTest.assertEquals((int)8, (int)((int)resourceWade.getDuration8().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration8().getUnits());
        MppResourceTest.assertEquals((int)9, (int)((int)resourceWade.getDuration9().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration9().getUnits());
        MppResourceTest.assertEquals((int)10, (int)((int)resourceWade.getDuration10().getDuration()));
        MppResourceTest.assertEquals((Object)TimeUnit.DAYS, (Object)resourceWade.getDuration10().getUnits());
        MppResourceTest.assertEquals((String)"AAA", (String)resourceWade.getOutlineCode1());
        MppResourceTest.assertEquals((String)"BBB", (String)resourceWade.getOutlineCode2());
        MppResourceTest.assertEquals((String)"CCC", (String)resourceWade.getOutlineCode3());
        MppResourceTest.assertEquals((String)"DDD", (String)resourceWade.getOutlineCode4());
        MppResourceTest.assertEquals((String)"EEE", (String)resourceWade.getOutlineCode5());
        MppResourceTest.assertEquals((String)"FFF", (String)resourceWade.getOutlineCode6());
        MppResourceTest.assertEquals((String)"GGG", (String)resourceWade.getOutlineCode7());
        MppResourceTest.assertEquals((String)"HHH", (String)resourceWade.getOutlineCode8());
        MppResourceTest.assertEquals((String)"III", (String)resourceWade.getOutlineCode9());
        MppResourceTest.assertEquals((String)"JJJ", (String)resourceWade.getOutlineCode10());
        MppResourceTest.assertEquals((int)1, (int)resourceWade.getNumber1().intValue());
        MppResourceTest.assertEquals((int)2, (int)resourceWade.getNumber2().intValue());
        MppResourceTest.assertEquals((int)3, (int)resourceWade.getNumber3().intValue());
        MppResourceTest.assertEquals((int)4, (int)resourceWade.getNumber4().intValue());
        MppResourceTest.assertEquals((int)5, (int)resourceWade.getNumber5().intValue());
        MppResourceTest.assertEquals((int)6, (int)resourceWade.getNumber6().intValue());
        MppResourceTest.assertEquals((int)7, (int)resourceWade.getNumber7().intValue());
        MppResourceTest.assertEquals((int)8, (int)resourceWade.getNumber8().intValue());
        MppResourceTest.assertEquals((int)9, (int)resourceWade.getNumber9().intValue());
        MppResourceTest.assertEquals((int)10, (int)resourceWade.getNumber10().intValue());
        MppResourceTest.assertEquals((int)11, (int)resourceWade.getNumber11().intValue());
        MppResourceTest.assertEquals((int)12, (int)resourceWade.getNumber12().intValue());
        MppResourceTest.assertEquals((int)13, (int)resourceWade.getNumber13().intValue());
        MppResourceTest.assertEquals((int)14, (int)resourceWade.getNumber14().intValue());
        MppResourceTest.assertEquals((int)15, (int)resourceWade.getNumber15().intValue());
        MppResourceTest.assertEquals((int)16, (int)resourceWade.getNumber16().intValue());
        MppResourceTest.assertEquals((int)17, (int)resourceWade.getNumber17().intValue());
        MppResourceTest.assertEquals((int)18, (int)resourceWade.getNumber18().intValue());
        MppResourceTest.assertEquals((int)19, (int)resourceWade.getNumber19().intValue());
        MppResourceTest.assertEquals((int)20, (int)resourceWade.getNumber20().intValue());
        MppResourceTest.assertEquals((String)"1", (String)resourceWade.getText1());
        MppResourceTest.assertEquals((String)"2", (String)resourceWade.getText2());
        MppResourceTest.assertEquals((String)"3", (String)resourceWade.getText3());
        MppResourceTest.assertEquals((String)"4", (String)resourceWade.getText4());
        MppResourceTest.assertEquals((String)"5", (String)resourceWade.getText5());
        MppResourceTest.assertEquals((String)"6", (String)resourceWade.getText6());
        MppResourceTest.assertEquals((String)"7", (String)resourceWade.getText7());
        MppResourceTest.assertEquals((String)"8", (String)resourceWade.getText8());
        MppResourceTest.assertEquals((String)"9", (String)resourceWade.getText9());
        MppResourceTest.assertEquals((String)"10", (String)resourceWade.getText10());
        MppResourceTest.assertEquals((String)"11", (String)resourceWade.getText11());
        MppResourceTest.assertEquals((String)"12", (String)resourceWade.getText12());
        MppResourceTest.assertEquals((String)"13", (String)resourceWade.getText13());
        MppResourceTest.assertEquals((String)"14", (String)resourceWade.getText14());
        MppResourceTest.assertEquals((String)"15", (String)resourceWade.getText15());
        MppResourceTest.assertEquals((String)"16", (String)resourceWade.getText16());
        MppResourceTest.assertEquals((String)"17", (String)resourceWade.getText17());
        MppResourceTest.assertEquals((String)"18", (String)resourceWade.getText18());
        MppResourceTest.assertEquals((String)"19", (String)resourceWade.getText19());
        MppResourceTest.assertEquals((String)"20", (String)resourceWade.getText20());
        MppResourceTest.assertEquals((String)"21", (String)resourceWade.getText21());
        MppResourceTest.assertEquals((String)"22", (String)resourceWade.getText22());
        MppResourceTest.assertEquals((String)"23", (String)resourceWade.getText23());
        MppResourceTest.assertEquals((String)"24", (String)resourceWade.getText24());
        MppResourceTest.assertEquals((String)"25", (String)resourceWade.getText25());
        MppResourceTest.assertEquals((String)"26", (String)resourceWade.getText26());
        MppResourceTest.assertEquals((String)"27", (String)resourceWade.getText27());
        MppResourceTest.assertEquals((String)"28", (String)resourceWade.getText28());
        MppResourceTest.assertEquals((String)"29", (String)resourceWade.getText29());
        MppResourceTest.assertEquals((String)"30", (String)resourceWade.getText30());
    }

    private void testResourceAssignments(ProjectFile mpp) {
        Integer intOne = new Integer(1);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        List listResourceAssignments = mpp.getAllResourceAssignments();
        ResourceAssignment ra = (ResourceAssignment)listResourceAssignments.get(0);
        MppResourceTest.assertEquals((Object)intOne, (Object)ra.getResourceID());
        MppResourceTest.assertEquals((Object)intOne, (Object)ra.getResourceUniqueID());
        MppResourceTest.assertEquals((String)"25/08/2006", (String)df.format(ra.getStart()));
        MppResourceTest.assertEquals((String)"29/08/2006", (String)df.format(ra.getFinish()));
        Task task = ra.getTask();
        MppResourceTest.assertEquals((Object)intOne, (Object)task.getID());
        MppResourceTest.assertEquals((Object)new Integer(2), (Object)task.getUniqueID());
        MppResourceTest.assertEquals((Object)new Double(100.0), (Object)ra.getUnits());
        Duration dur24Hours = Duration.getInstance(24, TimeUnit.HOURS);
        MppResourceTest.assertEquals((Object)dur24Hours, (Object)ra.getWork());
        MppResourceTest.assertEquals((Object)dur24Hours, (Object)ra.getRemainingWork());
        ResourceAssignment ra2 = (ResourceAssignment)listResourceAssignments.get(3);
        MppResourceTest.assertEquals((Object)WorkContour.TURTLE, (Object)ra2.getWorkContour());
    }
}

