/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.VarMeta;

abstract class AbstractVarMeta
extends MPPComponent
implements VarMeta {
    protected int m_unknown1;
    protected int m_itemCount;
    protected int m_unknown2;
    protected int m_unknown3;
    protected int m_dataSize;
    protected int[] m_offsets;
    protected Map m_table = new TreeMap();

    AbstractVarMeta() {
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public int getDataSize() {
        return this.m_dataSize;
    }

    public Integer[] getUniqueIdentifierArray() {
        Integer[] result = new Integer[this.m_table.size()];
        Iterator iter = this.m_table.keySet().iterator();
        int index = 0;
        while (iter.hasNext()) {
            result[index] = (Integer)iter.next();
            ++index;
        }
        return result;
    }

    public Set getUniqueIdentifierSet() {
        return this.m_table.keySet();
    }

    public Integer getOffset(Integer id, Integer type) {
        Integer result = null;
        Map map = (Map)this.m_table.get(id);
        if (map != null) {
            result = (Integer)map.get(type);
        }
        return result;
    }

    public int getOffset(int index) {
        return this.m_offsets[index];
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("BEGIN: VarMeta");
        pw.println("   Item count: " + this.m_itemCount);
        pw.println("   Data size: " + this.m_dataSize);
        for (Integer uniqueID : this.m_table.keySet()) {
            pw.println("   Entries for Unique ID: " + uniqueID);
            Map map = (Map)this.m_table.get(uniqueID);
            for (Integer type : map.keySet()) {
                Integer offset = (Integer)map.get(type);
                pw.println("      Type=" + type + " Offset=" + offset);
            }
        }
        pw.println("END: VarMeta");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

