/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.Duration;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.TimeUnit;

final class MPPUtility {
    private static final long EPOCH = 441676800000L;
    private static final long MS_PER_DAY = 86400000L;
    private static final long MS_PER_MINUTE = 60000L;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int DURATION_UNITS_MASK = 31;
    private static final int DEFAULT_DST_SAVINGS = 3600000;
    private static boolean HAS_DST_SAVINGS;

    static {
        Class<TimeZone> tz = TimeZone.class;
        try {
            tz.getMethod("getDSTSavings", null);
            HAS_DST_SAVINGS = true;
        }
        catch (NoSuchMethodException ex) {
            HAS_DST_SAVINGS = false;
        }
    }

    private MPPUtility() {
    }

    public static final void getByteArray(byte[] data, int offset, int size, byte[] buffer, int bufferOffset) {
        int loop = 0;
        while (loop < size) {
            buffer[bufferOffset + loop] = data[offset + loop];
            ++loop;
        }
    }

    public static final int getByte(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        return result += (data[offset] >> 4 & 0xF) * 16;
    }

    public static final int getByte(byte[] data) {
        return MPPUtility.getByte(data, 0);
    }

    public static final int getShort(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        result += (data[offset] >> 4 & 0xF) * 16;
        result += (data[offset + 1] & 0xF) * 256;
        return result += (data[offset + 1] >> 4 & 0xF) * 4096;
    }

    public static final int getShort(byte[] data) {
        return MPPUtility.getShort(data, 0);
    }

    public static final int getInt(byte[] data, int offset) {
        int result = data[offset] & 0xF;
        result += (data[offset] >> 4 & 0xF) * 16;
        result += (data[offset + 1] & 0xF) * 256;
        result += (data[offset + 1] >> 4 & 0xF) * 4096;
        result += (data[offset + 2] & 0xF) * 65536;
        result += (data[offset + 2] >> 4 & 0xF) * 0x100000;
        result += (data[offset + 3] & 0xF) * 0x1000000;
        return result += (data[offset + 3] >> 4 & 0xF) * 0x10000000;
    }

    public static final int getInt(byte[] data) {
        return MPPUtility.getInt(data, 0);
    }

    public static final long getLong(byte[] data, int offset) {
        long result = data[offset] & 0xF;
        result += (long)((data[offset] >> 4 & 0xF) * 16);
        result += (long)((data[offset + 1] & 0xF) * 256);
        result += (long)((data[offset + 1] >> 4 & 0xF) * 4096);
        result += (long)((data[offset + 2] & 0xF) * 65536);
        result += (long)((data[offset + 2] >> 4 & 0xF) * 0x100000);
        result += (long)((data[offset + 3] & 0xF) * 0x1000000);
        result += (long)((data[offset + 3] >> 4 & 0xF) * 0x10000000);
        result += (long)(data[offset + 4] & 0xF) * 0x100000000L;
        result += (long)(data[offset + 4] >> 4 & 0xF) * 0x1000000000L;
        result += (long)(data[offset + 5] & 0xF) * 0x10000000000L;
        result += (long)(data[offset + 5] >> 4 & 0xF) * 0x100000000000L;
        result += (long)(data[offset + 6] & 0xF) * 0x1000000000000L;
        result += (long)(data[offset + 6] >> 4 & 0xF) * 0x10000000000000L;
        result += (long)(data[offset + 7] & 0xF) * 0x100000000000000L;
        return result += (long)(data[offset + 7] >> 4 & 0xF) * 0x1000000000000000L;
    }

    public static final long getLong6(byte[] data, int offset) {
        long result = data[offset] & 0xF;
        result += (long)((data[offset] >> 4 & 0xF) * 16);
        result += (long)((data[offset + 1] & 0xF) * 256);
        result += (long)((data[offset + 1] >> 4 & 0xF) * 4096);
        result += (long)((data[offset + 2] & 0xF) * 65536);
        result += (long)((data[offset + 2] >> 4 & 0xF) * 0x100000);
        result += (long)((data[offset + 3] & 0xF) * 0x1000000);
        result += (long)((data[offset + 3] >> 4 & 0xF) * 0x10000000);
        result += (long)(data[offset + 4] & 0xF) * 0x100000000L;
        result += (long)(data[offset + 4] >> 4 & 0xF) * 0x1000000000L;
        result += (long)(data[offset + 5] & 0xF) * 0x10000000000L;
        return result += (long)(data[offset + 5] >> 4 & 0xF) * 0x100000000000L;
    }

    public static final long getLong6(byte[] data) {
        return MPPUtility.getLong6(data, 0);
    }

    public static final long getLong(byte[] data) {
        return MPPUtility.getLong(data, 0);
    }

    public static final double getDouble(byte[] data, int offset) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, offset));
    }

    public static final double getDouble(byte[] data) {
        return Double.longBitsToDouble(MPPUtility.getLong(data, 0));
    }

    public static final Date getDate(byte[] data, int offset) {
        Date result;
        long days = MPPUtility.getShort(data, offset);
        if (days == 65535L) {
            result = null;
        } else {
            TimeZone tz = TimeZone.getDefault();
            result = new Date(441676800000L + days * 86400000L - (long)tz.getRawOffset());
        }
        return result;
    }

    public static final Date getTime(byte[] data, int offset) {
        int time = MPPUtility.getShort(data, offset) / 10;
        Calendar cal = Calendar.getInstance();
        cal.set(11, time / 60);
        cal.set(12, time % 60);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static final Date getTime(byte[] data) {
        return MPPUtility.getTime(data, 0);
    }

    public static final long getDuration(byte[] data, int offset) {
        return (long)MPPUtility.getShort(data, offset) * 60000L / 10L;
    }

    public static final Date getTimestamp(byte[] data, int offset) {
        Date result;
        long days = MPPUtility.getShort(data, offset + 2);
        if (days == 65535L) {
            result = null;
        } else {
            TimeZone tz = TimeZone.getDefault();
            long time = MPPUtility.getShort(data, offset);
            if (time == 65535L) {
                time = 0L;
            }
            if (tz.inDaylightTime(result = new Date(441676800000L + days * 86400000L + time * 60000L / 10L - (long)tz.getRawOffset()))) {
                int savings = HAS_DST_SAVINGS ? tz.getDSTSavings() : 3600000;
                result = new Date(result.getTime() - (long)savings);
            }
        }
        return result;
    }

    public static final Date getTimestamp(byte[] data) {
        return MPPUtility.getTimestamp(data, 0);
    }

    public static final String getUnicodeString(byte[] data) {
        return MPPUtility.getUnicodeString(data, 0);
    }

    public static final String getUnicodeString(byte[] data, int offset) {
        StringBuffer buffer = new StringBuffer();
        int loop = offset;
        while (loop < data.length - 1) {
            char c = (char)MPPUtility.getShort(data, loop);
            if (c == '\u0000') break;
            buffer.append(c);
            loop += 2;
        }
        return buffer.toString();
    }

    public static final String getUnicodeString(byte[] data, int offset, int length) {
        StringBuffer buffer = new StringBuffer();
        int loop = offset;
        int byteLength = 0;
        while (loop < data.length - 1 && byteLength < length) {
            char c = (char)MPPUtility.getShort(data, loop);
            if (c == '\u0000') break;
            buffer.append(c);
            loop += 2;
            byteLength += 2;
        }
        return buffer.toString();
    }

    public static final String getString(byte[] data) {
        return MPPUtility.getString(data, 0);
    }

    public static final String getString(byte[] data, int offset) {
        StringBuffer buffer = new StringBuffer();
        int loop = 0;
        while (offset + loop < data.length) {
            char c = (char)data[offset + loop];
            if (c == '\u0000') break;
            buffer.append(c);
            ++loop;
        }
        return buffer.toString();
    }

    public static final Duration getDuration(int value, TimeUnit type) {
        return MPPUtility.getDuration((double)value, type);
    }

    public static final Duration getDuration(double value, TimeUnit type) {
        double duration;
        switch (type.getValue()) {
            case 0: 
            case 7: {
                duration = value / 10.0;
                break;
            }
            case 1: 
            case 8: {
                duration = value / 600.0;
                break;
            }
            case 2: 
            case 9: {
                duration = value / 4800.0;
                break;
            }
            case 3: 
            case 10: {
                duration = value / 24000.0;
                break;
            }
            case 4: 
            case 11: {
                duration = value / 96000.0;
                break;
            }
            default: {
                duration = value;
            }
        }
        return Duration.getInstance(duration, type);
    }

    public static final TimeUnit getDurationTimeUnits(int type) {
        TimeUnit units;
        switch (type & 0x1F) {
            case 3: {
                units = TimeUnit.MINUTES;
                break;
            }
            case 4: {
                units = TimeUnit.ELAPSED_MINUTES;
                break;
            }
            case 5: {
                units = TimeUnit.HOURS;
                break;
            }
            case 6: {
                units = TimeUnit.ELAPSED_HOURS;
                break;
            }
            case 8: {
                units = TimeUnit.ELAPSED_DAYS;
                break;
            }
            case 9: {
                units = TimeUnit.WEEKS;
                break;
            }
            case 10: {
                units = TimeUnit.ELAPSED_WEEKS;
                break;
            }
            case 11: {
                units = TimeUnit.MONTHS;
                break;
            }
            case 12: {
                units = TimeUnit.ELAPSED_MONTHS;
                break;
            }
            default: {
                units = TimeUnit.DAYS;
            }
        }
        return units;
    }

    public static Duration getAdjustedDuration(ProjectFile file, int duration, TimeUnit timeUnit) {
        Duration result;
        switch (timeUnit.getValue()) {
            case 2: {
                double unitsPerDay = file.getProjectHeader().getMinutesPerDay().doubleValue() * 10.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case 9: {
                double unitsPerDay = 14400.0;
                double totalDays = (double)duration / unitsPerDay;
                result = Duration.getInstance(totalDays, timeUnit);
                break;
            }
            case 10: {
                double unitsPerWeek = 100800.0;
                double totalWeeks = (double)duration / unitsPerWeek;
                result = Duration.getInstance(totalWeeks, timeUnit);
                break;
            }
            case 11: {
                double unitsPerMonth = 417600.0;
                double totalMonths = (double)duration / unitsPerMonth;
                result = Duration.getInstance(totalMonths, timeUnit);
                break;
            }
            default: {
                result = MPPUtility.getDuration(duration, timeUnit);
            }
        }
        return result;
    }

    public static TimeUnit getWorkTimeUnits(int value) {
        TimeUnit result;
        switch (value) {
            case 1: {
                result = TimeUnit.MINUTES;
                break;
            }
            case 3: {
                result = TimeUnit.DAYS;
                break;
            }
            case 4: {
                result = TimeUnit.WEEKS;
                break;
            }
            default: {
                result = TimeUnit.HOURS;
            }
        }
        return result;
    }

    public static CurrencySymbolPosition getSymbolPosition(int value) {
        CurrencySymbolPosition result;
        switch (value) {
            case 1: {
                result = CurrencySymbolPosition.AFTER;
                break;
            }
            case 2: {
                result = CurrencySymbolPosition.BEFORE_WITH_SPACE;
                break;
            }
            case 3: {
                result = CurrencySymbolPosition.AFTER_WITH_SPACE;
                break;
            }
            default: {
                result = CurrencySymbolPosition.BEFORE;
            }
        }
        return result;
    }

    public static final String removeAmpersands(String name) {
        if (name != null && name.indexOf(38) != -1) {
            StringBuffer sb = new StringBuffer();
            int index = 0;
            while (index < name.length()) {
                char c = name.charAt(index);
                if (c != '&') {
                    sb.append(c);
                }
                ++index;
            }
            name = sb.toString();
        }
        return name;
    }

    public static final byte[] cloneSubArray(byte[] data, int offset, int size) {
        byte[] newData = new byte[size];
        System.arraycopy(data, offset, newData, 0, size);
        return newData;
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int count = offset + length;
            int loop = offset;
            while (loop < count) {
                sb.append(" ");
                sb.append(HEX_DIGITS[(buffer[loop] & 0xF0) >> 4]);
                sb.append(HEX_DIGITS[buffer[loop] & 0xF]);
                ++loop;
            }
            if (ascii) {
                sb.append("   ");
                loop = offset;
                while (loop < count) {
                    char c = (char)buffer[loop];
                    if (c > '\u00c8' || c < '\u001b') {
                        c = ' ';
                    }
                    sb.append(c);
                    ++loop;
                }
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, boolean ascii) {
        int length = 0;
        if (buffer != null) {
            length = buffer.length;
        }
        return MPPUtility.hexdump(buffer, 0, length, ascii);
    }

    public static final String hexdump(byte[] buffer, boolean ascii, int columns, String prefix) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int index = 0;
            DecimalFormat df = new DecimalFormat("00000");
            while (index < buffer.length) {
                if (index + columns > buffer.length) {
                    columns = buffer.length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPPUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
                index += columns;
            }
        }
        return sb.toString();
    }

    public static final String hexdump(byte[] buffer, int offset, int length, boolean ascii, int columns, String prefix) {
        StringBuffer sb = new StringBuffer();
        if (buffer != null) {
            int index = offset;
            DecimalFormat df = new DecimalFormat("00000");
            while (index < offset + length) {
                if (index + columns > offset + length) {
                    columns = offset + length - index;
                }
                sb.append(prefix);
                sb.append(df.format(index));
                sb.append(":");
                sb.append(MPPUtility.hexdump(buffer, index, columns, ascii));
                sb.append('\n');
                index += columns;
            }
        }
        return sb.toString();
    }

    public static final void fileHexDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(MPPUtility.hexdump(data, true, 16, "").getBytes());
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileHexDump(String fileName, InputStream is) {
        try {
            byte[] data = new byte[is.available()];
            is.read(data);
            MPPUtility.fileHexDump(fileName, data);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static final void fileDump(String fileName, byte[] data) {
        try {
            FileOutputStream os = new FileOutputStream(fileName);
            os.write(data);
            os.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

