/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.mpp.MPPUtility;

public final class RTFEmbeddedObject {
    private int m_typeFlag1;
    private int m_typeFlag2;
    private byte[] m_data;
    private static final String OBJDATA = "\\objdata ";

    private RTFEmbeddedObject(List blocks, int type) {
        switch (type) {
            case 2: 
            case 5: {
                this.m_typeFlag1 = this.getInt(blocks);
                this.m_typeFlag2 = this.getInt(blocks);
                int length = this.getInt(blocks);
                this.m_data = this.getData(blocks, length);
                break;
            }
            case 1: {
                int length = this.getInt(blocks);
                this.m_data = this.getData(blocks, length);
            }
        }
    }

    public int getTypeFlag1() {
        return this.m_typeFlag1;
    }

    public int getTypeFlag2() {
        return this.m_typeFlag2;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public String getDataString() {
        return this.m_data == null ? "" : new String(this.m_data);
    }

    public static List getEmbeddedObjects(String text) {
        LinkedList objects = null;
        int offset = text.indexOf(OBJDATA);
        if (offset != -1) {
            objects = new LinkedList();
        }
        while (offset != -1) {
            LinkedList objectData = new LinkedList();
            objects.add(objectData);
            offset = RTFEmbeddedObject.readObjectData(offset, text, objectData);
            offset = text.indexOf(OBJDATA, offset);
        }
        return objects;
    }

    private int getInt(List blocks) {
        int result;
        if (!blocks.isEmpty()) {
            byte[] data = (byte[])blocks.remove(0);
            result = MPPUtility.getInt(data);
        } else {
            result = 0;
        }
        return result;
    }

    private byte[] getData(List blocks, int length) {
        byte[] result;
        if (!blocks.isEmpty()) {
            if (length < 4) {
                length = 4;
            }
            result = new byte[length];
            int offset = 0;
            while (offset < length) {
                byte[] data = (byte[])blocks.remove(0);
                System.arraycopy(data, 0, result, offset, data.length);
                offset += data.length;
            }
        } else {
            result = null;
        }
        return result;
    }

    private static int readObjectData(int offset, String text, List objects) {
        LinkedList blocks = new LinkedList();
        offset += OBJDATA.length();
        int lastOffset = offset = RTFEmbeddedObject.skipEndOfLine(text, offset);
        while (offset != -1) {
            int length = RTFEmbeddedObject.getBlockLength(text, offset);
            lastOffset = RTFEmbeddedObject.readDataBlock(text, offset, length, blocks);
            offset = RTFEmbeddedObject.skipEndOfLine(text, lastOffset);
        }
        while (!blocks.isEmpty()) {
            RTFEmbeddedObject headerObject = new RTFEmbeddedObject(blocks, 2);
            objects.add(headerObject);
            if (blocks.isEmpty()) continue;
            RTFEmbeddedObject dataObject = new RTFEmbeddedObject(blocks, headerObject.getTypeFlag2());
            objects.add(dataObject);
        }
        return lastOffset;
    }

    private static int skipEndOfLine(String text, int offset) {
        boolean finished = false;
        while (!finished) {
            char c = text.charAt(offset);
            switch (c) {
                case '\n': 
                case '\r': {
                    ++offset;
                    break;
                }
                case '}': {
                    offset = -1;
                    finished = true;
                    break;
                }
                default: {
                    finished = true;
                }
            }
        }
        return offset;
    }

    private static int getBlockLength(String text, int offset) {
        int startIndex = offset;
        boolean finished = false;
        while (!finished) {
            char c = text.charAt(offset);
            switch (c) {
                case '\n': 
                case '\r': 
                case '}': {
                    finished = true;
                    break;
                }
                default: {
                    ++offset;
                }
            }
        }
        int length = offset - startIndex;
        return length;
    }

    private static int readDataBlock(String text, int offset, int length, List blocks) {
        int bytes = length / 2;
        byte[] data = new byte[bytes];
        int index = 0;
        while (index < bytes) {
            data[index] = (byte)Integer.parseInt(text.substring(offset, offset + 2), 16);
            offset += 2;
            ++index;
        }
        blocks.add(data);
        return offset;
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(os);
        pw.println("[RTFObject");
        pw.println("   Flag1=" + this.m_typeFlag1);
        pw.println("   Flag2=" + this.m_typeFlag2);
        pw.println("   Data=");
        pw.println(MPPUtility.hexdump(this.m_data, true, 16, "  "));
        pw.println("]");
        pw.flush();
        return os.toString();
    }
}

