/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.VarMeta;

final class Var2Data
extends MPPComponent {
    private TreeMap m_map = new TreeMap();
    private VarMeta m_meta;

    Var2Data(VarMeta meta, InputStream is) throws IOException {
        this.m_meta = meta;
        int itemCount = this.m_meta.getItemCount();
        int loop = 0;
        while (loop < itemCount) {
            int itemOffset = meta.getOffset(loop);
            is.reset();
            is.skip(itemOffset);
            int size = this.readInt(is);
            byte[] data = this.readByteArray(is, size);
            this.m_map.put(new Integer(itemOffset), data);
            ++loop;
        }
    }

    public byte[] getByteArray(Integer offset) {
        byte[] result = null;
        if (offset != null) {
            result = (byte[])this.m_map.get(offset);
        }
        return result;
    }

    public byte[] getByteArray(Integer id, Integer type) {
        return this.getByteArray(this.m_meta.getOffset(id, type));
    }

    public String getUnicodeString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getUnicodeString(value);
        }
        return result;
    }

    public String getUnicodeString(Integer id, Integer type) {
        return this.getUnicodeString(this.m_meta.getOffset(id, type));
    }

    public Date getTimestamp(Integer id, Integer type) {
        byte[] value;
        Date result = null;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getTimestamp(value);
        }
        return result;
    }

    public String getString(Integer offset) {
        byte[] value;
        String result = null;
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getString(value);
        }
        return result;
    }

    public String getString(Integer id, Integer type) {
        return this.getString(this.m_meta.getOffset(id, type));
    }

    public int getShort(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getShort(value);
        }
        return result;
    }

    public int getInt(Integer id, Integer type) {
        byte[] value;
        int result = 0;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getInt(value);
        }
        return result;
    }

    public int getInt(Integer id, int offset, Integer type) {
        byte[] value;
        int result = 0;
        Integer metaOffset = this.m_meta.getOffset(id, type);
        if (metaOffset != null && (value = (byte[])this.m_map.get(metaOffset)) != null) {
            result = MPPUtility.getInt(value, offset);
        }
        return result;
    }

    public long getLong(Integer id, Integer type) {
        byte[] value;
        long result = 0L;
        Integer offset = this.m_meta.getOffset(id, type);
        if (offset != null && (value = (byte[])this.m_map.get(offset)) != null) {
            result = MPPUtility.getLong(value);
        }
        return result;
    }

    public double getDouble(Integer id, Integer type) {
        return Double.longBitsToDouble(this.getLong(id, type));
    }

    public VarMeta getVarMeta() {
        return this.m_meta;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Iterator iter = this.m_map.keySet().iterator();
        pw.println("BEGIN Var2Data");
        while (iter.hasNext()) {
            Integer offset = (Integer)iter.next();
            byte[] data = (byte[])this.m_map.get(offset);
            pw.println("   Data at offset: " + offset + " size: " + data.length);
            pw.println(MPPUtility.hexdump(data, true, 16, "   "));
        }
        pw.println("END Var2Data");
        pw.println();
        pw.close();
        return sw.toString();
    }
}

