/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.FileCreationRecord;
import net.sf.mpxj.FileVersion;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceAssignmentWorkgroupFields;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpx.ConstraintTypeUtility;
import net.sf.mpxj.mpx.DurationUtility;
import net.sf.mpxj.mpx.InputStreamTokenizer;
import net.sf.mpxj.mpx.LocaleData;
import net.sf.mpxj.mpx.LocaleUtility;
import net.sf.mpxj.mpx.MPXResourceField;
import net.sf.mpxj.mpx.MPXTaskField;
import net.sf.mpxj.mpx.PriorityUtility;
import net.sf.mpxj.mpx.ReaderTokenizer;
import net.sf.mpxj.mpx.Record;
import net.sf.mpxj.mpx.RelationTypeUtility;
import net.sf.mpxj.mpx.ResourceModel;
import net.sf.mpxj.mpx.TaskModel;
import net.sf.mpxj.mpx.Tokenizer;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.MPXJFormats;
import net.sf.mpxj.utility.NumberUtility;

public final class MPXReader
extends AbstractProjectReader {
    private Locale m_locale = Locale.ENGLISH;
    private boolean m_ignoreTextModels = true;
    private ProjectFile m_projectFile;
    private Task m_lastTask;
    private Resource m_lastResource;
    private ProjectCalendar m_lastResourceCalendar;
    private ResourceAssignment m_lastResourceAssignment;
    private ProjectCalendar m_lastBaseCalendar;
    private boolean m_resourceTableDefinition;
    private boolean m_taskTableDefinition;
    private TaskModel m_taskModel;
    private ResourceModel m_resourceModel;
    private char m_delimiter;
    private MPXJFormats m_formats;
    private int m_baseOutlineLevel;

    public ProjectFile read(InputStream is) throws MPXJException {
        int line = 1;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            byte[] data = new byte[4];
            data[0] = (byte)bis.read();
            bis.mark(1024);
            data[1] = (byte)bis.read();
            data[2] = (byte)bis.read();
            data[3] = (byte)bis.read();
            if (data[0] != 77 || data[1] != 80 || data[2] != 88) {
                throw new MPXJException("Invalid file format");
            }
            this.m_projectFile = new ProjectFile();
            LocaleUtility.setLocale(this.m_projectFile, this.m_locale);
            this.m_delimiter = (char)data[3];
            this.m_projectFile.setDelimiter(this.m_delimiter);
            this.m_taskModel = new TaskModel(this.m_projectFile, this.m_locale);
            this.m_taskModel.setLocale(this.m_locale);
            this.m_resourceModel = new ResourceModel(this.m_projectFile, this.m_locale);
            this.m_resourceModel.setLocale(this.m_locale);
            this.m_baseOutlineLevel = -1;
            this.m_formats = new MPXJFormats(this.m_locale, LocaleData.getString(this.m_locale, "NA"), this.m_projectFile);
            this.m_projectFile.setAutoCalendarUniqueID(true);
            bis.reset();
            Tokenizer tk = new InputStreamTokenizer(bis);
            tk.setDelimiter(this.m_delimiter);
            this.parseRecord(Integer.toString(999), new Record(this.m_locale, tk, this.m_formats));
            ++line;
            InputStreamReader reader = new InputStreamReader((InputStream)bis, this.m_projectFile.getFileCreationRecord().getCodePage().getCharset());
            tk = new ReaderTokenizer(reader);
            tk.setDelimiter(this.m_delimiter);
            while (tk.getType() != -1) {
                Record record = new Record(this.m_locale, tk, this.m_formats);
                String number = record.getRecordNumber();
                if (number != null) {
                    this.parseRecord(number, record);
                }
                ++line;
            }
            this.m_projectFile.updateUniqueIdentifiers();
            this.m_projectFile.updateStructure();
            this.m_projectFile.updateUniqueCounters();
            this.m_projectFile.setAutoCalendarUniqueID(false);
            ProjectFile projectFile = this.m_projectFile;
            return projectFile;
        }
        catch (Exception ex) {
            throw new MPXJException("Error reading file (failed at line " + line + ")", ex);
        }
        finally {
            this.m_projectFile = null;
            this.m_lastTask = null;
            this.m_lastResource = null;
            this.m_lastResourceCalendar = null;
            this.m_lastResourceAssignment = null;
            this.m_lastBaseCalendar = null;
            this.m_resourceTableDefinition = false;
            this.m_taskTableDefinition = false;
            this.m_taskModel = null;
            this.m_resourceModel = null;
            this.m_formats = null;
        }
    }

    private void parseRecord(String recordNumber, Record record) throws MPXJException {
        switch (Integer.parseInt(recordNumber)) {
            case 0: {
                break;
            }
            case 10: {
                this.populateCurrencySettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 11: {
                this.populateDefaultSettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 12: {
                this.populateDateTimeSettings(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 20: {
                this.m_lastBaseCalendar = this.m_projectFile.addBaseCalendar();
                this.populateCalendar(record, this.m_lastBaseCalendar);
                break;
            }
            case 25: {
                if (this.m_lastBaseCalendar == null) break;
                ProjectCalendarHours hours = this.m_lastBaseCalendar.addCalendarHours();
                this.populateCalendarHours(record, hours);
                break;
            }
            case 26: {
                if (this.m_lastBaseCalendar == null) break;
                ProjectCalendarException exception = this.m_lastBaseCalendar.addCalendarException();
                this.populateCalendarException(record, exception);
                break;
            }
            case 30: {
                this.populateProjectHeader(record, this.m_projectFile.getProjectHeader());
                this.m_formats.update();
                break;
            }
            case 40: {
                if (this.m_resourceTableDefinition || this.m_ignoreTextModels) break;
                this.m_resourceModel.update(record, true);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 41: {
                if (this.m_resourceTableDefinition) break;
                this.m_resourceModel.update(record, false);
                this.m_resourceTableDefinition = true;
                break;
            }
            case 50: {
                this.m_lastResource = this.m_projectFile.addResource();
                this.populateResource(this.m_lastResource, record);
                this.m_projectFile.fireResourceReadEvent(this.m_lastResource);
                break;
            }
            case 51: {
                if (this.m_lastResource == null) break;
                this.m_lastResource.setNotes(record.getString(0));
                break;
            }
            case 55: {
                if (this.m_lastResource == null) break;
                this.m_lastResourceCalendar = this.m_lastResource.addResourceCalendar();
                this.populateCalendar(record, this.m_lastResourceCalendar);
                break;
            }
            case 56: {
                if (this.m_lastResourceCalendar == null) break;
                ProjectCalendarHours hours = this.m_lastResourceCalendar.addCalendarHours();
                this.populateCalendarHours(record, hours);
                break;
            }
            case 57: {
                if (this.m_lastResourceCalendar == null) break;
                ProjectCalendarException exception = this.m_lastResourceCalendar.addCalendarException();
                this.populateCalendarException(record, exception);
                break;
            }
            case 60: {
                if (this.m_taskTableDefinition || this.m_ignoreTextModels) break;
                this.m_taskModel.update(record, true);
                this.m_taskTableDefinition = true;
                break;
            }
            case 61: {
                if (this.m_taskTableDefinition) break;
                this.m_taskModel.update(record, false);
                this.m_taskTableDefinition = true;
                break;
            }
            case 70: {
                this.m_lastTask = this.m_projectFile.addTask();
                this.populateTask(record, this.m_lastTask);
                int outlineLevel = NumberUtility.getInt(this.m_lastTask.getOutlineLevel());
                if (this.m_baseOutlineLevel == -1) {
                    this.m_baseOutlineLevel = outlineLevel;
                }
                List childTasks = this.m_projectFile.getChildTasks();
                if (outlineLevel == this.m_baseOutlineLevel) {
                    childTasks.add(this.m_lastTask);
                } else {
                    if (childTasks.isEmpty()) {
                        throw new MPXJException("Invalid outline level");
                    }
                    ((Task)childTasks.get(childTasks.size() - 1)).addChildTask(this.m_lastTask, outlineLevel);
                }
                this.m_projectFile.fireTaskReadEvent(this.m_lastTask);
                break;
            }
            case 71: {
                if (this.m_lastTask == null) break;
                this.m_lastTask.setNotes(record.getString(0));
                break;
            }
            case 72: {
                if (this.m_lastTask == null) break;
                RecurringTask task = this.m_lastTask.addRecurringTask();
                this.populateRecurringTask(record, task);
                break;
            }
            case 75: {
                if (this.m_lastTask == null) break;
                this.m_lastResourceAssignment = this.m_lastTask.addResourceAssignment();
                this.populateResourceAssignment(record, this.m_lastResourceAssignment);
                break;
            }
            case 76: {
                if (this.m_lastResourceAssignment == null) break;
                ResourceAssignmentWorkgroupFields workgroup = this.m_lastResourceAssignment.addWorkgroupAssignment();
                this.populateResourceAssignmentWorkgroupFields(record, workgroup);
                break;
            }
            case 80: {
                break;
            }
            case 81: {
                break;
            }
            case 999: {
                MPXReader.populateFileCreationRecord(record, this.m_projectFile.getFileCreationRecord());
                break;
            }
            default: {
                throw new MPXJException("Invalid record");
            }
        }
    }

    private void populateCurrencySettings(Record record, ProjectHeader projectHeader) {
        projectHeader.setCurrencySymbol(record.getString(0));
        projectHeader.setSymbolPosition(record.getCurrencySymbolPosition(1));
        projectHeader.setCurrencyDigits(record.getInteger(2));
        Character c = record.getCharacter(3);
        if (c != null) {
            projectHeader.setThousandsSeparator(c.charValue());
        }
        if ((c = record.getCharacter(4)) != null) {
            projectHeader.setDecimalSeparator(c.charValue());
        }
    }

    private void populateDefaultSettings(Record record, ProjectHeader projectHeader) throws MPXJException {
        projectHeader.setDefaultDurationUnits(record.getTimeUnit(0));
        projectHeader.setDefaultDurationIsFixed(record.getNumericBoolean(1));
        projectHeader.setDefaultWorkUnits(record.getTimeUnit(2));
        projectHeader.setMinutesPerDay(new Double(NumberUtility.getDouble(record.getFloat(3)) * 60.0));
        projectHeader.setMinutesPerWeek(new Double(NumberUtility.getDouble(record.getFloat(4)) * 60.0));
        projectHeader.setDefaultStandardRate(record.getRate(5));
        projectHeader.setDefaultOvertimeRate(record.getRate(6));
        projectHeader.setUpdatingTaskStatusUpdatesResourceStatus(record.getNumericBoolean(7));
        projectHeader.setSplitInProgressTasks(record.getNumericBoolean(8));
    }

    private void populateDateTimeSettings(Record record, ProjectHeader projectHeader) {
        Character c;
        projectHeader.setDateOrder(record.getDateOrder(0));
        projectHeader.setTimeFormat(record.getTimeFormat(1));
        Date time = this.getTimeFromInteger(record.getInteger(2));
        if (time != null) {
            projectHeader.setDefaultStartTime(time);
        }
        if ((c = record.getCharacter(3)) != null) {
            projectHeader.setDateSeparator(c.charValue());
        }
        projectHeader.setTimeSeparator(record.getCharacter(4));
        projectHeader.setAMText(record.getString(5));
        projectHeader.setPMText(record.getString(6));
        projectHeader.setDateFormat(record.getDateFormat(7));
        projectHeader.setBarTextDateFormat(record.getDateFormat(8));
    }

    private Date getTimeFromInteger(Integer time) {
        Date result = null;
        if (time != null) {
            int minutes = time;
            int hours = minutes / 60;
            Calendar cal = Calendar.getInstance();
            cal.set(14, 0);
            cal.set(13, 0);
            cal.set(12, minutes -= hours * 60);
            cal.set(11, hours);
            result = cal.getTime();
        }
        return result;
    }

    private void populateProjectHeader(Record record, ProjectHeader projectHeader) throws MPXJException {
        projectHeader.setProjectTitle(record.getString(0));
        projectHeader.setCompany(record.getString(1));
        projectHeader.setManager(record.getString(2));
        projectHeader.setCalendarName(record.getString(3));
        projectHeader.setStartDate(record.getDateTime(4));
        projectHeader.setFinishDate(record.getDateTime(5));
        projectHeader.setScheduleFrom(record.getScheduleFrom(6));
        projectHeader.setCurrentDate(record.getDateTime(7));
        projectHeader.setComments(record.getString(8));
        projectHeader.setCost(record.getCurrency(9));
        projectHeader.setBaselineCost(record.getCurrency(10));
        projectHeader.setActualCost(record.getCurrency(11));
        projectHeader.setWork(record.getDuration(12));
        projectHeader.setBaselineWork(record.getDuration(13));
        projectHeader.setActualWork(record.getDuration(14));
        projectHeader.setWork2(record.getPercentage(15));
        projectHeader.setDuration(record.getDuration(16));
        projectHeader.setBaselineDuration(record.getDuration(17));
        projectHeader.setActualDuration(record.getDuration(18));
        projectHeader.setPercentageComplete(record.getPercentage(19));
        projectHeader.setBaselineStart(record.getDateTime(20));
        projectHeader.setBaselineFinish(record.getDateTime(21));
        projectHeader.setActualStart(record.getDateTime(22));
        projectHeader.setActualFinish(record.getDateTime(23));
        projectHeader.setStartVariance(record.getDuration(24));
        projectHeader.setFinishVariance(record.getDuration(25));
        projectHeader.setSubject(record.getString(26));
        projectHeader.setAuthor(record.getString(27));
        projectHeader.setKeywords(record.getString(28));
    }

    private void populateCalendarHours(Record record, ProjectCalendarHours hours) throws MPXJException {
        hours.setDay(Day.getInstance(NumberUtility.getInt(record.getInteger(0))));
        hours.addDateRange(new DateRange(record.getTime(1), record.getTime(2)));
        hours.addDateRange(new DateRange(record.getTime(3), record.getTime(4)));
        hours.addDateRange(new DateRange(record.getTime(5), record.getTime(6)));
    }

    private void populateCalendarException(Record record, ProjectCalendarException exception) throws MPXJException {
        exception.setFromDate(record.getDate(0));
        exception.setToDate(record.getDate(1));
        exception.setWorking(record.getNumericBoolean(2));
        exception.setFromTime1(record.getTime(3));
        exception.setToTime1(record.getTime(4));
        exception.setFromTime2(record.getTime(5));
        exception.setToTime2(record.getTime(6));
        exception.setFromTime3(record.getTime(7));
        exception.setToTime3(record.getTime(8));
    }

    private void populateCalendar(Record record, ProjectCalendar calendar) {
        if (calendar.isBaseCalendar()) {
            calendar.setName(record.getString(0));
        } else {
            calendar.setBaseCalendar(this.m_projectFile.getBaseCalendar(record.getString(0)));
        }
        calendar.setWorkingDay(Day.SUNDAY, record.getInteger(1));
        calendar.setWorkingDay(Day.MONDAY, record.getInteger(2));
        calendar.setWorkingDay(Day.TUESDAY, record.getInteger(3));
        calendar.setWorkingDay(Day.WEDNESDAY, record.getInteger(4));
        calendar.setWorkingDay(Day.THURSDAY, record.getInteger(5));
        calendar.setWorkingDay(Day.FRIDAY, record.getInteger(6));
        calendar.setWorkingDay(Day.SATURDAY, record.getInteger(7));
    }

    private void populateResource(Resource resource, Record record) throws MPXJException {
        String falseText = LocaleData.getString(this.m_locale, "NO");
        int length = record.getLength();
        int[] model = this.m_resourceModel.getModel();
        int i = 0;
        while (i < length) {
            int mpxFieldType = model[i];
            if (mpxFieldType == -1) break;
            String field = record.getString(i);
            if (field != null && field.length() != 0) {
                ResourceField resourceField = MPXResourceField.getMpxjField(mpxFieldType);
                switch (resourceField.getValue()) {
                    case 32: {
                        resource.set((FieldType)resourceField, record.getInteger(i));
                        break;
                    }
                    case 0: {
                        resource.setID(record.getInteger(i));
                        break;
                    }
                    case 26: {
                        resource.setUniqueID(record.getInteger(i));
                        break;
                    }
                    case 4: {
                        resource.set((FieldType)resourceField, record.getUnits(i));
                        break;
                    }
                    case 25: 
                    case 28: {
                        resource.set((FieldType)resourceField, record.getPercentage(i));
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 17: 
                    case 18: 
                    case 20: 
                    case 23: {
                        resource.set((FieldType)resourceField, record.getCurrency(i));
                        break;
                    }
                    case 6: 
                    case 7: {
                        resource.set((FieldType)resourceField, record.getRate(i));
                        break;
                    }
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 21: 
                    case 22: {
                        resource.set((FieldType)resourceField, record.getDuration(i));
                        break;
                    }
                    case 19: {
                        resource.set((FieldType)resourceField, record.getAccrueType(i));
                        break;
                    }
                    case 24: {
                        resource.set((FieldType)resourceField, record.getBoolean(i, falseText));
                        break;
                    }
                    default: {
                        resource.set((FieldType)resourceField, field);
                    }
                }
            }
            ++i;
        }
        if (this.m_projectFile.getAutoResourceUniqueID()) {
            resource.setUniqueID(new Integer(this.m_projectFile.getResourceUniqueID()));
        }
        if (this.m_projectFile.getAutoResourceID()) {
            resource.setID(new Integer(this.m_projectFile.getResourceID()));
        }
    }

    private List populateRelationList(String data) throws MPXJException {
        LinkedList<Relation> list = new LinkedList<Relation>();
        int length = data.length();
        if (length != 0) {
            int start = 0;
            int end = 0;
            while (end != length) {
                end = data.indexOf(this.m_delimiter, start);
                if (end == -1) {
                    end = length;
                }
                Relation relation = new Relation(this.m_projectFile);
                this.populateRelation(data.substring(start, end).trim(), relation);
                list.add(relation);
                start = end + 1;
            }
        }
        return list;
    }

    private void populateRelation(String relationship, Relation relation) throws MPXJException {
        int index = 0;
        int length = relationship.length();
        while (index < length && Character.isDigit(relationship.charAt(index))) {
            ++index;
        }
        try {
            relation.setTaskID(new Integer(relationship.substring(0, index)));
        }
        catch (NumberFormatException ex) {
            throw new MPXJException("Invalid format '" + relationship + "'");
        }
        Task task = this.m_projectFile.getTaskByID(relation.getTaskID());
        if (task != null) {
            relation.setTaskUniqueID(task.getUniqueID());
        }
        if (index == length) {
            relation.setType(RelationType.FINISH_START);
            relation.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
        } else {
            if (index + 1 == length) {
                throw new MPXJException("Invalid format '" + relationship + "'");
            }
            String relationType = relationship.substring(index, index + 2);
            relation.setType(RelationTypeUtility.getInstance(this.m_locale, relationship.substring(index, index + 2)));
            if (relation.getType() == null) {
                throw new MPXJException("Invalid format '" + relationType + "'");
            }
            if ((index += 2) == length) {
                relation.setDuration(Duration.getInstance(0, TimeUnit.DAYS));
            } else {
                if (relationship.charAt(index) == '+') {
                    ++index;
                }
                relation.setDuration(DurationUtility.getInstance(relationship.substring(index), this.m_formats.getDurationDecimalFormat(), this.m_locale));
            }
        }
    }

    private void populateTask(Record record, Task task) throws MPXJException {
        String falseText = LocaleData.getString(this.m_locale, "NO");
        int mpxFieldID = 0;
        int i = 0;
        int length = record.getLength();
        int[] model = this.m_taskModel.getModel();
        while (i < length) {
            String field;
            mpxFieldID = model[i];
            if (mpxFieldID == -1) break;
            if ((field = record.getString(i++)) == null || field.length() == 0) continue;
            TaskField taskField = MPXTaskField.getMpxjField(mpxFieldID);
            if (taskField == null) {
                System.out.println("Null Task Field " + mpxFieldID);
            }
            switch (taskField.getValue()) {
                case 45: 
                case 46: 
                case 93: 
                case 94: {
                    task.set((FieldType)taskField, this.populateRelationList(field));
                    break;
                }
                case 31: 
                case 32: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getPercentageDecimalFormat().parse(field));
                        break;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse percentage", ex);
                    }
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 81: 
                case 103: 
                case 104: 
                case 105: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getCurrencyFormat().parse(field));
                        break;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse currency", ex);
                    }
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 19: 
                case 20: 
                case 21: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 43: 
                case 44: 
                case 100: 
                case 101: 
                case 102: {
                    task.set((FieldType)taskField, DurationUtility.getInstance(field, this.m_formats.getDurationDecimalFormat(), this.m_locale));
                    break;
                }
                case 17: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 91: 
                case 97: 
                case 98: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDateTimeFormat().parse(field));
                        break;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse date time", ex);
                    }
                }
                case 18: 
                case 23: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 90: 
                case 96: 
                case 106: 
                case 107: 
                case 108: {
                    task.set((FieldType)taskField, field.equalsIgnoreCase(falseText) ? Boolean.FALSE : Boolean.TRUE);
                    break;
                }
                case 16: {
                    task.set((FieldType)taskField, ConstraintTypeUtility.getInstance(this.m_locale, field));
                    break;
                }
                case 83: 
                case 95: {
                    task.set((FieldType)taskField, Integer.valueOf(field));
                    break;
                }
                case 22: {
                    task.setID(Integer.valueOf(field));
                    break;
                }
                case 84: {
                    task.setUniqueID(Integer.valueOf(field));
                    break;
                }
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: {
                    try {
                        task.set((FieldType)taskField, this.m_formats.getDecimalFormat().parse(field));
                        break;
                    }
                    catch (ParseException ex) {
                        throw new MPXJException("Failed to parse number", ex);
                    }
                }
                case 24: {
                    task.set((FieldType)taskField, PriorityUtility.getInstance(this.m_locale, field));
                    break;
                }
                case 112: {
                    boolean fixed = !field.equalsIgnoreCase(falseText);
                    task.setType(fixed ? TaskType.FIXED_DURATION : TaskType.FIXED_UNITS);
                    break;
                }
                default: {
                    task.set((FieldType)taskField, field);
                }
            }
        }
        if (this.m_projectFile.getAutoWBS()) {
            task.generateWBS(null);
        }
        if (this.m_projectFile.getAutoOutlineNumber()) {
            task.generateOutlineNumber(null);
        }
        if (this.m_projectFile.getAutoOutlineLevel()) {
            task.setOutlineLevel(new Integer(1));
        }
        if (this.m_projectFile.getAutoTaskUniqueID()) {
            task.setUniqueID(new Integer(this.m_projectFile.getTaskUniqueID()));
        }
        if (this.m_projectFile.getAutoTaskID()) {
            task.setID(new Integer(this.m_projectFile.getTaskID()));
        }
    }

    private void populateRecurringTask(Record record, RecurringTask task) throws MPXJException {
        task.setTaskUniqueID(record.getInteger(0));
        task.setStartDate(record.getDateTime(1));
        task.setFinishDate(record.getDateTime(2));
        task.setDuration(record.getInteger(3));
        task.setDurationType(record.getString(4));
        task.setNumberOfOccurances(record.getInteger(5));
        task.setRecurranceType(record.getInteger(6));
        task.setNotSureIndex(record.getInteger(7));
        task.setLengthRadioIndex(record.getInteger(8));
        task.setDailyBoxRadioIndex(record.getInteger(9));
        task.setWeeklyBoxDayOfWeekIndex(record.getString(10));
        task.setMonthlyBoxRadioIndex(record.getInteger(11));
        task.setYearlyBoxRadioIndex(record.getInteger(12));
        task.setDailyBoxComboIndex(record.getInteger(13));
        task.setWeeklyBoxComboIndex(record.getInteger(14));
        task.setMonthlyBoxFirstLastComboIndex(record.getInteger(15));
        task.setMonthlyBoxDayComboIndex(record.getInteger(16));
        task.setMonthlyBoxBottomRadioFrequencyComboIndex(record.getInteger(17));
        task.setMonthlyBoxDayIndex(record.getInteger(18));
        task.setMonthlyBoxTopRadioFrequencyComboIndex(record.getInteger(19));
        task.setYearlyBoxFirstLastComboIndex(record.getInteger(20));
        task.setYearlyBoxDayComboIndex(record.getInteger(21));
        task.setYearlyBoxMonthComboIndex(record.getInteger(22));
        task.setYearlyBoxDate(record.getDateTime(23));
    }

    private void populateResourceAssignment(Record record, ResourceAssignment assignment) throws MPXJException {
        Resource resource;
        assignment.setResourceID(record.getInteger(0));
        assignment.setUnits(record.getUnits(1));
        assignment.setWork(record.getDuration(2));
        assignment.setPlannedWork(record.getDuration(3));
        assignment.setActualWork(record.getDuration(4));
        assignment.setOvertimeWork(record.getDuration(5));
        assignment.setCost(record.getCurrency(6));
        assignment.setPlannedCost(record.getCurrency(7));
        assignment.setActualCost(record.getCurrency(8));
        assignment.setStart(record.getDateTime(9));
        assignment.setFinish(record.getDateTime(10));
        assignment.setDelay(record.getDuration(11));
        assignment.setResourceUniqueID(record.getInteger(12));
        Duration work = assignment.getWork();
        Duration actualWork = assignment.getActualWork();
        if (work != null && actualWork != null) {
            if (work.getUnits() != actualWork.getUnits()) {
                actualWork = actualWork.convertUnits(work.getUnits(), this.m_projectFile.getProjectHeader());
            }
            assignment.setRemainingWork(Duration.getInstance(work.getDuration() - actualWork.getDuration(), work.getUnits()));
        }
        if ((resource = assignment.getResource()) != null) {
            resource.addResourceAssignment(assignment);
        }
    }

    private void populateResourceAssignmentWorkgroupFields(Record record, ResourceAssignmentWorkgroupFields workgroup) throws MPXJException {
        workgroup.setMessageUniqueID(record.getString(0));
        workgroup.setConfirmed(NumberUtility.getInt(record.getInteger(1)) == 1);
        workgroup.setResponsePending(NumberUtility.getInt(record.getInteger(1)) == 1);
        workgroup.setUpdateStart(record.getDateTime(3));
        workgroup.setUpdateFinish(record.getDateTime(4));
        workgroup.setScheduleID(record.getString(5));
    }

    static void populateFileCreationRecord(Record record, FileCreationRecord fcr) {
        fcr.setProgramName(record.getString(0));
        fcr.setFileVersion(FileVersion.getInstance(record.getString(1)));
        fcr.setCodePage(record.getCodePage(2));
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setIgnoreTextModels(boolean flag) {
        this.m_ignoreTextModels = flag;
    }

    public boolean getIgnoreTextModels() {
        return this.m_ignoreTextModels;
    }
}

