/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpx;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.CodePage;
import net.sf.mpxj.CurrencySymbolPosition;
import net.sf.mpxj.DateOrder;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectDateFormat;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.Rate;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.mpx.AccrueTypeUtility;
import net.sf.mpxj.mpx.DurationUtility;
import net.sf.mpxj.mpx.TimeUnitUtility;
import net.sf.mpxj.mpx.Tokenizer;
import net.sf.mpxj.utility.MPXJFormats;

final class Record {
    private Locale m_locale;
    private String m_recordNumber;
    private String[] m_fields;
    private MPXJFormats m_formats;

    Record(Locale locale, Tokenizer tk, MPXJFormats formats) throws MPXJException {
        try {
            this.m_locale = locale;
            this.m_formats = formats;
            LinkedList<String> list = new LinkedList<String>();
            while (tk.nextToken() == -3) {
                list.add(tk.getToken());
            }
            if (list.size() > 0) {
                this.m_recordNumber = (String)list.remove(0);
                this.m_fields = list.toArray(new String[list.size()]);
            }
        }
        catch (IOException ex) {
            throw new MPXJException("Invalid record", ex);
        }
    }

    public String getRecordNumber() {
        return this.m_recordNumber;
    }

    public String getString(int field) {
        String result;
        if (field < this.m_fields.length) {
            result = this.m_fields[field];
            if (result != null) {
                result = result.replace('\u007f', '\n');
            }
        } else {
            result = null;
        }
        return result;
    }

    public Character getCharacter(int field) {
        Character result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? new Character(this.m_fields[field].charAt(0)) : null;
        return result;
    }

    public Number getFloat(int field) throws MPXJException {
        try {
            Number result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? (Number)this.m_formats.getDecimalFormat().parse(this.m_fields[field]) : (Number)null;
            return result;
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse float", ex);
        }
    }

    public Integer getInteger(int field) {
        Integer result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? Integer.valueOf(this.m_fields[field]) : null;
        return result;
    }

    public Date getDateTime(int field) throws MPXJException {
        try {
            Date result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_formats.getDateTimeFormat().parse(this.m_fields[field]) : null;
            return result;
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse date time", ex);
        }
    }

    public Date getDate(int field) throws MPXJException {
        try {
            Date result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_formats.getDateFormat().parse(this.m_fields[field]) : null;
            return result;
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse date", ex);
        }
    }

    public Date getTime(int field) throws MPXJException {
        try {
            Date result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? this.m_formats.getTimeFormat().parse(this.m_fields[field]) : null;
            return result;
        }
        catch (ParseException ex) {
            throw new MPXJException("Failed to parse time", ex);
        }
    }

    public boolean getNumericBoolean(int field) {
        boolean result = false;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            result = Integer.parseInt(this.m_fields[field]) == 1;
        }
        return result;
    }

    public Rate getRate(int field) throws MPXJException {
        Rate result;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            try {
                TimeUnit units;
                double amount;
                String rate = this.m_fields[field];
                int index = rate.indexOf(47);
                if (index == -1) {
                    amount = this.m_formats.getCurrencyFormat().parse(rate).doubleValue();
                    units = TimeUnit.HOURS;
                } else {
                    amount = this.m_formats.getCurrencyFormat().parse(rate.substring(0, index)).doubleValue();
                    units = TimeUnitUtility.getInstance(rate.substring(index + 1), this.m_locale);
                }
                result = new Rate(amount, units);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse rate", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Number getCurrency(int field) throws MPXJException {
        Number result;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            try {
                result = this.m_formats.getCurrencyFormat().parse(this.m_fields[field]);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse currency", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Number getPercentage(int field) throws MPXJException {
        Number result;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            try {
                result = this.m_formats.getPercentageDecimalFormat().parse(this.m_fields[field]);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse percentage", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public Duration getDuration(int field) throws MPXJException {
        Duration result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? DurationUtility.getInstance(this.m_fields[field], this.m_formats.getDurationDecimalFormat(), this.m_locale) : null;
        return result;
    }

    public Number getUnits(int field) throws MPXJException {
        Double result;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            try {
                result = new Double(this.m_formats.getUnitsDecimalFormat().parse(this.m_fields[field]).doubleValue() * 100.0);
            }
            catch (ParseException ex) {
                throw new MPXJException("Failed to parse units", ex);
            }
        } else {
            result = null;
        }
        return result;
    }

    public TimeUnit getTimeUnit(int field) {
        TimeUnit result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? TimeUnit.getInstance(Integer.parseInt(this.m_fields[field])) : TimeUnit.DAYS;
        return result;
    }

    public ProjectTimeFormat getTimeFormat(int field) {
        ProjectTimeFormat result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? ProjectTimeFormat.getInstance(Integer.parseInt(this.m_fields[field])) : ProjectTimeFormat.TWELVE_HOUR;
        return result;
    }

    public ScheduleFrom getScheduleFrom(int field) {
        ScheduleFrom result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? ScheduleFrom.getInstance(Integer.parseInt(this.m_fields[field])) : ScheduleFrom.START;
        return result;
    }

    public DateOrder getDateOrder(int field) {
        DateOrder result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? DateOrder.getInstance(Integer.parseInt(this.m_fields[field])) : DateOrder.MDY;
        return result;
    }

    public CurrencySymbolPosition getCurrencySymbolPosition(int field) {
        CurrencySymbolPosition result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? CurrencySymbolPosition.getInstance(Integer.parseInt(this.m_fields[field])) : CurrencySymbolPosition.BEFORE;
        return result;
    }

    public ProjectDateFormat getDateFormat(int field) {
        ProjectDateFormat result = null;
        result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? ProjectDateFormat.getInstance(Integer.parseInt(this.m_fields[field])) : ProjectDateFormat.DD_MM_YY;
        return result;
    }

    public CodePage getCodePage(int field) {
        CodePage result = null;
        if (field < this.m_fields.length && this.m_fields[field].length() != 0) {
            result = CodePage.getInstance(this.m_fields[field]);
        }
        return result;
    }

    public AccrueType getAccrueType(int field) {
        AccrueType result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? AccrueTypeUtility.getInstance(this.m_fields[field], this.m_locale) : null;
        return result;
    }

    public Boolean getBoolean(int field, String falseText) {
        Boolean result = field < this.m_fields.length && this.m_fields[field].length() != 0 ? (this.m_fields[field].equalsIgnoreCase(falseText) ? Boolean.FALSE : Boolean.TRUE) : null;
        return result;
    }

    public int getLength() {
        return this.m_fields.length;
    }
}

