/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.utility;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Locale;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.ProjectTimeFormat;
import net.sf.mpxj.utility.MPXJDateFormat;
import net.sf.mpxj.utility.MPXJNumberFormat;
import net.sf.mpxj.utility.MPXJTimeFormat;

public final class MPXJFormats {
    private Locale m_locale;
    private String m_nullText;
    private ProjectFile m_projectFile;
    private MPXJNumberFormat m_unitsDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_decimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_currencyFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_durationDecimalFormat = new MPXJNumberFormat();
    private MPXJNumberFormat m_percentageDecimalFormat = new MPXJNumberFormat();
    private MPXJDateFormat m_dateTimeFormat = new MPXJDateFormat();
    private MPXJDateFormat m_dateFormat = new MPXJDateFormat();
    private MPXJTimeFormat m_timeFormat = new MPXJTimeFormat();

    public MPXJFormats(Locale locale, String nullText, ProjectFile file) {
        this.m_locale = locale;
        this.m_nullText = nullText;
        this.m_projectFile = file;
        this.update();
    }

    public void update() {
        ProjectHeader header = this.m_projectFile.getProjectHeader();
        char decimalSeparator = header.getDecimalSeparator();
        char thousandsSeparator = header.getThousandsSeparator();
        this.m_unitsDecimalFormat.applyPattern("#.##", null, decimalSeparator, thousandsSeparator);
        this.m_decimalFormat.applyPattern("0.00#", null, decimalSeparator, thousandsSeparator);
        this.m_durationDecimalFormat.applyPattern("#.#", null, decimalSeparator, thousandsSeparator);
        this.m_percentageDecimalFormat.applyPattern("##0.##", null, decimalSeparator, thousandsSeparator);
        this.updateCurrencyFormats(header, decimalSeparator, thousandsSeparator);
        this.updateDateTimeFormats(header);
    }

    private void updateCurrencyFormats(ProjectHeader header, char decimalSeparator, char thousandsSeparator) {
        String noSymbolSecondaryPattern;
        String noSymbolPrimaryPattern;
        String secondaryPattern;
        String prefix = "";
        String suffix = "";
        String currencySymbol = this.quoteFormatCharacters(header.getCurrencySymbol());
        switch (header.getSymbolPosition().getValue()) {
            case 0: {
                suffix = currencySymbol;
                break;
            }
            case 1: {
                prefix = currencySymbol;
                break;
            }
            case 2: {
                suffix = " " + currencySymbol;
                break;
            }
            case 3: {
                prefix = String.valueOf(currencySymbol) + " ";
            }
        }
        StringBuffer pattern = new StringBuffer(prefix);
        pattern.append("#0");
        int digits = header.getCurrencyDigits().intValue();
        if (digits > 0) {
            pattern.append('.');
            int i = 0;
            while (i < digits) {
                pattern.append("0");
                ++i;
            }
        }
        pattern.append(suffix);
        String primaryPattern = pattern.toString();
        String[] alternativePatterns = new String[7];
        alternativePatterns[0] = String.valueOf(primaryPattern) + ";(" + primaryPattern + ")";
        pattern.insert(prefix.length(), "#,#");
        alternativePatterns[1] = secondaryPattern = pattern.toString();
        alternativePatterns[2] = String.valueOf(secondaryPattern) + ";(" + secondaryPattern + ")";
        pattern.setLength(0);
        pattern.append("#0");
        if (digits > 0) {
            pattern.append('.');
            int i = 0;
            while (i < digits) {
                pattern.append("0");
                ++i;
            }
        }
        alternativePatterns[3] = noSymbolPrimaryPattern = pattern.toString();
        alternativePatterns[4] = String.valueOf(noSymbolPrimaryPattern) + ";(" + noSymbolPrimaryPattern + ")";
        pattern.insert(0, "#,#");
        alternativePatterns[5] = noSymbolSecondaryPattern = pattern.toString();
        alternativePatterns[6] = String.valueOf(noSymbolSecondaryPattern) + ";(" + noSymbolSecondaryPattern + ")";
        this.m_currencyFormat.applyPattern(primaryPattern, alternativePatterns, decimalSeparator, thousandsSeparator);
    }

    private String quoteFormatCharacters(String literal) {
        StringBuffer sb = new StringBuffer();
        int length = literal.length();
        int loop = 0;
        while (loop < length) {
            char c = literal.charAt(loop);
            switch (c) {
                case '#': 
                case '%': 
                case ',': 
                case '-': 
                case '.': 
                case '0': 
                case ';': 
                case 'E': {
                    sb.append("'");
                    sb.append(c);
                    sb.append("'");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++loop;
        }
        return sb.toString();
    }

    private void updateDateTimeFormats(ProjectHeader header) {
        String datePattern = "";
        String dateTimePattern = "";
        String timePattern = this.getTimeElement(header);
        char datesep = header.getDateSeparator();
        int dateOrderValue = header.getDateOrder().getValue();
        switch (dateOrderValue) {
            case 1: {
                datePattern = "dd" + datesep + "MM" + datesep + "yy";
                break;
            }
            case 0: {
                datePattern = "MM" + datesep + "dd" + datesep + "yy";
                break;
            }
            case 2: {
                datePattern = "yy" + datesep + "MM" + datesep + "dd";
            }
        }
        block5 : switch (header.getDateFormat().getValue()) {
            case 0: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yy " + timePattern;
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yy " + timePattern;
                        break;
                    }
                    case 2: {
                        dateTimePattern = "yy" + datesep + "MM" + datesep + "dd " + timePattern;
                    }
                }
                break;
            }
            case 1: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yy";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yy";
                        break;
                    }
                    case 2: {
                        dateTimePattern = "yy" + datesep + "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case 2: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMMMM yyyy " + timePattern;
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MMMMM dd yyyy " + timePattern;
                        break;
                    }
                    case 2: {
                        dateTimePattern = "yyyy MMMMM dd " + timePattern;
                    }
                }
                break;
            }
            case 3: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMMMM yyyy";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MMMMM dd yyyy";
                        break;
                    }
                    case 2: {
                        dateTimePattern = "yyyy MMMMM dd";
                    }
                }
                break;
            }
            case 4: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMM " + timePattern;
                        break;
                    }
                    case 0: {
                        dateTimePattern = " MMM dd " + timePattern;
                    }
                }
                break;
            }
            case 5: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMM ''yy";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MMM dd ''yy";
                        break;
                    }
                    case 2: {
                        dateTimePattern = "''yy MMM dd";
                    }
                }
                break;
            }
            case 6: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMMMM";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MMMMM dd";
                    }
                }
                break;
            }
            case 7: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd MMM";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MMM dd";
                    }
                }
                break;
            }
            case 8: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy " + timePattern;
                        break;
                    }
                    case 0: {
                        dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy " + timePattern;
                        break;
                    }
                    case 2: {
                        dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd " + timePattern;
                    }
                }
                break;
            }
            case 9: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "EEE dd" + datesep + "MM" + datesep + "yy";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "EEE MM" + datesep + "dd" + datesep + "yy";
                        break;
                    }
                    case 2: {
                        dateTimePattern = "EEE yy" + datesep + "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case 10: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "EEE dd MMM ''yy";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "EEE MM dd ''yy";
                        break;
                    }
                    case 2: {
                        dateTimePattern = "EEE ''yy MMM dd";
                    }
                }
                break;
            }
            case 11: {
                dateTimePattern = "EEE " + timePattern;
                break;
            }
            case 12: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd" + datesep + "MM";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "MM" + datesep + "dd";
                    }
                }
                break;
            }
            case 13: {
                dateTimePattern = "dd";
                break;
            }
            case 14: {
                dateTimePattern = timePattern;
                break;
            }
            case 15: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "EEE dd MMM";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "EEE MMM dd";
                    }
                }
                break;
            }
            case 16: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "EEE dd" + datesep + "MM";
                        break;
                    }
                    case 0: {
                        dateTimePattern = "EEE MM" + datesep + "dd";
                    }
                }
                break;
            }
            case 17: {
                dateTimePattern = "EEE dd";
                break;
            }
            case 18: {
                dateTimePattern = "F" + datesep + "'W'ww";
                break;
            }
            case 19: {
                dateTimePattern = "F" + datesep + "'W'ww" + datesep + "yy " + timePattern;
                break;
            }
            case 20: {
                switch (dateOrderValue) {
                    case 1: {
                        dateTimePattern = "dd" + datesep + "MM" + datesep + "yyyy";
                        break block5;
                    }
                    case 0: {
                        dateTimePattern = "MM" + datesep + "dd" + datesep + "yyyy";
                        break block5;
                    }
                    case 2: {
                        dateTimePattern = "yyyy" + datesep + "MM" + datesep + "dd";
                    }
                }
            }
        }
        this.m_dateTimeFormat.applyPattern(dateTimePattern);
        this.m_dateFormat.applyPattern(datePattern);
        this.m_timeFormat.applyPattern(timePattern);
        this.m_dateTimeFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_dateFormat.setLocale(this.m_locale, this.m_nullText);
        this.m_timeFormat.setNullText(this.m_nullText);
        this.m_dateTimeFormat.setAmPmText(header.getAMText(), header.getPMText());
        this.m_timeFormat.setAmPmText(header.getAMText(), header.getPMText());
    }

    private String getTimeElement(ProjectHeader header) {
        char timesep = header.getTimeSeparator();
        ProjectTimeFormat format = header.getTimeFormat();
        String time = format == null || format.getValue() == 0 ? "hh" + timesep + "mm a" : "HH" + timesep + "mm";
        return time;
    }

    public NumberFormat getUnitsDecimalFormat() {
        return this.m_unitsDecimalFormat;
    }

    public NumberFormat getDecimalFormat() {
        return this.m_decimalFormat;
    }

    public NumberFormat getCurrencyFormat() {
        return this.m_currencyFormat;
    }

    public NumberFormat getDurationDecimalFormat() {
        return this.m_durationDecimalFormat;
    }

    public NumberFormat getPercentageDecimalFormat() {
        return this.m_percentageDecimalFormat;
    }

    public DateFormat getDateTimeFormat() {
        return this.m_dateTimeFormat;
    }

    public DateFormat getDateFormat() {
        return this.m_dateFormat;
    }

    public DateFormat getTimeFormat() {
        return this.m_timeFormat;
    }
}

