/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public abstract class CSTNode {
    public int getMeaning() {
        return this.getRoot(true).getMeaning();
    }

    public boolean isA(int type) {
        return Types.ofType(this.getMeaning(), type);
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract int size();

    public int children() {
        int size = this.size();
        if (size > 1) {
            return size - 1;
        }
        return 0;
    }

    public abstract CSTNode get(int var1);

    public CSTNode get(int index, boolean safe) {
        CSTNode element = this.get(index);
        if (element == null && safe) {
            element = Token.NULL;
        }
        return element;
    }

    public abstract Token getRoot();

    public Token getRoot(boolean safe) {
        Token root = this.getRoot();
        if (root == null && safe) {
            root = Token.NULL;
        }
        return root;
    }

    public int getStartLine() {
        return this.getRoot(true).getStartLine();
    }

    public int getStartColumn() {
        return this.getRoot(true).getStartColumn();
    }

    public String toString() {
        StringWriter string = new StringWriter();
        this.write(new PrintWriter(string));
        string.flush();
        return string.toString();
    }

    public void write(PrintWriter writer) {
        this.write(writer, "");
    }

    protected void write(PrintWriter writer, String indent) {
        writer.print("(");
        if (!this.isEmpty()) {
            String text;
            int length;
            Token root = this.getRoot(true);
            int type = root.getType();
            int meaning = root.getMeaning();
            writer.print(Types.getDescription(type));
            if (meaning != type) {
                writer.print(" as ");
                writer.print(Types.getDescription(meaning));
            }
            if (this.getStartLine() > -1) {
                writer.print(" at " + this.getStartLine() + ":" + this.getStartColumn());
            }
            if ((length = (text = root.getText()).length()) > 0) {
                writer.print(": ");
                if (length > 40) {
                    text = text.substring(0, 17) + "..." + text.substring(length - 17, length);
                }
                writer.print(" \"");
                writer.print(text);
                writer.print("\" ");
            } else if (this.children() > 0) {
                writer.print(": ");
            }
            int count = this.size();
            if (count > 1) {
                writer.println("");
                String indent1 = indent + "  ";
                String indent2 = indent + "   ";
                for (int i = 1; i < count; ++i) {
                    writer.print(indent1);
                    writer.print(i);
                    writer.print(": ");
                    this.get(i, true).write(writer, indent2);
                }
                writer.print(indent);
            }
        }
        if (indent.length() > 0) {
            writer.println(")");
        } else {
            writer.print(")");
        }
    }
}

