/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.swing;

import com.l2fprod.common.swing.ButtonAreaLayout;
import com.l2fprod.common.swing.PercentLayout;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Font;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public class LookAndFeelTweaks {
    public static final Border PANEL_BORDER = BorderFactory.createEmptyBorder(3, 3, 3, 3);
    public static final Border WINDOW_BORDER = BorderFactory.createEmptyBorder(4, 10, 10, 10);
    public static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();

    public static void tweak() {
        Object object = UIManager.get("List.font");
        UIManager.put("Table.font", object);
        UIManager.put("ToolTip.font", object);
        UIManager.put("TextField.font", object);
        UIManager.put("FormattedTextField.font", object);
        UIManager.put("Viewport.background", "Table.background");
    }

    public static PercentLayout createVerticalPercentLayout() {
        return new PercentLayout(1, 8);
    }

    public static PercentLayout createHorizontalPercentLayout() {
        return new PercentLayout(0, 8);
    }

    public static ButtonAreaLayout createButtonAreaLayout() {
        return new ButtonAreaLayout(6);
    }

    public static BorderLayout createBorderLayout() {
        return new BorderLayout(8, 8);
    }

    public static void setBorder(JComponent jComponent) {
        if (jComponent instanceof JPanel) {
            jComponent.setBorder(PANEL_BORDER);
        }
    }

    public static void setBorderLayout(Container container) {
        container.setLayout(new BorderLayout(3, 3));
    }

    public static void makeBold(JComponent jComponent) {
        jComponent.setFont(jComponent.getFont().deriveFont(1));
    }

    public static void makeMultilineLabel(JTextComponent jTextComponent) {
        jTextComponent.setFont(UIManager.getFont("Label.font"));
        jTextComponent.setEditable(false);
        jTextComponent.setOpaque(false);
        if (jTextComponent instanceof JTextArea) {
            ((JTextArea)jTextComponent).setWrapStyleWord(true);
            ((JTextArea)jTextComponent).setLineWrap(true);
        }
    }

    public static void htmlize(JComponent jComponent) {
        LookAndFeelTweaks.htmlize(jComponent, UIManager.getFont("Button.font"));
    }

    public static void htmlize(JComponent jComponent, Font font) {
        String string = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;\t}";
        try {
            HTMLDocument hTMLDocument;
            block7: {
                Document document;
                block8: {
                    block6: {
                        hTMLDocument = null;
                        if (!(jComponent instanceof JEditorPane)) break block6;
                        if (!(((JEditorPane)jComponent).getDocument() instanceof HTMLDocument)) break block7;
                        document = ((JEditorPane)jComponent).getDocument();
                        break block8;
                    }
                    View view = (View)jComponent.getClientProperty("html");
                    if (view == null || !(view.getDocument() instanceof HTMLDocument)) break block7;
                    document = view.getDocument();
                }
                hTMLDocument = (HTMLDocument)document;
            }
            if (hTMLDocument != null) {
                hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public static Border addMargin(Border border) {
        return new CompoundBorder(border, PANEL_BORDER);
    }
}

