/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.a;
import org.apache.commons.collections.collection.d;
import org.apache.commons.collections.collection.e;
import org.apache.commons.collections.collection.g;
import org.apache.commons.collections.collection.h;
import org.apache.commons.collections.f;

public class CollectionUtils {
    private static Integer a = new Integer(1);
    public static final Collection EMPTY_COLLECTION = e.a(new ArrayList());

    public static Collection union(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = 0;
            int n3 = Math.max(CollectionUtils.a(e2, map), CollectionUtils.a(e2, map2));
            while (n2 < n3) {
                arrayList.add(e2);
                ++n2;
            }
        }
        return arrayList;
    }

    public static Collection intersection(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = 0;
            int n3 = Math.min(CollectionUtils.a(e2, map), CollectionUtils.a(e2, map2));
            while (n2 < n3) {
                arrayList.add(e2);
                ++n2;
            }
        }
        return arrayList;
    }

    public static Collection disjunction(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList();
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        HashSet hashSet = new HashSet(collection);
        hashSet.addAll(collection2);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            int n2 = 0;
            int n3 = Math.max(CollectionUtils.a(e2, map), CollectionUtils.a(e2, map2)) - Math.min(CollectionUtils.a(e2, map), CollectionUtils.a(e2, map2));
            while (n2 < n3) {
                arrayList.add(e2);
                ++n2;
            }
        }
        return arrayList;
    }

    public static Collection subtract(Collection collection, Collection collection2) {
        ArrayList arrayList = new ArrayList(collection);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            ((AbstractCollection)arrayList).remove(iterator.next());
        }
        return arrayList;
    }

    public static boolean containsAny(Collection collection, Collection collection2) {
        if (collection.size() < collection2.size()) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!collection2.contains(iterator.next())) continue;
                return true;
            }
        } else {
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                if (!collection.contains(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map getCardinalityMap(Collection collection) {
        HashMap hashMap = new HashMap();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            Integer n2 = (Integer)hashMap.get(e2);
            if (n2 == null) {
                hashMap.put(e2, a);
                continue;
            }
            hashMap.put(e2, new Integer(n2 + 1));
        }
        return hashMap;
    }

    public static boolean isSubCollection(Collection collection, Collection collection2) {
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (CollectionUtils.a(e2, map) <= CollectionUtils.a(e2, map2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isProperSubCollection(Collection collection, Collection collection2) {
        return collection.size() < collection2.size() && CollectionUtils.isSubCollection(collection, collection2);
    }

    public static boolean isEqualCollection(Collection collection, Collection collection2) {
        if (collection.size() != collection2.size()) {
            return false;
        }
        Map map = CollectionUtils.getCardinalityMap(collection);
        Map map2 = CollectionUtils.getCardinalityMap(collection2);
        if (map.size() != map2.size()) {
            return false;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k2 = iterator.next();
            if (CollectionUtils.a(k2, map) == CollectionUtils.a(k2, map2)) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(Object object, Collection collection) {
        if (collection instanceof Set) {
            if (collection.contains(object)) {
                return 1;
            }
            return 0;
        }
        if (collection instanceof f) {
            return ((f)collection).a();
        }
        int n2 = 0;
        if (object == null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                ++n2;
            }
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static Object find(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!predicate.evaluate(e2)) continue;
                return e2;
            }
        }
        return null;
    }

    public static void forAllDo(Collection collection, Closure closure) {
        if (collection != null && closure != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                closure.execute(iterator.next());
            }
        }
    }

    public static void filter(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (predicate.evaluate(iterator.next())) continue;
                iterator.remove();
            }
        }
    }

    public static void transform(Collection collection, Transformer transformer) {
        if (collection != null && transformer != null) {
            if (collection instanceof List) {
                List list = (List)collection;
                ListIterator<Object> listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    listIterator.set(transformer.transform(listIterator.next()));
                }
                return;
            }
            Collection collection2 = CollectionUtils.collect(collection, transformer);
            collection.clear();
            collection.addAll(collection2);
        }
    }

    public static int countMatches(Collection collection, Predicate predicate) {
        int n2 = 0;
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                ++n2;
            }
        }
        return n2;
    }

    public static boolean exists(Collection collection, Predicate predicate) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!predicate.evaluate(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    public static Collection select(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.select(collection, predicate, arrayList);
        return arrayList;
    }

    public static void select(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (!predicate.evaluate(e2)) continue;
                collection2.add(e2);
            }
        }
    }

    public static Collection selectRejected(Collection collection, Predicate predicate) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.selectRejected(collection, predicate, arrayList);
        return arrayList;
    }

    public static void selectRejected(Collection collection, Predicate predicate, Collection collection2) {
        if (collection != null && predicate != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                if (predicate.evaluate(e2)) continue;
                collection2.add(e2);
            }
        }
    }

    public static Collection collect(Collection collection, Transformer transformer) {
        ArrayList arrayList = new ArrayList(collection.size());
        CollectionUtils.collect(collection, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Iterator iterator, Transformer transformer) {
        ArrayList arrayList = new ArrayList();
        CollectionUtils.collect(iterator, transformer, arrayList);
        return arrayList;
    }

    public static Collection collect(Collection collection, Transformer transformer, Collection collection2) {
        if (collection != null) {
            return CollectionUtils.collect(collection.iterator(), transformer, collection2);
        }
        return collection2;
    }

    public static Collection collect(Iterator iterator, Transformer transformer, Collection collection) {
        if (iterator != null && transformer != null) {
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                Object object = transformer.transform(e2);
                collection.add(object);
            }
        }
        return collection;
    }

    public static void addAll(Collection collection, Iterator iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
    }

    public static void addAll(Collection collection, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
    }

    public static void addAll(Collection collection, Object[] objectArray) {
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            collection.add(objectArray[n2]);
            ++n2;
        }
    }

    public static Object index(Object object, int n2) {
        return CollectionUtils.index(object, new Integer(n2));
    }

    public static Object index(Object object, Object object2) {
        Map map;
        if (object instanceof Map && (map = (Map)object).containsKey(object2)) {
            return map.get(object2);
        }
        int n2 = -1;
        if (object2 instanceof Integer) {
            n2 = (Integer)object2;
        }
        if (n2 < 0) {
            return object;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            Iterator iterator = map2.keySet().iterator();
            return CollectionUtils.a(iterator, n2);
        }
        if (object instanceof List) {
            return ((List)object).get(n2);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n2];
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n2 == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
        } else {
            if (object instanceof Iterator) {
                return CollectionUtils.a((Iterator)object, n2);
            }
            if (object instanceof Collection) {
                Iterator iterator = ((Collection)object).iterator();
                return CollectionUtils.a(iterator, n2);
            }
        }
        return object;
    }

    private static Object a(Iterator iterator, int n2) {
        while (iterator.hasNext()) {
            if (--n2 == -1) {
                return iterator.next();
            }
            iterator.next();
        }
        return iterator;
    }

    public static Object get(Object object, int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + n2);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionUtils.get(iterator, n2);
        }
        if (object instanceof List) {
            return ((List)object).get(n2);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[n2];
        }
        if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                if (--n2 == -1) {
                    return iterator.next();
                }
                iterator.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n2);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionUtils.get(iterator, n2);
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                if (--n2 == -1) {
                    return enumeration.nextElement();
                }
                enumeration.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + n2);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, n2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
        }
    }

    public static int size(Object object) {
        int n2 = 0;
        if (object instanceof Map) {
            n2 = ((Map)object).size();
        } else if (object instanceof Collection) {
            n2 = ((Collection)object).size();
        } else if (object instanceof Object[]) {
            n2 = ((Object[])object).length;
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                ++n2;
                iterator.next();
            }
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                ++n2;
                enumeration.nextElement();
            }
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Unsupported object type: null");
            }
            try {
                n2 = Array.getLength(object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Unsupported object type: " + object.getClass().getName());
            }
        }
        return n2;
    }

    public static void reverseArray(Object[] objectArray) {
        int n2 = 0;
        int n3 = objectArray.length - 1;
        while (n3 > n2) {
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n2];
            objectArray[n2] = object;
            --n3;
            ++n2;
        }
    }

    private static final int a(Object object, Map map) {
        Integer n2 = (Integer)map.get(object);
        if (n2 != null) {
            return n2;
        }
        return 0;
    }

    public static boolean isFull(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (collection instanceof org.apache.commons.collections.d) {
            return ((org.apache.commons.collections.d)collection).b();
        }
        try {
            org.apache.commons.collections.d d2 = h.a(collection);
            return d2.b();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static int maxSize(Collection collection) {
        if (collection == null) {
            throw new NullPointerException("The collection must not be null");
        }
        if (collection instanceof org.apache.commons.collections.d) {
            return ((org.apache.commons.collections.d)collection).c();
        }
        try {
            org.apache.commons.collections.d d2 = h.a(collection);
            return d2.c();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    public static Collection synchronizedCollection(Collection collection) {
        return org.apache.commons.collections.collection.a.a(collection);
    }

    public static Collection unmodifiableCollection(Collection collection) {
        return e.a(collection);
    }

    public static Collection predicatedCollection(Collection collection, Predicate predicate) {
        return org.apache.commons.collections.collection.f.a(collection, predicate);
    }

    public static Collection typedCollection(Collection collection, Class clazz) {
        return d.a(collection, clazz);
    }

    public static Collection transformedCollection(Collection collection, Transformer transformer) {
        return g.a(collection, transformer);
    }
}

