/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public class SoftReferenceObjectPool
extends BaseObjectPool
implements ObjectPool {
    private List a = new ArrayList();
    private PoolableObjectFactory b = null;
    private int c = 0;

    public SoftReferenceObjectPool() {
        this.b = null;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory) {
        this.b = poolableObjectFactory;
    }

    public SoftReferenceObjectPool(PoolableObjectFactory poolableObjectFactory, int n2) throws Exception {
        this.b = poolableObjectFactory;
        if (null != this.b) {
            int n3 = 0;
            while (n3 < n2) {
                Object object = this.b.makeObject();
                this.b.passivateObject(object);
                this.a.add(new SoftReference<Object>(object));
                ++n3;
            }
        }
    }

    public synchronized Object borrowObject() throws Exception {
        Object object;
        this.b();
        Object object2 = null;
        while (null == (object = object2)) {
            if (this.a.isEmpty()) {
                if (null == this.b) {
                    throw new NoSuchElementException();
                }
                object2 = this.b.makeObject();
                continue;
            }
            SoftReference softReference = (SoftReference)this.a.remove(this.a.size() - 1);
            object2 = softReference.get();
        }
        if (null != this.b && null != object) {
            this.b.activateObject(object);
        }
        ++this.c;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnObject(Object object) throws Exception {
        this.b();
        boolean bl = true;
        if (!this.b.validateObject(object)) {
            bl = false;
        } else {
            try {
                this.b.passivateObject(object);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        boolean bl2 = !bl;
        SoftReferenceObjectPool softReferenceObjectPool = this;
        synchronized (softReferenceObjectPool) {
            --this.c;
            if (bl) {
                this.a.add(new SoftReference<Object>(object));
            }
            this.notifyAll();
        }
        if (bl2) {
            try {
                this.b.destroyObject(object);
                return;
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void invalidateObject(Object object) throws Exception {
        this.b();
        --this.c;
        this.b.destroyObject(object);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject() throws Exception {
        Object object = this.b.makeObject();
        SoftReferenceObjectPool softReferenceObjectPool = this;
        synchronized (softReferenceObjectPool) {
            ++this.c;
            this.returnObject(object);
            return;
        }
    }

    public int getNumIdle() {
        return this.a.size();
    }

    public int getNumActive() {
        return this.c;
    }

    public synchronized void clear() {
        this.b();
        if (null != this.b) {
            Iterator iterator = this.a.iterator();
            while (iterator.hasNext()) {
                try {
                    Object t2 = ((SoftReference)iterator.next()).get();
                    if (null == t2) continue;
                    this.b.destroyObject(t2);
                }
                catch (Exception exception) {}
            }
        }
        this.a.clear();
    }

    public synchronized void close() throws Exception {
        this.clear();
        this.a = null;
        this.b = null;
        super.close();
    }

    public synchronized void setFactory(PoolableObjectFactory poolableObjectFactory) throws IllegalStateException {
        this.b();
        if (0 < this.getNumActive()) {
            throw new IllegalStateException("Objects are already active");
        }
        this.clear();
        this.b = poolableObjectFactory;
    }
}

