/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data;

import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import com.projity.exchange.ImportedCalendarService;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.VoidNodeImpl;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.model.NodeModelUtil;
import com.projity.job.JobRunnable;
import com.projity.options.CalendarOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkingCalendar;
import com.projity.pm.dependency.Dependency;
import com.projity.pm.key.uniqueid.UniqueIdException;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.TaskSnapshot;
import com.projity.server.data.CommonDataObject;
import com.projity.server.data.DataObject;
import com.projity.server.data.MPXConverter;
import com.projity.server.data.ProjectSerializer;
import com.projity.server.data.linker.Linker;
import com.projity.server.data.linker.ResourceLinker;
import com.projity.server.data.linker.TaskLinker;
import com.projity.server.data.mspdi.ModifiedMSPDIWriter;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;

public class MSPDISerializer
implements ProjectSerializer {
    public static final boolean TMP_FILES = false;
    protected JobRunnable job = null;
    protected Linker resourceLinker = new ResourceLinker(){

        public Object addTransformedObjects(Object object) throws Exception {
            Project project = (Project)this.parent;
            ModifiedMSPDIWriter modifiedMSPDIWriter = (ModifiedMSPDIWriter)this.transformedParent;
            ResourceImpl resourceImpl = (ResourceImpl)object;
            Resource resource = modifiedMSPDIWriter.getProjectFile().addResource();
            MPXConverter.toMPXResource(resourceImpl, resource);
            this.transformationMap.put(resourceImpl, resource);
            return resource;
        }

        public boolean addOutlineElement(Object object, Object object2, long l) {
            return true;
        }
    };
    protected Linker taskLinker = new TaskLinker(){

        public Object addTransformedObjects(Object object) throws Exception {
            Project project = (Project)this.parent;
            ModifiedMSPDIWriter modifiedMSPDIWriter = (ModifiedMSPDIWriter)this.transformedParent;
            NormalTask normalTask = (NormalTask)object;
            Task task = modifiedMSPDIWriter.getProjectFile().addTask();
            MPXConverter.toMPXTask(normalTask, task);
            Map map = (Map)this.args[0];
            for (int i = 0; i < Settings.numBaselines(); ++i) {
                AssociationList associationList;
                TaskSnapshot taskSnapshot = (TaskSnapshot)normalTask.getSnapshot((Object)new Integer(i));
                if (taskSnapshot == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
                for (Assignment assignment : associationList) {
                    ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                    if (i != Snapshottable.CURRENT) continue;
                    Resource resource = (Resource)map.get(resourceImpl);
                    ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
                    modifiedMSPDIWriter.putProjityAssignmentMap(resourceAssignment, assignment);
                    modifiedMSPDIWriter.putProjitySnapshotIdMap(resourceAssignment, new Integer(i));
                    if (i != Snapshottable.CURRENT) continue;
                    MPXConverter.toMPXAssignment(assignment, resourceAssignment);
                }
            }
            this.transformationMap.put(normalTask, task);
            return task;
        }

        public boolean addOutlineElement(Object object, Object object2, long l) {
            if (object instanceof VoidNodeImpl) {
                return false;
            }
            Task task = (Task)this.getTransformationMap().get(object);
            Task task2 = object2 == null ? null : (Task)this.getTransformationMap().get(object2);
            task.setOutlineLevel(new Integer(task2 == null ? 1 : task2.getOutlineLevel() + 1));
            task.setOutlineNumber((task2 == null ? "" : task2.getOutlineNumber() + ".") + (l + 1L));
            return true;
        }
    };

    protected Map saveResources(Project project, ModifiedMSPDIWriter modifiedMSPDIWriter) throws Exception {
        NodeModelUtil.enumerateNonAssignments((NodeModel)project.getResourcePool().getResourceOutline());
        this.resourceLinker.setParent(project);
        this.resourceLinker.setTransformedParent(modifiedMSPDIWriter);
        this.resourceLinker.init();
        this.resourceLinker.addTransformedObjects(ResourceImpl.getUnassignedInstance());
        this.resourceLinker.addTransformedObjects();
        this.resourceLinker.addOutline(null);
        return this.resourceLinker.getTransformationMap();
    }

    protected Map saveTasks(Project project, ModifiedMSPDIWriter modifiedMSPDIWriter, Map map) throws Exception {
        NodeModelUtil.enumerateNonAssignments((NodeModel)project.getTaskOutline());
        this.taskLinker.setParent(project);
        this.taskLinker.setTransformedParent(modifiedMSPDIWriter);
        this.taskLinker.setArgs(new Object[]{map});
        this.taskLinker.init();
        this.taskLinker.addTransformedObjects();
        this.taskLinker.addOutline(null);
        CalendarOption calendarOption = CalendarOption.getInstance();
        CalendarOption.setInstance((CalendarOption)CalendarOption.getDefaultInstance());
        int n = 0;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = project.getTaskOutline().iterator();
        while (iterator.hasNext()) {
            Object object3;
            Object object2 = ((Node)iterator.next()).getImpl();
            if (linkedList.size() > 0 && !(object2 instanceof VoidNodeImpl)) {
                for (Object object3 : linkedList) {
                    Task task = modifiedMSPDIWriter.getProjectFile().addTask();
                    MPXConverter.toMPXVoid((VoidNodeImpl)object3, task);
                }
                linkedList.clear();
            }
            if (object2 instanceof Assignment) continue;
            if (object2 instanceof VoidNodeImpl) {
                if (n == 0) continue;
                linkedList.add(object2);
                continue;
            }
            com.projity.pm.task.Task task = (com.projity.pm.task.Task)object2;
            object3 = (Task)this.taskLinker.getTransformationMap().get(task);
            modifiedMSPDIWriter.putProjityTaskMap(object3, task);
            for (Dependency dependency : task.getPredecessorList()) {
                com.projity.pm.task.Task task2 = (com.projity.pm.task.Task)dependency.getPredecessor();
                Task task3 = (Task)this.taskLinker.getTransformationMap().get(task2);
                Relation relation = ((Task)object3).addUniqueIdPredecessor(task3);
                relation.setType(RelationType.getInstance(dependency.getDependencyType()));
                relation.setDuration(MPXConverter.toMPXDuration(dependency.getLag()));
            }
            ++n;
        }
        CalendarOption.setInstance((CalendarOption)calendarOption);
        return this.taskLinker.getTransformationMap();
    }

    public ModifiedMSPDIWriter serializeProject(Project project) throws Exception {
        return this.serializeProject(project, false);
    }

    public ModifiedMSPDIWriter serializeProject(Project project, boolean bl) throws Exception {
        if (bl) {
            this.makeGLobal((DataObject)project);
        }
        ModifiedMSPDIWriter modifiedMSPDIWriter = new ModifiedMSPDIWriter();
        ProjectFile projectFile = new ProjectFile();
        modifiedMSPDIWriter.setProjectFile(projectFile);
        modifiedMSPDIWriter.setProjityProject(project);
        projectFile.setAutoTaskUniqueID(true);
        projectFile.setAutoResourceUniqueID(true);
        ProjectHeader projectHeader = projectFile.getProjectHeader();
        MPXConverter.toMPXOptions(projectHeader);
        MPXConverter.toMPXProject(project, projectHeader);
        if (this.job != null) {
            this.job.setProgress(0.2f);
        }
        projectFile.setAutoCalendarUniqueID(true);
        CalendarService calendarService = CalendarService.getInstance();
        Object[] objectArray = CalendarService.allBaseCalendars();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                WorkingCalendar workingCalendar = (WorkingCalendar)objectArray[i];
                ProjectCalendar projectCalendar = projectFile.addBaseCalendar();
                MPXConverter.toMpxCalendar(workingCalendar, projectCalendar);
                ImportedCalendarService.getInstance().addExportedCalendar(projectCalendar, workingCalendar);
            }
        }
        if (this.job != null) {
            this.job.setProgress(0.3f);
        }
        Map map = this.saveResources(project, modifiedMSPDIWriter);
        if (this.job != null) {
            this.job.setProgress(0.5f);
        }
        this.saveTasks(project, modifiedMSPDIWriter, map);
        if (this.job != null) {
            this.job.setProgress(0.7f);
        }
        return modifiedMSPDIWriter;
    }

    public void makeGLobal(DataObject dataObject) throws UniqueIdException {
        CommonDataObject.makeGlobal((DataObject)dataObject);
    }

    public boolean saveProject(Project project, String string) {
        try {
            ModifiedMSPDIWriter modifiedMSPDIWriter = this.serializeProject(project);
            if (this.job != null) {
                this.job.setProgress(0.9f);
            }
            modifiedMSPDIWriter.write(modifiedMSPDIWriter.getProjectFile(), new FileOutputStream(string));
            if (this.job != null) {
                this.job.setProgress(1.0f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public JobRunnable getJob() {
        return this.job;
    }

    public void setJob(JobRunnable jobRunnable) {
        this.job = jobRunnable;
    }
}

